/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.persistent;

import com.trs.infra.db.QueryFilter;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class WCMFilter
implements Cloneable {
    private static final String REG_REMOVE_INJECT_SQL = "(?i)([;'\n\r\\-]| delete | update | insert ).*";
    private static final String REG_REMOVE_INJECT_WHERE = "(?i)([;\n\r]| delete | update | insert ).*";
    protected String from = "";
    protected String where = "";
    protected String order = "";
    protected String select = "";
    protected String group = "";
    protected String orderSelect = "";
    protected int maxRowNumber = NOTLIMITED_OPEN_OPEN_RECORD_COUNT;
    protected int m_nPageSize = 20;
    protected String m_SQL = null;
    protected String m_SQLCountQuery = null;
    public static int DEFAULT_OPEN_RECORD_COUNT = 1000;
    public static int NOTLIMITED_OPEN_OPEN_RECORD_COUNT = 0;
    private List m_listSearchValues = null;
    private String[] m_pSelectFields;
    private boolean m_bForceFirstLoadIds = false;

    public WCMFilter() {
    }

    public WCMFilter(WCMFilter wCMFilter) {
        this.copy(wCMFilter);
    }

    public WCMFilter(String string, String string2, String string3) {
        this(string, string2, string3, "");
    }

    public WCMFilter(String string, String string2, String string3, String string4) {
        this.from = string;
        this.where = string2;
        this.order = string3;
        this.select = string4;
    }

    public WCMFilter(String string, String string2, String string3, String string4, String string5) {
        this.from = string;
        this.where = string2;
        this.order = string3;
        this.select = string4;
        this.orderSelect = string5;
    }

    public WCMFilter(String string, String string2, String string3, String string4, int n) {
        this.from = string;
        this.where = string2;
        this.order = string3;
        this.select = string4;
        this.maxRowNumber = n;
    }

    public WCMFilter(QueryFilter queryFilter) {
        if (queryFilter == null) {
            return;
        }
        this.from = queryFilter.getFrom();
        this.where = queryFilter.getWhere();
        this.order = queryFilter.getOrder();
        this.select = queryFilter.getSelect();
        this.m_listSearchValues = queryFilter.getSearchValues();
    }

    public void clear() {
        this.from = "";
        this.where = "";
        this.order = "";
        this.select = "";
        this.maxRowNumber = 0;
        this.group = "";
        this.m_SQL = null;
        if (this.m_listSearchValues != null) {
            this.m_listSearchValues.clear();
            this.m_listSearchValues = null;
        }
    }

    public void copy(WCMFilter wCMFilter) {
        if (wCMFilter == null) {
            this.clear();
        } else {
            this.from = wCMFilter.getFrom();
            this.where = wCMFilter.getWhere();
            this.order = wCMFilter.getOrder();
            this.group = wCMFilter.getGroup();
            this.select = wCMFilter.getSelect();
            this.orderSelect = wCMFilter.getOderSelect();
            this.maxRowNumber = wCMFilter.getMaxRowNumber();
            this.m_listSearchValues = wCMFilter.m_listSearchValues;
            this.m_bForceFirstLoadIds = wCMFilter.m_bForceFirstLoadIds;
            this.m_nPageSize = wCMFilter.m_nPageSize;
            this.m_SQL = null;
        }
    }

    public Object clone() {
        return new WCMFilter(this);
    }

    public String getFrom() {
        return this.from == null ? "" : this.from;
    }

    public void setFrom(String string) {
        this.from = string;
        this.m_SQL = null;
    }

    public String getWhere() {
        return this.where == null ? "" : this.where;
    }

    public void setWhere(String string) {
        this.where = string;
        this.m_SQL = null;
    }

    public String getOrder() {
        return this.order == null ? "" : this.order;
    }

    public void setOrder(String string) {
        this.order = string;
        this.m_SQL = null;
    }

    public String getSelect() {
        return this.select == null ? "" : this.select;
    }

    public void setSelect(String string) {
        this.select = string;
        this.m_SQL = null;
    }

    public String getOderSelect() {
        return this.orderSelect == null ? "" : this.orderSelect;
    }

    public void setOrderSelect(String string) {
        this.orderSelect = string;
    }

    public void setGroup(String string) {
        this.group = string;
    }

    public String getGroup() {
        return this.group == null ? "" : this.group;
    }

    public int getMaxRowNumber() {
        return this.maxRowNumber;
    }

    public void setMaxRowNumber(int n) {
        this.maxRowNumber = n;
    }

    public WCMFilter mergeWith(WCMFilter wCMFilter) {
        if (wCMFilter == null) {
            return this;
        }
        StringTokenizer stringTokenizer = null;
        String string = "";
        String string2 = wCMFilter.getSelect();
        if (string2.length() > 0) {
            this.select = this.select == null || this.select.length() == 0 ? string2 : string2 + "," + this.select;
        }
        if ((string2 = wCMFilter.getFrom()).length() > 0) {
            stringTokenizer = new StringTokenizer(string2.toUpperCase(), ",");
            while (stringTokenizer.hasMoreElements()) {
                string = (String)stringTokenizer.nextElement();
                if (this.from.toUpperCase().indexOf(string.toUpperCase().trim()) >= 0) continue;
                if (this.from.length() > 0) {
                    this.from = this.from + ",";
                }
                this.from = this.from + string;
            }
        }
        if ((string2 = wCMFilter.getWhere()).length() > 0) {
            this.where = this.where != null && this.where.length() > 0 ? "(" + this.where + ") and (" + string2 + ")" : string2;
        }
        if ((string2 = wCMFilter.getOrder()).length() > 0) {
            this.order = string2;
        }
        if ((string2 = wCMFilter.getGroup()).length() > 0) {
            this.group = string2;
        }
        if (wCMFilter.getMaxRowNumber() > 0) {
            this.maxRowNumber = wCMFilter.getMaxRowNumber();
        }
        this.m_nPageSize = wCMFilter.m_nPageSize;
        if (wCMFilter.getSearchValues() != null) {
            if (this.m_listSearchValues != null) {
                this.m_listSearchValues.addAll(wCMFilter.getSearchValues());
            } else {
                this.m_listSearchValues = wCMFilter.getSearchValues();
            }
        }
        this.m_SQL = null;
        return this;
    }

    public String toSQL() {
        String string;
        if (this.m_SQL != null) {
            return this.m_SQL;
        }
        this.m_SQL = "select " + CMyString.showNull(this.select, "*") + " from " + this.from;
        if (!CMyString.isEmpty(this.where) && !CMyString.isEmpty(string = this.where.replaceAll(REG_REMOVE_INJECT_WHERE, ""))) {
            this.m_SQL = this.m_SQL + " where " + string;
        }
        if (this.group != null && this.group.length() > 0) {
            this.m_SQL = this.m_SQL + " group by " + this.group;
        }
        if (!CMyString.isEmpty(this.order) && !CMyString.isEmpty(string = this.order.replaceAll(REG_REMOVE_INJECT_SQL, ""))) {
            this.m_SQL = this.m_SQL + " order by " + string;
        }
        return this.m_SQL;
    }

    public String toCountSQL() {
        String string;
        if (this.m_SQLCountQuery != null) {
            return this.m_SQLCountQuery;
        }
        this.m_SQLCountQuery = "select count(*) from " + this.from;
        if (!CMyString.isEmpty(this.where) && !CMyString.isEmpty(string = this.where.replaceAll(REG_REMOVE_INJECT_WHERE, ""))) {
            this.m_SQLCountQuery = this.m_SQLCountQuery + " where " + string;
        }
        if (this.group != null && this.group.length() > 0) {
            this.m_SQLCountQuery = this.m_SQLCountQuery + " group by " + this.group;
        }
        return this.m_SQLCountQuery;
    }

    public String toString() {
        String string = this.toSQL();
        if (this.m_listSearchValues == null) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() + 5 + this.m_listSearchValues.size() * 12);
        stringBuffer.append(string);
        int n = this.m_listSearchValues.size();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append('\n');
            stringBuffer.append("Param#");
            stringBuffer.append(i + 1);
            stringBuffer.append(":");
            stringBuffer.append(this.m_listSearchValues.get(i));
        }
        return stringBuffer.toString();
    }

    public String toCountQueryInfo() {
        String string = this.toCountSQL();
        if (this.m_listSearchValues == null) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() + 5 + this.m_listSearchValues.size() * 12);
        stringBuffer.append(string);
        int n = this.m_listSearchValues.size();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append('\n');
            stringBuffer.append("Param#");
            stringBuffer.append(i + 1);
            stringBuffer.append(":");
            stringBuffer.append(this.m_listSearchValues.get(i));
        }
        return stringBuffer.toString();
    }

    public boolean isToGetAll() {
        return this.where == null || this.where.trim().length() == 0;
    }

    public String findSelectField(String string) {
        int n;
        if (this.select == null || this.select.length() == 0) {
            return null;
        }
        String string2 = this.select.toUpperCase();
        char[] cArray = string2.toCharArray();
        String string3 = string.toUpperCase();
        int n2 = string.length();
        boolean bl = false;
        int n3 = 0;
        do {
            if ((n3 = string2.indexOf(string3, n3)) < 0) {
                return null;
            }
            if (n3 > 0 && cArray[n3 - 1] != ' ' && cArray[n3 - 1] != ',' && cArray[n3 - 1] != '.') {
                n3 += n2;
                continue;
            }
            n = n3 + n2;
            if (n < cArray.length) {
                if (cArray[n] != ' ' && cArray[n] != ',') {
                    n3 = n + 1;
                    continue;
                }
                while (++n < cArray.length && cArray[n] == ' ') {
                }
                if (cArray[n] == 'A') {
                    n3 = n + 2;
                    continue;
                }
            }
            bl = true;
            break;
        } while (!bl);
        for (n = n3 - 1; n >= 0; --n) {
            if (cArray[n] != ',') continue;
            ++n;
            break;
        }
        if (n < 0) {
            n = 0;
        }
        return this.select.substring(n, n3 + n2).trim();
    }

    public static void main(String[] stringArray) {
        WCMFilter wCMFilter = new WCMFilter("", "", "", "Document.DocId");
        String[] stringArray2 = new String[]{"WCMDocument.DocId", "WCMDocument.DocId as DocId2", "WCMDocument.DocId as DocId2, WCMTest.TestId as DocId", "WCMDocument.MyDocId", "distinct WCMDocument.docid,WCMDocument.doctitle,WCMDocument.docstatus,WCMDocument.docchannel,WCMDocument.docauthor,WCMDocument.crtime,WCMDocument.cruser,WCMDocument.RightDefined,WCMDocument.DocType"};
        for (int i = 0; i < stringArray2.length; ++i) {
            wCMFilter.setSelect(stringArray2[i]);
            System.out.println("[" + i + "] " + wCMFilter.findSelectField("DocId"));
        }
        WCMFilter wCMFilter2 = new WCMFilter("", "", "docid asc", "", 10);
        WCMFilter wCMFilter3 = new WCMFilter("", "", "chnlid desc", "*", 20);
        wCMFilter3.mergeWith(wCMFilter2);
        System.out.println(wCMFilter3.getOrder());
        System.out.println(wCMFilter3.getMaxRowNumber());
        System.out.println(wCMFilter3.getSelect());
    }

    public List getSearchValues() {
        return this.m_listSearchValues;
    }

    public void setSearchValues(List list) {
        this.m_listSearchValues = list;
    }

    public void addSearchValues(int n, int n2) {
        if (this.m_listSearchValues == null) {
            this.m_listSearchValues = new ArrayList();
        }
        if (this.m_listSearchValues.size() <= n) {
            this.m_listSearchValues.add(n, new Integer(n2));
        } else {
            this.m_listSearchValues.set(n, new Integer(n2));
        }
    }

    public void addSearchValues(int n) {
        int n2 = 0;
        if (this.m_listSearchValues != null) {
            n2 = this.m_listSearchValues.size();
        }
        this.addSearchValues(n2, n);
    }

    public void addSearchValues(long l) {
        int n = 0;
        if (this.m_listSearchValues != null) {
            n = this.m_listSearchValues.size();
        }
        this.addSearchValue(n, new Long(l));
    }

    public void addSearchValues(int n, float f) {
        Float f2 = new Float(f);
        this.addSearchValue(n, f2);
    }

    private void addSearchValue(int n, Object object) {
        if (this.m_listSearchValues == null) {
            this.m_listSearchValues = new ArrayList();
        }
        if (this.m_listSearchValues.size() <= n) {
            this.m_listSearchValues.add(n, object);
        } else {
            this.m_listSearchValues.set(n, object);
        }
    }

    public void addSearchValues(float f) {
        int n = 0;
        if (this.m_listSearchValues != null) {
            n = this.m_listSearchValues.size();
        }
        this.addSearchValues(n, f);
    }

    public void addSearchValues(int n, double d) {
        if (this.m_listSearchValues == null) {
            this.m_listSearchValues = new ArrayList();
        }
        if (this.m_listSearchValues.size() <= n) {
            this.m_listSearchValues.add(n, new Double(d));
        } else {
            this.m_listSearchValues.set(n, new Double(d));
        }
    }

    public void addSearchValues(double d) {
        int n = 0;
        if (this.m_listSearchValues != null) {
            n = this.m_listSearchValues.size();
        }
        this.addSearchValues(n, d);
    }

    public void addSearchValues(int n, String string) {
        if (this.m_listSearchValues == null) {
            this.m_listSearchValues = new ArrayList();
        }
        if (this.m_listSearchValues.size() <= n) {
            this.m_listSearchValues.add(n, string);
        } else {
            this.m_listSearchValues.set(n, string);
        }
    }

    public void addSearchValues(String string) {
        int n = 0;
        if (this.m_listSearchValues != null) {
            n = this.m_listSearchValues.size();
        }
        this.addSearchValues(n, string);
    }

    public void addSearchValues(int n, CMyDateTime cMyDateTime) {
        if (this.m_listSearchValues == null) {
            this.m_listSearchValues = new ArrayList();
        }
        if (this.m_listSearchValues.size() <= n) {
            this.m_listSearchValues.add(n, cMyDateTime);
        } else {
            this.m_listSearchValues.set(n, cMyDateTime);
        }
    }

    public void addSearchValues(CMyDateTime cMyDateTime) {
        int n = 0;
        if (this.m_listSearchValues != null) {
            n = this.m_listSearchValues.size();
        }
        this.addSearchValues(n, cMyDateTime);
    }

    public boolean isForceFirstLoadIds() {
        return this.m_bForceFirstLoadIds;
    }

    public void setForceFirstLoadIds(boolean bl) {
        this.m_bForceFirstLoadIds = bl;
    }

    public int getPageSize() {
        return this.m_nPageSize;
    }

    public void setPageSize(int n) {
        this.m_nPageSize = n;
    }

    public boolean containsSelectFields(String string) {
        int n;
        if (string == null || (string = string.trim()).length() == 0) {
            return false;
        }
        if (this.m_pSelectFields == null) {
            this.makeSelectFields();
        }
        if ((n = this.m_pSelectFields.length) == 0) {
            return true;
        }
        string = string.toUpperCase();
        for (int i = 0; i < n; ++i) {
            if (!this.m_pSelectFields[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean isFromMultiTable() {
        if (this.from == null) {
            return false;
        }
        return this.from.indexOf(44) > 0;
    }

    private void makeSelectFields() {
        this.m_pSelectFields = new String[0];
        if (this.select == null || this.select.length() == 0 || this.select.equals("*")) {
            return;
        }
        String[] stringArray = this.select.split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i].trim();
            int n = string.indexOf(32);
            if (n > 0) {
                string = string.substring(n + 1);
            }
            if ((n = string.indexOf(46)) > 0) {
                string = string.substring(n + 1);
            }
            stringArray[i] = string.toUpperCase();
        }
        this.m_pSelectFields = stringArray;
    }
}

