/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.persistent;

import com.trs.components.wcm.content.service.portervisitors.PorterUtil;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.persistent.NullValue;
import com.trs.infra.util.CMyDOM4jHelper;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.database.CDBText;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public abstract class BaseObjToXmlConverter {
    private static final String PATTERN_CDATA = "(?ism).*<!\\[CDATA\\[.*|.*\\]\\]>.*";
    private String m_sXmlEncoding = "UTF-8";
    private boolean bAddVersion = true;

    public String toXMLString(Object object) throws WCMException {
        return this.toXMLString(object, null);
    }

    public String toXMLString(Object object, String string) throws WCMException {
        return this.toXMLString(object, string, null);
    }

    public String toXMLString(Object object, String string, String string2) throws WCMException {
        Element element = this.convertObjToElement(object, string2);
        if (string == null) {
            return element.asXML();
        }
        Document document = CMyDOM4jHelper.makeXMLDocument(element, string);
        return document.asXML();
    }

    public void toXMLFile(Object object, String string) throws WCMException {
        this.toXMLFile(object, string, null);
    }

    public void toXMLFile(Object object, String string, String string2) throws WCMException {
        this.toXMLFile(object, string, string2, null);
    }

    public void toXMLFile(Object object, String string, String string2, String string3) throws WCMException {
        Element element = this.convertObjToElement(object, string3);
        CMyDOM4jHelper.toXMLFile(element, this.m_sXmlEncoding, string, string2);
    }

    private Element convertObjToElement(Object object, String string) throws WCMException {
        if (object == null) {
            throw new WCMException(10, I18NMessage.get(BaseObjToXmlConverter.class, "BaseObjToXmlConverter.label1", "\u65e0\u6548\u7684\u5bf9\u8c61[null]!"));
        }
        if (object instanceof BaseObj) {
            return this.toXmlElement((BaseObj)object, string);
        }
        if (object instanceof BaseObjs) {
            return this.toXmlElement((BaseObjs)object, string);
        }
        if (object instanceof List) {
            return this.toXmlElement((List)object, string);
        }
        throw new WCMException(1100, I18NMessage.get(BaseObjToXmlConverter.class, "BaseObjToXmlConverter.label2", "\u4e0d\u652f\u6301[") + object.getClass() + I18NMessage.get(BaseObjToXmlConverter.class, "BaseObjToXmlConverter.label3", "]\u7c7b\u578b\u5bf9\u8c61\u7684XML\u8f6c\u6362"));
    }

    public Element toXmlElement(BaseObjs baseObjs, String string) throws WCMException {
        Element element = DocumentHelper.createElement((String)this.getElementTag(baseObjs));
        BaseObj baseObj = null;
        for (int i = 0; i < baseObjs.size(); ++i) {
            baseObj = baseObjs.getAt(i);
            if (baseObj == null) continue;
            element.add(this.toXmlElement(baseObj, string));
        }
        return element;
    }

    public Element toXmlElement(List list, String string) throws WCMException {
        if (list.isEmpty()) {
            return null;
        }
        BaseObj baseObj = (BaseObj)list.get(0);
        if (baseObj == null) {
            throw new WCMException(10, I18NMessage.get(BaseObjToXmlConverter.class, "BaseObjToXmlConverter.label4", "\u6307\u5b9a\u7684List\u4e2d\u7684\u5143\u7d20[") + list.get(0).getClass() + I18NMessage.get(BaseObjToXmlConverter.class, "BaseObjToXmlConverter.label5", "]\u4e0d\u7b26\u5408\u8981\u6c42\uff01"));
        }
        Element element = DocumentHelper.createElement((String)(baseObj.getDbTableName() + "S"));
        BaseObj baseObj2 = null;
        for (int i = 0; i < list.size(); ++i) {
            baseObj2 = (BaseObj)list.get(i);
            if (baseObj2 == null) continue;
            element.add(this.toXmlElement(baseObj2, string));
        }
        return element;
    }

    public Element toXmlElement(BaseObj baseObj) throws WCMException {
        return this.toXmlElement(baseObj, null);
    }

    protected Element toXmlElement(BaseObj baseObj, String string) throws WCMException {
        Object object;
        StringTokenizer stringTokenizer = null;
        String string2 = null;
        Object object2 = null;
        Hashtable hashtable = baseObj.getAllProperty();
        Element element = DocumentHelper.createElement((String)this.getElementTag(baseObj));
        if (this.isAddVersion()) {
            element.addAttribute("Version", "6.0");
        }
        Element element2 = element.addElement("PROPERTIES");
        Element element3 = null;
        String string3 = string;
        if (string3 == null || string3.trim().length() == 0) {
            string3 = this.getFieldList(baseObj);
        }
        stringTokenizer = string3 != null && string3.trim().length() > 0 ? new StringTokenizer(string3.toUpperCase(), ",") : hashtable.keys();
        while (stringTokenizer.hasMoreElements()) {
            try {
                string2 = ((String)stringTokenizer.nextElement()).trim();
                object2 = baseObj.getProperty(string2);
                element3 = element2.addElement(string2);
                if (object2 == null || object2 instanceof NullValue) continue;
                if (object2 instanceof String) {
                    object = (String)object2;
                    if (((String)object).matches(PATTERN_CDATA)) {
                        element3.setText((String)object);
                        continue;
                    }
                    element3.addCDATA((String)object);
                    continue;
                }
                if (object2 instanceof CDBText) {
                    object = ((CDBText)object2).getText();
                    if (CMyString.isEmpty((String)object)) continue;
                    if (((String)object).matches(PATTERN_CDATA)) {
                        element3.setText((String)object);
                        continue;
                    }
                    element3.addCDATA((String)object);
                    continue;
                }
                if (object2 instanceof CMyDateTime) {
                    object = (CMyDateTime)object2;
                    if (((CMyDateTime)object).isNull()) continue;
                    element3.setText(((CMyDateTime)object).toString());
                    continue;
                }
                element3.setText(object2.toString());
            }
            catch (Throwable throwable) {
                throw new WCMException(I18NMessage.get(BaseObjToXmlConverter.class, "BaseObjToXmlConverter.label6", "\u5904\u7406[") + string2 + I18NMessage.get(BaseObjToXmlConverter.class, "BaseObjToXmlConverter.label7", "]\u5b57\u6bb5\u5931\u8d25!"), throwable);
            }
        }
        object = this.getChildElement(baseObj);
        this.addChildElements(element, (Element[])object);
        PorterUtil.doExports(baseObj, new Object[]{this, element});
        return element;
    }

    public void addChildElements(Element element, Element[] elementArray) {
        if (elementArray == null) {
            return;
        }
        for (int i = 0; i < elementArray.length; ++i) {
            Element element2 = elementArray[i];
            if (element2 == null) continue;
            element.add(element2);
        }
    }

    protected abstract Element[] getChildElement(BaseObj var1) throws WCMException;

    public String getXmlEncoding() {
        return this.m_sXmlEncoding;
    }

    public void setXmlEncoding(String string) {
        this.m_sXmlEncoding = string;
    }

    protected String getFieldList(BaseObj baseObj) {
        return null;
    }

    public String getElementTag(BaseObjs baseObjs) {
        return baseObjs.getDbTableName() + "S";
    }

    public String getElementTag(BaseObj baseObj) {
        return baseObj.getDbTableName();
    }

    public boolean isAddVersion() {
        return this.bAddVersion;
    }

    public void setAddVersion(boolean bl) {
        this.bAddVersion = bl;
    }
}

