/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.persistent;

import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjHandler;
import com.trs.infra.persistent.BaseObjsHandler;
import com.trs.infra.util.CMyString;
import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class BaseObjHelper {
    public static BaseObj toWCMObj(String string, BaseObj baseObj) throws WCMException {
        if (string == null || string.length() <= 0) {
            return null;
        }
        try {
            BaseObjHandler baseObjHandler = new BaseObjHandler(baseObj);
            String string2 = CMyString.filterForJDOM(string);
            BaseObjHelper.parseXMLFile(new InputSource(new StringReader(string2)), baseObjHandler, false);
            BaseObj baseObj2 = baseObjHandler.getWCMObj();
            baseObj2.removeProperty(baseObj2.getIdFieldName());
            return baseObj2;
        }
        catch (Exception exception) {
            throw new WCMException(1104, I18NMessage.get(BaseObjHelper.class, "BaseObjHelper.label1", "\u8bbe\u7f6e\u5bf9\u8c61[") + baseObj.getClassName(false) + "][" + baseObj.getId() + I18NMessage.get(BaseObjHelper.class, "BaseObjHelper.label2", "]\u5c5e\u6027\u65f6\u53d1\u751f\u5f02\u5e38\uff01"), exception);
        }
    }

    public static BaseObj toWCMObj(String string, int n, Class clazz) throws WCMException {
        if (string == null || string.length() <= 0) {
            return null;
        }
        BaseObj baseObj = null;
        try {
            baseObj = BaseObj.createNewInstance(clazz);
        }
        catch (Exception exception) {
            throw new WCMException(2, I18NMessage.get(BaseObjHelper.class, "BaseObjHelper.label3", "\u4ea7\u751f\u6307\u5b9a\u5bf9\u8c61[") + clazz.getName() + I18NMessage.get(BaseObjHelper.class, "BaseObjHelper.label4", "]\u7684\u5b9e\u4f8b\u5931\u8d25\uff01"), exception);
        }
        if (n > 0) {
            baseObj = BaseObjHelper.findAndLockWCMObj(baseObj, n);
        }
        return BaseObjHelper.toWCMObj(string, baseObj);
    }

    public static List toWCMObjList(String string, BaseObj baseObj) throws Exception {
        if (string == null || string.length() <= 0) {
            return null;
        }
        BaseObjsHandler baseObjsHandler = new BaseObjsHandler(baseObj);
        BaseObjHelper.parseXMLFile(new InputSource(new StringReader(string)), baseObjsHandler, false);
        List list = baseObjsHandler.getWCMObjList();
        BaseObj baseObj2 = null;
        for (int i = list.size() - 1; i >= 0; --i) {
            baseObj2 = (BaseObj)list.get(i);
            if (baseObj2.getProperty(baseObj2.getIdFieldName()) == null) continue;
            int n = baseObj2.getPropertyAsInt(baseObj2.getIdFieldName(), 0);
            if (n > 0) {
                BaseObj baseObj3 = BaseObjHelper.findAndLockWCMObj(baseObj2, n);
                baseObj3.setNewProperties(baseObj2.getProperties());
                list.remove(i);
                list.add(i, baseObj3);
                baseObj2 = baseObj3;
            }
            baseObj2.removeProperty(baseObj2.getIdFieldName());
        }
        return list;
    }

    public static String toIdsString(List list) {
        return BaseObjHelper.toIdsString(list, ",");
    }

    public static String toIdsString(List list, String string) {
        if (list == null) {
            return "";
        }
        int n = 0;
        boolean bl = true;
        String string2 = "";
        for (int i = 0; i < list.size(); ++i) {
            n = ((BaseObj)list.get(i)).getId();
            if (n == 0) continue;
            if (bl) {
                string2 = String.valueOf(n);
                bl = false;
                continue;
            }
            string2 = string2 + string + n;
        }
        return string2;
    }

    private static BaseObj findAndLockWCMObj(BaseObj baseObj, int n) throws WCMException {
        BaseObj baseObj2 = BaseObj.findById(baseObj.getClass(), n);
        if (baseObj2 == null) {
            throw new WCMException(200006, I18NMessage.get(BaseObjHelper.class, "BaseObjHelper.label5", "\u6307\u5b9a\u7684\u5bf9\u8c61\u6216\u8bb8\u88ab\u5220\u9664!ID\u4e3a[") + n + "]");
        }
        return baseObj2;
    }

    private static void parseXMLFile(InputSource inputSource, DefaultHandler defaultHandler, boolean bl) throws WCMException {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setValidating(bl);
            sAXParserFactory.newSAXParser().parse(inputSource, defaultHandler);
        }
        catch (SAXException sAXException) {
            throw new WCMException(150, I18NMessage.get(BaseObjHelper.class, "BaseObjHelper.label6", "\u89e3\u6790\u6570\u636e\u65f6\u53d1\u751f\u5f02\u5e38\uff01") + sAXException.getMessage(), sAXException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            System.out.println("ParserConfigurationException:" + parserConfigurationException.getMessage());
        }
        catch (IOException iOException) {
            System.out.println("IOException:" + iOException.getMessage());
        }
    }
}

