/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.db;

import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class QueryFilter
implements Cloneable {
    protected String from = "";
    protected String where = "";
    protected String order = "";
    protected String select = "";
    protected String orderSelect = "";
    protected int maxRowNumber = NOTLIMITED_OPEN_OPEN_RECORD_COUNT;
    protected int m_nPageSize = 20;
    protected String m_SQL = null;
    public static int DEFAULT_OPEN_RECORD_COUNT = 1000;
    public static int NOTLIMITED_OPEN_OPEN_RECORD_COUNT = 0;
    private List m_listSearchValues = null;
    private boolean m_bForceFirstLoadIds = false;

    public QueryFilter() {
    }

    public QueryFilter(QueryFilter queryFilter) {
        this.copy(queryFilter);
    }

    public QueryFilter(String string, String string2, String string3) {
        this(string, string2, string3, "");
    }

    public QueryFilter(String string, String string2, String string3, String string4) {
        this.from = string;
        this.where = string2;
        this.order = string3;
        this.select = string4;
    }

    public QueryFilter(String string, String string2, String string3, String string4, String string5) {
        this.from = string;
        this.where = string2;
        this.order = string3;
        this.select = string4;
        this.orderSelect = string5;
    }

    public QueryFilter(String string, String string2, String string3, String string4, int n) {
        this.from = string;
        this.where = string2;
        this.order = string3;
        this.select = string4;
        this.maxRowNumber = n;
    }

    public void clear() {
        this.from = "";
        this.where = "";
        this.order = "";
        this.select = "";
        this.maxRowNumber = 0;
        this.m_SQL = null;
        if (this.m_listSearchValues != null) {
            this.m_listSearchValues.clear();
            this.m_listSearchValues = null;
        }
    }

    public void copy(QueryFilter queryFilter) {
        if (queryFilter == null) {
            this.clear();
        } else {
            this.from = queryFilter.getFrom();
            this.where = queryFilter.getWhere();
            this.order = queryFilter.getOrder();
            this.select = queryFilter.getSelect();
            this.orderSelect = queryFilter.getOderSelect();
            this.maxRowNumber = queryFilter.getMaxRowNumber();
            this.m_listSearchValues = queryFilter.m_listSearchValues;
            this.m_bForceFirstLoadIds = queryFilter.m_bForceFirstLoadIds;
            this.m_nPageSize = queryFilter.m_nPageSize;
            this.m_SQL = null;
        }
    }

    public Object clone() {
        return new QueryFilter(this);
    }

    public String getFrom() {
        return this.from == null ? "" : this.from;
    }

    public void setFrom(String string) {
        this.from = string;
        this.m_SQL = null;
    }

    public String getWhere() {
        return this.where == null ? "" : this.where;
    }

    public void setWhere(String string) {
        this.where = string;
        this.m_SQL = null;
    }

    public String getOrder() {
        return this.order == null ? "" : this.order;
    }

    public void setOrder(String string) {
        this.order = string;
        this.m_SQL = null;
    }

    public String getSelect() {
        return this.select == null ? "" : this.select;
    }

    public void setSelect(String string) {
        this.select = string;
        this.m_SQL = null;
    }

    public String getOderSelect() {
        return this.orderSelect == null ? "" : this.orderSelect;
    }

    public void setOrderSelect(String string) {
        this.orderSelect = string;
    }

    public int getMaxRowNumber() {
        return this.maxRowNumber;
    }

    public void setMaxRowNumber(int n) {
        this.maxRowNumber = n;
    }

    public QueryFilter mergeWith(QueryFilter queryFilter) {
        StringTokenizer stringTokenizer = null;
        String string = "";
        if (queryFilter == null) {
            return this;
        }
        String string2 = queryFilter.getSelect();
        if (string2.length() > 0) {
            this.select = this.select == null || this.select.length() == 0 ? string2 : string2 + "," + this.select;
        }
        if ((string2 = queryFilter.getFrom()).length() > 0) {
            stringTokenizer = new StringTokenizer(string2.toUpperCase(), ",");
            while (stringTokenizer.hasMoreElements()) {
                string = (String)stringTokenizer.nextElement();
                if (this.from.indexOf(string.trim()) >= 0) continue;
                if (this.from.length() > 0) {
                    this.from = this.from + ",";
                }
                this.from = this.from + string;
            }
        }
        if ((string2 = queryFilter.getWhere()).length() > 0) {
            this.where = this.where != null && this.where.length() > 0 ? "(" + this.where + ") and (" + string2 + ")" : string2;
        }
        if ((string2 = queryFilter.getOrder()).length() > 0) {
            this.order = string2;
        }
        if (queryFilter.getMaxRowNumber() > 0) {
            this.maxRowNumber = queryFilter.getMaxRowNumber();
        }
        this.m_nPageSize = queryFilter.m_nPageSize;
        if (queryFilter.getSearchValues() != null) {
            if (this.m_listSearchValues != null) {
                this.m_listSearchValues.addAll(queryFilter.getSearchValues());
            } else {
                this.m_listSearchValues = queryFilter.getSearchValues();
            }
        }
        this.m_SQL = null;
        return this;
    }

    public String toSQL() {
        if (this.m_SQL != null) {
            return this.m_SQL;
        }
        this.m_SQL = "select " + CMyString.showNull(this.select, "*") + " from " + this.from;
        if (this.where != null && this.where.length() > 0) {
            this.m_SQL = this.m_SQL + " where " + this.where;
        }
        if (this.order != null && this.order.length() > 0) {
            this.m_SQL = this.m_SQL + " order by " + this.order;
        }
        return this.m_SQL;
    }

    public String toString() {
        String string = this.toSQL();
        if (this.m_listSearchValues == null) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() + 5 + this.m_listSearchValues.size() * 12);
        stringBuffer.append(string);
        int n = this.m_listSearchValues.size();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append('\n');
            stringBuffer.append("Param#");
            stringBuffer.append(i + 1);
            stringBuffer.append(":");
            stringBuffer.append(this.m_listSearchValues.get(i));
        }
        return stringBuffer.toString();
    }

    public boolean isToGetAll() {
        return this.where == null || this.where.trim().length() == 0;
    }

    public String findSelectField(String string) {
        int n;
        if (this.select == null || this.select.length() == 0) {
            return null;
        }
        String string2 = this.select.toUpperCase();
        char[] cArray = string2.toCharArray();
        String string3 = string.toUpperCase();
        int n2 = string.length();
        boolean bl = false;
        int n3 = 0;
        do {
            if ((n3 = string2.indexOf(string3, n3)) < 0) {
                return null;
            }
            if (n3 > 0 && cArray[n3 - 1] != ' ' && cArray[n3 - 1] != ',' && cArray[n3 - 1] != '.') {
                n3 += n2;
                continue;
            }
            n = n3 + n2;
            if (n < cArray.length) {
                if (cArray[n] != ' ' && cArray[n] != ',') {
                    n3 = n + 1;
                    continue;
                }
                while (++n < cArray.length && cArray[n] == ' ') {
                }
                if (cArray[n] == 'A') {
                    n3 = n + 2;
                    continue;
                }
            }
            bl = true;
            break;
        } while (!bl);
        for (n = n3 - 1; n >= 0; --n) {
            if (cArray[n] != ',') continue;
            ++n;
            break;
        }
        if (n < 0) {
            n = 0;
        }
        return this.select.substring(n, n3 + n2).trim();
    }

    public static void main(String[] stringArray) {
        QueryFilter queryFilter = new QueryFilter("", "", "", "Document.DocId");
        String[] stringArray2 = new String[]{"WCMDocument.DocId", "WCMDocument.DocId as DocId2", "WCMDocument.DocId as DocId2, WCMTest.TestId as DocId", "WCMDocument.MyDocId", "distinct WCMDocument.docid,WCMDocument.doctitle,WCMDocument.docstatus,WCMDocument.docchannel,WCMDocument.docauthor,WCMDocument.crtime,WCMDocument.cruser,WCMDocument.RightDefined,WCMDocument.DocType"};
        for (int i = 0; i < stringArray2.length; ++i) {
            queryFilter.setSelect(stringArray2[i]);
            System.out.println("[" + i + "] " + queryFilter.findSelectField("DocId"));
        }
        QueryFilter queryFilter2 = new QueryFilter("", "", "docid asc", "", 10);
        QueryFilter queryFilter3 = new QueryFilter("", "", "chnlid desc", "*", 20);
        queryFilter3.mergeWith(queryFilter2);
        System.out.println(queryFilter3.getOrder());
        System.out.println(queryFilter3.getMaxRowNumber());
        System.out.println(queryFilter3.getSelect());
    }

    public List getSearchValues() {
        return this.m_listSearchValues;
    }

    public void setSearchValues(List list) {
        this.m_listSearchValues = list;
    }

    public void addSearchValues(int n, int n2) {
        if (this.m_listSearchValues == null) {
            this.m_listSearchValues = new ArrayList();
        }
        if (this.m_listSearchValues.size() <= n) {
            this.m_listSearchValues.add(n, new Integer(n2));
        } else {
            this.m_listSearchValues.set(n, new Integer(n2));
        }
    }

    public void addSearchValues(int n) {
        int n2 = 0;
        if (this.m_listSearchValues != null) {
            n2 = this.m_listSearchValues.size();
        }
        this.addSearchValues(n2, n);
    }

    public void addSearchValues(int n, float f) {
        if (this.m_listSearchValues == null) {
            this.m_listSearchValues = new ArrayList();
        }
        if (this.m_listSearchValues.size() <= n) {
            this.m_listSearchValues.add(n, new Float(f));
        } else {
            this.m_listSearchValues.set(n, new Float(f));
        }
    }

    public void addSearchValues(float f) {
        int n = 0;
        if (this.m_listSearchValues != null) {
            n = this.m_listSearchValues.size();
        }
        this.addSearchValues(n, f);
    }

    public void addSearchValues(int n, double d) {
        if (this.m_listSearchValues == null) {
            this.m_listSearchValues = new ArrayList();
        }
        if (this.m_listSearchValues.size() <= n) {
            this.m_listSearchValues.add(n, new Double(d));
        } else {
            this.m_listSearchValues.set(n, new Double(d));
        }
    }

    public void addSearchValues(double d) {
        int n = 0;
        if (this.m_listSearchValues != null) {
            n = this.m_listSearchValues.size();
        }
        this.addSearchValues(n, d);
    }

    public void addSearchValues(int n, String string) {
        if (this.m_listSearchValues == null) {
            this.m_listSearchValues = new ArrayList();
        }
        if (this.m_listSearchValues.size() <= n) {
            this.m_listSearchValues.add(n, string);
        } else {
            this.m_listSearchValues.set(n, string);
        }
    }

    public void addSearchValues(String string) {
        int n = 0;
        if (this.m_listSearchValues != null) {
            n = this.m_listSearchValues.size();
        }
        this.addSearchValues(n, string);
    }

    public void addSearchValues(int n, CMyDateTime cMyDateTime) {
        if (this.m_listSearchValues == null) {
            this.m_listSearchValues = new ArrayList();
        }
        if (this.m_listSearchValues.size() <= n) {
            this.m_listSearchValues.add(n, cMyDateTime);
        } else {
            this.m_listSearchValues.set(n, cMyDateTime);
        }
    }

    public void addSearchValues(CMyDateTime cMyDateTime) {
        int n = 0;
        if (this.m_listSearchValues != null) {
            n = this.m_listSearchValues.size();
        }
        this.addSearchValues(n, cMyDateTime);
    }

    public boolean isForceFirstLoadIds() {
        return this.m_bForceFirstLoadIds;
    }

    public void setForceFirstLoadIds(boolean bl) {
        this.m_bForceFirstLoadIds = bl;
    }

    public int getPageSize() {
        return this.m_nPageSize;
    }

    public void setPageSize(int n) {
        this.m_nPageSize = n;
    }
}

