/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.config.domain;

import com.trs.infra.I18NMessage;
import com.trs.infra.config.domain.ConfigFilesFinder;
import com.trs.infra.config.domain.ConfigHelper;
import com.trs.infra.config.persistent.ConfigFiles;
import com.trs.infra.config.persistent.ExtensionConfigs;
import com.trs.infra.config.persistent.PluginConfig;
import com.trs.infra.util.CMyException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.xml.Unmarshaller;

public final class ConfigObjectLoader {
    private static Logger logger = Logger.getLogger(ConfigObjectLoader.class);
    private Map m_hmPluginConfigMap = null;
    private Map m_hmExtensionConfigByClassMap = null;
    private Map m_hmExtensionConfigByIdMap = null;
    private ConfigFilesFinder m_oConfigFileFinder = new ConfigFilesFinder(ConfigHelper.getDomainConfigPaths(), "config.xml");
    private boolean m_bLoaded = false;

    public ConfigObjectLoader() {
        this.m_hmPluginConfigMap = new HashMap();
        this.m_hmExtensionConfigByClassMap = new HashMap();
        this.m_hmExtensionConfigByIdMap = new HashMap();
    }

    public synchronized void clear() {
        this.m_hmExtensionConfigByClassMap.clear();
        this.m_hmExtensionConfigByIdMap.clear();
        this.m_hmPluginConfigMap.clear();
        this.m_bLoaded = false;
    }

    public synchronized void load() {
        if (this.m_bLoaded) {
            return;
        }
        try {
            ConfigFiles configFiles = this.m_oConfigFileFinder.getConfigFiles();
            Mapping mapping = new Mapping();
            try {
                mapping.loadMapping(ConfigHelper.getMappingSource(configFiles));
            }
            catch (Exception exception) {
                throw new CMyException(I18NMessage.get(ConfigObjectLoader.class, "ConfigObjectLoader.label1", "\u88c5\u8f7dCastor\u7684mapping\u6587\u4ef6\u65f6\u51fa\u9519"), exception);
            }
            for (int i = 0; i < configFiles.size(); ++i) {
                try {
                    File file = configFiles.get(i).getPlugin();
                    PluginConfig pluginConfig = ConfigObjectLoader.loadUnmarshallerRoot(file, mapping);
                    this.m_hmPluginConfigMap.put(pluginConfig.getHostFilePath(), pluginConfig);
                    this.loadExtensionByClassMapFromPlugin(pluginConfig);
                    this.loadExtensionByIdMapFromPlugin(pluginConfig);
                    continue;
                }
                catch (MappingException mappingException) {
                    throw new CMyException(I18NMessage.get(ConfigObjectLoader.class, "ConfigObjectLoader.label2", "\u5206\u6790\u6620\u5c04\u6587\u4ef6\u5931\u8d25! (\u5f53\u524d\u5206\u6790\u7684\u914d\u7f6e\u6587\u4ef6[") + configFiles.get(i).getPlugin().getPath() + "])", mappingException);
                }
                catch (Exception exception) {
                    throw new CMyException(I18NMessage.get(ConfigObjectLoader.class, "ConfigObjectLoader.label3", "\u5206\u6790\u914d\u7f6e\u6587\u4ef6[config-file=") + configFiles.get(i).getPlugin().getPath() + I18NMessage.get(ConfigObjectLoader.class, "ConfigObjectLoader.label4", "]\u5931\u8d25\uff1a") + exception.getLocalizedMessage(), exception);
                }
            }
            this.m_bLoaded = true;
        }
        catch (CMyException cMyException) {
            throw new RuntimeException("Load Config File error!" + CMyException.getStackTraceText(cMyException));
        }
    }

    private void loadExtensionByClassMapFromPlugin(PluginConfig pluginConfig) {
        ArrayList arrayList = pluginConfig.getExtensions();
        if (arrayList.size() == 0) {
            return;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            ExtensionConfigs extensionConfigs = (ExtensionConfigs)arrayList.get(i);
            String string = extensionConfigs.getClassName();
            if (this.m_hmExtensionConfigByClassMap.containsKey(string)) {
                this.getConfigElementsByClass(string).addAll(extensionConfigs.getConfigElements());
                continue;
            }
            ArrayList arrayList2 = new ArrayList();
            arrayList2.addAll(extensionConfigs.getConfigElements());
            this.m_hmExtensionConfigByClassMap.put(extensionConfigs.getClassName(), arrayList2);
        }
    }

    private void loadExtensionByIdMapFromPlugin(PluginConfig pluginConfig) {
        ArrayList arrayList = pluginConfig.getExtensions();
        HashMap<String, ExtensionConfigs> hashMap = new HashMap<String, ExtensionConfigs>();
        for (int i = 0; i < arrayList.size(); ++i) {
            Object object;
            ExtensionConfigs extensionConfigs = (ExtensionConfigs)arrayList.get(i);
            String string = extensionConfigs.getId();
            if (hashMap.containsKey(string)) {
                object = (ExtensionConfigs)hashMap.get(string);
                if (extensionConfigs.getClassName() != null && extensionConfigs.getClassName().compareTo(((ExtensionConfigs)object).getClassName()) != 0) {
                    throw new RuntimeException(I18NMessage.get(ConfigObjectLoader.class, "ConfigObjectLoader.label5", "\u5b9a\u4e49\u4e86\u4e00\u4e2a[id=") + extensionConfigs.getId() + "]\u3001[element-class=" + extensionConfigs.getClassName() + I18NMessage.get(ConfigObjectLoader.class, "ConfigObjectLoader.label6", "]\u914d\u7f6e\u9879\uff0c\u4f46\u8be5\u9879\u7684[id]\u5df2\u7ecf\u88ab\u53e6\u5916\u4e00\u4e2a[elemnt-class=") + ((ExtensionConfigs)object).getClassName() + I18NMessage.get(ConfigObjectLoader.class, "ConfigObjectLoader.label7", "]\u7684\u914d\u7f6e\u6587\u4ef6\u5360\u7528!"));
                }
                ArrayList arrayList2 = (ArrayList)this.m_hmExtensionConfigByIdMap.get(string);
                arrayList2.addAll(extensionConfigs.getConfigElements());
                continue;
            }
            hashMap.put(string, extensionConfigs);
            object = new ArrayList();
            ((ArrayList)object).addAll(extensionConfigs.getConfigElements());
            this.m_hmExtensionConfigByIdMap.put(string, object);
        }
    }

    private ArrayList getConfigElementsByClass(String string) {
        return (ArrayList)this.m_hmExtensionConfigByClassMap.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PluginConfig loadUnmarshallerRoot(File file, Mapping mapping) throws MappingException, Exception {
        PluginConfig pluginConfig = null;
        Unmarshaller unmarshaller = new Unmarshaller();
        Reader reader = null;
        try {
            unmarshaller.setMapping(mapping);
            reader = new InputStreamReader((InputStream)new FileInputStream(file), "GBK");
            pluginConfig = (PluginConfig)unmarshaller.unmarshal(reader);
            pluginConfig.setHostFilePath(file.getPath());
            PluginConfig pluginConfig2 = pluginConfig;
            return pluginConfig2;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private Map getExtensionConfigByClassMap() {
        if (!this.m_bLoaded) {
            this.load();
        }
        return this.m_hmExtensionConfigByClassMap;
    }

    private Map getExtensionConfigByIdMap() {
        if (!this.m_bLoaded) {
            this.load();
        }
        return this.m_hmExtensionConfigByIdMap;
    }

    public List getExtensionalObjects(Class clazz) {
        return (ArrayList)this.getExtensionConfigByClassMap().get(clazz.getName());
    }

    public List getExtensionalObjects(String string) {
        return (ArrayList)this.getExtensionConfigByIdMap().get(string);
    }

    public Map getPluginMap() {
        if (!this.m_bLoaded) {
            this.load();
        }
        return this.m_hmPluginConfigMap;
    }
}

