/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.config.domain;

import com.trs.infra.I18NMessage;
import com.trs.infra.config.ConfigConstants;
import com.trs.infra.config.TRSConfigServer;
import com.trs.infra.config.persistent.ConfigFiles;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.XmlDocWithDom4j;
import java.io.File;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.xml.sax.InputSource;

public class ConfigHelper {
    private static Logger logger = Logger.getLogger(ConfigHelper.class);
    public static boolean RUN_IN_ECLISPE = false;
    private static ArrayList s_arDomainConfigPaths = new ArrayList();
    private static ArrayList s_arServiceConfigPaths = new ArrayList();
    private static ArrayList s_arClassPaths = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList getDomainConfigPaths() {
        Properties properties = System.getProperties();
        if (s_arDomainConfigPaths.isEmpty()) {
            ArrayList arrayList = s_arDomainConfigPaths;
            synchronized (arrayList) {
                if (!s_arDomainConfigPaths.isEmpty()) {
                    return s_arDomainConfigPaths;
                }
                ArrayList<String> arrayList2 = new ArrayList<String>();
                boolean bl = RUN_IN_ECLISPE;
                String[] stringArray = properties.getProperty("java.class.path").split(";");
                for (int i = 0; i < stringArray.length; ++i) {
                    File file;
                    String string = stringArray[i];
                    File file2 = new File(string);
                    if (!file2.isDirectory()) continue;
                    string = file2.getAbsolutePath();
                    if (!bl && string.endsWith(".cp")) {
                        bl = true;
                        continue;
                    }
                    if (!string.endsWith(File.separator)) {
                        string = string + File.separator;
                    }
                    if (!(file = new File(string = string + "trsconfig" + File.separator + "domain" + File.separator)).exists()) continue;
                    arrayList2.add(string);
                }
                if (!bl) {
                    arrayList2 = new ArrayList();
                    arrayList2.add(ConfigConstants.getConfigRootPath());
                }
                s_arDomainConfigPaths = arrayList2;
            }
        }
        return s_arDomainConfigPaths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList getClassPaths() {
        Properties properties = System.getProperties();
        if (s_arClassPaths.isEmpty()) {
            ArrayList arrayList = s_arClassPaths;
            synchronized (arrayList) {
                if (!s_arClassPaths.isEmpty()) {
                    return s_arClassPaths;
                }
                ArrayList<String> arrayList2 = new ArrayList<String>();
                boolean bl = RUN_IN_ECLISPE;
                String[] stringArray = properties.getProperty("java.class.path").split(";");
                for (int i = 0; i < stringArray.length; ++i) {
                    String string = stringArray[i];
                    File file = new File(string);
                    if (!file.isDirectory()) continue;
                    string = file.getAbsolutePath();
                    if (!bl && string.endsWith(".cp")) {
                        bl = true;
                        continue;
                    }
                    if (!string.endsWith(File.separator)) {
                        string = string + File.separator;
                    }
                    arrayList2.add(string);
                }
                if (!bl) {
                    arrayList2 = new ArrayList();
                    arrayList2.add(TRSConfigServer.getAppRootPath());
                }
                s_arClassPaths = arrayList2;
            }
        }
        return s_arClassPaths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList getServiceConfigPaths() {
        Properties properties = System.getProperties();
        if (s_arServiceConfigPaths.isEmpty()) {
            ArrayList arrayList = s_arServiceConfigPaths;
            synchronized (arrayList) {
                if (!s_arServiceConfigPaths.isEmpty()) {
                    return s_arServiceConfigPaths;
                }
                ArrayList<String> arrayList2 = new ArrayList<String>();
                boolean bl = RUN_IN_ECLISPE;
                String[] stringArray = properties.getProperty("java.class.path").split(";");
                for (int i = 0; i < stringArray.length; ++i) {
                    File file;
                    String string = stringArray[i];
                    File file2 = new File(string);
                    if (!file2.isDirectory()) continue;
                    string = file2.getAbsolutePath();
                    if (!bl && string.endsWith(".cp")) {
                        bl = true;
                        continue;
                    }
                    if (!string.endsWith(File.separator)) {
                        string = string + File.separator;
                    }
                    if (!(file = new File(string = string + "trsconfig" + File.separator)).exists()) continue;
                    arrayList2.add(string);
                }
                if (!bl) {
                    arrayList2 = new ArrayList();
                    arrayList2.add(TRSConfigServer.getConfigRootPath());
                }
                s_arServiceConfigPaths = arrayList2;
            }
        }
        return s_arServiceConfigPaths;
    }

    public static Document toXMLDocument(File file) throws CMyException {
        if (file == null) {
            throw new CMyException(20, I18NMessage.get(ConfigHelper.class, "ConfigHelper.label1", "\u6307\u5b9a\u7684XML\u6587\u4ef6\u4e0d\u5b58\u5728!"));
        }
        try {
            return XmlDocWithDom4j.parse(file.getAbsolutePath());
        }
        catch (Exception exception) {
            throw new CMyException(150, I18NMessage.get(ConfigHelper.class, "ConfigHelper.label2", "\u5efa\u7acbXML Document\u5bf9\u8c61\u5931\u8d25!"), exception);
        }
    }

    public static InputSource getMappingSource(ConfigFiles configFiles) throws CMyException {
        Document document = ConfigHelper.getMappingDoc(ConfigConstants.getAbsoluteFileNameOfCoreMapping());
        Document document2 = null;
        for (int i = 0; i < configFiles.size(); ++i) {
            File file = configFiles.get(i).getMapping();
            if (file == null || file.getPath().compareTo(ConfigConstants.getAbsoluteFileNameOfCoreMapping()) == 0) continue;
            document2 = ConfigHelper.getMappingDoc(file.getPath());
            List list = document2.getRootElement().elements("class");
            int n = list.size();
            while (n > 0) {
                Element element = (Element)list.get(--n);
                element.getParent().remove(element);
                document.getRootElement().add(element);
            }
        }
        return ConfigHelper.toFileInputSrcFromXmlDocument(document);
    }

    public static InputSource getMappingSource(String string) throws CMyException {
        return ConfigHelper.toFileInputSrcFromXmlDocument(ConfigHelper.getMappingDoc(string));
    }

    private static InputSource toFileInputSrcFromXmlDocument(Document document) {
        return new InputSource(new StringReader(document.asXML()));
    }

    private static Document getMappingDoc(String string) throws CMyException {
        Document document = null;
        try {
            logger.debug((Object)("Loading the mapping file[" + string + "]"));
            document = XmlDocWithDom4j.parse(string);
        }
        catch (Exception exception) {
            if (string.compareTo(ConfigConstants.getAbsoluteFileNameOfCoreMapping()) == 0) {
                return ConfigHelper.getEmptyXMLDocument();
            }
            throw new CMyException(I18NMessage.get(ConfigHelper.class, "ConfigHelper.label3", "\u8bfb\u53d6\u6216\u89e3\u6790\u6587\u4ef6[") + string + I18NMessage.get(ConfigHelper.class, "ConfigHelper.label4", "]\u65f6\u51fa\u9519"), exception);
        }
        return document;
    }

    private static Document getEmptyXMLDocument() {
        return DocumentHelper.createDocument();
    }
}

