/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.config.domain;

import com.trs.infra.common.WCMException;
import com.trs.infra.config.persistent.ConfigFile;
import com.trs.infra.config.persistent.ConfigFiles;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class ConfigFilesFinder {
    private static Logger s_logger = Logger.getLogger(ConfigFilesFinder.class);
    private ConfigFiles m_oConfigFiles = null;
    private ArrayList m_pConfigFileRootPaths = new ArrayList();
    private String m_sConfigXmlFile;
    private HashMap m_mapAlreadyDoneWithFileNames = new HashMap();

    public ConfigFilesFinder(String string, String string2) {
        this.m_pConfigFileRootPaths.add(string);
        this.m_sConfigXmlFile = string2;
    }

    public ConfigFilesFinder(ArrayList arrayList, String string) {
        this.m_pConfigFileRootPaths = arrayList;
        this.m_sConfigXmlFile = string;
    }

    public ConfigFiles getConfigFiles() throws WCMException {
        if (this.m_oConfigFiles == null) {
            this.m_oConfigFiles = new ConfigFiles();
            for (int i = 0; i < this.m_pConfigFileRootPaths.size(); ++i) {
                String string = (String)this.m_pConfigFileRootPaths.get(i);
                if (s_logger.isDebugEnabled()) {
                    s_logger.debug((Object)("begin to load config files from[" + string + "]..."));
                }
                File file = new File(string);
                this.lookupCfgFiles(file);
            }
        } else if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)"the files have been loaded.");
        }
        return this.m_oConfigFiles;
    }

    public ConfigFiles refresh() throws CMyException {
        this.m_oConfigFiles = null;
        return this.getConfigFiles();
    }

    private void lookupCfgFiles(File file) {
        if (file.isFile()) {
            if (!file.getName().equals(this.m_sConfigXmlFile)) {
                return;
            }
            String string = CMyFile.extractFilePath(file.getPath()) + "mapping.xml";
            File file2 = CMyFile.fileExists(string) ? new File(string) : null;
            String string2 = file.getAbsolutePath();
            String string3 = this.extractConfigFileNameExcludeProjectPath(string2);
            ConfigFile configFile = (ConfigFile)this.m_mapAlreadyDoneWithFileNames.get(string3);
            if (configFile != null) {
                if (configFile.getMapping() == null && file2 != null) {
                    configFile.setMapping(file2);
                }
                return;
            }
            configFile = new ConfigFile(file, file2);
            this.m_mapAlreadyDoneWithFileNames.put(string3, configFile);
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)("load xml file[" + file.getPath() + "]"));
            }
            this.m_oConfigFiles.add(configFile);
            return;
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            s_logger.warn((Object)("May be a IOException,find an invalid dir:" + file.getAbsolutePath()));
            return;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            this.lookupCfgFiles(fileArray[i]);
        }
    }

    private String extractConfigFileNameExcludeProjectPath(String string) {
        String string2 = File.separatorChar + "trsconfig" + File.separatorChar;
        String string3 = string;
        int n = string.indexOf(string2);
        if (n >= 0) {
            string3 = string.substring(n);
        }
        return string3;
    }

    private ConfigFile getConfigFile(File file) {
        String string = file.getAbsolutePath();
        String string2 = this.extractConfigFileNameExcludeProjectPath(string);
        ConfigFile configFile = (ConfigFile)this.m_mapAlreadyDoneWithFileNames.get(string2);
        if (configFile != null) {
            System.out.println("sConfigFileNameExcludeProjectPath\uff1a" + string2);
            System.out.println("sConfigFileNameExcludeProjectPath\uff1a" + this.m_mapAlreadyDoneWithFileNames.get(string2));
            return configFile;
        }
        this.m_mapAlreadyDoneWithFileNames.put(string2, string);
        return null;
    }
}

