/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.config.domain;

import com.trs.infra.I18NMessage;
import com.trs.infra.config.BeanConfigServer;
import com.trs.infra.config.persistent.BeanConfig;
import com.trs.infra.util.CMyException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.DocumentType;
import org.dom4j.Element;
import org.dom4j.tree.DefaultDocumentType;

public class BeanConfigHelper {
    private Document m_oBeansDocument;
    private Element m_elBeansRoot;
    private List m_listBeanConfigCollection;

    public BeanConfigHelper(List list) {
        this.m_listBeanConfigCollection = list;
        this.m_elBeansRoot = DocumentHelper.createElement((String)"beans");
        this.m_oBeansDocument = DocumentHelper.createDocument((Element)this.m_elBeansRoot);
        DefaultDocumentType defaultDocumentType = new DefaultDocumentType("beans", "-//SPRING//DTD BEAN//EN", "http://www.springframework.org/dtd/spring-beans.dtd");
        this.m_oBeansDocument.setDocType((DocumentType)defaultDocumentType);
    }

    public InputStream getBeanConfigXmlInputStream() throws CMyException {
        if (this.m_listBeanConfigCollection == null || this.m_listBeanConfigCollection.isEmpty()) {
            throw new CMyException(I18NMessage.get(BeanConfigHelper.class, "BeanConfigHelper.label1", "\u5c1a\u672a\u8bfb\u53d6\u914d\u7f6e\u6587\u4ef6\uff0c\u521d\u59cb\u5316\u5931\u8d25"));
        }
        String string = "bean";
        String string2 = "id";
        String string3 = "class";
        String string4 = "singleton";
        for (int i = 0; i < this.m_listBeanConfigCollection.size(); ++i) {
            BeanConfig beanConfig = (BeanConfig)this.m_listBeanConfigCollection.get(i);
            Element element = DocumentHelper.createElement((String)string);
            element.addAttribute(string2, beanConfig.getId());
            element.addAttribute(string3, beanConfig.getClassName());
            if (beanConfig.isSingleton()) {
                element.addAttribute(string4, "true");
            } else {
                element.addAttribute(string4, "false");
            }
            this.m_elBeansRoot.add(element);
        }
        this.m_oBeansDocument.setXMLEncoding("UTF-8");
        return BeanConfigHelper.getInputStream(this.m_oBeansDocument.asXML(), "UTF-8");
    }

    private static InputStream getInputStream(String string, String string2) throws CMyException {
        try {
            byte[] byArray = string.getBytes(string2);
            return new ByteArrayInputStream(byArray);
        }
        catch (Exception exception) {
            throw new CMyException("Failed to convert string into UTF-8 stream.", exception);
        }
    }

    public void unload() {
        this.m_elBeansRoot = null;
        this.m_oBeansDocument = null;
        this.m_listBeanConfigCollection.clear();
    }

    public static void checkIsBeanValid(String string, String string2) {
        if (!BeanConfigServer.started()) {
            return;
        }
        if (!BeanConfigServer.getInstance().containsBean(string)) {
            throw new RuntimeException("[name=" + string2 + I18NMessage.get(BeanConfigHelper.class, "BeanConfigHelper.label2", "]\u7684\u914d\u7f6e\u5bf9\u8c61\uff0c\u5176[BeanId=") + string + I18NMessage.get(BeanConfigHelper.class, "BeanConfigHelper.label3", "]\u65e0\u6548\uff01"));
        }
    }

    public static void checkIsBeanValid(String string) {
        BeanConfigHelper.checkIsBeanValid(string, "UNKOWN");
    }
}

