/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.config;

import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.config.BaseConfigServer;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.Loader;
import com.trs.infra.util.WCMDiscoveryFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class TRSConfigServer {
    private static final String SERVER_CLASS_NAME_INI = "server.class.name.ini";
    private static Logger logger = Logger.getLogger(TRSConfigServer.class);
    private static String sPropertiesFilePath = null;
    private static final int STATUS_NOTSTART = 0;
    private static final int STATUS_STARTING = 1;
    private static final int STATUS_STARTED = 2;
    private static final int STATUS_STARTFAIL = 3;
    public static String FILENAME_APP_PROPERTIES = "TRSApp.properties";
    private static String KEY_ROOT_PATH = "config.root.path";
    private static String PATH_CONFIG_ROOT = null;
    private static int STATUS_CURRENT = 0;
    private static Map MAP_CONFIG_SERVER = null;
    private static String s_sAppRootPath = null;

    public static BaseConfigServer findConfigServerById(String string) {
        if (MAP_CONFIG_SERVER == null) {
            TRSConfigServer.start();
        }
        return (BaseConfigServer)MAP_CONFIG_SERVER.get(string.toLowerCase());
    }

    public static String getConfigRootPath() {
        if (PATH_CONFIG_ROOT == null) {
            try {
                TRSConfigServer.makeConfigRootPath();
            }
            catch (WCMException wCMException) {
                throw new RuntimeException("Fail to load config root path!", wCMException);
            }
        }
        return PATH_CONFIG_ROOT;
    }

    public static void start() {
        if (MAP_CONFIG_SERVER == null) {
            try {
                TRSConfigServer.init();
            }
            catch (Throwable throwable) {
                logger.error((Object)I18NMessage.get(TRSConfigServer.class, "TRSConfigServer.label1", "\u542f\u52a8ConfigServer\u5931\u8d25!"), throwable);
                STATUS_CURRENT = 3;
            }
        }
    }

    private static synchronized void init() throws WCMException {
        if (MAP_CONFIG_SERVER != null || STATUS_CURRENT == 3) {
            return;
        }
        STATUS_CURRENT = 1;
        TRSConfigServer.makeConfigRootPath();
        HashMap<String, BaseConfigServer> hashMap = new HashMap<String, BaseConfigServer>(10);
        Iterator iterator = WCMDiscoveryFactory.getDiscovery().getImplementors(BaseConfigServer.class.getName());
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            BaseConfigServer baseConfigServer = null;
            try {
                baseConfigServer = (BaseConfigServer)Class.forName(string).newInstance();
            }
            catch (Exception exception) {
                logger.error((Object)(I18NMessage.get(TRSConfigServer.class, "TRSConfigServer.label2", "\u5b9e\u4f8b\u5316\u914d\u7f6e\u670d\u52a1\u5668\u5b9e\u4f8b\u5931\u8d25\uff01[Class=") + string + ", ClassName=" + string + "]"), (Throwable)exception);
                continue;
            }
            try {
                baseConfigServer.startup();
            }
            catch (Throwable throwable) {
                logger.error((Object)(I18NMessage.get(TRSConfigServer.class, "TRSConfigServer.label3", "\u542f\u52a8\u914d\u7f6e\u670d\u52a1\u5668\u5b9e\u4f8b\u5931\u8d25\uff01[Class=") + string + ", ClassName=" + string + "]"), throwable);
            }
            hashMap.put(baseConfigServer.getServerName().toLowerCase(), baseConfigServer);
        }
        MAP_CONFIG_SERVER = hashMap;
        STATUS_CURRENT = 2;
    }

    private static synchronized void makeConfigRootPath() throws WCMException {
        if (PATH_CONFIG_ROOT != null) {
            return;
        }
        String string = TRSConfigServer.loadDefaultProperties();
        if (string == null) {
            throw new WCMException(I18NMessage.get(TRSConfigServer.class, "TRSConfigServer.label5", "\u8bfb\u53d6\u9ed8\u8ba4\u7684\u914d\u7f6e\u6587\u4ef6\u6839\u76ee\u5f55\u5931\u8d25\uff01"));
        }
        File file = new File(string);
        if (!file.exists() || !file.isDirectory()) {
            string = CMyString.setStrEndWith(string, '/');
            URL uRL = Loader.getResource(FILENAME_APP_PROPERTIES);
            File file2 = new File(uRL.getFile());
            string = CMyFile.extractFilePath(file2.getAbsolutePath()) + string;
            file = new File(string);
        }
        if (!file.exists() || !file.isDirectory()) {
            throw new WCMException(I18NMessage.get(TRSConfigServer.class, "TRSConfigServer.label6", "\u8bbe\u7f6e\u7684\u76ee\u5f55[") + string + I18NMessage.get(TRSConfigServer.class, "TRSConfigServer.label4", "]\u4e0d\u6b63\u786e\uff01"));
        }
        if (File.separatorChar == '\\') {
            string = string.replace('/', File.separatorChar);
        }
        PATH_CONFIG_ROOT = CMyString.setStrEndWith(string, File.separatorChar);
    }

    private static String loadDefaultProperties() {
        Serializable serializable;
        URL uRL = Loader.getResource(FILENAME_APP_PROPERTIES);
        if (uRL == null) {
            throw new RuntimeException("Cannot find file[" + FILENAME_APP_PROPERTIES + "] at the root of application!");
        }
        InputStream inputStream = null;
        try {
            sPropertiesFilePath = uRL.getFile();
            inputStream = uRL.openStream();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Cannot find file[" + FILENAME_APP_PROPERTIES + "] at the root of application!", iOException);
        }
        String string = null;
        if (inputStream != null) {
            logger.info((Object)("Load service from properties: " + sPropertiesFilePath + ".."));
            serializable = new Properties();
            try {
                ((Properties)serializable).load(inputStream);
                string = ((Properties)serializable).getProperty(KEY_ROOT_PATH);
            }
            catch (IOException iOException) {
                logger.info((Object)("Errors occur when reading " + sPropertiesFilePath + ", ommited"));
                iOException.printStackTrace();
            }
            logger.info((Object)"Finished to load service from properties.");
        }
        serializable = new File(sPropertiesFilePath);
        s_sAppRootPath = ((File)serializable).getAbsolutePath();
        if (File.separatorChar == '\\') {
            s_sAppRootPath = s_sAppRootPath.replace('/', '\\');
        }
        s_sAppRootPath = CMyFile.extractFilePath(s_sAppRootPath);
        return string;
    }

    public static String getAppRootPath() {
        if (s_sAppRootPath != null) {
            return s_sAppRootPath;
        }
        TRSConfigServer.start();
        return s_sAppRootPath;
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println("result:" + TRSConfigServer.getConfigRootPath());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        TRSConfigServer.start();
    }
}

