/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.config;

import com.trs.infra.config.TRSConfigServer;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.Loader;
import java.io.File;
import java.net.URL;

public final class ConfigConstants {
    public static String DIR_APPROOT = ConfigConstants.makeAppRootPath();
    public static String DIR_CLASSROOT = ConfigConstants.makeClassRootPath();
    public static final String EXT_FILE_CONFIG = "xml";
    public static final String NAME_FILE_CONFIG = "config.xml";
    public static final String NAME_FILE_BEAN = "beans.xml";
    public static final String TAG_ELEMENT_BEANS = "beans";
    public static final String TAG_ELEMENT_BEAN = "bean";
    public static final String TAG_ATTRIBUTE_BEANID = "id";
    public static final String TAG_ATTRIBUTE_BEANCLASSNAME = "class";
    public static final String NAME_FILE_MAPPING = "mapping.xml";
    public static final String TAG_ATTRIBUTE_BEANISSINGLETON = "singleton";
    public static final int ERR_FORMAT_INVALID = 3000;

    private static String makeAppRootPath() {
        URL uRL = Loader.getResource(TRSConfigServer.FILENAME_APP_PROPERTIES);
        if (uRL == null) {
            throw new RuntimeException("Cannot find file[" + TRSConfigServer.FILENAME_APP_PROPERTIES + "] at the root of application!");
        }
        String string = null;
        string = uRL.getFile();
        File file = new File(string);
        String string2 = file.getAbsolutePath();
        if (File.separatorChar == '\\') {
            string2 = string2.replace('/', '\\');
        }
        string2 = CMyFile.extractFilePath(string2);
        return string2;
    }

    private static String makeClassRootPath() {
        try {
            URL uRL = Loader.getResource("RootFile.trs");
            if (uRL == null) {
                throw new RuntimeException("Cannot find file[" + TRSConfigServer.FILENAME_APP_PROPERTIES + "] at the root of application!");
            }
            String string = null;
            string = uRL.getFile();
            File file = new File(string);
            String string2 = file.getAbsolutePath();
            if (File.separatorChar == '\\') {
                string2 = string2.replace('/', '\\');
            }
            string2 = CMyFile.extractFilePath(string2);
            return string2;
        }
        catch (Throwable throwable) {
            return ConfigConstants.makeAppRootPath();
        }
    }

    public static String getAbsoluteFileNameOfCoreMapping() {
        return ConfigConstants.getConfigRootPath() + NAME_FILE_MAPPING;
    }

    public static String getAbsoluteFileNameOfCoreConfigXML() {
        return ConfigConstants.getConfigRootPath() + NAME_FILE_CONFIG;
    }

    public static String getAbsoluteFileNameOfCoreBeansXML() {
        return ConfigConstants.getConfigRootPath() + NAME_FILE_BEAN;
    }

    public static String getConfigRootPath() {
        try {
            return TRSConfigServer.getConfigRootPath() + "domain" + File.separator;
        }
        catch (Exception exception) {
            throw new RuntimeException("Fail to read config path!", exception);
        }
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println(DIR_APPROOT);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

