/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.config;

import com.trs.infra.BaseServer;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.config.ConfigConstants;
import com.trs.infra.config.domain.ConfigFilesFinder;
import com.trs.infra.config.domain.ConfigHelper;
import com.trs.infra.config.domain.ConfigObjectLoader;
import com.trs.infra.config.persistent.BeanConfig;
import com.trs.infra.config.persistent.ConfigFiles;
import com.trs.infra.config.persistent.PluginConfig;
import com.trs.infra.util.CMyException;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exolab.castor.mapping.Mapping;

public class BeanConfigServer
extends BaseServer {
    private ConfigFilesFinder m_oConfigFileFinder = new ConfigFilesFinder(ConfigHelper.getDomainConfigPaths(), "beans.xml");
    private Map m_hmBeanIdMap = new HashMap();
    private Map m_hmPluginIdMap = new HashMap();
    private List m_listBeanConfigCollection = new ArrayList();
    private static BeanConfigServer itsInstance = new BeanConfigServer();

    private BeanConfigServer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BeanConfigServer getInstance() {
        if (itsInstance == null) {
            itsInstance = new BeanConfigServer();
        }
        if (!itsInstance.isStarted()) {
            BeanConfigServer beanConfigServer = itsInstance;
            synchronized (beanConfigServer) {
                if (itsInstance.isStarted()) {
                    return itsInstance;
                }
                itsInstance.startup();
                if (!itsInstance.isStarted()) {
                    throw new RuntimeException("Bean Config Server startup Error!" + itsInstance.getErrors());
                }
            }
        }
        return itsInstance;
    }

    protected void doShutdown() {
        this.m_hmBeanIdMap.clear();
        this.m_hmPluginIdMap.clear();
        this.m_listBeanConfigCollection.clear();
        if (this.m_oConfigFileFinder != null) {
            this.m_oConfigFileFinder = null;
        }
    }

    protected boolean doStart() throws WCMException {
        try {
            if (this.m_bIsStarted) {
                return false;
            }
            this.load();
            return true;
        }
        catch (Exception exception) {
            throw new WCMException(I18NMessage.get(BeanConfigServer.class, "BeanConfigServer.label1", "\u521d\u59cb\u5316\u914d\u7f6e\u670d\u52a1\u5668\u5931\u8d25"), exception);
        }
    }

    public List getBeanConfigCollection() {
        return this.m_listBeanConfigCollection;
    }

    public List getBeanConfigCollection(String string) {
        return (List)this.m_hmPluginIdMap.get(string);
    }

    void load() throws CMyException {
        ConfigFiles configFiles = this.m_oConfigFileFinder.getConfigFiles();
        Mapping mapping = new Mapping();
        try {
            mapping.loadMapping(ConfigHelper.getMappingSource(ConfigConstants.getAbsoluteFileNameOfCoreMapping()));
        }
        catch (Exception exception) {
            throw new RuntimeException(I18NMessage.get(BeanConfigServer.class, "BeanConfigServer.label2", "\u88c5\u8f7dCastor\u7684mapping\u6587\u4ef6\u65f6\u51fa\u9519:") + exception.getMessage(), exception);
        }
        for (int i = 0; i < configFiles.size(); ++i) {
            try {
                File file = configFiles.get(i).getPlugin();
                PluginConfig pluginConfig = ConfigObjectLoader.loadUnmarshallerRoot(file, mapping);
                this.loadBeanCollectionFromPlugin(pluginConfig);
                this.loadBeanIdMapFromPlugin(pluginConfig);
                this.loadPluginIdFromPluginMap(pluginConfig);
                continue;
            }
            catch (Exception exception) {
                throw new CMyException(I18NMessage.get(BeanConfigServer.class, "BeanConfigServer.label3", "\u5206\u6790\u914d\u7f6e\u6587\u4ef6[config-file=") + configFiles.get(i).getPlugin().getPath() + I18NMessage.get(BeanConfigServer.class, "BeanConfigServer.label4", "]\u5931\u8d25\uff1a") + exception.getLocalizedMessage(), exception);
            }
        }
    }

    private void loadPluginIdFromPluginMap(PluginConfig pluginConfig) throws CMyException {
        if (this.m_hmPluginIdMap.containsKey(pluginConfig.getId())) {
            throw new CMyException("[id=" + pluginConfig.getId() + I18NMessage.get(BeanConfigServer.class, "BeanConfigServer.label5", "]\u7684plugin\u5df2\u5b9a\u4e49"));
        }
        this.m_hmPluginIdMap.put(pluginConfig.getId(), pluginConfig.getBeans());
    }

    private void loadBeanCollectionFromPlugin(PluginConfig pluginConfig) {
        this.m_listBeanConfigCollection.addAll(pluginConfig.getBeans());
    }

    void loadBeanIdMapFromPlugin(PluginConfig pluginConfig) {
        ArrayList arrayList = pluginConfig.getBeans();
        for (int i = 0; i < arrayList.size(); ++i) {
            BeanConfig beanConfig = (BeanConfig)arrayList.get(i);
            this.m_hmBeanIdMap.put(beanConfig.getId(), beanConfig.getClassName());
        }
    }

    public boolean containsBean(String string) {
        return this.m_hmBeanIdMap.containsKey(string);
    }

    public static boolean started() {
        return itsInstance.isStarted();
    }
}

