/*
 * Decompiled with CFR 0.152.
 */
package com.trs.deployer.domain.filter;

import com.trs.deployer.domain.impl.DeployCompletedInfoMgr;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;
import com.trs.update.wcm.UpdateFixStatus;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class DeployerControllerFilter
implements Filter {
    private static Logger logger = Logger.getLogger(DeployerControllerFilter.class);
    private String[] aExcludeFiles;
    private String[] aExcludeDirs;
    private String sRedictPageValue = null;
    private String sRedictPage4UpdateFix = "app/installdeployer/updating_info.html";
    private String sFilterParameter = "notAccessFilterJsp";
    private String sFilterparameterWithDir = "notAccessFilterPath";
    private String sRedictPage = "accessRedictPage";

    public void destroy() {
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)req;
        HttpServletResponse httpResponse = (HttpServletResponse)res;
        DeployCompletedInfoMgr deployerComInfo = new DeployCompletedInfoMgr();
        UpdateFixStatus updateFixStatus = new UpdateFixStatus();
        boolean bDeployerComplate = true;
        boolean bUpgradeFix = false;
        try {
            bDeployerComplate = deployerComInfo.isCompleted("WCM");
            bUpgradeFix = updateFixStatus.isUpgrading();
            if (bDeployerComplate && !bUpgradeFix) {
                chain.doFilter(req, res);
                return;
            }
            if (bUpgradeFix) {
                this.sRedictPageValue = this.sRedictPage4UpdateFix;
            }
        }
        catch (CMyException e) {
            logger.error((Object)"\u5224\u65ad\u5347\u7ea7\u540e\u662f\u5426\u90e8\u7f72\u5b8c\u6210\u7684\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)e);
        }
        String sUri = httpRequest.getRequestURI();
        String sContextPath = CMyString.showNull(httpRequest.getContextPath(), "/wcm");
        sContextPath = CMyString.setStrEndWith(sContextPath, '/');
        String sFileNameWithPath = sUri.substring(sContextPath.length());
        int nIdx = sUri.lastIndexOf("/");
        String sFileName = "";
        if (sUri.length() < nIdx + 1) {
            httpResponse.sendRedirect(String.valueOf(sContextPath) + this.sRedictPageValue);
            return;
        }
        sFileName = sUri.substring(nIdx + 1);
        if (this.isExcludeDirs(this.aExcludeDirs, sFileNameWithPath) || this.bArrIncludeStr(this.aExcludeFiles, sFileName)) {
            chain.doFilter(req, res);
            return;
        }
        if (bUpgradeFix) {
            logger.info((Object)"\u66f4\u65b0fix\u5c1a\u672a\u5b8c\u6210\uff0c\u5982\u679c\u8981\u5f3a\u884c\u89e3\u9664\u8bbf\u95ee\u63a7\u5236\uff0c\u53ef\u624b\u5de5\u5220\u9664classes\u76ee\u5f55\u4e0b\u7684[updatefix.txt]");
        }
        httpResponse.sendRedirect(String.valueOf(sContextPath) + this.sRedictPageValue);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        String sExcludeDirs = filterConfig.getInitParameter(this.sFilterparameterWithDir);
        this.aExcludeDirs = CMyString.isEmpty(sExcludeDirs) ? null : sExcludeDirs.split(",");
        this.sRedictPageValue = filterConfig.getInitParameter(this.sRedictPage);
        String sNotFilterJspValue = filterConfig.getInitParameter(this.sFilterParameter);
        this.aExcludeFiles = sNotFilterJspValue.split(",");
    }

    private boolean isExcludeDirs(String[] aValue, String sFileNameWithPath) {
        if (aValue == null || aValue.length <= 0) {
            return false;
        }
        if (CMyString.isEmpty(sFileNameWithPath)) {
            return true;
        }
        int i = 0;
        while (i < aValue.length) {
            if (sFileNameWithPath.startsWith(aValue[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean bArrIncludeStr(String[] aValue, String sFileName) {
        if (aValue == null || CMyString.isEmpty(sFileName)) {
            return true;
        }
        int i = 0;
        while (i < aValue.length) {
            if (sFileName.equals(aValue[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

