/*
 * Decompiled with CFR 0.152.
 */
package com.trs.db.schema;

import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.database.DBType;
import com.trs.infra.util.database.DBTypes;
import com.trs.infra.util.database.TableInfo;
import com.trs.infra.util.database.TableInfos;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Enumeration;
import org.apache.log4j.Logger;

public class TRSDBSchema {
    private static Logger logger = Logger.getLogger(TRSDBSchema.class);
    private DBManager m_oDBMgr = DBManager.getDBManager();
    private int m_nDBType = 0;
    private DBType m_oDBType = null;

    public TRSDBSchema(int n) {
        this.m_nDBType = n;
        this.m_oDBType = DBTypes.getDBType(this.m_nDBType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String createDBDataInsertSQL(String string) throws Exception {
        block16: {
            String string2 = CMyFile.extractFilePath(string);
            if (!CMyFile.pathExists(string2)) {
                CMyFile.makeDir(string2, true);
            }
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "GBK");
            TableInfos tableInfos = this.m_oDBMgr.getTableInfos();
            Enumeration enumeration = tableInfos.getTableNames();
            while (enumeration.hasMoreElements()) {
                String string3 = (String)enumeration.nextElement();
                TableInfo tableInfo = tableInfos.getTableInfo(string3);
                if (tableInfo == null) continue;
                this.createTableDataInsertSQL(tableInfo, outputStreamWriter);
            }
            Object var10_10 = null;
            try {
                if (outputStreamWriter != null) {
                    ((Writer)outputStreamWriter).flush();
                    ((Writer)outputStreamWriter).close();
                }
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
                break block16;
            }
            catch (Exception exception) {}
            break block16;
            {
                catch (Exception exception) {
                    logger.error((Object)I18NMessage.get(TRSDBSchema.class, "TRSDBSchema.label1", "\u4ea7\u751f\u6570\u636e\u7ef4\u62a4\u811a\u672c\u51fa\u73b0\u5f02\u5e38\uff01"), (Throwable)exception);
                    exception.printStackTrace();
                    Object var10_11 = null;
                    try {
                        if (outputStreamWriter != null) {
                            ((Writer)outputStreamWriter).flush();
                            ((Writer)outputStreamWriter).close();
                        }
                        if (fileOutputStream != null) {
                            fileOutputStream.close();
                        }
                        break block16;
                    }
                    catch (Exception exception2) {}
                }
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                try {
                    if (outputStreamWriter != null) {
                        ((Writer)outputStreamWriter).flush();
                        ((Writer)outputStreamWriter).close();
                    }
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return null;
    }

    /*
     * Loose catch block
     */
    private String createTableDataInsertSQL(TableInfo tableInfo, Writer writer) throws WCMException {
        block17: {
            Connection connection = null;
            Statement statement = null;
            ResultSet resultSet = null;
            ResultSetMetaData resultSetMetaData = null;
            String string = "select * from " + tableInfo.getTableName();
            connection = this.m_oDBMgr.getConnection();
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string);
            while (resultSet.next()) {
                if (resultSetMetaData == null) {
                    resultSetMetaData = resultSet.getMetaData();
                }
                writer.write(this.createSQLFromRs(tableInfo.getTableName(), resultSet, resultSetMetaData));
            }
            Object var10_8 = null;
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (connection != null) {
                this.m_oDBMgr.freeConnection(connection);
            }
            break block17;
            {
                catch (SQLException sQLException) {
                    throw new WCMException(40, I18NMessage.get(TRSDBSchema.class, "TRSDBSchema.label2", "\u83b7\u53d6\u6570\u636e\u65f6\u5931\u8d25\uff08") + this.getClass().getName() + ".createTableDataInsertSQL)\uff1aSQL=" + string, sQLException);
                }
                catch (Exception exception) {
                    throw new WCMException(0, I18NMessage.get(TRSDBSchema.class, "TRSDBSchema.label2", "\u83b7\u53d6\u6570\u636e\u65f6\u5931\u8d25\uff08") + this.getClass().getName() + ".refresh)\uff1acreateTableDataInsertSQL=" + string, exception);
                }
            }
            catch (Throwable throwable) {
                Object var10_9 = null;
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (connection != null) {
                    this.m_oDBMgr.freeConnection(connection);
                }
                throw throwable;
            }
        }
        return null;
    }

    private String createSQLFromRs(String string, ResultSet resultSet, ResultSetMetaData resultSetMetaData) throws WCMException {
        String string2;
        String string3 = null;
        String string4 = null;
        try {
            if (resultSet == null) {
                return null;
            }
            string2 = null;
            ResultSetMetaData resultSetMetaData2 = resultSetMetaData != null ? resultSetMetaData : resultSet.getMetaData();
            int n = resultSetMetaData2.getColumnCount();
            block9: for (int i = 1; i <= n; ++i) {
                String string5 = resultSetMetaData2.getColumnLabel(i).toUpperCase();
                string2 = null;
                switch (resultSetMetaData2.getColumnType(i)) {
                    case -6: 
                    case -5: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 8: {
                        string2 = resultSet.getString(i);
                        if (!resultSet.wasNull()) break;
                        continue block9;
                    }
                    case 12: {
                        Object object = resultSet.getString(i);
                        if (resultSet.wasNull() || object == null) continue block9;
                        string2 = '\'' + this.filterForSQLValue((String)object) + '\'';
                        break;
                    }
                    case 91: 
                    case 92: 
                    case 93: {
                        Object object = resultSet.getDate(i);
                        if (resultSet.wasNull() || object == null) continue block9;
                        string2 = this.m_oDBType.sqlDateTime(new CMyDateTime(((Date)object).getTime()).toString("yyyy-MM-dd HH:mm:ss"), "YYYY-MM-DD HH24:MI:SS");
                        break;
                    }
                    case -1: 
                    case 2005: {
                        string2 = "empty_clob()";
                        break;
                    }
                    default: {
                        Object object = resultSet.getString(i);
                        if (resultSet.wasNull() || object == null) continue block9;
                        string2 = '\'' + this.filterForSQLValue((String)object) + '\'';
                        break;
                    }
                }
                if (string3 == null) {
                    string3 = string5;
                    string4 = string2;
                    continue;
                }
                string3 = string3 + "," + string5;
                string4 = string4 + "," + string2;
            }
        }
        catch (SQLException sQLException) {
            throw new WCMException(40, I18NMessage.get(TRSDBSchema.class, "TRSDBSchema.label3", "\u4ece\u6570\u636e\u5e93\u4e2d\u8bfb\u53d6\u5bf9\u8c61\u4fe1\u606f\u65f6\u51fa\u9519\uff08") + this.getClass().getName() + ".createSQLFromRs).", sQLException);
        }
        catch (Exception exception) {
            throw new WCMException(0, I18NMessage.get(TRSDBSchema.class, "TRSDBSchema.label3", "\u4ece\u6570\u636e\u5e93\u4e2d\u8bfb\u53d6\u5bf9\u8c61\u4fe1\u606f\u65f6\u51fa\u9519\uff08") + this.getClass().getName() + ".createSQLFromRs).", exception);
        }
        if (string3 == null) {
            return null;
        }
        string2 = "insert into " + string + " (" + string3 + ") values(" + string4 + ")";
        if (this.m_nDBType != 2) {
            string2 = string2 + ';';
        }
        string2 = string2 + '\n';
        return string2;
    }

    private String filterForSQLValue(String string) {
        String string2 = string.replaceAll("'", "''");
        return string2;
    }
}

