/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.util;

import com.trs.cms.auth.persistent.User;
import com.trs.components.wcm.util.Category;
import com.trs.components.wcm.util.Categorys;
import com.trs.components.wcm.util.ICategoryMgr;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;

public class CategoryMgr
implements ICategoryMgr {
    public void deleteCategory(User user, Category category) throws WCMException {
        if (category == null) {
            return;
        }
        Categorys categorys = this.queryChildren(user, category, null);
        int n = categorys.size();
        for (int i = 0; i < n; ++i) {
            Category category2 = (Category)categorys.getAt(i);
            this.deleteCategory(user, category2);
        }
        category.delete(user);
    }

    public Categorys queryChildren(User user, Category category, WCMFilter wCMFilter) throws WCMException {
        WCMFilter wCMFilter2 = new WCMFilter("", "ParentId=?", "COrder desc");
        wCMFilter2.addSearchValues(category == null ? 0 : category.getId());
        wCMFilter2.mergeWith(wCMFilter);
        return Categorys.openWCMObjs(user, wCMFilter2);
    }

    public String getPath(Categorys categorys) throws WCMException {
        if (categorys == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(50);
        int n = categorys.size();
        for (int i = 0; i < n; ++i) {
            Category category = (Category)categorys.getAt(i);
            if (category == null) continue;
            stringBuffer.append(this.getPath(category)).append(",");
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    public String getPath(Category category) throws WCMException {
        if (category == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(50);
        stringBuffer.insert(0, category.getId());
        while (!category.isRoot()) {
            int n = category.getParentId();
            stringBuffer.insert(0, n + ",");
            category = Category.findById(n);
        }
        return stringBuffer.toString();
    }
}

