/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.stat.domain;

import com.trs.DreamFactory;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.User;
import com.trs.components.wcm.stat.StatFieldMap;
import com.trs.components.wcm.stat.StatFieldMaps;
import com.trs.components.wcm.stat.StatView;
import com.trs.components.wcm.stat.domain.ChartBuildException;
import com.trs.components.wcm.stat.domain.ChartOption;
import com.trs.components.wcm.stat.domain.StatDataItem;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.CMyResultSet;
import com.trs.infra.persistent.CMyResultSets;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CPager;
import com.trs.service.impl.StatService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class TimingChartData {
    private static final String MAPDATA_INDEX = "_INDEX";
    public static boolean IS_DEBUG = false;
    public static final String KEY_DATASET_HEADER = "header";
    public static final String KEY_DATASET_VALUES = "values";
    private ChartOption m_oChartOption = null;
    private int m_nStatViewId;
    private Map m_hDataset = null;

    public TimingChartData(int n, ChartOption chartOption) {
        if (n <= 0) {
            throw new ChartBuildException(I18NMessage.get(TimingChartData.class, "TimingChartData.label1", "\u4f20\u5165\u7684StatViewId\u53c2\u6570\u5fc5\u987b\u4e3a\u6b63\u6574\u6570\uff08\u5f53\u524d\u4e3a") + n + "\uff09\uff01");
        }
        if (chartOption == null) {
            throw new ChartBuildException(I18NMessage.get(TimingChartData.class, "TimingChartData.label2", "\u6ca1\u6709\u4f20\u5165\u56fe\u8868\u6784\u9020\u53c2\u6570\uff01"));
        }
        this.m_nStatViewId = n;
        this.m_oChartOption = chartOption;
        this.m_oChartOption.validate();
    }

    public Object getDataSet() {
        if (this.m_hDataset == null) {
            this.fill();
        }
        return this.m_hDataset;
    }

    public Object fill() {
        return this.fill(this.m_oChartOption.getPeriodType());
    }

    /*
     * WARNING - void declaration
     */
    public Object fill(int n) {
        if (IS_DEBUG) {
            this.m_hDataset = (Map)this.getTestDataset(this.m_oChartOption, n);
            return this.m_hDataset;
        }
        StatService statService = (StatService)DreamFactory.createObjectById("IStatService");
        String string = this.m_oChartOption.getStartStatTimeAsString();
        String string2 = this.m_oChartOption.getEndStatTimeAsString();
        String string3 = this.m_oChartOption.getGroupBy();
        String string4 = this.m_oChartOption.getStatTimeField();
        try {
            Object object;
            Object object2;
            this.m_hDataset = new HashMap();
            StatFieldMaps statFieldMaps = statService.getStatFieldsByView(this.m_nStatViewId);
            int n2 = statFieldMaps.size();
            HashMap<String, String> hashMap = new HashMap<String, String>(n2);
            StatFieldMap statFieldMap = null;
            for (int i = 0; i < n2; ++i) {
                statFieldMap = (StatFieldMap)statFieldMaps.getAt(i);
                if (statFieldMap == null) continue;
                object2 = statFieldMap.getFieldName();
                object = statFieldMap.getFieldType();
                if (object2 == null || ((String)object2).equalsIgnoreCase(string3) || object == null || !((String)object).equalsIgnoreCase("Number")) continue;
                hashMap.put(((String)object2).toUpperCase(), statFieldMap.getFieldDesc());
            }
            this.m_hDataset.put(KEY_DATASET_HEADER, hashMap);
            CMyResultSets cMyResultSets = new CMyResultSets();
            object2 = this.makeSql(this.m_nStatViewId, string, string2, string4, this.m_oChartOption);
            cMyResultSets.open(((WCMFilter)object2).toSQL(), "recid");
            object = new CPager(-1);
            int n3 = cMyResultSets.size();
            ((CPager)object).setItemCount(n3);
            HashMap<String, void> hashMap2 = new HashMap<String, void>();
            HashMap<String, Integer> hashMap3 = null;
            for (int i = ((CPager)object).getFirstItemIndex() - 1; i < ((CPager)object).getLastItemIndex(); ++i) {
                void var22_32;
                CMyResultSet cMyResultSet = (CMyResultSet)cMyResultSets.getAt(i);
                if (cMyResultSet == null) continue;
                String string5 = cMyResultSet.getPropertyAsString(string3);
                CMyDateTime cMyDateTime = cMyResultSet.getPropertyAsDateTime(string4);
                if (string5 == null || cMyDateTime == null) continue;
                hashMap3 = new HashMap<String, Integer>(hashMap.size());
                for (Map.Entry entry : hashMap.entrySet()) {
                    String string6 = (String)entry.getKey();
                    hashMap3.put(string6.toUpperCase(), new Integer(cMyResultSet.getPropertyAsInt(string6, 0)));
                }
                if (n > 0) {
                    void var22_29;
                    Map map = (Map)hashMap2.get(string5);
                    if (map == null) {
                        HashMap hashMap4 = new HashMap();
                    }
                    this.manipulateHash((Map)var22_29, hashMap3, n, cMyDateTime);
                    hashMap2.put(string5, var22_29);
                    continue;
                }
                ArrayList arrayList = (ArrayList)hashMap2.get(string5);
                if (arrayList == null) {
                    ArrayList arrayList2 = new ArrayList();
                }
                var22_32.add(new StatDataItem(cMyDateTime, hashMap3));
                hashMap2.put(string5, var22_32);
            }
            this.m_hDataset.put(KEY_DATASET_VALUES, hashMap2);
            return this.m_hDataset;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    protected Object getTestDataset(ChartOption chartOption, int n) {
        HashMap hashMap = new HashMap();
        int n2 = 5;
        String string = chartOption.getCurrStageField();
        HashMap<String, Integer> hashMap2 = null;
        int n3 = n;
        for (int i = 0; i < n2; ++i) {
            String string2 = "S-" + (i + 1);
            int n4 = 12;
            for (int j = 0; j < n4; ++j) {
                try {
                    Object object;
                    hashMap2 = new HashMap<String, Integer>(1);
                    hashMap2.put(string.toUpperCase(), new Integer((int)(Math.random() * 100.0)));
                    CMyDateTime cMyDateTime = new CMyDateTime();
                    cMyDateTime.setDateTimeWithString("2007-" + (j + 1) + "-" + (j + 1));
                    if (n3 > 0) {
                        object = (Map)hashMap.get(string2);
                        if (object == null) {
                            object = new HashMap();
                        }
                        this.manipulateHash((Map)object, hashMap2, n3, cMyDateTime);
                        hashMap.put(string2, object);
                        continue;
                    }
                    object = (ArrayList)hashMap.get(string2);
                    if (object == null) {
                        object = new ArrayList();
                    }
                    ((ArrayList)object).add(new StatDataItem(cMyDateTime, hashMap2));
                    hashMap.put(string2, object);
                    continue;
                }
                catch (CMyException cMyException) {
                    // empty catch block
                }
            }
        }
        HashMap hashMap3 = new HashMap(1);
        hashMap3.put(KEY_DATASET_VALUES, hashMap);
        return hashMap3;
    }

    private void manipulateHash(Map map, Map map2, int n, CMyDateTime cMyDateTime) throws CMyException {
        if (map2 == null || map2.isEmpty()) {
            return;
        }
        String string = null;
        Integer n2 = null;
        int n3 = cMyDateTime.getYear();
        if (n == 3) {
            string = String.valueOf(n3 + "-01-01");
            n2 = new Integer(n3);
        } else {
            int n4 = cMyDateTime.getMonth();
            string = String.valueOf(n3 + "-" + n4 + "-01");
            n2 = new Integer(n3 * 12 + n4);
        }
        HashMap<String, Integer> hashMap = (HashMap<String, Integer>)map.get(string);
        if (hashMap == null) {
            hashMap = new HashMap<String, Integer>();
        }
        hashMap.put(MAPDATA_INDEX, n2);
        for (Map.Entry entry : map2.entrySet()) {
            Object k = entry.getKey();
            Integer n5 = (Integer)entry.getValue();
            Integer n6 = (Integer)hashMap.get(k);
            if (n6 == null) {
                hashMap.put((String)k, n5);
                continue;
            }
            hashMap.put((String)k, new Integer(n6 + n5));
        }
        map.put(string, hashMap);
    }

    private WCMFilter makeSql(int n, String string, String string2, String string3, ChartOption chartOption) throws WCMException {
        StatView statView = StatView.findById(n);
        if (statView == null) {
            throw new ChartBuildException(I18NMessage.get(TimingChartData.class, "TimingChartData.label3", "\u6ca1\u6709\u627e\u5230[ID=") + n + I18NMessage.get(TimingChartData.class, "TimingChartData.label4", "]\u7684StatView\u5bf9\u8c61\uff01"));
        }
        WCMFilter wCMFilter = new WCMFilter();
        wCMFilter.setFrom(statView.getResultTable());
        wCMFilter.setSelect("*");
        String string4 = string3 + " >= " + this.toSqlDate(string) + " and " + string3 + " <= " + this.toSqlDate(string2);
        wCMFilter.setWhere(string4);
        wCMFilter.setOrder("STATTIME");
        WCMFilter wCMFilter2 = null;
        if (chartOption != null && (wCMFilter2 = chartOption.getExtraFilter()) != null) {
            wCMFilter.mergeWith(wCMFilter2);
        }
        return wCMFilter;
    }

    private String toSqlDate(String string) {
        return DBManager.getDBManager().getDBType().sqlDateTime(string, "YYYY-MM-DD HH24:MI:SS");
    }

    public static String makeDatasetJSON(int n, ChartOption chartOption) throws Throwable {
        TimingChartData timingChartData = new TimingChartData(n, chartOption);
        if (chartOption.getPeriodType() > 0) {
            timingChartData.fill(chartOption.getPeriodType());
            return TimingChartData.makeDatasetJSON(timingChartData, chartOption.getPeriodType(), chartOption.getGroupBy());
        }
        return TimingChartData.makeDatasetJSON(timingChartData, 0, chartOption.getGroupBy());
    }

    public static String makeDatasetJSON(TimingChartData timingChartData, ChartOption chartOption) throws Throwable {
        return TimingChartData.makeDatasetJSON(timingChartData, chartOption.getPeriodType(), chartOption.getGroupBy());
    }

    public static String makeDatasetJSON(TimingChartData timingChartData) throws Throwable {
        return TimingChartData.makeDatasetJSON(timingChartData, 0, "UserId");
    }

    public static String makeDatasetJSON(TimingChartData timingChartData, int n, String string) throws Throwable {
        Object object;
        Map map = (Map)timingChartData.getDataSet();
        Map map2 = (Map)map.get(KEY_DATASET_VALUES);
        if (map2 == null || map2.isEmpty()) {
            return null;
        }
        Iterator iterator = map2.entrySet().iterator();
        StringBuffer stringBuffer = new StringBuffer("\nvar dataset = {};");
        while (iterator.hasNext()) {
            Object object2;
            object = iterator.next();
            String string2 = (String)object.getKey();
            string2 = IS_DEBUG ? string2 + "[Test]" : (!string.equalsIgnoreCase("UserId") ? TimingChartData.getGroupNameById(string2) : TimingChartData.getUserNameById(string2));
            stringBuffer.append("\ndataset['" + string2 + "'] = [");
            if (n > 0) {
                object2 = (Map)object.getValue();
                if (string2 == null || object2 == null) continue;
                Object[][] objectArray = TimingChartData.orderTimingData((Map)object2);
                for (int i = 0; i < objectArray.length; ++i) {
                    String string3 = (String)objectArray[i][0];
                    String string4 = StatDataItem.getDataMapStr((Map)objectArray[i][1]);
                    stringBuffer.append("\n\t['" + string3 + "', {" + string4 + "}],");
                }
            } else {
                object2 = (ArrayList)object.getValue();
                if (string2 == null || object2 == null) continue;
                for (int i = 0; i < ((ArrayList)object2).size(); ++i) {
                    StatDataItem statDataItem = (StatDataItem)((ArrayList)object2).get(i);
                    stringBuffer.append("\n\t['" + statDataItem.getStatTimeAsString() + "', {" + StatDataItem.getDataMapStr(statDataItem.getDataMap()) + "}],");
                }
            }
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
            stringBuffer.append("\n];");
        }
        object = stringBuffer.toString();
        stringBuffer.setLength(0);
        return object;
    }

    private static Object[][] orderTimingData(Map map) {
        int n;
        int n2 = map.size();
        Object[][] objectArray = new Object[n2][2];
        Iterator iterator = map.entrySet().iterator();
        HashMap hashMap = new HashMap(n2);
        int[] nArray = new int[n2];
        int n3 = 0;
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Integer n4 = (Integer)((Map)entry.getValue()).get(MAPDATA_INDEX);
            hashMap.put(n4, entry.getKey());
            nArray[n3++] = n4;
        }
        for (n = nArray.length; n != 2; --n) {
            int n5 = 0;
            for (int i = 0; i < n - 1; ++i) {
                boolean bl;
                int n6 = nArray[i];
                int n7 = nArray[i + 1];
                boolean bl2 = bl = n6 > n7;
                if (!bl) continue;
                nArray[i] = n7;
                nArray[i + 1] = n6;
                ++n5;
            }
            if (n5 == 0) break;
        }
        for (n = 0; n < nArray.length; ++n) {
            Object v = hashMap.get(new Integer(nArray[n]));
            Map map2 = (Map)map.get(v);
            map2.remove(MAPDATA_INDEX);
            objectArray[n] = new Object[]{v, map2};
        }
        return objectArray;
    }

    public static String getUserNameById(String string) {
        String string2 = null;
        try {
            User user = User.findById(Integer.parseInt(string));
            string2 = user.getName();
        }
        catch (Exception exception) {
            string2 = I18NMessage.get(TimingChartData.class, "TimingChartData.label5", "\u7528\u6237[ID=") + string + "]";
        }
        return string2;
    }

    public static String getGroupNameById(String string) {
        String string2 = null;
        try {
            Group group = Group.findById(Integer.parseInt(string));
            string2 = group.getName();
        }
        catch (Exception exception) {
            string2 = I18NMessage.get(TimingChartData.class, "TimingChartData.label6", "\u7ec4\u7ec7[ID=") + string + "]";
        }
        return string2;
    }
}

