/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.stat.domain;

import com.trs.cms.auth.persistent.User;
import com.trs.components.wcm.stat.domain.ChartBuildException;
import com.trs.components.wcm.stat.domain.ChartOption;
import com.trs.components.wcm.stat.domain.ChartStyle;
import com.trs.components.wcm.stat.domain.IChartBuilder;
import com.trs.components.wcm.stat.domain.StatDataItem;
import com.trs.components.wcm.stat.domain.TimingChartData;
import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;
import java.awt.Color;
import java.awt.Paint;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.DateTickUnit;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.time.FixedMillisecond;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;

public class TimingChartBuilder
implements IChartBuilder {
    public JFreeChart buildChart(TimingChartData timingChartData, ChartStyle chartStyle, ChartOption chartOption) {
        XYDataset xYDataset = null;
        try {
            timingChartData.fill();
            xYDataset = this.makeXYDataSet(timingChartData.getDataSet(), chartOption);
        }
        catch (CMyException cMyException) {
            throw new ChartBuildException(I18NMessage.get(TimingChartBuilder.class, "TimingChartBuilder.label1", "\u6784\u9020\u56fe\u8868\u6570\u636e\u96c6\u65f6\u51fa\u9519\uff01"), cMyException);
        }
        if (CMyString.isEmpty(chartStyle.getXDesc()) || CMyString.isEmpty(chartStyle.getYDesc())) {
            chartStyle.setXYAxisDescs(I18NMessage.get(TimingChartBuilder.class, "TimingChartBuilder.label2", "\u65f6\u95f4"), I18NMessage.get(TimingChartBuilder.class, "TimingChartBuilder.label3", "\u8ba1\u6570"));
        }
        JFreeChart jFreeChart = ChartFactory.createTimeSeriesChart((String)chartStyle.getChartTitle(), (String)chartStyle.getXDesc(), (String)chartStyle.getYDesc(), (XYDataset)xYDataset, (boolean)true, (boolean)false, (boolean)false);
        XYPlot xYPlot = jFreeChart.getXYPlot();
        DateAxis dateAxis = (DateAxis)xYPlot.getDomainAxis();
        int n = chartOption.getPeriodType();
        int n2 = chartOption.getPeriodInterval();
        String string = "yyyy-MM-dd";
        switch (n) {
            case 1: {
                dateAxis.setTickUnit(new DateTickUnit(2, 7));
                string = "yy-MM-dd";
                break;
            }
            case 2: {
                dateAxis.setTickUnit(new DateTickUnit(1, n2));
                string = "yyyy-MM";
                break;
            }
            case 3: {
                dateAxis.setTickUnit(new DateTickUnit(0, n2));
                string = "yyyy";
                break;
            }
            default: {
                dateAxis.setTickUnit(new DateTickUnit(2, n2));
                string = "yy-MM-dd";
            }
        }
        dateAxis.setAutoTickUnitSelection(true);
        dateAxis.setDateFormatOverride((DateFormat)new SimpleDateFormat(string));
        jFreeChart.setBackgroundPaint((Paint)Color.white);
        return jFreeChart;
    }

    public XYDataset makeXYDataSet(Object object, ChartOption chartOption) throws CMyException {
        Map map = null;
        if (object == null || !(object instanceof Map)) {
            return null;
        }
        map = (Map)object;
        TimeSeriesCollection timeSeriesCollection = new TimeSeriesCollection();
        Map map2 = (Map)map.get("values");
        if (map2 == null || map2.isEmpty()) {
            return timeSeriesCollection;
        }
        map2 = this.rearrageDataSet(map2, chartOption.getPeriodType(), chartOption.getPeriodInterval());
        Iterator iterator = map2.entrySet().iterator();
        String string = chartOption.getCurrStageField();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string2 = (String)entry.getKey();
            string2 = TimingChartData.IS_DEBUG ? string2 : this.getUserNameById((String)entry.getKey());
            ArrayList arrayList = (ArrayList)entry.getValue();
            if (string2 == null || arrayList == null) continue;
            TimeSeries timeSeries = this.makeTimeSeries(string2);
            for (int i = 0; i < arrayList.size(); ++i) {
                StatDataItem statDataItem = (StatDataItem)arrayList.get(i);
                this.addTimeSeriesUniteData(timeSeries, statDataItem.getStatTimeAsString(), statDataItem.getData(string));
            }
            timeSeriesCollection.addSeries(timeSeries);
        }
        return timeSeriesCollection;
    }

    private Map rearrageDataSet(Map map, int n, int n2) {
        if (n == 0 && n2 == 1) {
            return map;
        }
        Map map2 = map;
        return map2;
    }

    private String getUserNameById(String string) {
        String string2 = null;
        try {
            User user = User.findById(Integer.parseInt(string));
            string2 = user.getName();
        }
        catch (Exception exception) {
            string2 = I18NMessage.get(TimingChartBuilder.class, "TimingChartBuilder.label4", "\u7528\u6237[ID=") + string + "]";
        }
        return string2;
    }

    private TimeSeries makeTimeSeries(String string) {
        return new TimeSeries(string, FixedMillisecond.class);
    }

    private void addTimeSeriesUniteData(TimeSeries timeSeries, String string, int n) throws CMyException {
        CMyDateTime cMyDateTime = new CMyDateTime();
        cMyDateTime.setDateTimeWithString(string, ChartOption.DEF_DATE_FORMAT);
        timeSeries.add((RegularTimePeriod)new FixedMillisecond(cMyDateTime.getDateTime()), (double)n);
    }
}

