/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.stat;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.stat.StatFieldMap;
import com.trs.components.wcm.stat.StatFieldMaps;
import com.trs.components.wcm.stat.StatHost;
import com.trs.components.wcm.stat.StatHosts;
import com.trs.components.wcm.stat.StatView;
import com.trs.components.wcm.stat.StatViewRel;
import com.trs.components.wcm.stat.StatViewRels;
import com.trs.components.wcm.stat.StatViews;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.persistent.CMyResultObjs;
import com.trs.infra.persistent.CMyResultSet;
import com.trs.infra.persistent.CMyResultSets;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.Reports;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class StatMgr {
    private static Logger s_logger = Logger.getLogger(StatMgr.class);
    public static final String StatMgrName = "StatMgr";
    private static final String DEF_TEMPDB_ID = "RECID";
    private static final String DEF_STATTIME_FIELD = "STATTIME";
    private static final String START_QUOTE = "[";
    private static final String END_QUOTE = "]";
    private static final String TAG_START_TIME = "$STAT_STARTTIME$";
    private static final String TAG_END_TIME = "$STAT_ENDTIME$";
    private static final String[] DB_NUMBER_TYPE = new String[]{"NUMBER", "INT", "BIGINT", "int", "BIGINT"};
    private static final String[] DB_STRING_TYPE = new String[]{"VARCHAR2", "nvarchar", "VARCHAR", "nvarchar", "VARCHAR"};
    private static final String[] DB_DATETIME_TYPE = new String[]{"DATE", "DATETIME", "TIMESTAMP", "datetime", "TIMESTAMP"};
    private static final String ORIGINAL_STARTTIME = "2002-01-01 00:00:00";
    private String m_sOriginalStartTime = null;

    public CMyResultSets getStatResult(String string, String string2) throws WCMException {
        CMyResultSets cMyResultSets = new CMyResultSets();
        if (this.emptyString(string) || this.emptyString(string2)) {
            return cMyResultSets;
        }
        cMyResultSets.open(string, string2);
        return cMyResultSets;
    }

    public CMyResultSets getStatResult(int n, CMyDateTime cMyDateTime, CMyDateTime cMyDateTime2, String string, String string2) throws WCMException {
        StatView statView = StatView.findById(n);
        this.assertViewFound(n, statView);
        if (!this.isTemplateView(statView)) {
            throw new WCMException(10, I18NMessage.get(StatMgr.class, "StatMgr.label1", "\u8be5\u7edf\u8ba1\u89c6\u56fe\u4e0d\u662f\u4e00\u4e2a\u6a21\u677f\u89c6\u56fe(\u5f53\u524d\u7c7b\u578b\u4e3a:") + statView.getViewType() + I18NMessage.get(StatMgr.class, "StatMgr.label2", "),\u65e0\u6cd5\u7ee7\u7eed\u83b7\u5f97\u7edf\u8ba1\u7ed3\u679c!"));
        }
        String string3 = this.getStatSql(statView, cMyDateTime, cMyDateTime2, string, string2);
        CMyResultSets cMyResultSets = new CMyResultSets();
        cMyResultSets.open(string3, this.getResultId(statView));
        return cMyResultSets;
    }

    public StatFieldMaps getViewFields(int n) throws WCMException {
        StatView statView = StatView.findById(n);
        this.assertViewFound(n, statView);
        return this.getViewFields(statView);
    }

    public void generateTodayStat(int n) throws WCMException {
        StatView statView = StatView.findById(n);
        this.assertViewFound(n, statView);
        if (!this.isTemplateView(statView)) {
            return;
        }
        String string = "SELECT MAX(RECID) AS ID, MAX(STATTIME) AS LAST FROM " + statView.getResultTable();
        CMyResultSets cMyResultSets = new CMyResultSets();
        cMyResultSets.open(string, "ID");
        CMyDateTime cMyDateTime = this.getLastStatTime(cMyResultSets);
        CMyDateTime cMyDateTime2 = CMyDateTime.now();
        CMyDateTime cMyDateTime3 = (CMyDateTime)cMyDateTime2.clone();
        CMyDateTime cMyDateTime4 = (CMyDateTime)cMyDateTime2.clone();
        try {
            if (cMyResultSets.isEmpty() || cMyDateTime == null) {
                cMyDateTime3.setDateTimeWithString(this.getOriginalStart());
            } else {
                this.deleteDataOfLast(statView, cMyDateTime);
                cMyDateTime3 = cMyDateTime;
            }
        }
        catch (CMyException cMyException) {
            throw new WCMException(1100, I18NMessage.get(StatMgr.class, "StatMgr.label3", "\u83b7\u53d6\u7edf\u8ba1\u7684\u65f6\u95f4\u6bb5\u51fa\u9519,\u7edf\u8ba1\u5f02\u5e38\u4e2d\u6b62!"), cMyException);
        }
        this.generatePeriodStat(statView, cMyDateTime3, cMyDateTime4);
    }

    private String getOriginalStart() {
        if (this.m_sOriginalStartTime == null) {
            try {
                String string = ConfigServer.getServer().getSysConfigValue("STAT_ORIGINAL_STARTDATE", null);
                string = string == null ? ORIGINAL_STARTTIME : string + " 00:00:01";
                this.m_sOriginalStartTime = string;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.m_sOriginalStartTime;
    }

    /*
     * Loose catch block
     */
    private void deleteDataOfLast(StatView statView, CMyDateTime cMyDateTime) throws WCMException {
        block11: {
            PreparedStatement preparedStatement;
            Connection connection;
            DBManager dBManager;
            block10: {
                StringBuffer stringBuffer = new StringBuffer(64);
                stringBuffer.append("delete from ");
                stringBuffer.append(statView.getResultTable());
                stringBuffer.append(" where ").append(DEF_STATTIME_FIELD);
                stringBuffer.append("=?");
                dBManager = DBManager.getDBManager();
                connection = null;
                preparedStatement = null;
                connection = dBManager.getConnection();
                preparedStatement = connection.prepareStatement(stringBuffer.toString());
                cMyDateTime.setTimeWithString("12:00:00", 0);
                preparedStatement.setTimestamp(1, cMyDateTime.toTimestamp());
                preparedStatement.executeUpdate();
                Object var9_7 = null;
                if (preparedStatement == null) break block10;
                try {
                    preparedStatement.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (connection != null) {
                dBManager.freeConnection(connection);
            }
            break block11;
            {
                catch (Exception exception) {
                    throw new WCMException(I18NMessage.get(StatMgr.class, "StatMgr.label4", "\u6e05\u7406\u7edf\u8ba1\u6570\u636e\u5931\u8d25!"), exception);
                }
            }
            catch (Throwable throwable) {
                Object var9_8 = null;
                if (preparedStatement != null) {
                    try {
                        preparedStatement.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (connection != null) {
                    dBManager.freeConnection(connection);
                }
                throw throwable;
            }
        }
    }

    public CMyResultSets getCurrentStatResult(int n, CMyDateTime cMyDateTime, CMyDateTime cMyDateTime2, String string) throws WCMException {
        StatView statView = StatView.findById(n);
        this.assertViewFound(n, statView);
        if (this.isTemplateView(statView)) {
            throw new WCMException(1100, I18NMessage.get(StatMgr.class, "StatMgr.label5", "\u6a21\u677f\u7edf\u8ba1\u89c6\u56fe\u4e0d\u80fd\u8fdb\u884c\u5373\u65f6\u7edf\u8ba1!"));
        }
        String string2 = this.composeFrom(statView.getViewFrom(), cMyDateTime, cMyDateTime2);
        if (this.emptyString(string2)) {
            throw new WCMException(10, I18NMessage.get(StatMgr.class, "StatMgr.label6", "\u65e0\u6548\u7684\u7edf\u8ba1\u89c6\u56fe,\u6ca1\u6709\u660e\u786e\u7684\u7edf\u8ba1\u5bf9\u8c61!"));
        }
        String string3 = "SELECT " + statView.getViewSelect() + " FROM " + string2;
        string2 = this.mergeAnd(statView.getViewWhere(), string);
        if (!this.emptyString(string2)) {
            string3 = string3 + " WHERE " + string2;
        }
        if (!this.emptyString(string2 = statView.getViewGroupBy())) {
            string3 = string3 + " GROUP BY " + string2;
        }
        if (!this.emptyString(string2 = statView.getViewOrderBy())) {
            string3 = string3 + " ORDER BY " + string2;
        }
        string3 = this.parseDateTime(string3, cMyDateTime, cMyDateTime2);
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("current stat,querystat sql:" + string3));
        }
        CMyResultSets cMyResultSets = new CMyResultSets();
        cMyResultSets.open(string3, this.getResultId(statView));
        return cMyResultSets;
    }

    public StatViews getStatViews(String string, int n, WCMFilter wCMFilter) throws WCMException {
        if (this.emptyString(string)) {
            throw new WCMException(10, I18NMessage.get(StatMgr.class, "StatMgr.label7", "\u65e0\u6548\u7684\u7edf\u8ba1\u4e3b\u4f53\u540d\u79f0,\u65e0\u6cd5\u83b7\u5f97\u7edf\u8ba1\u89c6\u56fe\u6a21\u677f!"));
        }
        String string2 = "STATHOST='" + CMyString.filterForSQL(string) + "'";
        if (n != 0) {
            string2 = string2 + " AND VIEWTYPE=" + n;
        }
        WCMFilter wCMFilter2 = new WCMFilter("", string2, "");
        wCMFilter2.mergeWith(wCMFilter);
        return StatViews.openWCMObjs(this.getLoginUser(), wCMFilter2);
    }

    private String convertSqlValueByType(String string, String string2) {
        if (this.emptyString(string2)) {
            return "";
        }
        String string3 = string2.trim().toUpperCase();
        boolean bl = this.emptyString(string);
        if ("NUMBER".equals(string3)) {
            if (bl) {
                return "0";
            }
            return string;
        }
        if ("STRING".equals(string3)) {
            if (bl) {
                return "''";
            }
            return "'" + string + "'";
        }
        if ("DATETIME".equals(string3)) {
            if (bl) {
                return "";
            }
            return DBManager.getDBManager().getDBType().sqlDateTime(string, "YYYY-MM-DD HH24:MI:SS");
        }
        return "";
    }

    private String mergeAnd(String string, String string2) {
        if (this.emptyString(string)) {
            return string2;
        }
        if (this.emptyString(string2)) {
            return string;
        }
        return "(" + string + ")" + " AND " + "(" + string2 + ")";
    }

    private String getResultId(StatView statView) throws WCMException {
        StatFieldMap statFieldMap = this.getTopField(statView);
        if (statFieldMap == null) {
            throw new WCMException(1100, I18NMessage.get(StatMgr.class, "StatMgr.label8", "\u83b7\u53d6\u7edf\u8ba1\u7ed3\u679cId\u5931\u8d25!"));
        }
        return statFieldMap.getFieldName();
    }

    private StatFieldMap getTopField(StatView statView) throws WCMException {
        StatFieldMaps statFieldMaps = new StatFieldMaps(this.getLoginUser());
        WCMFilter wCMFilter = new WCMFilter("", "StatViewId=" + statView.getId() + " AND FieldTop=1", "");
        wCMFilter.setMaxRowNumber(1);
        statFieldMaps.open(wCMFilter);
        if (statFieldMaps.isEmpty()) {
            return null;
        }
        return (StatFieldMap)statFieldMaps.getAt(0);
    }

    private CMyDateTime getLastStatTime(CMyResultSets cMyResultSets) {
        CMyDateTime cMyDateTime;
        CMyResultSet cMyResultSet = (CMyResultSet)cMyResultSets.getAt(0);
        if (cMyResultSet != null && !(cMyDateTime = (CMyDateTime)cMyResultSet.getProperty("LAST")).isNull()) {
            return cMyDateTime;
        }
        return null;
    }

    private void generatePeriodStat(StatView statView, CMyDateTime cMyDateTime, CMyDateTime cMyDateTime2) throws WCMException {
        try {
            cMyDateTime.setTimeWithString("00:00:00", 0);
            cMyDateTime2.setTimeWithString("23:59:59", 0);
            long l = cMyDateTime2.dateDiff(3, cMyDateTime) + 1L;
            CMyDateTime cMyDateTime3 = (CMyDateTime)cMyDateTime.clone();
            int n = 0;
            while ((long)n < l) {
                this.generateOneStatSets(statView, cMyDateTime3);
                cMyDateTime3 = cMyDateTime3.dateAdd(3, 1);
                ++n;
            }
        }
        catch (CMyException cMyException) {
            throw new WCMException(1100, I18NMessage.get(StatMgr.class, "StatMgr.label9", "\u4ea7\u751f\u7279\u5b9a\u65f6\u95f4\u6bb5\u7684\u7edf\u8ba1\u6570\u636e\u65f6\u53d1\u751f\u9519\u8bef\uff0c\u65e0\u6cd5\u4ea7\u751f\u7edf\u8ba1\u7ed3\u679c\uff01"), cMyException);
        }
    }

    private void generateOneStatSets(StatView statView, CMyDateTime cMyDateTime) throws WCMException {
        CMyDateTime cMyDateTime2 = (CMyDateTime)cMyDateTime.clone();
        CMyDateTime cMyDateTime3 = (CMyDateTime)cMyDateTime.clone();
        CMyDateTime cMyDateTime4 = (CMyDateTime)cMyDateTime.clone();
        try {
            cMyDateTime2.setTimeWithString("00:00:00", 0);
            cMyDateTime3.setTimeWithString("23:59:59", 0);
            cMyDateTime4.setTimeWithString("12:00:00", 0);
        }
        catch (CMyException cMyException) {
            throw new WCMException(1100, I18NMessage.get(StatMgr.class, "StatMgr.label10", "\u683c\u5f0f\u5316\u7edf\u8ba1\u7684\u76f8\u5173\u65f6\u95f4\u5931\u8d25"), cMyException);
        }
        List list = this.getNewResultSetList(statView, cMyDateTime2, cMyDateTime3);
        if (!list.isEmpty()) {
            this.insertResultIntoDb(statView, list, cMyDateTime4);
        }
    }

    private void insertResultIntoDb(StatView statView, List list, CMyDateTime cMyDateTime) throws WCMException {
        String[] stringArray;
        StatFieldMaps statFieldMaps = this.getViewFields(statView);
        if (statFieldMaps.isEmpty()) {
            throw new WCMException(1100, I18NMessage.get(StatMgr.class, "StatMgr.label11", "\u65e0\u6cd5\u83b7\u5f97\u7edf\u8ba1\u89c6\u56fe\u5bf9\u5e94\u7684\u5b57\u6bb5\u5217\u8868!"));
        }
        StringBuffer stringBuffer = new StringBuffer("INSERT INTO ");
        stringBuffer.append(statView.getResultTable()).append('(');
        stringBuffer.append(DEF_TEMPDB_ID).append(',');
        stringBuffer.append(DEF_STATTIME_FIELD);
        for (int i = 0; i < statFieldMaps.size(); ++i) {
            stringArray = (String[])statFieldMaps.getAt(i);
            if (stringArray == null) continue;
            stringBuffer.append(',').append(stringArray.getFieldName());
        }
        stringBuffer.append(')').append(" VALUES (");
        String string = stringBuffer.toString();
        stringBuffer.setLength(0);
        stringArray = new String[list.size()];
        StringBuffer stringBuffer2 = stringBuffer;
        int n = this.getMaxRecId(statView);
        DBManager dBManager = DBManager.getDBManager();
        String string2 = dBManager.getDBType().sqlDateTime(cMyDateTime.toString(), "YYYY-MM-DD HH24:MI:SS");
        for (int i = 0; i < list.size(); ++i) {
            CMyResultSet cMyResultSet = (CMyResultSet)list.get(i);
            if (cMyResultSet == null) continue;
            stringBuffer2.setLength(0);
            stringBuffer2.append(string);
            stringBuffer2.append(++n).append(',').append(string2);
            for (int j = 0; j < statFieldMaps.size(); ++j) {
                StatFieldMap statFieldMap = (StatFieldMap)statFieldMaps.getAt(j);
                if (statFieldMap == null) continue;
                String string3 = this.convertSqlValueByType(cMyResultSet.getPropertyAsString(statFieldMap.getFieldName()), statFieldMap.getFieldType());
                stringBuffer2.append(',').append(string3);
            }
            stringBuffer2.append(')');
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)("debug...sql for insert data:" + stringBuffer));
            }
            stringArray[i] = stringBuffer2.toString();
        }
        try {
            dBManager.sqlExecuteUpdate(stringArray);
        }
        catch (WCMException wCMException) {
            throw new WCMException(1100, I18NMessage.get(StatMgr.class, "StatMgr.label12", "\u4fdd\u5b58\u7edf\u8ba1\u7ed3\u679c\u5931\u8d25!"), wCMException);
        }
    }

    private List getNewResultSetList(StatView statView, CMyDateTime cMyDateTime, CMyDateTime cMyDateTime2) throws WCMException {
        Object object;
        Object object2;
        int n;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        StatViews statViews = this.getEmbeddedViews(statView);
        if (statViews.isEmpty()) {
            statViews.addElement(statView);
        }
        String string = null;
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        for (n = 0; n < statViews.size(); ++n) {
            object2 = (StatView)statViews.getAt(n);
            if (object2 == null) continue;
            if (string == null) {
                string = this.getResultId((StatView)object2);
            }
            String string2 = this.getStatSql((StatView)object2, cMyDateTime, cMyDateTime2, "", "");
            object = new CMyResultSets();
            ((CMyResultObjs)object).open(string2, this.getResultId((StatView)object2));
            arrayList2.add(object);
        }
        n = arrayList2.size();
        object2 = new int[n];
        while (!this.isEOF(arrayList2, (int[])object2)) {
            int n2 = this.getMinimaxId(arrayList2, (int[])object2, string);
            object = new CMyResultSet();
            for (int i = 0; i < n; ++i) {
                CMyResultSet cMyResultSet;
                int n3;
                CMyResultSets cMyResultSets = (CMyResultSets)arrayList2.get(i);
                if (cMyResultSets.size() <= object2[i] || (n3 = (cMyResultSet = (CMyResultSet)cMyResultSets.getAt((int)object2[i])).getPropertyAsInt(string, 0)) != n2) continue;
                StatView statView2 = (StatView)statViews.getAt(i);
                StatFieldMaps statFieldMaps = this.getViewFields(statView2);
                for (int j = 0; j < statFieldMaps.size(); ++j) {
                    StatFieldMap statFieldMap = (StatFieldMap)statFieldMaps.getAt(j);
                    String string3 = statFieldMap.getFieldName();
                    Object object3 = cMyResultSet.getProperty(string3);
                    if (object3 == null) continue;
                    ((CMyResultSet)object).setProperty(string3, object3);
                }
                Object object4 = object2;
                int n4 = i;
                object4[n4] = object4[n4] + true;
            }
            arrayList.add(object);
        }
        return arrayList;
    }

    private String getStatSql(StatView statView, CMyDateTime cMyDateTime, CMyDateTime cMyDateTime2, String string, String string2) throws WCMException {
        String string3 = this.constructStatSql(statView, string, string2);
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("the row sql: " + string3));
        }
        string3 = this.parseDateTime(string3, cMyDateTime, cMyDateTime2);
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("the actula sql: " + string3));
        }
        return string3;
    }

    private String constructStatSql(StatView statView, String string, String string2) {
        String string3 = "SELECT " + statView.getViewSelect() + " FROM " + statView.getViewFrom();
        String string4 = this.mergeAnd(statView.getViewWhere(), string);
        if (!this.emptyString(string4)) {
            string3 = string3 + " WHERE " + string4;
        }
        if (!this.emptyString(string4 = statView.getViewGroupBy())) {
            string3 = string3 + " GROUP BY " + string4;
        }
        if (this.emptyString(string2)) {
            string2 = statView.getViewOrderBy();
        }
        if (!this.emptyString(string2)) {
            string3 = string3 + " ORDER BY " + string2;
        }
        return string3;
    }

    private boolean isEOF(List list, int[] nArray) {
        for (int i = 0; i < list.size(); ++i) {
            if (((CMyResultSets)list.get(i)).size() <= nArray[i]) continue;
            return false;
        }
        return true;
    }

    private int getMinimaxId(List list, int[] nArray, String string) {
        int n = 0;
        for (int i = 0; i < list.size(); ++i) {
            CMyResultSets cMyResultSets = (CMyResultSets)list.get(i);
            if (cMyResultSets.size() <= nArray[i]) continue;
            CMyResultSet cMyResultSet = (CMyResultSet)cMyResultSets.getAt(nArray[i]);
            int n2 = cMyResultSet.getPropertyAsInt(string, 0);
            if (n == 0) {
                n = n2;
                continue;
            }
            if (n <= n2) continue;
            n = n2;
        }
        return n;
    }

    private StatViews getEmbeddedViews(int n) throws WCMException {
        String string = "ViewType = 2";
        string = string + " AND EXISTS( Select * From WCMSTATVIEWREL Where WCMSTATVIEWREL.MainViewID=" + n + " AND WCMSTATVIEW.StatViewID = WCMSTATVIEWREL.EmbedViewId)";
        WCMFilter wCMFilter = new WCMFilter("", string, "");
        return StatViews.openWCMObjs(this.getLoginUser(), wCMFilter);
    }

    private int getMaxRecId(StatView statView) throws WCMException {
        String string = statView.getResultTable();
        if (this.emptyString(string)) {
            throw new WCMException(10, I18NMessage.get(StatMgr.class, "StatMgr.label13", "\u6ca1\u6709\u627e\u5230\u7edf\u8ba1\u89c6\u56fe\u5bf9\u5e94\u7684\u4e34\u65f6\u8868\uff01"));
        }
        String string2 = "SELECT MAX(RECID) AS MAXID FROM " + string;
        CMyResultSets cMyResultSets = new CMyResultSets();
        cMyResultSets.open(string2, "MAXID");
        if (cMyResultSets.isEmpty()) {
            return 0;
        }
        CMyResultSet cMyResultSet = (CMyResultSet)cMyResultSets.getAt(0);
        return cMyResultSet.getPropertyAsInt("MAXID", 0);
    }

    public StatView findStatViewByName(String string) throws WCMException {
        if (this.emptyString(string)) {
            return null;
        }
        WCMFilter wCMFilter = new WCMFilter("", "VIEWNAME='" + CMyString.filterForSQL(string) + "'", "");
        StatViews statViews = new StatViews(this.getLoginUser());
        statViews.open(wCMFilter);
        if (statViews == null || statViews.isEmpty()) {
            return null;
        }
        return (StatView)statViews.getAt(0);
    }

    private String composeFrom(String string, CMyDateTime cMyDateTime, CMyDateTime cMyDateTime2) throws WCMException {
        if (this.emptyString(string)) {
            return "";
        }
        String string2 = "";
        int n = 0;
        String string3 = string + " ,";
        int n2 = string3.indexOf(",", n);
        while (n2 != -1) {
            String string4 = string3.substring(n, n2).trim();
            if ((string4 = this.parseColumn(string4, cMyDateTime, cMyDateTime2)) != null) {
                string2 = string2 + string4 + ",";
            }
            n = n2 + 1;
            n2 = string3.indexOf(",", n2 + 1);
        }
        return string2.substring(0, string2.length() - 1);
    }

    private String parseColumn(String string, CMyDateTime cMyDateTime, CMyDateTime cMyDateTime2) throws WCMException {
        if (this.emptyString(string)) {
            return null;
        }
        if (!START_QUOTE.equals(string.substring(0, 1))) {
            return string;
        }
        String string2 = string.substring(1, string.length() - 1);
        StatView statView = this.findStatViewByName(string2);
        if (statView == null) {
            return null;
        }
        String string3 = "(SELECT " + statView.getViewSelect();
        string3 = string3 + " FROM " + statView.getViewFrom();
        String string4 = statView.getViewWhere();
        if (!this.emptyString(string4)) {
            string3 = string3 + " WHERE " + string4;
        }
        if (!this.emptyString(string4 = statView.getViewGroupBy())) {
            string3 = string3 + " GROUP BY " + string4;
        }
        string3 = string3 + ") " + statView.getViewName();
        string3 = this.parseDateTime(string3, cMyDateTime, cMyDateTime2);
        return string3;
    }

    private StatViews getEmbeddedViewsByFrom(int n) throws WCMException {
        if (n <= 0) {
            throw new WCMException(10, I18NMessage.get(StatMgr.class, "StatMgr.label14", "\u7edf\u8ba1\u89c6\u56fe\u6a21\u677fId\u65e0\u6548\uff0c\u65e0\u6cd5\u5f97\u5230\u5176\u7edf\u8ba1\u5143\u7d20\u4e2a\u6570\uff01"));
        }
        StatView statView = StatView.findById(n);
        if (statView == null) {
            throw new WCMException(10, I18NMessage.get(StatMgr.class, "StatMgr.label15", "\u65e0\u6cd5\u6839\u636e\u7edf\u8ba1\u89c6\u56fe\u6a21\u677fId\u627e\u5230\u7edf\u8ba1\u6a21\u677f\uff01"));
        }
        if (statView.getViewType() != 3) {
            throw new WCMException(10, I18NMessage.get(StatMgr.class, "StatMgr.label16", "\u8be5\u6a21\u677f\u4e0d\u662f\u5373\u65f6\u7edf\u8ba1\u578b\u6a21\u677f\uff0c\u65e0\u6cd5\u8fdb\u884c\u5373\u65f6\u7edf\u8ba1\uff01"));
        }
        String string = statView.getViewFrom();
        StatViews statViews = new StatViews(this.getLoginUser());
        int n2 = string.indexOf(START_QUOTE, 0);
        while (n2 != -1) {
            int n3 = string.indexOf(END_QUOTE, n2);
            if (n3 == -1) {
                s_logger.error((Object)I18NMessage.get(StatMgr.class, "StatMgr.label17", "\u67e5\u627e\u7edf\u8ba1\u6a21\u677f\u4e2d\u7684\u7edf\u8ba1\u5143\u7d20\u65f6\uff0c\u627e\u5230\u6709\u5f00\u59cb\uff0c\u6ca1\u6709\u7ed3\u675f\u7684\u6bb5\u843d\uff01"));
                n2 = -1;
                continue;
            }
            String string2 = string.substring(n2 + 1, n3);
            StatView statView2 = this.findStatViewByName(string2);
            if (statView2 == null) {
                s_logger.error((Object)(I18NMessage.get(StatMgr.class, "StatMgr.label18", "\u67e5\u627e\u7edf\u8ba1\u6a21\u677f\u4e2d\u7684\u7edf\u8ba1\u5143\u7d20\u65f6\uff0c\u627e\u5230\u4e00\u4e2a\u7edf\u8ba1\u5143\u7d20\uff08") + string2 + I18NMessage.get(StatMgr.class, "StatMgr.label19", "\uff09\uff0c\u4f46\u662f\u6570\u636e\u5e93\u4e2d\u6ca1\u6709\u627e\u5230\u8be5\u5143\u7d20\uff01")));
            } else {
                statViews.addElement(statView2);
            }
            n2 = string.indexOf(START_QUOTE, n3 + 1);
        }
        return statViews;
    }

    public StatView saveStatView(StatView statView, List list) throws WCMException {
        if (statView == null || list == null || list.isEmpty()) {
            throw new WCMException(10, I18NMessage.get(StatMgr.class, "StatMgr.label20", "\u53c2\u6570\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fdd\u5b58\u7edf\u8ba1\u89c6\u56fe\u6a21\u677f\uff01"));
        }
        if (statView.getStatHost() == null) {
            throw new WCMException(10, I18NMessage.get(StatMgr.class, "StatMgr.label21", "\u7edf\u8ba1\u4e3b\u4f53\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fdd\u5b58\u7edf\u8ba1\u89c6\u56fe\u6a21\u677f\uff01"));
        }
        if (this.statHostNotExists(statView)) {
            throw new WCMException(10, I18NMessage.get(StatMgr.class, "StatMgr.label22", "\u7edf\u8ba1\u4e3b\u4f53\u540d\u79f0\u65e0\u6548\uff0c\u65e0\u6cd5\u4fdd\u5b58\u7edf\u8ba1\u89c6\u56fe\u6a21\u677f\uff01"));
        }
        if (statView.getViewType() < 1 || statView.getViewType() > 3) {
            throw new WCMException(10, I18NMessage.get(StatMgr.class, "StatMgr.label23", "\u7edf\u8ba1\u89c6\u56fe\u7c7b\u578b\u65e0\u6548\uff0c\u65e0\u6cd5\u4fdd\u5b58\u7edf\u8ba1\u89c6\u56fe\u6a21\u677f\uff01"));
        }
        boolean bl = false;
        if (this.isTemplateView(statView)) {
            if (statView.isAddMode()) {
                statView.setResultTable(statView.getViewName());
                bl = true;
            } else if (this.isStructureChanged(statView, list)) {
                String string = statView.getResultTable();
                String string2 = "DROP TABLE " + string;
                DBManager dBManager = DBManager.getDBManager();
                dBManager.sqlExecuteUpdate(string2);
                dBManager.notifyRemoveTable(string);
                bl = true;
            }
        }
        statView.save(this.getLoginUser());
        this.saveFieldList(statView, list);
        if (bl) {
            try {
                this.createStatResultTableIfNecessary(statView, list);
            }
            catch (WCMException wCMException) {
                statView.delete(this.getLoginUser());
                throw wCMException;
            }
        }
        return statView;
    }

    private boolean statHostNotExists(StatView statView) throws WCMException {
        String string = statView.getStatHost();
        if (string == null || (string = string.trim()).length() == 0) {
            return true;
        }
        WCMFilter wCMFilter = new WCMFilter("", "HostName='" + CMyString.filterForSQL(string) + "'", "");
        wCMFilter.setMaxRowNumber(1);
        return StatHosts.openWCMObjs(this.getLoginUser(), wCMFilter).isEmpty();
    }

    private void saveFieldList(StatView statView, List list) throws WCMException {
        StatFieldMap statFieldMap;
        int n;
        Object object;
        String string = "";
        for (int i = 0; i < list.size(); ++i) {
            object = (StatFieldMap)list.get(i);
            if (((BaseObj)object).isAddMode()) continue;
            string = string + ((BaseObj)object).getId() + ",";
        }
        String string2 = "";
        if (string.length() > 0) {
            string = string.substring(0, string.length() - 1);
            string2 = "STATFIELDMAPID NOT IN (" + string + ")";
        }
        object = StatFieldMaps.openWCMObjs(this.getLoginUser(), new WCMFilter("", this.mergeAnd(string2, "STATVIEWID=" + statView.getId()), ""));
        for (n = 0; n < ((BaseObjs)object).size(); ++n) {
            statFieldMap = (StatFieldMap)((BaseObjs)object).getAt(n);
            statFieldMap.delete(this.getLoginUser());
        }
        for (n = 0; n < list.size(); ++n) {
            statFieldMap = (StatFieldMap)list.get(n);
            if (statFieldMap == null) continue;
            statFieldMap.setStatTempId(statView.getId());
            this.saveFieldMap(statView, statFieldMap);
        }
    }

    private StatFieldMap saveFieldMap(StatView statView, StatFieldMap statFieldMap) throws WCMException {
        if (statFieldMap.canEdit(this.getLoginUser())) {
            statFieldMap.setStatTempId(statView.getId());
        }
        statFieldMap.save(this.getLoginUser());
        return statFieldMap;
    }

    public void autorunStat() throws WCMException {
        WCMFilter wCMFilter = new WCMFilter("", "VIEWTYPE=1", "");
        StatViews statViews = StatViews.openWCMObjs(this.getLoginUser(), wCMFilter);
        if (statViews == null || statViews.isEmpty()) {
            return;
        }
        for (int i = 0; i < statViews.size(); ++i) {
            StatView statView = (StatView)statViews.getAt(i);
            if (statView == null) {
                s_logger.debug((Object)I18NMessage.get(StatMgr.class, "StatMgr.label24", "\u81ea\u52a8\u6267\u884c\u7edf\u8ba1\u6570\u636e\u7684\u4efb\u52a1\u65f6\u627e\u5230\u4e00\u4e2a\u4e3a\u7a7a\u7684\u4efb\u52a1\uff01"));
                continue;
            }
            this.generateTodayStat(statView.getId());
        }
    }

    private void createStatResultTableIfNecessary(StatView statView, List list) throws WCMException {
        if (!this.isTemplateView(statView)) {
            return;
        }
        String string = statView.getResultTable();
        if (string == null) {
            throw new WCMException(1106, I18NMessage.get(StatMgr.class, "StatMgr.label25", "\u7edf\u8ba1\u4e34\u65f6\u8868\u540d\u79f0\u4e3a\u7a7a,\u65e0\u6cd5\u4ea7\u751f\u7edf\u8ba1!"));
        }
        string = string.toUpperCase();
        DBManager dBManager = DBManager.getDBManager();
        if (dBManager.getTableInfo(string) != null) {
            throw new WCMException(1100, I18NMessage.get(StatMgr.class, "StatMgr.label26", "\u5df2\u5b58\u5728\u540d\u79f0\u4e3a[") + string + I18NMessage.get(StatMgr.class, "StatMgr.label27", "]\u7684\u7edf\u8ba1\u8868!"));
        }
        String string2 = "CREATE TABLE " + string + "(";
        string2 = string2 + "RECID " + this.getType("NUMBER") + ", ";
        string2 = string2 + "STATTIME " + this.getType("DATETIME");
        for (int i = 0; i < list.size(); ++i) {
            StatFieldMap statFieldMap = (StatFieldMap)list.get(i);
            if (statFieldMap == null) continue;
            String string3 = statFieldMap.getFieldName();
            String string4 = statFieldMap.getFieldType();
            string2 = string2 + ", " + string3 + " " + this.getType(string4);
            if (!"STRING".equals(string4.toUpperCase())) continue;
            string2 = string2 + "(200) ";
        }
        string2 = string2 + ")";
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)(I18NMessage.get(StatMgr.class, "StatMgr.label28", "\u521b\u5efa\u6570\u636e\u5e93\uff1a") + string2));
        }
        try {
            dBManager.sqlExecuteUpdate(string2);
        }
        catch (WCMException wCMException) {
            throw new WCMException(1100, I18NMessage.get(StatMgr.class, "StatMgr.label29", "\u521b\u5efa\u7edf\u8ba1\u6570\u636e\u8868\u5931\u8d25!"), wCMException);
        }
        dBManager.notifyAddTable(string);
    }

    private String getType(String string) {
        int n = DBManager.getDBManager().getDBTypeAsInt() - 1;
        if ((string = string.toUpperCase()).equals("NUMBER")) {
            return DB_NUMBER_TYPE[n];
        }
        if (string.equals("STRING")) {
            return DB_STRING_TYPE[n];
        }
        if (string.equals("DATETIME")) {
            return DB_DATETIME_TYPE[n];
        }
        return "";
    }

    public final Reports deleteStatView(StatView statView) throws WCMException {
        if (statView == null) {
            throw new WCMException(10, I18NMessage.get(StatMgr.class, "StatMgr.label30", "\u7edf\u8ba1\u89c6\u56fe\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5220\u9664\uff01"));
        }
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("be going to delete a statview \uff1a" + statView.getViewName()));
        }
        Reports reports = new Reports(I18NMessage.get(StatMgr.class, "StatMgr.label31", "\u5220\u9664\u7edf\u8ba1\u89c6\u56fe"));
        try {
            this.deleteFieldMapsOf(statView);
            this.deleteStatResultTableIfTemplateView(statView);
            this.deleteEmbedViews(statView);
            this.deleteStatViewRelations(statView);
            statView.delete(this.getLoginUser());
        }
        catch (Exception exception) {
            reports.addFailedReport(I18NMessage.get(StatMgr.class, "StatMgr.label32", "\u5220\u9664[") + statView + I18NMessage.get(StatMgr.class, "StatMgr.label33", "]\u5931\u8d25."), exception);
        }
        reports.addSucessedReport(I18NMessage.get(StatMgr.class, "StatMgr.label32", "\u5220\u9664[") + statView + I18NMessage.get(StatMgr.class, "StatMgr.label34", "]\u6210\u529f."));
        return reports;
    }

    private void deleteFieldMapsOf(StatView statView) throws WCMException {
        StatFieldMaps statFieldMaps = this.getViewFields(statView.getId());
        if (statFieldMaps != null && !statFieldMaps.isEmpty()) {
            for (int i = 0; i < statFieldMaps.size(); ++i) {
                StatFieldMap statFieldMap = (StatFieldMap)statFieldMaps.getAt(i);
                if (statFieldMap == null) {
                    s_logger.error((Object)I18NMessage.get(StatMgr.class, "StatMgr.label35", "\u5220\u9664\u5b57\u6bb5\u6620\u5c04\u8868\u65f6\u53d1\u73b0\u4e00\u4e2a\u7a7a\u7684\uff01\u7ee7\u7eed\u6267\u884c\u3002"));
                    continue;
                }
                statFieldMap.delete(this.getLoginUser());
            }
        }
    }

    private void deleteStatResultTableIfTemplateView(StatView statView) throws WCMException {
        if (this.isTemplateView(statView)) {
            String string = "DROP TABLE " + statView.getResultTable();
            DBManager dBManager = DBManager.getDBManager();
            dBManager.sqlExecuteUpdate(string);
            dBManager.notifyRemoveTable(statView.getResultTable());
        }
    }

    private void deleteEmbedViews(StatView statView) throws WCMException {
        if (this.isTemplateView(statView)) {
            StatViews statViews = this.getEmbeddedViews(statView.getId());
            for (int i = 0; i < statViews.size(); ++i) {
                StatView statView2 = (StatView)statViews.getAt(i);
                if (statView2 == null) continue;
                this.deleteStatView(statView2);
            }
        }
    }

    private void deleteStatViewRelations(StatView statView) throws WCMException {
        String string = "DELETE FROM WCMSTATVIEWREL WHERE ";
        string = this.isTemplateView(statView) ? string + "MainViewId=" + statView.getId() : string + "EmbedViewId=" + statView.getId();
        DBManager.getDBManager().sqlExecuteUpdate(string);
    }

    private boolean isTemplateView(StatView statView) {
        return 1 == statView.getViewType();
    }

    public void setStatViewRelation(StatView statView, StatViews statViews) throws WCMException {
        CMSObj cMSObj;
        int n;
        if (statView == null) {
            throw new WCMException(10, I18NMessage.get(StatMgr.class, "StatMgr.label36", "\u7edf\u8ba1\u89c6\u56fe\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u8bbe\u7f6e\u5173\u8054\u5173\u7cfb\uff01"));
        }
        if (statViews == null || statViews.isEmpty()) {
            return;
        }
        String string = "MAINVIEWID=" + statView.getId();
        StatViewRels statViewRels = StatViewRels.openWCMObjs(this.getLoginUser(), new WCMFilter("", string, ""));
        for (n = 0; n < statViewRels.size(); ++n) {
            cMSObj = (StatViewRel)statViewRels.getAt(n);
            if (cMSObj == null) continue;
            cMSObj.delete(this.getLoginUser());
        }
        for (n = 0; n < statViews.size(); ++n) {
            cMSObj = (StatView)statViews.getAt(n);
            if (cMSObj == null) continue;
            StatViewRel statViewRel = new StatViewRel();
            statViewRel.setMainViewId(statView.getId());
            statViewRel.setEmbedViewId(cMSObj.getId());
            statViewRel.save(this.getLoginUser());
        }
    }

    private String parseDateTime(String string, CMyDateTime cMyDateTime, CMyDateTime cMyDateTime2) throws WCMException {
        String string2 = string;
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("start: " + cMyDateTime));
            s_logger.debug((Object)("end: " + cMyDateTime2));
        }
        String string3 = this.getStartTime(cMyDateTime);
        string2 = CMyString.replaceStr(string2, TAG_START_TIME, string3);
        String string4 = this.getEndTime(cMyDateTime2);
        string2 = CMyString.replaceStr(string2, TAG_END_TIME, string4);
        return string2;
    }

    private String getStartTime(CMyDateTime cMyDateTime) throws WCMException {
        if (this.isInvalidDateTime(cMyDateTime)) {
            try {
                cMyDateTime = CMyDateTime.now();
                cMyDateTime.setDateTimeWithString(this.getOriginalStart());
            }
            catch (CMyException cMyException) {
                throw new WCMException(1100, I18NMessage.get(StatMgr.class, "StatMgr.label37", "\u83b7\u53d6\u7edf\u8ba1\u8d44\u6e90\u7684\u8d77\u59cb\u65f6\u95f4\u51fa\u9519!"), cMyException);
            }
        }
        return this.toSqlDate(cMyDateTime);
    }

    private String getEndTime(CMyDateTime cMyDateTime) {
        if (this.isInvalidDateTime(cMyDateTime)) {
            cMyDateTime = CMyDateTime.now();
            try {
                cMyDateTime.setTimeWithString("23:59:59", 0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.toSqlDate(cMyDateTime);
    }

    private String toSqlDate(CMyDateTime cMyDateTime) {
        return DBManager.getDBManager().getDBType().sqlDateTime(cMyDateTime.toString(), "YYYY-MM-DD HH24:MI:SS");
    }

    private boolean isInvalidDateTime(CMyDateTime cMyDateTime) {
        return cMyDateTime == null || cMyDateTime.isNull();
    }

    public StatViews getEmbeddedViews(StatView statView) throws WCMException {
        if (statView == null) {
            throw new WCMException(10, I18NMessage.get(StatMgr.class, "StatMgr.label38", "\u7edf\u8ba1\u6a21\u677f\u4e3a\u7a7a\uff01"));
        }
        if (statView.getViewType() == 3) {
            return this.getEmbeddedViewsByFrom(statView.getId());
        }
        return this.getEmbeddedViews(statView.getId());
    }

    private boolean isStructureChanged(StatView statView, List list) throws WCMException {
        if (statView.isAddMode()) {
            return false;
        }
        if (statView.isChangeProperty("VIEWNAME")) {
            s_logger.debug((Object)I18NMessage.get(StatMgr.class, "StatMgr.label39", "\u4e34\u65f6\u7edf\u8ba1\u8868\u540d\u79f0\u53d8\u5316\u4e86\uff0c\u7ed3\u6784\u53d8\u5316\u4e86\u3002"));
            return true;
        }
        for (int i = 0; i < list.size(); ++i) {
            StatFieldMap statFieldMap = (StatFieldMap)list.get(i);
            if (statFieldMap == null) {
                s_logger.error((Object)I18NMessage.get(StatMgr.class, "StatMgr.label40", "\u5b57\u6bb5\u5217\u8868\u4e2d\u6709\u4e00\u4e2a\u4e3a\u7a7a\uff01"));
                continue;
            }
            if (statFieldMap.isAddMode()) {
                s_logger.debug((Object)I18NMessage.get(StatMgr.class, "StatMgr.label41", "\u65b0\u589e\u4e86\u5b57\u6bb5\uff0c\u7ed3\u6784\u53d8\u5316\u4e86\u3002"));
                return true;
            }
            if (!statFieldMap.isChangeProperty("FIELDPOS") && !statFieldMap.isChangeProperty("FIELDNAME") && !statFieldMap.isChangeProperty("FIELDTYPE")) continue;
            s_logger.debug((Object)I18NMessage.get(StatMgr.class, "StatMgr.label42", "\u5b57\u6bb5\u6620\u5c04\u8868\u4e2d\u7684\u5173\u952e\u4fe1\u606f\u53d1\u751f\u4e86\u53d8\u5316\uff0c\u7ed3\u6784\u53d8\u5316\u4e86\u3002"));
            return true;
        }
        if (this.getViewFields(statView.getId()).size() != list.size()) {
            s_logger.debug((Object)I18NMessage.get(StatMgr.class, "StatMgr.label43", "\u5b57\u6bb5\u6570\u76ee\u53d1\u751f\u4e86\u53d8\u5316\uff0c\u7ed3\u6784\u53d8\u5316\u4e86\u3002"));
            return true;
        }
        return false;
    }

    public void clearStatResult(int n) throws WCMException {
        StatView statView = StatView.findById(n);
        if (statView == null) {
            throw new WCMException(200006, I18NMessage.get(StatMgr.class, "StatMgr.label44", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684[id=") + n + I18NMessage.get(StatMgr.class, "StatMgr.label45", "]\u7684\u7edf\u8ba1\u89c6\u56fe!"));
        }
        if (statView.getViewType() != 1) {
            s_logger.error((Object)I18NMessage.get(StatMgr.class, "StatMgr.label46", "\u5f53\u524d\u7edf\u8ba1\u89c6\u56fe\u4e0d\u662f\u6a21\u677f\u578b\uff0c\u4e0d\u9700\u8981\u5220\u9664\u6570\u636e\uff01"));
            return;
        }
        String string = "DELETE FROM " + statView.getResultTable();
        s_logger.debug((Object)(I18NMessage.get(StatMgr.class, "StatMgr.label47", "\u5220\u9664\u4e34\u65f6\u8868\u4e2d\u7684\u6570\u636e\uff1a") + string));
        try {
            DBManager.getDBManager().sqlExecuteUpdate(string);
        }
        catch (WCMException wCMException) {
            throw new WCMException(1100, I18NMessage.get(StatMgr.class, "StatMgr.label48", "\u5220\u9664\u4e34\u65f6\u8868\u4e2d\u7684\u6570\u636e\u65f6\u5931\u8d25\uff1aSQL=\u3010") + string + "\u3011", wCMException);
        }
    }

    public Reports deleteStatHost(StatHost statHost) throws WCMException {
        if (statHost == null) {
            throw new WCMException(10, I18NMessage.get(StatMgr.class, "StatMgr.label49", "\u5f53\u524d\u7edf\u8ba1\u4e3b\u4f53\u4e3a\u7a7a,\u65e0\u6548\u7684\u7edf\u8ba1\u4e3b\u4f53,\u65e0\u6cd5\u5220\u9664!"));
        }
        Reports reports = new Reports(I18NMessage.get(StatMgr.class, "StatMgr.label50", "\u5220\u9664\u7edf\u8ba1\u4e3b\u4f53"));
        StatViews statViews = this.getStatViews(statHost.getHostName(), 0, null);
        for (int i = 0; i < statViews.size(); ++i) {
            StatView statView = (StatView)statViews.getAt(i);
            if (statView == null) {
                s_logger.error((Object)I18NMessage.get(StatMgr.class, "StatMgr.label51", "\u5220\u9664\u7edf\u8ba1\u89c6\u56fe\u65f6\u6709\u4e00\u4e2a\u4e3a\u7a7a\uff01"));
                reports.addFailedReport(I18NMessage.get(StatMgr.class, "StatMgr.label52", "\u5220\u9664\u7edf\u8ba1\u89c6\u56fe\u65f6\u6709\u4e00\u4e2a\u4e3a\u7a7a"), null);
                continue;
            }
            try {
                this.deleteStatView(statView);
                reports.addSucessedReport(I18NMessage.get(StatMgr.class, "StatMgr.label53", "\u5220\u9664\u7edf\u8ba1\u89c6\u56fe[") + statView.getViewName() + I18NMessage.get(StatMgr.class, "StatMgr.label54", "]\u6210\u529f\uff01"));
                continue;
            }
            catch (Exception exception) {
                reports.addFailedReport(I18NMessage.get(StatMgr.class, "StatMgr.label53", "\u5220\u9664\u7edf\u8ba1\u89c6\u56fe[") + statView.getViewName() + I18NMessage.get(StatMgr.class, "StatMgr.label55", "]\u5931\u8d25\uff01"), exception);
            }
        }
        try {
            statHost.delete(this.getLoginUser());
            reports.addSucessedReport(I18NMessage.get(StatMgr.class, "StatMgr.label56", "\u5220\u9664\u7edf\u8ba1\u4e3b\u4f53[") + statHost.getHostName() + I18NMessage.get(StatMgr.class, "StatMgr.label54", "]\u6210\u529f\uff01"));
        }
        catch (Exception exception) {
            reports.addFailedReport(I18NMessage.get(StatMgr.class, "StatMgr.label56", "\u5220\u9664\u7edf\u8ba1\u4e3b\u4f53[") + statHost.getHostName() + I18NMessage.get(StatMgr.class, "StatMgr.label55", "]\u5931\u8d25\uff01"), exception);
        }
        return reports;
    }

    public StatFieldMaps getStatFieldsByView(int n) throws WCMException {
        StatView statView = StatView.findById(n);
        this.assertViewFound(n, statView);
        String string = "STATVIEWID = " + n;
        WCMFilter wCMFilter = new WCMFilter("", string, "FIELDTOP DESC, FIELDPOS ASC");
        return StatFieldMaps.openWCMObjs(this.getLoginUser(), wCMFilter);
    }

    private StatFieldMaps getViewFields(StatView statView) throws WCMException {
        String string = "STATVIEWID = " + statView.getId();
        WCMFilter wCMFilter = new WCMFilter("", string, "FIELDTOP DESC, FIELDPOS ASC");
        return StatFieldMaps.openWCMObjs(this.getLoginUser(), wCMFilter);
    }

    private boolean emptyString(String string) {
        return string == null || string.trim().length() == 0;
    }

    private void assertViewFound(int n, StatView statView) throws WCMException {
        if (statView == null) {
            throw new WCMException(200006, I18NMessage.get(StatMgr.class, "StatMgr.label57", "\u6ca1\u6709\u627e\u5230[id=") + n + I18NMessage.get(StatMgr.class, "StatMgr.label58", "]\u7684\u7edf\u8ba1\u5b9e\u89c6\u56fe!"));
        }
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }
}

