/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.resource;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.util.CMyString;

public class Security
extends CMSObj {
    public static final int OBJ_TYPE = 607;
    public static final String DB_TABLE_NAME = "WCMSECURITY";
    public static final String DB_ID_NAME = "SECURITYID";

    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    public int getWCMType() {
        return 607;
    }

    public String getName() {
        return (String)this.getProperty("SNAME");
    }

    public boolean setName(String string) throws WCMException {
        return this.setProperty("SNAME", string);
    }

    public String getDesc() {
        return (String)this.getProperty("SDESC");
    }

    public boolean setDesc(String string) throws WCMException {
        return this.setProperty("SDESC", string);
    }

    public String getDisp() {
        return (String)this.getProperty("SDISP");
    }

    public boolean setDisp(String string) throws WCMException {
        return this.setProperty("SDISP", string);
    }

    public int getValue() {
        return this.getPropertyAsInt("SVALUE", 0);
    }

    public boolean setValue(int n) throws WCMException {
        return this.setProperty("SVALUE", n);
    }

    public boolean isValid() throws WCMException {
        String string = null;
        if (this.isAddMode()) {
            string = (String)this.getAllProperty().get("SNAME");
            if (string == null) {
                throw new WCMException(1107, I18NMessage.get(Security.class, "Security.label1", "\u5c5e\u6027Name\u6ca1\u6709\u66f4\u6539(Security.isValid)"));
            }
            if (this.getProperty("SVALUE") == null) {
                throw new WCMException(1107, I18NMessage.get(Security.class, "Security.label2", "\u5c5e\u6027Value\u6ca1\u6709\u66f4\u6539(Security.isValid)"));
            }
        } else {
            if (!this.isModified()) {
                throw new WCMException(1107, I18NMessage.get(Security.class, "Security.label3", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(Security.isValid)"));
            }
            string = (String)this.getNewProperty("SNAME");
        }
        if (string != null) {
            String string2 = " (SName='" + CMyString.filterForSQL(string) + "') ";
            if (!this.isAddMode()) {
                string2 = string2 + " and (" + this.getIdFieldName() + "<>" + this.getId() + ") ";
            }
            if (this.checkExists(string2)) {
                throw new WCMException(1108, I18NMessage.get(Security.class, "Security.label4", "\u5b89\u5168\u7c7b\u578b\u540d\u79f0\u5df2\u7ecf\u5b58\u5728\uff08Security.isValid\uff09"));
            }
        }
        return true;
    }

    public void insert(User user) throws WCMException {
        if (this.isAddMode() && this.getAllProperty() != null) {
            this.setCrTime();
            super.insert(user);
        }
    }

    public static final Security findById(int n) throws WCMException {
        if (n <= 0) {
            return null;
        }
        return (Security)BaseObj.findById(Security.class, n);
    }

    public static final Security createNewInstance() throws WCMException {
        return (Security)BaseObj.createNewInstance(Security.class);
    }

    public static final Security findByKey(Object object) throws WCMException {
        return (Security)BaseObj.findByKey(Security.class, object);
    }
}

