/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish.tagparser;

import com.trs.DreamFactory;
import com.trs.components.common.publish.domain.publisher.PublishPathCompass;
import com.trs.components.common.publish.domain.publisher.PublishSyncGlobalTuner;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.ITagParser;
import com.trs.components.common.publish.domain.tagparser.TagBeanAttrInfo;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfo;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.template.TemplateQuote;
import com.trs.components.metadata.center.MetaViewData;
import com.trs.components.metadata.publish.PublishContentViewDataImpl;
import com.trs.components.wcm.content.domain.AppendixMgr;
import com.trs.components.wcm.content.persistent.Appendix;
import com.trs.components.wcm.content.persistent.Appendixes;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.publish.element.PublishContentDocumentImpl;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.NamesRegister;
import com.trs.infra.util.html.HtmlUtil;
import com.trs.infra.util.image.CMyImage;
import com.trs.presentation.plugin.PluginConfig;
import com.trs.wcm.photo.IImageLibConfig;
import com.trs.wcm.photo.impl.ImageMagickCmd;
import com.trs.wcm.photo.impl.MagicImageImpl;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import javax.imageio.ImageIO;
import org.apache.log4j.Logger;

public class XWCMImageAppendixTagParser
implements ITagParser {
    private static Logger logger = Logger.getLogger(XWCMImageAppendixTagParser.class);
    private static NamesRegister s_oAppendixTypeRegister = new NamesRegister();
    private Document m_oDocument = null;
    private TagItem m_tagItem = null;
    private static TagBeanInfo s_TagBeanInfo;
    private static int n_maxRepeatTimes;

    public TemplateQuote[] analyzeQuotes(IPublishFolder iPublishFolder) throws WCMException {
        return null;
    }

    public TagBeanInfo getBeanInfo() {
        if (s_TagBeanInfo == null) {
            TagBeanAttrInfo tagBeanAttrInfo = null;
            TagBeanInfo tagBeanInfo = new TagBeanInfo();
            tagBeanInfo.setName("TRS_PHOTO");
            tagBeanInfo.setDesc("TRS_PHOTO");
            tagBeanInfo.setType(TagBeanInfo.BodyType.IGNORE);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("FIELD");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("INDEX");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.INTEGER);
            tagBeanAttrInfo.setDefaultValue("0");
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("WIDTH");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.INTEGER);
            tagBeanAttrInfo.setDefaultValue("0");
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("HEIGHT");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.INTEGER);
            tagBeanAttrInfo.setDefaultValue("0");
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("EXTRA");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("TARGET");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanAttrInfo.setDefaultValue("_blank");
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("LINKTEXT");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("UrlIsAbs");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanAttrInfo.setEnumValue(new String[]{"true", "false"});
            tagBeanAttrInfo.setDefaultValue("false");
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("AUTOLINK");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanAttrInfo.setEnumValue(new String[]{"true", "false"});
            tagBeanAttrInfo.setDefaultValue("false");
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
        }
        return s_TagBeanInfo;
    }

    private AppendixMgr getAppMgr() {
        return (AppendixMgr)DreamFactory.createObjectById("AppendixMgr");
    }

    public void setTagItem(TagItem tagItem) {
        this.m_tagItem = tagItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String compressImageFile(String string, PublishTagContext publishTagContext) throws Exception {
        int n;
        int n2;
        if (!CMyFile.fileExists(string)) {
            return null;
        }
        int n3 = publishTagContext.getAttribute("HEIGHT", 0);
        int n4 = publishTagContext.getAttribute("WIDTH", 0);
        String string2 = null;
        String string3 = CMyFile.extractFileExt(string);
        File file = new File(string);
        int[] nArray = CMyImage.getImageSize(string);
        int n5 = nArray[0];
        int n6 = nArray[1];
        if (n4 > 0 && n3 > 0) {
            n2 = n4;
            n = n2 * n6 / n5;
        } else if (n3 <= 0 && n4 > 0) {
            n2 = n4;
            n = n2 * n6 / n5;
        } else if (n4 <= 0 && n3 > 0) {
            n = n3;
            n2 = n * n5 / n6;
        } else {
            n = n6;
            n2 = n5;
        }
        if (PluginConfig.isStartPhoto()) {
            IImageLibConfig iImageLibConfig = (IImageLibConfig)DreamFactory.createObjectById("IImageLibConfig");
            String string4 = CMyFile.extractFileName(string);
            if (iImageLibConfig.isCmdUsed()) {
                ImageMagickCmd.ImageObj imageObj = new ImageMagickCmd.ImageObj();
                imageObj.setFilename(string4);
                FilesMan filesMan = FilesMan.getFilesMan();
                String string5 = filesMan.getNextFileName("W0", CMyFile.extractFileExt(imageObj.filename), CMyDateTime.now(), true);
                ImageMagickCmd.ImageObj imageObj2 = new ImageMagickCmd.ImageObj(string5, n2, n);
                ImageMagickCmd.scale(imageObj, imageObj2);
                return imageObj2.filename;
            }
            MagicImageImpl magicImageImpl = new MagicImageImpl();
            magicImageImpl.initMagicImage(string4);
            magicImageImpl.scaleImage(n2, n);
            return magicImageImpl.writeImageToSystemTemp();
        }
        BufferedImage bufferedImage = ImageIO.read(file);
        String string6 = n + "";
        String string7 = n2 + "";
        String string8 = string.substring(0, string.length() - string3.length() - 1);
        string2 = string8 + "_" + string7 + "_" + string6 + ".jpg";
        if (CMyFile.fileExists(string2) && new File(string2).length() > 10L) {
            return string2;
        }
        BufferedImage bufferedImage2 = new BufferedImage(n2, n, 1);
        bufferedImage2.getGraphics().drawImage(bufferedImage, 0, 0, n2, n, null);
        FileOutputStream fileOutputStream = null;
        int n7 = 0;
        while (n7 < n_maxRepeatTimes) {
            block21: {
                Object var22_30;
                block19: {
                    try {
                        try {
                            fileOutputStream = new FileOutputStream(string2);
                            ImageIO.write((RenderedImage)bufferedImage2, CMyFile.extractFileExt(string2), fileOutputStream);
                            File file2 = new File(string2);
                            if (file2.length() <= 20L) break block19;
                            if (fileOutputStream != null) {
                                fileOutputStream.close();
                            }
                            var22_30 = null;
                            if (fileOutputStream == null) return string2;
                        }
                        catch (Throwable throwable) {
                            if (n7 == n_maxRepeatTimes - 1) {
                                throw new WCMException("Compress image failed [DOCID=" + this.m_oDocument.getDocId() + ",DOCTITLE=" + this.m_oDocument.getTitle() + "]", throwable);
                            }
                            Thread.sleep(30L);
                            var22_30 = null;
                            if (fileOutputStream != null) {
                                fileOutputStream.close();
                            }
                            break block21;
                        }
                    }
                    catch (Throwable throwable) {
                        var22_30 = null;
                        if (fileOutputStream == null) throw throwable;
                        fileOutputStream.close();
                        throw throwable;
                    }
                    fileOutputStream.close();
                    return string2;
                }
                var22_30 = null;
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            ++n7;
        }
        return string2;
    }

    public String[] parse(PublishTagContext publishTagContext) throws WCMException {
        this.m_oDocument = this.getDocument(publishTagContext);
        if (this.m_oDocument == null) {
            logger.debug((Object)("Document that contants tag named TRS_PHOTO  is null[CHANNELID=" + this.m_oDocument.getChannelId() + ",DOCID=" + this.m_oDocument.getId() + ", DOCTITLE=" + this.m_oDocument.getTitle() + "]"));
            return null;
        }
        int n = 20;
        int n2 = publishTagContext.getAttribute("INDEX", 0);
        Appendixes appendixes = this.getAllAppendixes(publishTagContext, n);
        if (appendixes == null || appendixes.size() == 0) {
            return null;
        }
        Appendix appendix = null;
        if (n2 == -1) {
            String[] stringArray = new String[appendixes.size()];
            for (int i = 1; i <= appendixes.size(); ++i) {
                appendix = this.findAppendix(appendixes, i);
                stringArray[i - 1] = this.parseAppendix(appendix, publishTagContext);
            }
            return stringArray;
        }
        appendix = this.findAppendix(appendixes, n2);
        return new String[]{this.parseAppendix(appendix, publishTagContext)};
    }

    private String parseAppendix(Appendix appendix, PublishTagContext publishTagContext) throws WCMException {
        String string;
        String string2 = this.findSrcPathName(appendix);
        IPublishElement iPublishElement = publishTagContext.getUpperHost();
        String string3 = "[DOCTITLE=" + this.m_oDocument.getTitle() + ",DOCID=" + this.m_oDocument.getId() + "\uff0cAPPENDIXID=" + appendix.getId() + "]";
        if (!CMyFile.fileExists(string2)) {
            throw new WCMException("The uploaded file is not exist on the server " + string3);
        }
        if (!XWCMImageAppendixTagParser.isValidImage(string2)) {
            throw new WCMException("Not available image" + string3);
        }
        try {
            string = this.compressImageFile(string2, publishTagContext);
        }
        catch (Exception exception) {
            throw new WCMException("Exception caused when compressing image " + string3, exception);
        }
        String string4 = CMyFile.extractFileName(string);
        this.distributeImageFile(publishTagContext, iPublishElement, string4);
        String string5 = publishTagContext.getAttribute("FIELD");
        if ("_RECURL".equalsIgnoreCase(string5)) {
            String string6 = XWCMImageAppendixTagParser.getApdHttpPath(publishTagContext) + string4;
            if (!publishTagContext.getAttribute("UrlIsAbs", false)) {
                string6 = HtmlUtil.calRelativePath(string6, publishTagContext.getPageHttpPath());
            }
            return string6;
        }
        PublishPathCompass publishPathCompass = publishTagContext.getPathCompass();
        String string7 = HtmlUtil.calRelativePath(publishPathCompass.getAbsoluteHttpPath(iPublishElement), publishTagContext.getPageHttpPath()) + string4;
        Document document = (Document)iPublishElement.getSubstance();
        String string8 = document.getTitle();
        String string9 = publishTagContext.getAttribute("EXTRA");
        String string10 = HtmlUtil.renderImage(string7, string8, string9, null, null);
        if (publishTagContext.getAttribute("AUTOLINK", false)) {
            string10 = XWCMImageAppendixTagParser.addAutoLink(string10, publishTagContext);
        }
        return string10;
    }

    protected static String getApdHttpPath(PublishTagContext publishTagContext) throws WCMException {
        IPublishElement iPublishElement = publishTagContext.getUpperHost();
        PublishPathCompass publishPathCompass = publishTagContext.getPathCompass();
        return publishPathCompass.getAbsoluteHttpPath(iPublishElement);
    }

    private Appendix findAppendix(Appendixes appendixes, int n) throws WCMException {
        if (n <= 0 || n > appendixes.size()) {
            Appendix appendix = (Appendix)appendixes.getAt(0);
            return appendix;
        }
        if (n > 0 && n <= appendixes.size()) {
            return (Appendix)appendixes.getAt(n - 1);
        }
        throw new WCMException("Your index setted is beyond the sum of images the document contants [CHANNELID=" + this.m_oDocument.getChannelId() + ",DOCID=" + this.m_oDocument.getId() + ",DOCTITLE=" + this.m_oDocument.getTitle() + "]");
    }

    protected static String addAutoLink(String string, PublishTagContext publishTagContext) throws WCMException {
        String string2 = publishTagContext.getAttribute("TARGET");
        String string3 = "";
        String string4 = publishTagContext.getAttribute("LINKTEXT");
        String string5 = null;
        String string6 = XWCMImageAppendixTagParser.getAutoLinkUrl(publishTagContext);
        if (!publishTagContext.getUpperHost().isLink()) {
            string6 = HtmlUtil.calRelativePath(string6, publishTagContext.getPageHttpPath());
        }
        return HtmlUtil.renderLink(string6, string2, string5, string3, string, string4);
    }

    protected static String getAutoLinkUrl(PublishTagContext publishTagContext) throws WCMException {
        IPublishElement iPublishElement = publishTagContext.getUpperHost();
        IPublishContent iPublishContent = (IPublishContent)iPublishElement;
        PublishPathCompass publishPathCompass = publishTagContext.getPathCompass();
        switch (iPublishContent.getBodyType()) {
            case 40: {
                String string = iPublishContent.getFileName();
                return publishPathCompass.getAbsoluteHttpPath(publishTagContext.getUpperHost()) + string;
            }
            case 30: {
                return iPublishContent.getLinkUrl();
            }
        }
        return publishPathCompass.getHttpUrl((IPublishContent)publishTagContext.getUpperHost(), 0);
    }

    private void distributeImageFile(PublishTagContext publishTagContext, IPublishElement iPublishElement, String string) throws WCMException {
        String string2 = string;
        String string3 = FilesMan.getFilesMan().mapFilePath(string2, 0) + string2;
        if (!CMyFile.fileExists(string3)) {
            publishTagContext.addWarning(iPublishElement.getInfo() + "-image ", iPublishElement.getId(), "Can't find image [" + string2 + "]which belongs to(" + iPublishElement.getInfo() + ")");
        }
        PublishPathCompass publishPathCompass = publishTagContext.getPathCompass();
        boolean bl = publishTagContext.isPreview();
        String string4 = CMyString.setStrEndWith(publishPathCompass.getLocalPath(iPublishElement, bl), File.separatorChar);
        PublishSyncGlobalTuner.insureLocalPathExists(string4);
        if (CMyFile.fileExists(string4 + string2)) {
            return;
        }
        for (int i = 0; i < n_maxRepeatTimes; ++i) {
            try {
                CMyFile.copyFile(string3, string4 + string2);
                if (new File(string3).length() != new File(string4 + string2).length()) continue;
                break;
            }
            catch (Throwable throwable) {
                if (i == n_maxRepeatTimes - 1) {
                    throw new WCMException("Exception caused at upperHost(" + iPublishElement.getInfo() + ") when copying image [" + string2 + "]", throwable);
                }
                try {
                    Thread.sleep(30L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    throw new WCMException("Interrupt Exception!", interruptedException);
                }
            }
        }
        if (!bl) {
            publishTagContext.getFileDistributeShip().distributeFile(string3, iPublishElement);
        }
    }

    private String findSrcPathName(Appendix appendix) throws WCMException {
        String string = "";
        String string2 = appendix.getFile();
        if (string2 == null || string2.length() == 0) {
            return null;
        }
        string = FilesMan.getFilesMan().mapFilePath(string2, 0) + string2;
        return string;
    }

    private Appendixes getAllAppendixes(PublishTagContext publishTagContext, int n) throws WCMException {
        String string = publishTagContext.getAttribute("RELATEDCOLUMN");
        boolean bl = !CMyString.isEmpty(string);
        Appendixes appendixes = this.getAppMgr().getAppendixes(this.m_oDocument, n);
        if (bl) {
            for (int i = appendixes.size() - 1; i >= 0; --i) {
                Appendix appendix = (Appendix)appendixes.getAt(i);
                if (appendix == null || string.equals(appendix.getRelatedColumn())) continue;
                appendixes.remove(appendix);
            }
        }
        return appendixes;
    }

    private Document getDocument(PublishTagContext publishTagContext) throws WCMException {
        IPublishElement iPublishElement = publishTagContext.getUpperHost();
        if (iPublishElement instanceof PublishContentDocumentImpl) {
            return (Document)iPublishElement.getSubstance();
        }
        if (iPublishElement instanceof PublishContentViewDataImpl) {
            MetaViewData metaViewData = (MetaViewData)iPublishElement.getSubstance();
            return metaViewData.getDocument();
        }
        return null;
    }

    public void clear() {
        if (this.m_tagItem != null) {
            this.m_tagItem = null;
        }
        if (this.m_oDocument != null) {
            this.m_oDocument = null;
        }
    }

    private static boolean isValidImage(String string) {
        int[] nArray = CMyImage.getImageSize(string);
        return nArray[0] >= 0 && nArray[1] >= 0;
    }

    static {
        s_oAppendixTypeRegister.register("LINK", 40);
        s_oAppendixTypeRegister.register("FILE", 10);
        s_oAppendixTypeRegister.register("PIC", 20);
        s_oAppendixTypeRegister.register("ALL", 50);
        s_TagBeanInfo = null;
        n_maxRepeatTimes = 5;
    }
}

