/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish.tagparser;

import com.trs.DreamFactory;
import com.trs.components.common.publish.domain.publisher.PublishPathCompass;
import com.trs.components.common.publish.domain.publisher.PublishSyncGlobalTuner;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.ITagParser;
import com.trs.components.common.publish.domain.tagparser.TagBeanAttrInfo;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfo;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.template.TemplateQuote;
import com.trs.components.metadata.center.MetaViewData;
import com.trs.components.metadata.publish.PublishContentViewDataImpl;
import com.trs.components.wcm.content.domain.AppendixMgr;
import com.trs.components.wcm.content.persistent.Appendix;
import com.trs.components.wcm.content.persistent.Appendixes;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.publish.element.PublishContentDocumentImpl;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.NamesRegister;
import com.trs.infra.util.html.HtmlUtil;
import java.io.File;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class XWCMFileAppendixTagParser
implements ITagParser {
    private static Logger logger = Logger.getLogger(XWCMFileAppendixTagParser.class);
    private static NamesRegister s_oAppendixTypeRegister = new NamesRegister();
    private Document m_oDocument = null;
    private TagItem m_tagItem = null;
    private static TagBeanInfo s_TagBeanInfo;
    private static int n_maxRepeatTimes;

    public TemplateQuote[] analyzeQuotes(IPublishFolder iPublishFolder) throws WCMException {
        return null;
    }

    public TagBeanInfo getBeanInfo() {
        if (s_TagBeanInfo == null) {
            TagBeanAttrInfo tagBeanAttrInfo = null;
            TagBeanInfo tagBeanInfo = new TagBeanInfo();
            tagBeanInfo.setName("TRS_FILE");
            tagBeanInfo.setDesc("TRS_FILE");
            tagBeanInfo.setType(TagBeanInfo.BodyType.IGNORE);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("FIELD");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("UrlIsAbs");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanAttrInfo.setEnumValue(new String[]{"true", "false"});
            tagBeanAttrInfo.setDefaultValue("false");
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("INDEX");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.INTEGER);
            tagBeanAttrInfo.setDefaultValue("0");
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("PATTERN");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("EXTRA");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
        }
        return s_TagBeanInfo;
    }

    private AppendixMgr getAppMgr() {
        return (AppendixMgr)DreamFactory.createObjectById("AppendixMgr");
    }

    public void setTagItem(TagItem tagItem) {
        this.m_tagItem = tagItem;
    }

    public String[] parse(PublishTagContext publishTagContext) throws WCMException {
        Appendixes appendixes;
        IPublishElement iPublishElement = publishTagContext.getUpperHost();
        this.m_oDocument = this.getDocument(publishTagContext);
        if (this.m_oDocument == null) {
            return null;
        }
        String string = null;
        int n = 10;
        int n2 = publishTagContext.getAttribute("INDEX", 0);
        String string2 = (String)publishTagContext.getAttributes().get("PATTERN");
        if (CMyString.isEmpty(string2)) {
            string2 = "${NAME}_${CRTIME}.${EXT}";
        }
        if ((appendixes = this.getAllAppendixes(publishTagContext, n)) == null || appendixes.size() == 0) {
            logger.debug((Object)("\u6587\u6863\u6ca1\u6709\u6587\u4ef6\u9644\u4ef6[CHANNELID=" + this.m_oDocument.getChannelId() + ",DOCID=" + this.m_oDocument.getDocId() + "]"));
            return null;
        }
        if (n2 <= 0) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < appendixes.size(); ++i) {
                Object object;
                String string3;
                Appendix appendix = (Appendix)appendixes.getAt(i);
                string = this.findSrcPathName(appendix);
                if (!CMyFile.fileExists(string)) {
                    string3 = "\u76f8\u5173\u7684\u6587\u4ef6\u5728\u670d\u52a1\u5668\u4e0a\u4e0d\u5b58\u5728\uff01[\u6587\u4ef6\u540d=" + appendix.getFile() + "\uff0c\u9644\u4ef6ID=" + appendix.getId() + ", \u6587\u6863ID=" + this.m_oDocument.getId() + ", \u6587\u6863\u6807\u9898=" + this.m_oDocument.getTitle() + "]";
                    logger.error((Object)string3);
                    throw new WCMException(string3);
                }
                string3 = CMyFile.extractFileName(string);
                String string4 = this.makeAppFileName(string, string2, appendix);
                this.distributeFile(publishTagContext, iPublishElement, string3, string4);
                String string5 = publishTagContext.getAttribute("FIELD");
                String string6 = (String)publishTagContext.getAttributes().get("BEGINHTML");
                String string7 = (String)publishTagContext.getAttributes().get("ENDHTML");
                if (CMyString.isEmpty(string5)) {
                    object = publishTagContext.getPathCompass();
                    String string8 = HtmlUtil.calRelativePath(((PublishPathCompass)object).getAbsoluteHttpPath(iPublishElement), publishTagContext.getPageHttpPath()) + string4;
                    if (!CMyString.isEmpty(string6)) {
                        stringBuffer.append(string6);
                    }
                    stringBuffer.append("<a href=\"");
                    stringBuffer.append(string8);
                    stringBuffer.append("\" target=\"_blank\">");
                    stringBuffer.append(string4);
                    stringBuffer.append("</a>");
                    if (!CMyString.isEmpty(string7)) {
                        stringBuffer.append(string7);
                    }
                }
                if (CMyString.isEmpty(string5) || !string5.toUpperCase().equalsIgnoreCase("_RECURL")) continue;
                object = XWCMFileAppendixTagParser.getApdHttpPath(publishTagContext) + string4;
                if (!publishTagContext.getAttribute("UrlIsAbs", false)) {
                    object = HtmlUtil.calRelativePath((String)object, publishTagContext.getPageHttpPath());
                }
                stringBuffer.append((String)object);
            }
            return new String[]{stringBuffer.toString()};
        }
        if (n2 > 0 && n2 <= appendixes.size()) {
            Appendix appendix = (Appendix)appendixes.getAt(n2 - 1);
            string = this.findSrcPathName(appendix);
            if (CMyString.isEmpty(string)) {
                String string9 = "\u76f8\u5173\u7684\u6587\u4ef6\u5728\u670d\u52a1\u5668\u4e0a\u4e0d\u5b58\u5728\uff01[\u6587\u4ef6\u540d=" + appendix.getFile() + "\uff0c\u9644\u4ef6ID=" + appendix.getId() + ", \u6587\u6863ID=" + this.m_oDocument.getId() + ", \u6587\u6863\u6807\u9898=" + this.m_oDocument.getTitle() + "]";
                logger.error((Object)string9);
                throw new WCMException(string9);
            }
            if (!CMyFile.fileExists(string)) {
                String string10 = "\u76f8\u5173\u7684\u6587\u4ef6\u5728\u670d\u52a1\u5668\u4e0a\u4e0d\u5b58\u5728\uff01[\u6587\u4ef6\u540d=" + appendix.getFile() + "\uff0c\u9644\u4ef6ID=" + appendix.getId() + ", \u6587\u6863ID=" + this.m_oDocument.getId() + ", \u6587\u6863\u6807\u9898=" + this.m_oDocument.getTitle() + "]";
                logger.error((Object)string10);
                throw new WCMException(string10);
            }
            String string11 = CMyFile.extractFileName(string);
            String string12 = this.makeAppFileName(string, string2, appendix);
            this.distributeFile(publishTagContext, iPublishElement, string11, string12);
            PublishPathCompass publishPathCompass = publishTagContext.getPathCompass();
            String string13 = HtmlUtil.calRelativePath(publishPathCompass.getAbsoluteHttpPath(iPublishElement), publishTagContext.getPageHttpPath()) + string12;
            StringBuffer stringBuffer = new StringBuffer();
            String string14 = publishTagContext.getAttribute("FIELD");
            if (CMyString.isEmpty(string14)) {
                stringBuffer.append("<a href=\"");
                stringBuffer.append(string13);
                stringBuffer.append("\" target=\"_blank\">");
                stringBuffer.append(string12);
                stringBuffer.append("</a>");
            }
            if (string14 != null && string14.toUpperCase().equalsIgnoreCase("_RECURL")) {
                String string15 = XWCMFileAppendixTagParser.getApdHttpPath(publishTagContext) + string12;
                if (!publishTagContext.getAttribute("UrlIsAbs", false)) {
                    string15 = HtmlUtil.calRelativePath(string15, publishTagContext.getPageHttpPath());
                }
                stringBuffer.append(string15);
            }
            return new String[]{stringBuffer.toString()};
        }
        String string16 = "\u4f60\u8bbe\u7f6e\u7684index\u8d85\u51fa\u4e86\u6587\u6863\u5305\u542b\u7684\u6587\u4ef6\u9644\u4ef6\u603b\u6570[\u680f\u76eeID=" + this.m_oDocument.getChannelId() + ",\u6587\u6863ID=" + this.m_oDocument.getId() + "]";
        logger.error((Object)string16);
        throw new WCMException(string16);
    }

    protected static String getApdHttpPath(PublishTagContext publishTagContext) throws WCMException {
        IPublishElement iPublishElement = publishTagContext.getUpperHost();
        if (iPublishElement == null) {
            throw new WCMException("\u6ca1\u6709\u627e\u5230UpperHost\u5bf9\u8c61!");
        }
        if (!(iPublishElement instanceof IPublishContent)) {
            throw new WCMException("\u5f53\u524dUpperHost[" + iPublishElement.getInfo() + "]\u4e0d\u662fIPublishContent\u5bf9\u8c61");
        }
        PublishPathCompass publishPathCompass = publishTagContext.getPathCompass();
        return publishPathCompass.getAbsoluteHttpPath(iPublishElement);
    }

    private String makeAppFileName(String string, String string2, Appendix appendix) throws WCMException {
        String string3 = appendix.getSrcFile();
        String string4 = CMyFile.extractFileExt(string);
        int n = string3.length() - string4.length() - 1;
        if (n <= 0) {
            String string5 = "\u4e0a\u4f20\u6587\u6863\u7684\u6587\u4ef6\u540d\u4e3a\u7a7a\uff01[\u6587\u4ef6\u540d=" + appendix.getFile() + "\uff0c\u9644\u4ef6ID=" + appendix.getId() + ", \u6587\u6863ID=" + this.m_oDocument.getId() + ", \u6587\u6863\u6807\u9898=" + this.m_oDocument.getTitle() + "]";
            logger.error((Object)string5);
            throw new WCMException(string5);
        }
        String string6 = string3.substring(0, n);
        int n2 = this.m_oDocument.getChannelId();
        Channel channel = (Channel)Channel.findById(Channel.class, n2);
        String string7 = channel.getProperties().get("EXP_STOCKNO") + "";
        String string8 = channel.getProperties().get("EXP_CSNAME") + "";
        int n3 = this.m_oDocument.getId();
        int n4 = appendix.getId();
        CMyDateTime cMyDateTime = this.m_oDocument.getCrTime();
        String string9 = n2 + "";
        String string10 = n3 + "";
        String string11 = n4 + "";
        String string12 = cMyDateTime.toString("yyyyMMddHH");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("NAME", string6);
        hashMap.put("CHNLID", string9);
        hashMap.put("DOCID", string10);
        hashMap.put("CRTIME", string12);
        hashMap.put("EXT", string4);
        hashMap.put("APPID", string11);
        hashMap.put("EXPSTOCKNO", string7);
        hashMap.put("EXPSTOCKNAME", string8);
        String string13 = CMyString.parsePageVariables(string2, hashMap);
        return string13;
    }

    private void distributeFile(PublishTagContext publishTagContext, IPublishElement iPublishElement, String string, String string2) throws WCMException {
        File file;
        String string3 = string;
        String string4 = FilesMan.getFilesMan().mapFilePath(string3, 0);
        String string5 = string4 + string3;
        if (!CMyFile.fileExists(string5)) {
            publishTagContext.addWarning(iPublishElement.getInfo() + "-\u6587\u4ef6", iPublishElement.getId(), "\u5728\u78c1\u76d8\u4e0a\u6ca1\u6709\u627e\u5230(" + iPublishElement.getInfo() + ")\u7684\u6587\u4ef6[" + string3 + "]");
            return;
        }
        File file2 = new File(string5);
        PublishPathCompass publishPathCompass = publishTagContext.getPathCompass();
        boolean bl = publishTagContext.isPreview();
        String string6 = CMyString.setStrEndWith(publishPathCompass.getLocalPath(iPublishElement, bl), File.separatorChar);
        PublishSyncGlobalTuner.insureLocalPathExists(string6);
        String string7 = string4 + string2;
        if (!CMyString.isEmpty(string7) && !CMyString.isEmpty(CMyFile.extractFileName(string7)) && (!(file = new File(string7)).exists() || file.exists() && (double)file.length() != (double)file2.length())) {
            this.completeCopyFile(string5, file2, string7, file);
        }
        boolean bl2 = true;
        String string8 = string6 + string2;
        File file3 = new File(string8);
        if (!file3.exists() || file3.exists() && (double)file3.length() != (double)file2.length()) {
            this.completeCopyFile(string5, file2, string8, file3);
        } else {
            bl2 = false;
            logger.debug((Object)"\u6e90\u6587\u4ef6\u5df2\u7ecf\u5b58\u5728\uff0c\u6b64\u65f6\u4e0d\u518d\u590d\u5236");
        }
        if (!bl && bl2) {
            publishTagContext.getFileDistributeShip().distributeFile(string7, iPublishElement);
        }
    }

    private void completeCopyFile(String string, File file, String string2, File file2) throws WCMException {
        for (int i = 0; i < n_maxRepeatTimes; ++i) {
            try {
                CMyFile.copyFile(string, string2);
                if ((double)file2.length() == (double)file.length()) break;
                logger.error((Object)("\u6267\u884c\u6587\u4ef6\u62f7\u8d1d\u5931\u8d25[CHANNELID=" + this.m_oDocument.getChannelId() + ",DOCID=" + this.m_oDocument.getDocId() + "]"));
                continue;
            }
            catch (CMyException cMyException) {
                logger.error((Object)"\u62f7\u8d1d\u6587\u4ef6\u51fa\u73b0\u5f02\u5e38", (Throwable)cMyException);
                if (i != 99) continue;
                String string3 = "\u6587\u4ef6[CHANNELID=" + this.m_oDocument.getChannelId() + ",DOCID=" + this.m_oDocument.getDocId() + "]\u62f7\u8d1d\u51fa\u73b0\u5f02\u5e38\u5e76\u4e2d\u6b62";
                logger.error((Object)string3);
                throw new WCMException(string3);
            }
        }
    }

    private String findSrcPathName(Appendix appendix) throws WCMException {
        String string = "";
        String string2 = appendix.getFile();
        if (CMyString.isEmpty(string2)) {
            return null;
        }
        string = FilesMan.getFilesMan().mapFilePath(string2, 0) + string2;
        return string;
    }

    private Appendixes getAllAppendixes(PublishTagContext publishTagContext, int n) throws WCMException {
        BaseObjs baseObjs = null;
        for (int i = 0; i < n_maxRepeatTimes; ++i) {
            try {
                baseObjs = this.getAppMgr().getAppendixes(this.m_oDocument, n);
                break;
            }
            catch (WCMException wCMException) {
                logger.error((Object)"\u8bfb\u53d6\u6570\u636e\u5e93\u4fe1\u606f\u5931\u8d25\uff01", (Throwable)wCMException);
                if (i != 99) continue;
                baseObjs = null;
                String string = "\u53d1\u5e03\u6587\u6863[CHANNELID=" + this.m_oDocument.getChannelId() + ",DOCID=" + this.m_oDocument.getDocId() + "]\u51fa\u9519\u5e76\u4e2d\u6b62\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u5e93\u8fde\u63a5\u662f\u5426\u6b63\u5e38";
                logger.error((Object)string);
                throw new WCMException(string);
            }
        }
        if (baseObjs == null || baseObjs.size() == 0) {
            return null;
        }
        return baseObjs;
    }

    private Document getDocument(PublishTagContext publishTagContext) throws WCMException {
        IPublishElement iPublishElement = publishTagContext.getUpperHost();
        if (iPublishElement instanceof PublishContentDocumentImpl) {
            return (Document)iPublishElement.getSubstance();
        }
        if (iPublishElement instanceof PublishContentViewDataImpl) {
            MetaViewData metaViewData = (MetaViewData)iPublishElement.getSubstance();
            return metaViewData.getDocumnent();
        }
        return null;
    }

    public void clear() {
        if (this.m_tagItem != null) {
            this.m_tagItem = null;
        }
        if (this.m_oDocument != null) {
            this.m_oDocument = null;
        }
    }

    static {
        s_oAppendixTypeRegister.register("LINK", 40);
        s_oAppendixTypeRegister.register("FILE", 10);
        s_oAppendixTypeRegister.register("PIC", 20);
        s_oAppendixTypeRegister.register("ALL", 50);
        s_TagBeanInfo = null;
        n_maxRepeatTimes = 100;
    }
}

