/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish.tagparser;

import com.trs.cms.content.CMSObj;
import com.trs.cms.content.DefaultObj;
import com.trs.cms.content.DefaultObjs;
import com.trs.cms.process.config.FlowConfigServer;
import com.trs.components.common.publish.domain.publisher.PublishPathCompass;
import com.trs.components.common.publish.domain.publisher.PublishSyncGlobalTuner;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.BaseTagParser;
import com.trs.components.common.publish.domain.tagparser.TagBeanAttrInfo;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfo;
import com.trs.components.common.publish.domain.tagparser.TagParseHelper;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.publish.tagparser.WCMDocumentImagesGenerator;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.file.FileHelper;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.html.HtmlUtil;
import java.io.File;
import java.util.Map;
import org.apache.log4j.Logger;

public class XWCMContImgTagParser
extends BaseTagParser {
    private static Logger logger = Logger.getLogger(FlowConfigServer.class);
    private final String RETURN_HTML = "html";
    private final String RETURN_URL = "url";
    private final String RETURN_NAME = "name";
    private final String RETURN_DESC = "desc";
    protected static TagBeanInfo m_sTagBeanInfo = null;

    public TagBeanInfo getBeanInfo() {
        if (m_sTagBeanInfo == null) {
            TagBeanAttrInfo tagBeanAttrInfo = null;
            TagBeanInfo tagBeanInfo = new TagBeanInfo();
            tagBeanInfo.setName("TRS_CONTIMG");
            tagBeanInfo.setDesc("TRS_CONTIMG");
            tagBeanInfo.setType(TagBeanInfo.BodyType.IGNORE);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("WIDTH");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.INTEGER);
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("INDEX");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.INTEGER);
            tagBeanAttrInfo.setDefaultValue("-1");
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("AUTOLINK");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanAttrInfo.setEnumValue(new String[]{"true", "false"});
            tagBeanAttrInfo.setDefaultValue("true");
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("UPLOADONLY");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanAttrInfo.setEnumValue(new String[]{"true", "false"});
            tagBeanAttrInfo.setDefaultValue("false");
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("URLISABS");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanAttrInfo.setEnumValue(new String[]{"true", "false"});
            tagBeanAttrInfo.setDefaultValue("false");
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("FIELD");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanAttrInfo.setEnumValue(new String[]{"html", "name", "url", "desc"});
            tagBeanAttrInfo.setDefaultValue("html");
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("ONLYFROM");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanAttrInfo.setEnumValue(new String[]{"content", "appendix"});
            tagBeanAttrInfo.setDefaultValue("content");
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("FIRSTFROM");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanAttrInfo.setEnumValue(new String[]{"content", "appendix"});
            tagBeanAttrInfo.setDefaultValue("");
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("AUTOFORMAT");
            tagBeanAttrInfo.setEnumValue(new String[]{"true", "false"});
            tagBeanAttrInfo.setDefaultValue("false");
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("AUTOFORMATTYPE");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanAttrInfo.setEnumValue(new String[]{"HTML", "HTMLValue", "JAVASCRIPT", "XML"});
            tagBeanAttrInfo.setDefaultValue("HTML");
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("MINWIDTH");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.INTEGER);
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("MINHEIGHT");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.INTEGER);
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            m_sTagBeanInfo = tagBeanInfo;
        }
        return m_sTagBeanInfo;
    }

    public String[] parse(PublishTagContext publishTagContext) throws WCMException {
        int n;
        Object object;
        IPublishElement iPublishElement = publishTagContext.getUpperHost();
        if (iPublishElement.isFolder()) {
            throw new WCMException("TRS_CONIMG\u7f6e\u6807\u4e0d\u80fd\u5e94\u7528\u5230\u680f\u76ee[" + iPublishElement.getInfo() + "]\u4e0a\uff01");
        }
        CMSObj cMSObj = this.findObject(publishTagContext);
        String string = "";
        String string2 = "";
        if (cMSObj == null) {
            object = iPublishElement.getSubstance();
            if (!(object instanceof Document)) {
                throw new WCMException("TRS_CONIMG\u7f6e\u6807\u76ee\u524d\u53ea\u80fd\u7528\u5230\u6587\u6863\u5bf9\u8c61\u6216\u8005\u96c6\u5408\u7f6e\u6807TRS_CONIMGS\u4e0a\uff01");
            }
            n = publishTagContext.getAttribute("INDEX", 1);
            if (n < 1) {
                n = 1;
            }
            cMSObj = this.findDocumentImage(publishTagContext, (Document)object, n);
        }
        if (cMSObj == null) {
            return null;
        }
        string = (String)cMSObj.getProperty("FileName");
        if (CMyString.isEmpty(string)) {
            return null;
        }
        string2 = (String)cMSObj.getProperty("FileDesc");
        object = FilesMan.getFilesMan().mapFilePath(string, 0) + string;
        if (!CMyFile.fileExists((String)object)) {
            return null;
        }
        logger.debug((Object)("sImageNamePath: " + (String)object));
        n = publishTagContext.getAttribute("Width", 0);
        string = FileHelper.makeNewZoomInFileName(string, n);
        String string3 = "";
        if (!publishTagContext.getAttribute("UPLOADONLY", false)) {
            String string4 = publishTagContext.getAttribute("Field");
            string3 = string4.equalsIgnoreCase("url") ? XWCMContImgTagParser.makeAppendixURL(publishTagContext, (IPublishContent)publishTagContext.getUpperHost(), string) : (string4.equalsIgnoreCase("name") ? string : (string4.equalsIgnoreCase("desc") ? string2 : this.getHtmlResult(publishTagContext, string)));
        }
        if (!this.isExistFile(publishTagContext, string)) {
            this.distributeImageFile(publishTagContext, publishTagContext.getUpperHost(), string);
        }
        string3 = TagParseHelper.formatTextIfNeeded(publishTagContext, string3);
        return new String[]{string3};
    }

    private String getHtmlResult(PublishTagContext publishTagContext, String string) throws WCMException {
        PublishPathCompass publishPathCompass = new PublishPathCompass();
        String string2 = HtmlUtil.calRelativePath(publishPathCompass.getAbsoluteHttpPath(publishTagContext.getUpperHost()), publishTagContext.getPageHttpPath()) + string;
        String string3 = this.renderImage(string2, publishTagContext.getAttribute("WIDTH"), publishTagContext.getAttribute("HEIGHT"), publishTagContext.getAttribute("EXTRA"));
        if (publishTagContext.getAttribute("AUTOLINK", false)) {
            string3 = XWCMContImgTagParser.addAutoLink(string3, publishTagContext);
        }
        return string3;
    }

    protected CMSObj findObject(PublishTagContext publishTagContext) throws WCMException {
        Map map = publishTagContext.getExtraAttributes();
        if (map == null) {
            return null;
        }
        CMSObj cMSObj = (CMSObj)map.get("IMAGE");
        return cMSObj;
    }

    public static String makeAppendixURL(PublishTagContext publishTagContext, IPublishContent iPublishContent, String string) throws WCMException {
        PublishPathCompass publishPathCompass = publishTagContext.getPathCompass();
        String string2 = publishPathCompass.getAbsoluteHttpPath(iPublishContent);
        boolean bl = publishTagContext.getAttribute("UrlIsAbs", false);
        if (bl) {
            if (publishTagContext.isPreview()) {
                string2 = publishPathCompass.getPreviewHttpPath(iPublishContent);
            }
            return string2 + string;
        }
        return HtmlUtil.calRelativePath(string2, publishTagContext.getPageHttpPath()) + string;
    }

    private DefaultObj findDocumentImage(PublishTagContext publishTagContext, Document document, int n) throws WCMException {
        DefaultObjs defaultObjs = WCMDocumentImagesGenerator.getDocumentImages(publishTagContext, document, n);
        DefaultObj defaultObj = null;
        if (defaultObjs.size() == 0) {
            return defaultObj;
        }
        if (defaultObjs.size() >= n) {
            defaultObj = (DefaultObj)defaultObjs.getAt(n - 1);
        } else if (defaultObjs.size() < n) {
            defaultObj = (DefaultObj)defaultObjs.getAt(0);
        }
        if (defaultObj == null) {
            return null;
        }
        return defaultObj;
    }

    private String renderImage(String string, String string2, String string3, String string4) {
        String string5 = "<IMG src=\"";
        string5 = string5 + string + "\"";
        if (string2 != null) {
            string5 = string5 + " width=\"" + string2 + "\"";
        }
        if (string3 != null) {
            string5 = string5 + " height=\"" + string3 + "\"";
        }
        if (string4 != null) {
            string5 = string5 + " " + string4;
        }
        string5 = string5 + " />";
        return string5;
    }

    private boolean isExistFile(PublishTagContext publishTagContext, String string) throws WCMException {
        PublishPathCompass publishPathCompass = publishTagContext.getPathCompass();
        boolean bl = publishTagContext.isPreview();
        String string2 = null;
        string2 = CMyString.setStrEndWith(publishPathCompass.getLocalPath(publishTagContext.getUpperHost(), bl), File.separatorChar) + string;
        return CMyFile.fileExists(string2);
    }

    private void distributeImageFile(PublishTagContext publishTagContext, IPublishElement iPublishElement, String string) throws WCMException {
        String string2 = string;
        String string3 = FilesMan.getFilesMan().mapFilePath(string2, 0) + string2;
        if (!CMyFile.fileExists(string3)) {
            publishTagContext.addWarning(iPublishElement.getInfo() + "-\u56fe\u7247", iPublishElement.getId(), "\u5728\u78c1\u76d8\u4e0a\u6ca1\u6709\u627e\u5230(" + iPublishElement.getInfo() + ")\u7684\u56fe\u7247[" + string2 + "]");
            return;
        }
        PublishPathCompass publishPathCompass = publishTagContext.getPathCompass();
        boolean bl = publishTagContext.isPreview();
        String string4 = CMyString.setStrEndWith(publishPathCompass.getLocalPath(iPublishElement, bl), File.separatorChar);
        PublishSyncGlobalTuner.insureLocalPathExists(string4);
        try {
            CMyFile.copyFile(string3, string4 + string2);
        }
        catch (CMyException cMyException) {
            cMyException.printStackTrace();
            publishTagContext.addWarning(iPublishElement.getInfo() + "-\u56fe\u7247", iPublishElement.getId(), "\u62f7\u8d1d(" + iPublishElement.getInfo() + ")\u7684\u56fe\u7247[" + string2 + "]\u53d1\u751f\u5f02\u5e38:" + CMyException.getStackTraceText(cMyException));
        }
        if (!bl) {
            publishTagContext.getFileDistributeShip().distributeFile(string3, iPublishElement);
        }
    }

    protected static String addAutoLink(String string, PublishTagContext publishTagContext) throws WCMException {
        String string2 = publishTagContext.getAttribute("TARGET");
        String string3 = "";
        String string4 = publishTagContext.getAttribute("LINKTEXT");
        String string5 = null;
        String string6 = XWCMContImgTagParser.getAutoLinkUrl(publishTagContext);
        if (!publishTagContext.getUpperHost().isLink()) {
            string6 = HtmlUtil.calRelativePath(string6, publishTagContext.getPageHttpPath());
        }
        return HtmlUtil.renderLink(string6, string2, string5, string3, string, string4);
    }

    protected static String getAutoLinkUrl(PublishTagContext publishTagContext) throws WCMException {
        IPublishElement iPublishElement = publishTagContext.getUpperHost();
        if (iPublishElement == null) {
            throw new WCMException("\u6ca1\u6709\u627e\u5230UpperHost\u5bf9\u8c61!");
        }
        if (!(iPublishElement instanceof IPublishContent)) {
            throw new WCMException("\u5f53\u524dUpperHost[" + iPublishElement.getInfo() + "]\u4e0d\u662fIPublishContent\u5bf9\u8c61");
        }
        IPublishContent iPublishContent = (IPublishContent)iPublishElement;
        PublishPathCompass publishPathCompass = publishTagContext.getPathCompass();
        switch (iPublishContent.getBodyType()) {
            case 40: {
                String string = iPublishContent.getFileName();
                return publishPathCompass.getAbsoluteHttpPath(publishTagContext.getUpperHost()) + string;
            }
            case 30: {
                return iPublishContent.getLinkUrl();
            }
        }
        return publishPathCompass.getHttpUrl((IPublishContent)publishTagContext.getUpperHost(), 0);
    }
}

