/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish.tagparser;

import com.trs.DreamFactory;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.ITagParser;
import com.trs.components.common.publish.domain.tagparser.ITagParser4List;
import com.trs.components.common.publish.domain.tagparser.TagBeanAttrInfo;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfo;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.domain.tagparser.TagParseHelper;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishElements;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementsCMSObjsImpl;
import com.trs.components.common.publish.persistent.template.TemplateQuote;
import com.trs.components.wcm.content.domain.DocumentMgr;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.NamesRegister;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class WCMTagParserRelNews
implements ITagParser,
ITagParser4List {
    private static Logger logger = Logger.getLogger(WCMTagParserRelNews.class);
    private static ArrayList FIELDS_DEFAULT_LIST = new ArrayList(16);
    private static HashMap FIELDS_MAP;
    private TagItem m_tagItem = null;
    private IPublishElements m_contents;
    private int m_nCurrPos = 0;
    protected int m_nCurrNumber = 1;
    private PublishTagContext m_nextRecordContext = null;
    private static NamesRegister s_oNameRegister;
    private static TagBeanInfo s_TagBeanInfo;

    public TagBeanInfo getBeanInfo() {
        if (s_TagBeanInfo == null) {
            TagBeanAttrInfo tagBeanAttrInfo = null;
            TagBeanInfo tagBeanInfo = new TagBeanInfo();
            tagBeanInfo.setName("TRS_RELNEWS");
            tagBeanInfo.setDesc("TRS_RELNEWS");
            tagBeanInfo.setType(TagBeanInfo.BodyType.TAMPLATE);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("NUM");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.INTEGER);
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("STARTPOS");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.INTEGER);
            tagBeanAttrInfo.setDefaultValue("0");
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("TARGET");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanAttrInfo.setDefaultValue("_blank");
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("MODE");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanAttrInfo.setEnumValue(new String[]{"USERDEF", "KEYWORDS", "ALL"});
            tagBeanAttrInfo.setDefaultValue("USERDEF");
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("MULTISITE");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanAttrInfo.setEnumValue(new String[]{"true", "false"});
            tagBeanAttrInfo.setDefaultValue("false");
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("CHNLID");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            s_TagBeanInfo = tagBeanInfo;
        }
        return s_TagBeanInfo;
    }

    public void setTagItem(TagItem tagItem) {
        this.m_tagItem = tagItem;
    }

    public void clear() {
        if (this.m_contents != null) {
            this.m_contents.clear();
        }
        if (this.m_nextRecordContext != null) {
            this.m_nextRecordContext = null;
        }
        if (this.m_tagItem != null) {
            this.m_tagItem = null;
        }
    }

    public TemplateQuote[] analyzeQuotes(IPublishFolder iPublishFolder) {
        return null;
    }

    public String[] parse(PublishTagContext publishTagContext) throws WCMException {
        Document document = null;
        IPublishElement iPublishElement = publishTagContext.getUpperHost();
        if (!(iPublishElement instanceof IPublishContent)) {
            throw new WCMException(I18NMessage.get(WCMTagParserRelNews.class, "WCMTagParserRelNews.label1", "TRS_RELNEWS\u53ea\u80fd\u5e94\u7528\u5230\u6587\u6863\u4e0a!\u5f53\u524d\u5bf9\u8c61\u662f[") + iPublishElement.getInfo() + "]");
        }
        try {
            document = (Document)iPublishElement.getSubstance();
        }
        catch (ClassCastException classCastException) {
            throw new WCMException(I18NMessage.get(WCMTagParserRelNews.class, "WCMTagParserRelNews.label2", "TRS_RELNEWS\u53ea\u80fd\u5e94\u7528\u5230\u6587\u6863\u4e0a!\u76f8\u5173\u5bf9\u8c61\u662f\uff1a[") + iPublishElement.getSubstance() + "]", classCastException);
        }
        String string = publishTagContext.getAttribute("MODE");
        if (string == null || (string = string.trim()).length() == 0) {
            string = "USERDEF";
        }
        int n = s_oNameRegister.lookup(string.toUpperCase(), 30);
        boolean bl = publishTagContext.getAttribute("MULTISITE", false);
        String string2 = publishTagContext.getAttribute("CHNLID");
        int n2 = 0;
        if ("SELF".equalsIgnoreCase(string2)) {
            n2 = document.getChannelId();
        } else if (!CMyString.isEmpty(string2)) {
            try {
                n2 = Integer.parseInt(string2);
            }
            catch (Exception exception) {
                n2 = 0;
            }
        }
        DocumentMgr documentMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
        String string3 = this.getSelectFields(publishTagContext);
        WCMFilter wCMFilter = new WCMFilter("", "DocStatus=10 and DocChannel>0", "", string3);
        int n3 = publishTagContext.getAttribute("NUM", 20);
        if (n2 > 0) {
            n3 += 30;
        }
        wCMFilter.setMaxRowNumber(n3);
        Documents documents = documentMgr.getRelatedDocuments(document, n, wCMFilter, true, bl);
        documents.setMaxBufferSize(n3);
        if (n2 != 0) {
            for (int i = documents.size() - 1; i >= 0; --i) {
                Document document2 = (Document)documents.getAt(i);
                if (document2.getChannelId() == n2) continue;
                documents.removeAt(i, false);
            }
        }
        this.m_contents = new PublishElementsCMSObjsImpl(documents);
        if (this.m_contents == null || this.m_contents.isEmpty()) {
            return null;
        }
        this.m_nextRecordContext = new PublishTagContext(publishTagContext, this.m_tagItem, this);
        String[] stringArray = TagParseHelper.parse4List(this.m_tagItem, publishTagContext, this);
        return stringArray;
    }

    public int getRecordSize() {
        return this.m_contents == null ? 0 : this.m_contents.size();
    }

    public void setStartPos(int n) {
        this.m_nCurrPos = n;
    }

    public PublishTagContext getNextRecordContext() throws WCMException {
        if (this.m_nCurrPos >= this.getRecordSize()) {
            return null;
        }
        try {
            IPublishContent iPublishContent = (IPublishContent)this.m_contents.get(this.m_nCurrPos++);
            iPublishContent.setFolder(iPublishContent.getOriginalHome());
            this.m_nextRecordContext.setSequenceNumber(this.m_nCurrNumber++);
            this.m_nextRecordContext.setUpperHost(iPublishContent);
            return this.m_nextRecordContext;
        }
        catch (Exception exception) {
            throw new WCMException(220, "Failed to get the tag context of next record at " + this.m_nCurrPos, exception);
        }
    }

    public PublishTagContext getDelegatedContext() {
        if (this.m_nCurrPos >= this.getRecordSize()) {
            return null;
        }
        this.m_nextRecordContext.setUpperHost(null);
        return this.m_nextRecordContext;
    }

    public PublishTagContext substantiateContext(PublishTagContext publishTagContext) throws WCMException {
        try {
            IPublishContent iPublishContent = (IPublishContent)this.m_contents.get(this.m_nCurrPos++);
            iPublishContent.setFolder(iPublishContent.getOriginalHome());
            publishTagContext.setSequenceNumber(this.m_nCurrNumber++);
            publishTagContext.setUpperHost(iPublishContent);
            return publishTagContext;
        }
        catch (Exception exception) {
            throw new WCMException(220, "Failed to get the tag context of next record at " + this.m_nCurrPos, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSelectFields(PublishTagContext publishTagContext) {
        String string = this.m_tagItem.getExtraAttributeValue("SELECT");
        if (string == null) {
            TagItem tagItem = this.m_tagItem;
            synchronized (tagItem) {
                string = this.m_tagItem.getExtraAttributeValue("SELECT");
                if (string == null) {
                    string = this.makeSelectFields(publishTagContext);
                    this.m_tagItem.setExtraAttribute("SELECT", string);
                }
            }
        }
        return string;
    }

    private String makeSelectFields(PublishTagContext publishTagContext) {
        String string = (String)FIELDS_DEFAULT_LIST.get(0);
        int n = FIELDS_DEFAULT_LIST.size();
        for (int i = 1; i < n; ++i) {
            string = string + ",WCMDocument." + FIELDS_DEFAULT_LIST.get(i);
        }
        ArrayList arrayList = TagParseHelper.makeSelectFields(this.m_tagItem, "TRS_DOCUMENT");
        DBManager dBManager = DBManager.getDBManager();
        int n2 = arrayList.size();
        for (int i = 0; i < n2; ++i) {
            String string2 = (String)arrayList.get(i);
            if (FIELDS_DEFAULT_LIST.indexOf(string2) >= 0) continue;
            String string3 = (String)FIELDS_MAP.get(string2);
            if (string3 != null) {
                string2 = string3;
            }
            try {
                if (dBManager.getFieldInfo("WCMDOCUMENT", string2) == null) {
                    publishTagContext.addWarning(I18NMessage.get(WCMTagParserRelNews.class, "WCMTagParserRelNews.label3", "TRS_DOCUMENT\u7f6e\u6807\u6307\u5b9a\u7684Field[") + string2 + I18NMessage.get(WCMTagParserRelNews.class, "WCMTagParserRelNews.label4", "]\u5728WCMDocument\u8868\u4e2d\u4e0d\u5b58\u5728\uff01"));
                    continue;
                }
            }
            catch (WCMException wCMException) {
                wCMException.printStackTrace();
                try {
                    publishTagContext.addWarning(I18NMessage.get(WCMTagParserRelNews.class, "WCMTagParserRelNews.label5", "\u83b7\u53d6\u6307\u5b9a\u7684Field[") + string2 + I18NMessage.get(WCMTagParserRelNews.class, "WCMTagParserRelNews.label6", "]\u4eceWCMDocument\u8868\u4e2d\u53d1\u751f\u5f02\u5e38\uff01") + CMyException.getStackTraceText(wCMException));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            string = string + ",WCMDocument." + string2;
        }
        return string;
    }

    static {
        FIELDS_DEFAULT_LIST.add("DOCID");
        FIELDS_DEFAULT_LIST.add("DOCCHANNEL");
        FIELDS_DEFAULT_LIST.add("DOCSTATUS");
        FIELDS_DEFAULT_LIST.add("DOCTYPE");
        FIELDS_DEFAULT_LIST.add("DOCTITLE");
        FIELDS_DEFAULT_LIST.add("CRUSER");
        FIELDS_DEFAULT_LIST.add("CRTIME");
        FIELDS_DEFAULT_LIST.add("DocFlag");
        FIELDS_DEFAULT_LIST.add("TITLECOLOR");
        FIELDS_DEFAULT_LIST.add("DOCLINK");
        FIELDS_DEFAULT_LIST.add("DOCFILENAME");
        FIELDS_DEFAULT_LIST.add("DOCVERSION");
        FIELDS_DEFAULT_LIST.add("DOCRELTIME");
        FIELDS_DEFAULT_LIST.add("DOCPUBTIME");
        FIELDS_MAP = new HashMap(3);
        FIELDS_MAP.put("DOCFROM", "DOCSOURCE");
        FIELDS_MAP.put("DOCHTMLCON", "DOCPUBHTMLCON");
        FIELDS_MAP.put("DOCHTMLCONTENT", "DOCPUBHTMLCON");
        s_oNameRegister = new NamesRegister();
        s_oNameRegister.register("USERDEF", 30);
        s_oNameRegister.register("RELWORDS", 20);
        s_oNameRegister.register("KEYWORDS", 10);
        s_oNameRegister.register("ALL", 0);
        s_TagBeanInfo = null;
    }
}

