/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish.tagparser;

import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.domain.publisher.PublishPathCompass;
import com.trs.components.common.publish.domain.publisher.PublishSyncGlobalTuner;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.TagBeanAttrInfo;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfo;
import com.trs.components.common.publish.domain.tagparser.TagParseHelper;
import com.trs.components.common.publish.domain.tagparser.TagParserContentBase;
import com.trs.components.common.publish.parser.HTMLContentParseHelper;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.resource.Security;
import com.trs.components.wcm.resource.Source;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.html.HtmlUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class WCMTagParserDocument
extends TagParserContentBase {
    private static Logger s_logger = Logger.getLogger(WCMTagParserDocument.class);
    private static final int TITLE = 1;
    private static final int HTMLCONTENT = 2;
    private static final int PUBTIME = 3;
    private static final int SOURCE = 4;
    private static final int SECURITY = 5;
    private static final int DOCPUBHTMLCON = 6;
    private static final int CONTENT = 7;
    private static final int HOMENAME = 8;
    private static final int TRUEUSER = 9;
    private static final int DOCPEOPLE = 10;
    private static final int CRUSER = 11;
    private static final int HOME_SITE = 12;
    private static final int HOME_SITENAME = 13;
    private static final int DOCABSTRACT = 14;
    private static final int ENTITYURL = 15;
    private static final int DOC_FIRST_PUBTIME = 16;
    private static TagBeanInfo s_TagBeanInfo = null;

    public TagBeanInfo getBeanInfo() {
        if (s_TagBeanInfo == null) {
            TagBeanAttrInfo tagBeanAttrInfo = null;
            TagBeanInfo tagBeanInfo = new TagBeanInfo();
            tagBeanInfo.setName("TRS_DOCUMENT");
            tagBeanInfo.setDesc("TRS_DOCUMENT");
            tagBeanInfo.setType(TagBeanInfo.BodyType.IGNORE);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("FIELD");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanAttrInfo.setDefaultValue("DOCTITLE");
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("NUM");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.INTEGER);
            tagBeanAttrInfo.setDefaultValue("0");
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("DATEFORMAT");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanAttrInfo.setDefaultValue("yyyy-MM-dd HH:mm:ss");
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("AUTOFORMAT");
            tagBeanAttrInfo.setEnumValue(new String[]{"true", "false"});
            tagBeanAttrInfo.setDefaultValue("false");
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("AUTOFORMATTYPE");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanAttrInfo.setEnumValue(new String[]{"HTML", "HTMLValue", "JAVASCRIPT", "XML", "INNERTEXT"});
            tagBeanAttrInfo.setDefaultValue("HTML");
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("AUTOCOLOR");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanAttrInfo.setEnumValue(new String[]{"true", "false"});
            tagBeanAttrInfo.setDefaultValue("true");
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("AUTOLINK");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanAttrInfo.setEnumValue(new String[]{"true", "false"});
            tagBeanAttrInfo.setDefaultValue("false");
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("TARGET");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanAttrInfo.setDefaultValue("_self");
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("EXTRA");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("LINKALT");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanAttrInfo.setEnumValue(new String[]{"true", "false"});
            tagBeanAttrInfo.setDefaultValue("false");
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("LINKALTTEXT");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("LINKTEXT");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("TRUNCATEDFLAG");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanAttrInfo.setDefaultValue("...");
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("VALUE");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("CLASSNAME");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("NICKCRUSER");
            tagBeanAttrInfo.setDesc(I18NMessage.get(WCMTagParserDocument.class, "WCMTagParserDocument.label1", "\u521b\u5efa\u8005\u7684\u6635\u79f0"));
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("CRUSERID");
            tagBeanAttrInfo.setDesc("\u521b\u5efa\u8005\u7684ID");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("CODEFILTERED");
            tagBeanAttrInfo.setDesc(I18NMessage.get(WCMTagParserDocument.class, "WCMTagParserDocument.label2", "\u8fc7\u6ee4\u6807\u9898\u4e2d\u7684html\u4ee3\u7801"));
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanAttrInfo.setDefaultValue("false");
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("WML");
            tagBeanAttrInfo.setDesc("WML");
            tagBeanAttrInfo.setDefaultValue("false");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("PAGENUM");
            tagBeanAttrInfo.setDesc("PAGENUM");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.INTEGER);
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("EXT");
            tagBeanAttrInfo.setDesc("EXT");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("FILTEREDITORCSS");
            tagBeanAttrInfo.setDesc("FILTEREDITORCSS");
            tagBeanAttrInfo.setDefaultValue("false");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("pdfurlonly");
            tagBeanAttrInfo.setDesc("\u6587\u5e93\u6a21\u5f0f\u4e0b\u53ea\u53d6\u6e90\u6587\u4ef6");
            tagBeanAttrInfo.setDefaultValue("false");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            s_TagBeanInfo = tagBeanInfo;
        }
        return s_TagBeanInfo;
    }

    protected void registerHostSpecialProperties() {
        this.registerHostSpecialProperty("DOCCONTENT", 7);
        this.registerHostSpecialProperty("DOCTITLE", 1);
        this.registerHostSpecialProperty("DOCHTMLCON", 2);
        this.registerHostSpecialProperty("DOCHTMLCONTENT", 2);
        this.registerHostSpecialProperty("DOCPUBHTMLCON", 6);
        this.registerHostSpecialProperty("DOCPUBTIME", 3);
        this.registerHostSpecialProperty("DOCSOURCE", 4);
        this.registerHostSpecialProperty("DOCFROM", 4);
        this.registerHostSpecialProperty("DOCSECURITY", 5);
        this.registerHostSpecialProperty("HOMENAME", 8);
        this.registerHostSpecialProperty("TRUEUSER", 9);
        this.registerHostSpecialProperty("DOCPEOPLE", 10);
        this.registerHostSpecialProperty("CRUSER", 11);
        this.registerHostSpecialProperty("NICKCRUSER", 11);
        this.registerHostSpecialProperty("HOMESITE", 12);
        this.registerHostSpecialProperty("HOMESITENAME", 13);
        this.registerHostSpecialProperty("DOCABSTRACT", 14);
        this.registerHostSpecialProperty("ENTITYURL", 15);
        this.registerHostSpecialProperty("DOCFIRSTPUBTIME", 16);
    }

    protected String[] parseHostSpecialProperty(int n, PublishTagContext publishTagContext) throws WCMException {
        String[] stringArray = null;
        try {
            if (!(this.m_host instanceof Document)) {
                StringBuffer stringBuffer = new StringBuffer(256);
                stringBuffer.append(this.m_tagItem.getDescWithPos()).append(I18NMessage.get(WCMTagParserDocument.class, "WCMTagParserDocument.label3", "\u7f6e\u6807\u4f7f\u7528\u7684\u573a\u666f\u4e0d\u5bf9,"));
                stringBuffer.append(I18NMessage.get(WCMTagParserDocument.class, "WCMTagParserDocument.label4", "\u53ef\u80fd\u76f4\u63a5\u7528\u5728\u4e86\u6982\u89c8\u9875\u9762\u4e2d\u6216\u8005\u5176\u5b83\u975eTRS_DOCUMENTS\u6982\u89c8\u7f6e\u6807\u4e2d\uff01[tag-host="));
                stringBuffer.append(this.m_host).append(']');
                publishTagContext.addWarning(stringBuffer.toString());
                return null;
            }
            Document document = (Document)this.m_host;
            switch (n) {
                case 1: {
                    stringArray = this.parseTitle(document, publishTagContext);
                    break;
                }
                case 2: {
                    stringArray = this.parseHtmlContent(document, publishTagContext);
                    if (!publishTagContext.getAttribute("FILTEREDITORCSS", false)) break;
                    for (int i = 0; i < stringArray.length; ++i) {
                        stringArray[i] = stringArray[i].replaceAll("<style.+?id=(['\"]?)_Custom_V6_Style_\\1[^>]*>[\\d\\D]*?</style>", "");
                    }
                    break;
                }
                case 3: {
                    stringArray = this.parsePublishedTime(document, publishTagContext);
                    break;
                }
                case 4: {
                    stringArray = this.parseSource(document, publishTagContext);
                    break;
                }
                case 5: {
                    Security security = document.getSecurity();
                    if (security == null) break;
                    stringArray = new String[]{security.getName()};
                    break;
                }
                case 6: {
                    stringArray = document.getType() == 20 ? this.parseHtmlContent(document, publishTagContext) : this.parseHostNormalProperty("DOCPUBHTMLCON", publishTagContext);
                    if (!publishTagContext.getAttribute("FILTEREDITORCSS", false)) break;
                    for (int i = 0; i < stringArray.length; ++i) {
                        stringArray[i] = stringArray[i].replaceAll("<style.+?id=(['\"]?)_Custom_V6_Style_\\1[^>]*>[\\d\\D]*?</style>", "");
                    }
                    break;
                }
                case 7: {
                    stringArray = this.parseContent(document, publishTagContext);
                    break;
                }
                case 8: {
                    stringArray = this.parseHomeName(document, publishTagContext);
                    break;
                }
                case 9: {
                    stringArray = this.parseTrueUserName(document);
                    break;
                }
                case 10: {
                    stringArray = this.parseDocPeopleTitle(document, publishTagContext);
                    break;
                }
                case 11: {
                    stringArray = this.parseCrUser(document, publishTagContext);
                    break;
                }
                case 12: 
                case 13: {
                    stringArray = this.parseHomeSite(document, publishTagContext, n);
                    break;
                }
                case 14: {
                    stringArray = this.parseDocAbstract(document, publishTagContext);
                    break;
                }
                case 15: {
                    stringArray = this.parseDocEntityUrl(document, publishTagContext);
                    break;
                }
                case 16: {
                    stringArray = this.parseFirtPubTime(document, publishTagContext);
                    break;
                }
                default: {
                    throw new Exception(I18NMessage.get(WCMTagParserDocument.class, "WCMTagParserDocument.label5", "\u6307\u5b9a\u7684\u5c5e\u6027") + publishTagContext.getAttribute("FIELD") + I18NMessage.get(WCMTagParserDocument.class, "WCMTagParserDocument.label6", "\u6ca1\u6709\u6ce8\u518c!"));
                }
            }
            if (stringArray == null) {
                return null;
            }
            return TagParseHelper.addSpanStyleIfNeeded(publishTagContext, stringArray);
        }
        catch (Exception exception) {
            throw new WCMException(1100, I18NMessage.get(WCMTagParserDocument.class, "WCMTagParserDocument.label7", "\u89e3\u6790") + this.m_host + I18NMessage.get(WCMTagParserDocument.class, "WCMTagParserDocument.label8", "\u7684[") + publishTagContext.getAttribute("FIELD") + I18NMessage.get(WCMTagParserDocument.class, "WCMTagParserDocument.label9", "]\u5c5e\u6027\u53d1\u751f\u5f02\u5e38\uff01"), exception);
        }
    }

    private String[] parseFirtPubTime(Document document, PublishTagContext publishTagContext) {
        CMyDateTime cMyDateTime = document.getPropertyAsDateTime("DOCPUBTIME");
        if (cMyDateTime == null || cMyDateTime.isNull()) {
            cMyDateTime = CMyDateTime.now();
        }
        try {
            return this.parseProperty(cMyDateTime, publishTagContext);
        }
        catch (WCMException wCMException) {
            return null;
        }
    }

    private String[] parseDocAbstract(Document document, PublishTagContext publishTagContext) throws WCMException {
        String string = document.getAbstract();
        if (CMyString.isEmpty(string)) {
            return new String[]{""};
        }
        int n = publishTagContext.getAttribute("NUM", 0);
        if (n > 0) {
            string = CMyString.innerText(string);
        }
        return this.parseProperty(string, publishTagContext);
    }

    private String[] parseDocEntityUrl(Document document, PublishTagContext publishTagContext) throws WCMException {
        IPublishElement iPublishElement = PublishElementFactory.lookupElement(605, document.getId());
        PublishPathCompass publishPathCompass = new PublishPathCompass();
        String string = "";
        string = publishTagContext.isPreview() ? publishPathCompass.getPreviewHttpUrl((IPublishContent)iPublishElement, 0) : publishPathCompass.getHttpUrl((IPublishContent)iPublishElement, 0);
        return new String[]{string};
    }

    private String[] parseCrUser(Document document, PublishTagContext publishTagContext) {
        User user = document.getCrUser();
        if (user == null) {
            return null;
        }
        String string = null;
        if (publishTagContext.getAttribute("NICKCRUSER", true)) {
            string = user.getNickName();
        }
        if (publishTagContext.getAttribute("CRUSERID", false)) {
            string = String.valueOf(user.getId());
        }
        if (string == null) {
            string = user.getName();
        }
        return new String[]{string};
    }

    private String[] parseDocPeopleTitle(Document document, PublishTagContext publishTagContext) throws WCMException {
        String string = document.getPeople();
        if (CMyString.isEmpty(string)) {
            string = document.getTitle();
        }
        try {
            String string2;
            if (publishTagContext.getAttribute("CODEFILTERED", false)) {
                string = string.replaceAll("<{1}[^>]{1,}>{1}", "");
            }
            String string3 = TagParseHelper.truncateTextIfNeeded(publishTagContext, string);
            string3 = TagParseHelper.formatTextIfNeeded(publishTagContext, string3);
            if (publishTagContext.getAttribute("AUTOCOLOR", true) && (string2 = document.getTitleColor()) != null && (string2 = string2.trim()).length() > 0 && !string2.equalsIgnoreCase("null")) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("<font color=\"").append(string2).append("\">");
                stringBuffer.append(string3);
                stringBuffer.append("</font>");
                string3 = stringBuffer.toString();
                stringBuffer.setLength(0);
            }
            if (publishTagContext.getAttribute("AUTOLINK", true) && !publishTagContext.getPageElement().getSubstance().equals(document)) {
                string3 = this.addAutoLink(string3, string, publishTagContext);
            }
            return new String[]{string3};
        }
        catch (Exception exception) {
            throw new WCMException(1100, I18NMessage.get(WCMTagParserDocument.class, "WCMTagParserDocument.label10", "\u89e3\u6790 ") + this.m_host + I18NMessage.get(WCMTagParserDocument.class, "WCMTagParserDocument.label11", " \u7684\u6807\u9898\u5931\u8d25!"), exception);
        }
    }

    protected String getDefaultField() {
        return "DOCTITLE";
    }

    private String[] parseTitle(Document document, PublishTagContext publishTagContext) throws WCMException {
        String string = document.getTitle();
        try {
            String string2;
            int n;
            if (publishTagContext.getAttribute("CODEFILTERED", false)) {
                string = string.replaceAll("<{1}[^>]{1,}>{1}", "");
            }
            if ((n = publishTagContext.getAttribute("NUM", 0)) > 0) {
                string = CMyString.innerText(string);
            }
            String string3 = TagParseHelper.truncateTextIfNeeded(publishTagContext, string);
            string3 = TagParseHelper.formatTextIfNeeded(publishTagContext, string3);
            if (publishTagContext.getAttribute("AUTOCOLOR", true) && (string2 = document.getTitleColor()) != null && (string2 = string2.trim()).length() > 0) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("<font color=\"").append(string2).append("\">");
                stringBuffer.append(string3);
                stringBuffer.append("</font>");
                string3 = stringBuffer.toString();
                stringBuffer.setLength(0);
            }
            if (publishTagContext.getAttribute("AUTOLINK", true) && !publishTagContext.getPageElement().getSubstance().equals(document)) {
                string3 = this.addAutoLink(string3, string, publishTagContext);
            }
            return new String[]{string3};
        }
        catch (Exception exception) {
            throw new WCMException(1100, I18NMessage.get(WCMTagParserDocument.class, "WCMTagParserDocument.label10", "\u89e3\u6790 ") + this.m_host + I18NMessage.get(WCMTagParserDocument.class, "WCMTagParserDocument.label11", " \u7684\u6807\u9898\u5931\u8d25!"), exception);
        }
    }

    private String[] parseContent(Document document, PublishTagContext publishTagContext) throws WCMException {
        String[] stringArray;
        block11: {
            String string;
            boolean bl;
            String string2;
            block9: {
                String[] stringArray2;
                block10: {
                    if (document.getChannel().getType() == 13) {
                        return null;
                    }
                    string2 = document.getContent();
                    if (publishTagContext.getAttribute("CODEFILTERED", false)) {
                        string2 = string2.replaceAll("<{1}[^>]{1,}>{1}", "");
                    }
                    bl = false;
                    if (this.m_tagItem.getAttribute("AUTOFORMAT") == null) {
                        this.m_tagItem.setAttribute("AUTOFORMAT", true);
                        bl = true;
                    }
                    string = TagParseHelper.truncateTextIfNeeded(publishTagContext, string2);
                    if (!publishTagContext.getAttribute("WML", false) || (stringArray = this.makeWMLContent(publishTagContext, string)) == null) break block9;
                    stringArray2 = stringArray;
                    Object var9_9 = null;
                    if (!bl) break block10;
                    this.m_tagItem.setAttribute("AUTOFORMAT", null);
                }
                return stringArray2;
            }
            try {
                string = TagParseHelper.formatTextIfNeeded(publishTagContext, string);
                if (publishTagContext.getAttribute("AUTOLINK", false) && !publishTagContext.getPageElement().getSubstance().equals(document)) {
                    string = this.addAutoLink(string, string2, publishTagContext);
                }
                stringArray = new String[]{string};
                Object var9_10 = null;
                if (!bl) break block11;
            }
            catch (Exception exception) {
                try {
                    throw new WCMException(1100, I18NMessage.get(WCMTagParserDocument.class, "WCMTagParserDocument.label10", "\u89e3\u6790 ") + this.m_host + I18NMessage.get(WCMTagParserDocument.class, "WCMTagParserDocument.label12", " \u7684\u6b63\u6587\u5931\u8d25!"), exception);
                }
                catch (Throwable throwable) {
                    block12: {
                        Object var9_11 = null;
                        if (!bl) break block12;
                        this.m_tagItem.setAttribute("AUTOFORMAT", null);
                    }
                    throw throwable;
                }
            }
            this.m_tagItem.setAttribute("AUTOFORMAT", null);
        }
        return stringArray;
    }

    private String[] makeWMLContent(PublishTagContext publishTagContext, String string) throws WCMException {
        return this.makeWmlContent0(publishTagContext, string);
    }

    private String[] makeWmlContent0(PublishTagContext publishTagContext, String string) throws WCMException {
        int n = publishTagContext.getAttribute("PAGENUM", 900);
        if (n <= 0) {
            return null;
        }
        String string2 = PublishPathCompass.makeDetailPageFileName((IPublishContent)publishTagContext.getPageElement());
        String string3 = publishTagContext.getPageContext().getTemplate().getOutputFileExt();
        ArrayList<String> arrayList = new ArrayList<String>(5);
        StringBuffer stringBuffer = new StringBuffer(1024);
        int n2 = 1;
        int n3 = 3;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        String string4 = null;
        for (char c : string.toCharArray()) {
            int n7 = n4 = c <= '\u007f' ? n2 : n3;
            if ((n6 += n4) > n) {
                string4 = TagParseHelper.formatTextIfNeeded(publishTagContext, stringBuffer.toString());
                stringBuffer.setLength(0);
                stringBuffer.append(string4);
                stringBuffer.append("<br />");
                stringBuffer.append(WCMTagParserDocument.makeCurrNavContent(string2, string3, n5, true));
                arrayList.add(stringBuffer.toString());
                stringBuffer.setLength(0);
                ++n5;
                n6 = n4;
            }
            stringBuffer.append(c);
        }
        int n8 = 0;
        try {
            string4 = publishTagContext.getPageContext().getExtraAttribute("PAGVAR_WMLIMGCOUNT");
            n8 = Integer.parseInt(string4) - 1;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (stringBuffer.length() > 0) {
            string4 = TagParseHelper.formatTextIfNeeded(publishTagContext, stringBuffer.toString());
            stringBuffer.setLength(0);
            stringBuffer.append(string4);
            if (n5 > 0 || n8 > n5) {
                stringBuffer.append("<br />");
                stringBuffer.append(WCMTagParserDocument.makeCurrNavContent(string2, string3, n5, n8 > n5));
            }
            arrayList.add(stringBuffer.toString());
            stringBuffer.setLength(0);
        }
        stringBuffer.setLength(0);
        n8 -= n5;
        while (--n8 >= 0) {
            stringBuffer.append("<br />");
            stringBuffer.append(WCMTagParserDocument.makeCurrNavContent(string2, string3, ++n5, n8 > 0));
            arrayList.add(stringBuffer.toString());
            stringBuffer.setLength(0);
        }
        String[] stringArray = new String[arrayList.size()];
        stringArray = arrayList.toArray(stringArray);
        return stringArray;
    }

    private static String makeCurrNavContent(String string, String string2, int n, boolean bl) {
        String string3;
        StringBuffer stringBuffer = new StringBuffer();
        if (n > 0) {
            string3 = null;
            string3 = n == 1 ? string + "." + string2 : string + "_" + (n - 1) + "." + string2;
            stringBuffer.append("<a href=\"" + string3 + I18NMessage.get(WCMTagParserDocument.class, "WCMTagParserDocument.label13", "\">&lt;&lt;\u4e0a\u4e00\u9875</a>"));
            stringBuffer.append("&nbsp;&nbsp;");
        }
        if (bl) {
            string3 = string + "_" + (n + 1) + "." + string2;
            stringBuffer.append("<a href=\"" + string3 + I18NMessage.get(WCMTagParserDocument.class, "WCMTagParserDocument.label14", "\">\u4e0b\u4e00\u9875&gt;&gt;</a>"));
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] parseHtmlContent(Document document, PublishTagContext publishTagContext) throws WCMException {
        if (document.getChannel().getType() == 13) {
            return null;
        }
        if (document.getType() != 20) {
            String[] stringArray;
            block13: {
                boolean bl;
                block11: {
                    String[] stringArray2;
                    block12: {
                        bl = false;
                        try {
                            if (this.m_tagItem.getAttribute("AUTOFORMAT") == null) {
                                this.m_tagItem.setAttribute("AUTOFORMAT", true);
                                bl = true;
                            }
                            if (document.getType() == 40) break block11;
                            stringArray2 = this.parseHostNormalProperty("DOCPUBHTMLCON", publishTagContext);
                            Object var6_8 = null;
                            if (!bl) break block12;
                        }
                        catch (Throwable throwable) {
                            Object var6_10 = null;
                            if (bl) {
                                this.m_tagItem.setAttribute("AUTOFORMAT", null);
                            }
                            throw throwable;
                        }
                        this.m_tagItem.setAttribute("AUTOFORMAT", null);
                    }
                    return stringArray2;
                }
                stringArray = new String[]{this.makeSWFViewHTML(document, publishTagContext)};
                Object var6_9 = null;
                if (!bl) break block13;
                this.m_tagItem.setAttribute("AUTOFORMAT", null);
            }
            return stringArray;
        }
        String string = null;
        try {
            string = new HTMLContentParseHelper().makeHTMLContentParsed(publishTagContext, document.getPubHtmlContent());
            string = string.replaceAll("(?is)<TRS_COMMENT.*?>.*?</TRS_COMMENT>", "");
            if (string == null || string.length() == 0) {
                string = document.getContent();
            }
            string = TagParseHelper.formatTextIfNeeded(publishTagContext, string);
            if (publishTagContext.getPageElement() instanceof IPublishContent) {
                return TagParseHelper.separatePages(string);
            }
            return new String[]{string};
        }
        catch (Exception exception) {
            throw new WCMException(1100, I18NMessage.get(WCMTagParserDocument.class, "WCMTagParserDocument.label10", "\u89e3\u6790 ") + this.m_host + I18NMessage.get(WCMTagParserDocument.class, "WCMTagParserDocument.label12", " \u7684\u6b63\u6587\u5931\u8d25!"), exception);
        }
    }

    private String makeSWFViewHTML(Document document, PublishTagContext publishTagContext) {
        String string = document.getPropertyAsString("DOCFILENAME");
        int n = string.lastIndexOf(46);
        String string2 = CMyFile.excludeFileExt(string);
        if (!string2.equals("swf") && n > 0) {
            String string3 = string.substring(0, n + 1) + "swf";
            try {
                String string4 = FilesMan.getFilesMan().mapFilePath(string3, 0) + string3;
                if (!CMyFile.fileExists(string4)) {
                    return "";
                }
                this.distributionDocFile(document, publishTagContext, string3);
                this.distributionDocFile(document, publishTagContext, string);
                if (publishTagContext.getAttribute("pdfurlonly", false)) {
                    String string5 = publishTagContext.getPathCompass().getAbsoluteHttpPath(publishTagContext.getUpperHost());
                    string5 = string5 + string;
                    if (!publishTagContext.getAttribute("UrlIsAbs", false)) {
                        string5 = HtmlUtil.calRelativePath(string5, publishTagContext.getPageHttpPath());
                    }
                    return string5;
                }
                String string6 = CMyFile.readFile(CMyFile.mapResouceFullPath("swf_view.html"), "UTF-8");
                string6 = CMyString.replaceStr(string6, "SWF_FILENAME", string3);
                return string6;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "";
    }

    private void distributionDocFile(Document document, PublishTagContext publishTagContext, String string) {
        try {
            boolean bl = publishTagContext.isPreview();
            PublishPathCompass publishPathCompass = publishTagContext.getPathCompass();
            IPublishContent iPublishContent = (IPublishContent)publishTagContext.getUpperHost();
            String string2 = FilesMan.getFilesMan().mapFilePath(string, 0) + string;
            if (!CMyFile.fileExists(string2)) {
                return;
            }
            String string3 = publishPathCompass.getLocalPath(iPublishContent, bl);
            PublishSyncGlobalTuner.insureLocalPathExists(string3);
            CMyFile.copyFile(string2, string3 + string);
            if (!bl) {
                publishTagContext.getFileDistributeShip().distributeFile(string2, iPublishContent, null, true);
            }
        }
        catch (Exception exception) {
            s_logger.error((Object)(I18NMessage.get(WCMTagParserDocument.class, "WCMTagParserDocument.label15", "\u53d1\u5e03") + document + I18NMessage.get(WCMTagParserDocument.class, "WCMTagParserDocument.label16", "\u7684\u5916\u90e8\u5931\u8d25\uff01")), (Throwable)exception);
        }
    }

    private String[] parsePublishedTime(Document document, PublishTagContext publishTagContext) throws WCMException {
        IPublishFolder iPublishFolder = publishTagContext.getUpperFolder();
        if (iPublishFolder == null || iPublishFolder.getType() != 101) {
            throw new WCMException(10, "Parameter of channel folder required!");
        }
        try {
            CMyDateTime cMyDateTime = document.getPropertyAsDateTime("DOCPUBTIME");
            if ((cMyDateTime == null || cMyDateTime.isNull()) && ((cMyDateTime = this.loadPublishedTimeFromDB(document, iPublishFolder)) == null || cMyDateTime.isNull())) {
                cMyDateTime = CMyDateTime.now();
            }
            return this.parseProperty(cMyDateTime, publishTagContext);
        }
        catch (Exception exception) {
            throw new WCMException(1100, I18NMessage.get(WCMTagParserDocument.class, "WCMTagParserDocument.label10", "\u89e3\u6790 ") + this.m_host + I18NMessage.get(WCMTagParserDocument.class, "WCMTagParserDocument.label17", " \u7684\u53d1\u5e03\u65f6\u95f4\u5931\u8d25!"), exception);
        }
    }

    /*
     * Loose catch block
     */
    private CMyDateTime loadPublishedTimeFromDB(Document document, IPublishFolder iPublishFolder) throws WCMException {
        Exception exception322;
        CMyDateTime cMyDateTime;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        Connection connection;
        DBManager dBManager;
        block22: {
            block19: {
                Exception exception2222;
                CMyDateTime cMyDateTime2;
                block20: {
                    dBManager = null;
                    connection = null;
                    preparedStatement = null;
                    resultSet = null;
                    dBManager = DBManager.getDBManager();
                    connection = dBManager.getConnection();
                    preparedStatement = connection.prepareStatement("SELECT DOCPUBTIME FROM WCMCHNLDOC WHERE DOCID=? AND CHNLID=?");
                    preparedStatement.setInt(1, document.getId());
                    preparedStatement.setInt(2, iPublishFolder.getId());
                    preparedStatement.setMaxRows(1);
                    resultSet = preparedStatement.executeQuery();
                    if (resultSet != null && resultSet.next()) break block19;
                    cMyDateTime2 = null;
                    Object var11_10 = null;
                    if (resultSet == null) break block20;
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception2222) {
                        // empty catch block
                    }
                }
                if (preparedStatement != null) {
                    try {
                        preparedStatement.close();
                    }
                    catch (Exception exception2222) {
                        // empty catch block
                    }
                }
                if (connection != null && dBManager != null) {
                    dBManager.freeConnection(connection);
                }
                return cMyDateTime2;
            }
            CMyDateTime cMyDateTime3 = new CMyDateTime();
            cMyDateTime3.setDateTimeWithRs(resultSet, 1);
            cMyDateTime = cMyDateTime3;
            Object var11_11 = null;
            if (resultSet == null) break block22;
            try {
                resultSet.close();
            }
            catch (Exception exception322) {
                // empty catch block
            }
        }
        if (preparedStatement != null) {
            try {
                preparedStatement.close();
            }
            catch (Exception exception322) {
                // empty catch block
            }
        }
        if (connection != null && dBManager != null) {
            dBManager.freeConnection(connection);
        }
        return cMyDateTime;
        catch (Exception exception4) {
            try {
                throw new WCMException(1100, "Failed to load the doucment published time from database!", exception4);
            }
            catch (Throwable throwable) {
                block24: {
                    Exception exception5222;
                    Object var11_12 = null;
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Exception exception5222) {
                            // empty catch block
                        }
                    }
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Exception exception5222) {
                            // empty catch block
                        }
                    }
                    if (connection == null || dBManager == null) break block24;
                    dBManager.freeConnection(connection);
                }
                throw throwable;
            }
        }
    }

    private String[] parseSource(Document document, PublishTagContext publishTagContext) throws WCMException {
        Source source = null;
        try {
            String string;
            source = document.getSource();
            if (source == null) {
                String string2 = document.getPropertyAsString("DOCSOURCENAME");
                if (!CMyString.isEmpty(string2)) {
                    string2 = TagParseHelper.truncateTextIfNeeded(publishTagContext, string2);
                    return new String[]{string2};
                }
                int n = document.getSourceId();
                if (n > 0) {
                    return new String[]{"SRC-" + n};
                }
                return null;
            }
            String string3 = source.getName();
            String string4 = TagParseHelper.truncateTextIfNeeded(publishTagContext, string3);
            if (publishTagContext.getAttribute("AUTOLINK", false) && (string = source.getLink()) != null && (string = string.trim()).length() > 0) {
                String string5 = publishTagContext.getAttribute("TARGET");
                String string6 = publishTagContext.getAttribute("EXTRA");
                string4 = HtmlUtil.renderLink(string, string5, string3, string6, string4, publishTagContext.getAttribute("LINKTEXT"));
            }
            return new String[]{string4};
        }
        catch (Exception exception) {
            throw new WCMException(1100, "Failed to parse the document source!", exception);
        }
    }

    private String[] parseHomeName(Document document, PublishTagContext publishTagContext) throws WCMException {
        Channel channel = document.getChannel();
        if (channel == null) {
            throw new WCMException(I18NMessage.get(WCMTagParserDocument.class, "WCMTagParserDocument.label18", "\u83b7\u53d6 ") + document + I18NMessage.get(WCMTagParserDocument.class, "WCMTagParserDocument.label19", " \u7684\u6240\u5c5e\u9891\u9053\u5931\u8d25!"));
        }
        String string = (String)channel.getProperty("CHNLDESC");
        try {
            String string2 = TagParseHelper.truncateTextIfNeeded(publishTagContext, string);
            string2 = TagParseHelper.formatTextIfNeeded(publishTagContext, string2);
            if (publishTagContext.getAttribute("AUTOLINK", true)) {
                String string3 = null;
                IPublishFolder iPublishFolder = (IPublishFolder)PublishElementFactory.makeElementFrom(channel);
                if (iPublishFolder.isLink()) {
                    string3 = iPublishFolder.getLinkUrl();
                } else {
                    string3 = publishTagContext.getPathCompass().getAbsoluteHttpPath(iPublishFolder);
                    if (!publishTagContext.getAttribute("URLISABS", false)) {
                        string3 = HtmlUtil.calRelativePath(string3, publishTagContext.getPageHttpPath());
                    }
                }
                string2 = TagParseHelper.addAutoLink(string3, string2, string, publishTagContext);
            }
            return new String[]{string2};
        }
        catch (Exception exception) {
            throw new WCMException(I18NMessage.get(WCMTagParserDocument.class, "WCMTagParserDocument.label10", "\u89e3\u6790 ") + document + I18NMessage.get(WCMTagParserDocument.class, "WCMTagParserDocument.label20", " \u7684\u6240\u5c5e\u9891\u9053\u540d\u79f0\u5931\u8d25!"), exception);
        }
    }

    private String[] parseTrueUserName(Document document) throws WCMException {
        String string = null;
        try {
            User user = document.getCrUser();
            if (user != null) {
                string = user.getTrueName();
            }
            if (CMyString.isEmpty(string)) {
                string = document.getCrUserName();
            }
            return new String[]{string};
        }
        catch (Exception exception) {
            throw new WCMException(I18NMessage.get(WCMTagParserDocument.class, "WCMTagParserDocument.label10", "\u89e3\u6790 ") + document + I18NMessage.get(WCMTagParserDocument.class, "WCMTagParserDocument.label21", " \u7684\u521b\u5efa\u8005\u771f\u5b9e\u540d\u79f0\u5931\u8d25!"), exception);
        }
    }

    public static int getBytesLength(String string) {
        if (string == null) {
            return 0;
        }
        char[] cArray = string.toCharArray();
        int n = 0;
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            n += c <= '\u007f' ? 1 : 2;
        }
        return n;
    }

    private String[] parseHomeSite(Document document, PublishTagContext publishTagContext, int n) throws WCMException {
        Channel channel = document.getChannel();
        if (channel == null) {
            throw new WCMException("\u83b7\u53d6 " + document + " \u7684\u6240\u5c5e\u9891\u9053\u5931\u8d25!");
        }
        WebSite webSite = channel.getSite();
        String string = n == 12 ? webSite.getDesc() : webSite.getName();
        try {
            String string2 = TagParseHelper.truncateTextIfNeeded(publishTagContext, string);
            string2 = TagParseHelper.formatTextIfNeeded(publishTagContext, string2);
            if (publishTagContext.getAttribute("AUTOLINK", false)) {
                IPublishFolder iPublishFolder = (IPublishFolder)PublishElementFactory.makeElementFrom(webSite);
                String string3 = iPublishFolder.getRootDomain();
                string2 = TagParseHelper.addAutoLink(string3, string2, string, publishTagContext);
            }
            return new String[]{string2};
        }
        catch (Exception exception) {
            throw new WCMException("\u89e3\u6790 " + document + " \u7684\u6240\u5c5e\u7ad9\u70b9\u5931\u8d25!", exception);
        }
    }
}

