/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish.tagparser;

import com.trs.DreamFactory;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.ITagParser;
import com.trs.components.common.publish.domain.tagparser.TagBeanAttrInfo;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfo;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.template.TemplateQuote;
import com.trs.components.wcm.content.domain.AppendixMgr;
import com.trs.components.wcm.content.persistent.Appendix;
import com.trs.components.wcm.content.persistent.Appendixes;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.publish.tagparser.WCMAppendixGenerator;
import com.trs.components.wcm.publish.tagparser.WCMTagParserHelper;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.NamesRegister;

public class WCMTagParserAppendix
implements ITagParser {
    private static NamesRegister s_oAppendixTypeRegister = new NamesRegister();
    private Document m_oDocument = null;
    private TagItem m_tagItem = null;
    private static TagBeanInfo s_TagBeanInfo;

    public TagBeanInfo getBeanInfo() {
        if (s_TagBeanInfo == null) {
            TagBeanAttrInfo tagBeanAttrInfo = null;
            TagBeanInfo tagBeanInfo = new TagBeanInfo();
            tagBeanInfo.setName("TRS_APPENDIX");
            tagBeanInfo.setDesc("TRS_APPENDIX");
            tagBeanInfo.setType(TagBeanInfo.BodyType.IGNORE);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("MODE");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanAttrInfo.setEnumValue(new String[]{"PIC", "FILE", "LINK", "ALL"});
            tagBeanAttrInfo.setDefaultValue("FILE");
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("INDEX");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.INTEGER);
            tagBeanAttrInfo.setDefaultValue("-1");
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("AUTOLINK");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanAttrInfo.setEnumValue(new String[]{"true", "false"});
            tagBeanAttrInfo.setDefaultValue("true");
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("TARGET");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanAttrInfo.setDefaultValue("_blank");
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("EXTRA");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("BEGINHTML");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("ENDHTML");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("MEMO");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanAttrInfo.setEnumValue(new String[]{"true", "false"});
            tagBeanAttrInfo.setDefaultValue("true");
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("BEGINMEMO");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("ENDMEMO");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("SEPERATOR");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("FIELD");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("UPLOAD");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("UPLOADONLY");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanAttrInfo.setEnumValue(new String[]{"true", "false"});
            tagBeanAttrInfo.setDefaultValue("false");
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("NAMEONLY");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanAttrInfo.setEnumValue(new String[]{"true", "false"});
            tagBeanAttrInfo.setDefaultValue("false");
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("WIDTH");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.INTEGER);
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("HEIGHT");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.INTEGER);
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("MINWIDTH");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.INTEGER);
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("MINHEIGHT");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.INTEGER);
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("RELATEDCOLUMN");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("WHERE");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.INTEGER);
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("STARTPOS");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.INTEGER);
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            s_TagBeanInfo = tagBeanInfo;
        }
        return s_TagBeanInfo;
    }

    private AppendixMgr getAppMgr() {
        return (AppendixMgr)DreamFactory.createObjectById("AppendixMgr");
    }

    private int getAppendixType(PublishTagContext publishTagContext) {
        String string = CMyString.showNull(publishTagContext.getAttribute("MODE"), "FILE").toUpperCase();
        return s_oAppendixTypeRegister.lookup(string, 10);
    }

    public void setTagItem(TagItem tagItem) {
        this.m_tagItem = tagItem;
    }

    public void clear() {
        if (this.m_tagItem != null) {
            this.m_tagItem = null;
        }
        if (this.m_oDocument != null) {
            this.m_oDocument = null;
        }
    }

    public TemplateQuote[] analyzeQuotes(IPublishFolder iPublishFolder) {
        return null;
    }

    public String[] parse(PublishTagContext publishTagContext) throws WCMException {
        this.m_oDocument = WCMTagParserHelper.findDocumentHost(publishTagContext);
        if (this.m_oDocument == null) {
            return null;
        }
        int n = this.getAppendixType(publishTagContext);
        int n2 = publishTagContext.getAttribute("INDEX", -1);
        int n3 = 2;
        if (publishTagContext.getAttribute("UPLOADONLY", false)) {
            n3 = 0;
        } else {
            int n4 = n3 = publishTagContext.getAttribute("NAMEONLY", false) ? 1 : 2;
        }
        if (n2 < 0) {
            String string = WCMAppendixGenerator.generateAppendixes(this.m_oDocument, n, publishTagContext, n3);
            if (string == null) {
                return null;
            }
            return new String[]{string};
        }
        Appendixes appendixes = this.getAllAppendixes(publishTagContext, n);
        if (n2 >= appendixes.size()) {
            return null;
        }
        return new String[]{WCMAppendixGenerator.generateAppendix((Appendix)appendixes.getAt(n2), (IPublishContent)publishTagContext.getUpperHost(), publishTagContext, n3)};
    }

    private Appendixes getAllAppendixes(PublishTagContext publishTagContext, int n) throws WCMException {
        String string = publishTagContext.getAttribute("RELATEDCOLUMN");
        boolean bl = !CMyString.isEmpty(string);
        Appendixes appendixes = this.getAppMgr().getAppendixes(this.m_oDocument, n);
        if (bl) {
            for (int i = appendixes.size() - 1; i >= 0; --i) {
                Appendix appendix = (Appendix)appendixes.getAt(i);
                if (appendix == null || string.equals(appendix.getRelatedColumn())) continue;
                appendixes.remove(appendix, false);
            }
        }
        return appendixes;
    }

    static {
        s_oAppendixTypeRegister.register("LINK", 40);
        s_oAppendixTypeRegister.register("FILE", 10);
        s_oAppendixTypeRegister.register("PIC", 20);
        s_oAppendixTypeRegister.register("ALL", 50);
        s_TagBeanInfo = null;
    }
}

