/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish.tagparser;

import com.trs.components.common.publish.config.PublishServerConfigMapper;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.ITagParser4List;
import com.trs.components.common.publish.domain.tagparser.TagParseHelper;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishElements;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.publish.tagparser.WCMTagParser4FolderHostBase;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.html.HtmlUtil;

public abstract class WCMTagParser4ObjsInChannelBase
extends WCMTagParser4FolderHostBase
implements ITagParser4List {
    protected boolean m_bForceSetCurrFolderOfContent = true;
    private static final int ATTR_NUM_DEFAULTVALUE = 500;
    protected IPublishFolder m_oCurrFolder;
    private IPublishElements m_contents;
    private int m_nCurrPos = 0;
    protected int m_nCurrNumber = 1;
    private PublishTagContext m_nextRecordContext = null;
    private static int m_nDefaultMaxNum = 0;

    public void clear() {
        if (this.m_tagItem != null) {
            this.m_tagItem = null;
        }
        if (this.m_oCurrFolder != null) {
            this.m_oCurrFolder = null;
        }
        if (this.m_contents != null) {
            this.m_contents.clear();
            this.m_nCurrPos = 0;
            this.m_nextRecordContext = null;
        }
    }

    protected int getQuoteType() {
        return 1;
    }

    public int getRecordSize() {
        return this.m_contents == null ? 0 : this.m_contents.size();
    }

    public void setStartPos(int n) {
        this.m_nCurrPos = n;
    }

    public PublishTagContext getNextRecordContext() throws WCMException {
        if (this.m_nCurrPos >= this.getRecordSize()) {
            return null;
        }
        try {
            IPublishContent iPublishContent = (IPublishContent)this.m_contents.get(this.m_nCurrPos++);
            int n = this.m_contents.size();
            while (iPublishContent == null && this.m_nCurrPos < n) {
                iPublishContent = (IPublishContent)this.m_contents.get(this.m_nCurrPos++);
            }
            if (iPublishContent == null) {
                return null;
            }
            if (this.m_bForceSetCurrFolderOfContent || iPublishContent.getFolder() == null) {
                iPublishContent.setFolder(this.m_oCurrFolder);
            }
            this.m_nextRecordContext.setSequenceNumber(this.m_nCurrNumber++);
            this.m_nextRecordContext.setUpperHost(iPublishContent);
            return this.m_nextRecordContext;
        }
        catch (Exception exception) {
            throw new WCMException(220, "Failed to get the tag context of next record at " + this.m_nCurrPos, exception);
        }
    }

    public PublishTagContext getDelegatedContext() {
        if (this.m_nCurrPos >= this.getRecordSize()) {
            return null;
        }
        this.m_nextRecordContext.setUpperHost(null);
        return this.m_nextRecordContext;
    }

    public PublishTagContext substantiateContext(PublishTagContext publishTagContext) throws WCMException {
        try {
            IPublishContent iPublishContent = (IPublishContent)this.m_contents.get(this.m_nCurrPos++);
            iPublishContent.setFolder(this.m_oCurrFolder);
            publishTagContext.setSequenceNumber(this.m_nCurrNumber++);
            publishTagContext.setUpperHost(iPublishContent);
            return publishTagContext;
        }
        catch (Exception exception) {
            throw new WCMException(220, "Failed to get the tag context of next record at " + this.m_nCurrPos, exception);
        }
    }

    private void findFolder(PublishTagContext publishTagContext) throws WCMException {
        if (this.m_oCurrFolder != null) {
            return;
        }
        Channel channel = (Channel)this.findHost(publishTagContext, true);
        if (channel == null) {
            return;
        }
        this.m_oCurrFolder = (IPublishFolder)PublishElementFactory.makeElementFrom(channel);
        publishTagContext.setUpperFolder(this.m_oCurrFolder);
    }

    /*
     * Loose catch block
     */
    public String[] parse(PublishTagContext publishTagContext) throws WCMException {
        Object object;
        IPublishFolder iPublishFolder;
        block10: {
            iPublishFolder = publishTagContext.getUpperFolder();
            if (this.m_tagItem.hasChildren()) break block10;
            String[] stringArray = null;
            Object var7_6 = null;
            try {
                publishTagContext.setUpperFolder(iPublishFolder);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.clear();
            return stringArray;
        }
        this.findFolder(publishTagContext);
        WCMFilter wCMFilter = this.getContentsFilter(publishTagContext);
        this.m_contents = publishTagContext.isPreview() ? this.getAllContentsInCurrentFolder(publishTagContext, wCMFilter) : this.getPublishedContentsInCurrentFolder(publishTagContext, wCMFilter);
        this.m_nextRecordContext = new PublishTagContext(publishTagContext, this.m_tagItem, this);
        String[] stringArray = TagParseHelper.parse4List(this.m_tagItem, publishTagContext, this);
        if (stringArray != null && stringArray.length == 1 && publishTagContext.getAttribute("AUTOMORE", false) && this.m_contents != null && this.m_contents.size() >= publishTagContext.getAttribute("NUM", 0) && (object = this.parseAutoMore(this.m_oCurrFolder, publishTagContext)) != null) {
            stringArray[0] = stringArray[0] + (String)object;
        }
        object = stringArray;
        Object var7_7 = null;
        try {
            publishTagContext.setUpperFolder(iPublishFolder);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.clear();
        return object;
        catch (Exception exception) {
            try {
                StringBuffer stringBuffer = new StringBuffer(4096);
                stringBuffer.append(I18NMessage.get(WCMTagParser4ObjsInChannelBase.class, "WCMTagParser4ObjsInChannelBase.label1", "\u89e3\u6790 "));
                stringBuffer.append(this.m_oCurrFolder == null ? "m_currFolder == null" : this.m_oCurrFolder.getInfo());
                stringBuffer.append(I18NMessage.get(WCMTagParser4ObjsInChannelBase.class, "WCMTagParser4ObjsInChannelBase.label2", " \u7684\u6587\u6863\u5217\u8868\u5931\u8d25!\u7f6e\u6807\u5185\u5bb9: \n"));
                stringBuffer.append(this.m_tagItem.toString());
                throw new WCMException(234, stringBuffer.toString(), exception);
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                try {
                    publishTagContext.setUpperFolder(iPublishFolder);
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                this.clear();
                throw throwable;
            }
        }
    }

    protected abstract IPublishElements getPublishedContentsInCurrentFolder(PublishTagContext var1, WCMFilter var2) throws WCMException;

    protected abstract IPublishElements getAllContentsInCurrentFolder(PublishTagContext var1, WCMFilter var2) throws WCMException;

    private WCMFilter getContentsFilter(PublishTagContext publishTagContext) throws WCMException {
        String string;
        WCMFilter wCMFilter = new WCMFilter("", "", "");
        String string2 = publishTagContext.getAttribute("WHERE");
        if (!CMyString.isEmpty(string2)) {
            wCMFilter.setWhere(string2);
        }
        if (!CMyString.isEmpty(string = publishTagContext.getAttribute("ORDER"))) {
            wCMFilter.setOrder(string);
        }
        String string3 = this.getSelectFields(publishTagContext);
        String string4 = publishTagContext.getAttribute("SELECT");
        if (string3.length() > 0 && !CMyString.isEmpty(string4)) {
            string3 = string3 + "," + string4;
        }
        wCMFilter.setSelect(string3);
        int n = publishTagContext.getAttribute("STARTPOS", 0);
        if (n < 0) {
            n = 0;
        }
        int n2 = WCMTagParser4ObjsInChannelBase.getDefaultMaxNum();
        int n3 = publishTagContext.getAttribute("NUM", 500);
        if (n3 <= 0) {
            n3 = 500;
        } else if (n3 > n2) {
            n3 = n2;
        }
        wCMFilter.setMaxRowNumber(n3 + n);
        return wCMFilter;
    }

    private static int getDefaultMaxNum() {
        if (m_nDefaultMaxNum == 0) {
            int n = 0;
            try {
                n = PublishServerConfigMapper.getTemplateParseConfig().getWcmOutlineContentsMaxNum();
                if (n <= 0) {
                    n = 1000;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            m_nDefaultMaxNum = n;
        }
        return m_nDefaultMaxNum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String parseAutoMore(IPublishFolder iPublishFolder, PublishTagContext publishTagContext) throws Exception {
        String string = publishTagContext.getAttribute("BEGINMORE");
        String string2 = publishTagContext.getAttribute("ENDMORE");
        String string3 = publishTagContext.getAttribute("MORETEXT");
        String string4 = publishTagContext.getAttribute("MORETARGET");
        String string5 = publishTagContext.getAttribute("MOREEXTRA");
        if (string3 == null || (string3 = string3.trim()).length() == 0) {
            string3 = I18NMessage.get(WCMTagParser4ObjsInChannelBase.class, "WCMTagParser4ObjsInChannelBase.label3", "\u66f4\u591a\u5185\u5bb9...");
        }
        if (string4 == null || (string4 = string4.trim()).length() == 0) {
            string4 = "_blank";
        }
        StringBuffer stringBuffer = new StringBuffer();
        try {
            String string6 = publishTagContext.getPathCompass().getAbsoluteHttpPath(iPublishFolder);
            string6 = HtmlUtil.calRelativePath(string6, publishTagContext.getPageHttpPath());
            if (string != null && string.length() > 0) {
                stringBuffer.append(string);
            }
            stringBuffer.append("<A href=\"").append(string6);
            stringBuffer.append("\" target=\"").append(string4).append("\" ");
            if (string5 != null) {
                stringBuffer.append(string5);
            }
            stringBuffer.append('>').append(string3).append("</A>");
            if (string2 != null && string2.length() > 0) {
                stringBuffer.append(string2);
            }
            String string7 = stringBuffer.toString();
            Object var12_11 = null;
            stringBuffer.setLength(0);
            return string7;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            stringBuffer.setLength(0);
            throw throwable;
        }
    }

    protected IPublishFolder getCurrFolder(PublishTagContext publishTagContext) throws WCMException {
        if (this.m_oCurrFolder == null) {
            this.findFolder(publishTagContext);
        }
        return this.m_oCurrFolder;
    }

    protected String getSelectFields(PublishTagContext publishTagContext) {
        return "";
    }
}

