/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish.tagparser;

import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.ITagParser4List;
import com.trs.components.common.publish.domain.tagparser.TagBeanAttrInfo;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfo;
import com.trs.components.common.publish.domain.tagparser.TagParseHelper;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.publish.element.PublishFolderChannelImpl;
import com.trs.components.wcm.publish.tagparser.WCMTagParser4FolderHostBase;
import com.trs.infra.common.WCMException;
import java.util.ArrayList;
import java.util.List;

public class TagPreNextChannelsParser
extends WCMTagParser4FolderHostBase
implements ITagParser4List {
    private List m_channels;
    private int m_nCurrPos = 0;
    protected int m_nCurrNumber = 1;
    private PublishTagContext m_nextRecordContext = null;
    private static TagBeanInfo s_TagBeanInfo = null;

    public TagBeanInfo getBeanInfo() {
        if (s_TagBeanInfo == null) {
            TagBeanInfo tagBeanInfo = new TagBeanInfo();
            tagBeanInfo.setName("TRS_PRENEXTCHNLS");
            tagBeanInfo.setDesc("\u524d\u540e\u680f\u76ee\u96c6\u5408");
            TagBeanAttrInfo tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("NEXT");
            tagBeanAttrInfo.setDesc("\u53d6\u540e\u4e00\u4e2a\u680f\u76ee");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanAttrInfo.setDefaultValue("false");
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            s_TagBeanInfo = tagBeanInfo;
        }
        return s_TagBeanInfo;
    }

    public String[] parse(PublishTagContext publishTagContext) throws WCMException {
        this.m_channels = this.find(publishTagContext);
        try {
            this.m_nextRecordContext = new PublishTagContext(publishTagContext, this.m_tagItem, this);
            String[] stringArray = TagParseHelper.parse4List(this.m_tagItem, publishTagContext, this);
            Object var4_4 = null;
            this.clear();
            return stringArray;
        }
        catch (Exception exception) {
            try {
                throw new WCMException(220, "Failed to parse the channels list!", exception);
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this.clear();
                throw throwable;
            }
        }
    }

    private List find(PublishTagContext publishTagContext) throws WCMException {
        ArrayList arrayList = new ArrayList(1);
        BaseChannel baseChannel = super.findHost(publishTagContext, true);
        if (baseChannel == null || baseChannel.getWCMType() != 101) {
            return arrayList;
        }
        Channel channel = (Channel)baseChannel;
        List list = channel.getHost().getChildren(null);
        int n = list.indexOf(channel);
        if (n == -1) {
            return arrayList;
        }
        n = publishTagContext.getAttribute("NEXT", false) ? ++n : --n;
        if (n < 0 || n >= list.size()) {
            return arrayList;
        }
        arrayList.add(list.get(n));
        return arrayList;
    }

    public void clear() {
        if (this.m_tagItem != null) {
            this.m_tagItem = null;
        }
        if (this.m_channels != null) {
            this.m_channels = null;
            this.m_nCurrPos = 0;
            this.m_nextRecordContext = null;
        }
    }

    public void setStartPos(int n) {
        this.m_nCurrPos = n;
    }

    public int getRecordSize() {
        return this.m_channels == null ? 0 : this.m_channels.size();
    }

    public PublishTagContext getNextRecordContext() throws WCMException {
        if (this.m_nCurrPos >= this.getRecordSize()) {
            return null;
        }
        try {
            Channel channel = (Channel)this.m_channels.get(this.m_nCurrPos++);
            PublishFolderChannelImpl publishFolderChannelImpl = new PublishFolderChannelImpl(channel);
            this.m_nextRecordContext.setSequenceNumber(this.m_nCurrNumber++);
            this.m_nextRecordContext.setUpperHost(publishFolderChannelImpl);
            return this.m_nextRecordContext;
        }
        catch (Exception exception) {
            throw new WCMException(220, "Failed to get the tag context of next record at " + this.m_nCurrPos, exception);
        }
    }

    public PublishTagContext getDelegatedContext() {
        if (this.m_nCurrPos >= this.getRecordSize()) {
            return null;
        }
        this.m_nextRecordContext.setUpperHost(null);
        return this.m_nextRecordContext;
    }

    public PublishTagContext substantiateContext(PublishTagContext publishTagContext) throws WCMException {
        try {
            Channel channel = (Channel)this.m_channels.get(this.m_nCurrPos++);
            PublishFolderChannelImpl publishFolderChannelImpl = new PublishFolderChannelImpl(channel);
            publishTagContext.setSequenceNumber(this.m_nCurrNumber++);
            publishTagContext.setUpperHost(publishFolderChannelImpl);
            return publishTagContext;
        }
        catch (Exception exception) {
            throw new WCMException(220, "Failed to get the tag context of next record at " + this.m_nCurrPos, exception);
        }
    }

    protected int getQuoteType() {
        return 5;
    }
}

