/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish.tagparser;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.ITagParser;
import com.trs.components.common.publish.domain.tagparser.TagBeanAttrInfo;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfo;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfoHelper;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.domain.template.TemplateCacheMgr;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.common.publish.persistent.template.TemplateQuote;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.publish.tagparser.WCMTagParserHelper;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.html.HtmlUtil;
import java.util.List;

public class TagChannelHierarchy
implements ITagParser {
    private static TagBeanInfo s_TagBeanInfo = null;
    protected TagItem m_oTagItem = null;

    public TagBeanInfo getBeanInfo() {
        if (s_TagBeanInfo == null) {
            TagBeanAttrInfo tagBeanAttrInfo = null;
            TBI tBI = new TBI();
            tBI.setName("TRS_CHANNELHIERARCHY");
            tBI.setDesc("\u680f\u76ee\u5c42\u6b21");
            tBI.setType(TagBeanInfo.BodyType.TAMPLATE);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("ID");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanAttrInfo.setDefaultValue("SITE");
            tBI.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("CHILDTYPE");
            tagBeanAttrInfo.setDesc("\u7c7b\u578b");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.INTEGER);
            tagBeanAttrInfo.setEnumValue(new String[]{"-1", "0", "1", "2", "11"});
            tagBeanAttrInfo.setDefaultValue("0");
            tBI.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("CHILDINDEX");
            tagBeanAttrInfo.setDesc("\u8d77\u59cb\u4f4d\u7f6e");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.INTEGER);
            tagBeanAttrInfo.setDefaultValue("-1");
            tBI.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("STARTPOS");
            tagBeanAttrInfo.setDesc("\u8d77\u59cb\u4f4d\u7f6e");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.INTEGER);
            tagBeanAttrInfo.setDefaultValue("0");
            tBI.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("LEVEL");
            tagBeanAttrInfo.setDesc("\u83b7\u53d6\u7684\u5c42\u6b21\u6df1\u5ea6,\u82e5\u6307\u5b9a\u4e3a[-1]\u5219\u83b7\u53d6\u5168\u90e8");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.INTEGER);
            tBI.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("AUTOLINK");
            tagBeanAttrInfo.setDesc("\u662f\u5426\u751f\u6210\u8fde\u63a5");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanAttrInfo.setDefaultValue("true");
            tBI.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("DATATYPE");
            tagBeanAttrInfo.setDesc("\u6570\u636e\u683c\u5f0f");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanAttrInfo.setEnumValue(new String[]{"XML", "JS", "HTML"});
            tagBeanAttrInfo.setDefaultValue("XML");
            tBI.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("ONLY");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanAttrInfo.setEnumValue(new String[]{"true", "false"});
            tBI.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("PAGESIZE");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.INTEGER);
            tBI.addAttrInfo(tagBeanAttrInfo);
            s_TagBeanInfo = tBI;
        }
        return s_TagBeanInfo;
    }

    public void setTagItem(TagItem tagItem) {
        this.m_oTagItem = tagItem;
    }

    public TemplateQuote[] analyzeQuotes(IPublishFolder iPublishFolder) {
        return null;
    }

    public String[] parse(PublishTagContext publishTagContext) throws WCMException {
        BaseChannel baseChannel = WCMTagParserHelper.findFolderHost(this.m_oTagItem, publishTagContext, false, true);
        if (baseChannel == null) {
            return null;
        }
        int n = publishTagContext.getAttribute("LEVEL", -1);
        int n2 = publishTagContext.getAttribute("CHILDTYPE", 0);
        boolean bl = publishTagContext.getAttribute("AUTOLINK", true);
        String string = publishTagContext.getAttribute("DATATYPE");
        if (CMyString.isEmpty(string)) {
            string = "XML";
        }
        if ("XML".equals(string = string.toUpperCase())) {
            return this.generateXml(publishTagContext, baseChannel, n, n2, bl);
        }
        if ("JS".equals(string)) {
            return this.generateJs(publishTagContext, baseChannel, n, n2, bl);
        }
        return this.generateHtml(publishTagContext, baseChannel, n, n2, bl);
    }

    private String[] generateXml(PublishTagContext publishTagContext, BaseChannel baseChannel, int n, int n2, boolean bl) throws WCMException {
        return new String[]{this.generateXml0(publishTagContext, baseChannel, n, n2, bl)};
    }

    private String generateXml0(PublishTagContext publishTagContext, BaseChannel baseChannel, int n, int n2, boolean bl) throws WCMException {
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append("<CHNL name='");
        stringBuffer.append(baseChannel.getName());
        stringBuffer.append("' desc='");
        stringBuffer.append(baseChannel.getDesc());
        if (bl) {
            stringBuffer.append("' link='");
            stringBuffer.append(this.getLinkUrl(publishTagContext, baseChannel));
        }
        stringBuffer.append("'>");
        User user = ContextHelper.getLoginUser();
        List list = baseChannel.getChildren(user, n2);
        Channel channel = null;
        if ((n == -1 || n > 0) && list.size() > 0) {
            if (n > 0) {
                int n3 = list.size();
                for (int i = 0; i < n3; ++i) {
                    channel = (Channel)list.get(i);
                    if (channel == null) continue;
                    stringBuffer.append(this.generateXml0(publishTagContext, channel, n - 1, n2, bl));
                }
            } else {
                int n4 = list.size();
                for (int i = 0; i < n4; ++i) {
                    channel = (Channel)list.get(i);
                    if (channel == null) continue;
                    stringBuffer.append(this.generateXml0(publishTagContext, channel, -1, n2, bl));
                }
            }
        }
        stringBuffer.append("</CHNL>");
        return stringBuffer.toString();
    }

    private String[] generateJs(PublishTagContext publishTagContext, BaseChannel baseChannel, int n, int n2, boolean bl) throws WCMException {
        return new String[]{this.generateJs0(publishTagContext, baseChannel, n, n2, bl)};
    }

    private String generateJs0(PublishTagContext publishTagContext, BaseChannel baseChannel, int n, int n2, boolean bl) throws WCMException {
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append("{");
        stringBuffer.append("name:'");
        stringBuffer.append(baseChannel.getName());
        stringBuffer.append("', desc:'");
        stringBuffer.append(baseChannel.getDesc());
        if (bl) {
            stringBuffer.append("', link:'");
            stringBuffer.append(this.getLinkUrl(publishTagContext, baseChannel));
        }
        stringBuffer.append("',chnls:[");
        User user = ContextHelper.getLoginUser();
        List list = baseChannel.getChildren(user, n2);
        Channel channel = null;
        if ((n == -1 || n > 0) && list.size() > 0) {
            if (n > 0) {
                int n3 = list.size();
                for (int i = 0; i < n3; ++i) {
                    channel = (Channel)list.get(i);
                    if (channel == null) continue;
                    stringBuffer.append(this.generateJs0(publishTagContext, channel, n - 1, n2, bl));
                    stringBuffer.append(',');
                }
            } else {
                int n4 = list.size();
                for (int i = 0; i < n4; ++i) {
                    channel = (Channel)list.get(i);
                    if (channel == null) continue;
                    stringBuffer.append(this.generateJs0(publishTagContext, channel, -1, n2, bl));
                    stringBuffer.append(',');
                }
            }
        }
        stringBuffer.append("]");
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    private String[] generateHtml(PublishTagContext publishTagContext, BaseChannel baseChannel, int n, int n2, boolean bl) throws WCMException {
        return new String[]{this.generateHtml0(publishTagContext, baseChannel, n, n2, bl)};
    }

    private String generateHtml0(PublishTagContext publishTagContext, BaseChannel baseChannel, int n, int n2, boolean bl) throws WCMException {
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append("<LI>");
        if (bl) {
            stringBuffer.append(this.renderLink(publishTagContext, baseChannel));
        }
        User user = ContextHelper.getLoginUser();
        List list = baseChannel.getChildren(user, n2);
        Channel channel = null;
        stringBuffer.append("<UL>");
        if ((n == -1 || n > 0) && list.size() > 0) {
            if (n > 0) {
                int n3 = list.size();
                for (int i = 0; i < n3; ++i) {
                    channel = (Channel)list.get(i);
                    if (channel == null) continue;
                    stringBuffer.append(this.generateHtml0(publishTagContext, channel, n - 1, n2, bl));
                }
            } else {
                int n4 = list.size();
                for (int i = 0; i < n4; ++i) {
                    channel = (Channel)list.get(i);
                    if (channel == null) continue;
                    stringBuffer.append(this.generateHtml0(publishTagContext, channel, -1, n2, bl));
                }
            }
        }
        stringBuffer.append("</UL>");
        stringBuffer.append("</LI>");
        return stringBuffer.toString();
    }

    public void clear() {
        if (this.m_oTagItem != null) {
            this.m_oTagItem.clear();
        }
    }

    private String renderLink(PublishTagContext publishTagContext, BaseChannel baseChannel) throws WCMException {
        IPublishFolder iPublishFolder = (IPublishFolder)PublishElementFactory.makeElementFrom(baseChannel);
        String string = this.getLinkUrl(publishTagContext, iPublishFolder);
        String string2 = publishTagContext.getAttribute("TARGET");
        String string3 = publishTagContext.getAttribute("EXTRA");
        String string4 = publishTagContext.getAttribute("LINKTEXT");
        String string5 = null;
        if (publishTagContext.getAttribute("LINKALT", false) && CMyString.isEmpty(string5 = publishTagContext.getAttribute("LINKALTTEXT"))) {
            string5 = baseChannel.getDesc();
        }
        if (!iPublishFolder.isLink()) {
            string = HtmlUtil.calRelativePath(string, publishTagContext.getPageHttpPath());
        }
        return HtmlUtil.renderLink(string, string2, string5, string3, baseChannel.getDesc(), string4);
    }

    private String getLinkUrl(PublishTagContext publishTagContext, BaseChannel baseChannel) throws WCMException {
        IPublishFolder iPublishFolder = (IPublishFolder)PublishElementFactory.makeElementFrom(baseChannel);
        return this.getLinkUrl(publishTagContext, iPublishFolder);
    }

    private String getLinkUrl(PublishTagContext publishTagContext, IPublishFolder iPublishFolder) throws WCMException {
        TemplateCacheMgr templateCacheMgr;
        Template template;
        String string;
        String string2 = "";
        string2 = iPublishFolder.isLink() ? iPublishFolder.getLinkUrl() : publishTagContext.getPathCompass().getAbsoluteHttpPath(iPublishFolder);
        if ('/' != string2.charAt(string2.length() - 1)) {
            string2 = string2 + "/";
        }
        if (!CMyString.isEmpty(string = publishTagContext.getAttributeTrim("TemplateName")) && (template = (templateCacheMgr = (TemplateCacheMgr)DreamFactory.createObjectById("TemplateCacheMgr")).lookupByName(iPublishFolder.getRoot(), string)) != null) {
            string2 = string2 + template.getOutputFileName();
            string2 = string2 + "_";
            string2 = string2 + template.getId();
            string2 = string2 + ".";
            string2 = string2 + template.getOutputFileExt();
        }
        return string2;
    }

    private class TBI
    extends TagBeanInfo {
        private TBI() {
        }

        public void checkSemantic(IPublishFolder iPublishFolder, TagItem tagItem, StringBuffer stringBuffer) {
            TagBeanInfoHelper.checkChannelName(iPublishFolder, tagItem, stringBuffer);
        }
    }
}

