/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish.tagparser;

import com.trs.cms.content.CMSBaseObjs;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.publisher.PublishTaskContext;
import com.trs.components.common.publish.domain.tagparser.BaseTagParser4List;
import com.trs.components.common.publish.domain.tagparser.TagBeanAttrInfo;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfo;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.domain.tagparser.TagParseHelper;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.components.wcm.publish.domain.IPreNextDocuments;
import com.trs.components.wcm.publish.domain.PreNextDocumentsImpl;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;

public abstract class BaseWCMTagParserPreNextDocuments
extends BaseTagParser4List {
    private static Logger logger = Logger.getLogger(BaseWCMTagParserPreNextDocuments.class);
    public static ArrayList FIELDS_DEFAULT_LIST = new ArrayList(16);
    public static HashMap FIELDS_MAP;
    protected static TagBeanInfo s_TagBeanInfo;
    public static final int MODE_PRE = 0;
    public static final int MODE_NEXT = 1;

    protected abstract int getCurrMode();

    protected abstract String getCurrTagName();

    public TagBeanInfo getBeanInfo() {
        if (s_TagBeanInfo == null) {
            TagBeanAttrInfo tagBeanAttrInfo = null;
            TagBeanInfo tagBeanInfo = new TagBeanInfo();
            tagBeanInfo.setName(this.getCurrTagName());
            tagBeanInfo.setDesc(I18NMessage.get(BaseWCMTagParserPreNextDocuments.class, "BaseWCMTagParserPreNextDocuments.label1", "\u83b7\u53d6\u524d\u540e\u6587\u6863"));
            tagBeanInfo.setType(TagBeanInfo.BodyType.TAMPLATE);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("STARTPOS");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.INTEGER);
            tagBeanAttrInfo.setDefaultValue("0");
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("NUM");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.INTEGER);
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("SELECT");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            s_TagBeanInfo = tagBeanInfo;
        }
        return s_TagBeanInfo;
    }

    protected CMSBaseObjs findObjects(PublishTagContext publishTagContext) throws WCMException {
        String string;
        if (publishTagContext.isPreview() && (publishTagContext.getPageElement().getId() <= 0 || publishTagContext.getPageElement().getSubstance().isAddMode())) {
            return new Documents(null);
        }
        PublishTaskContext publishTaskContext = publishTagContext.getPageContext().getTaskContext();
        IPreNextDocuments iPreNextDocuments = (IPreNextDocuments)publishTaskContext.getCachObject(string = "IPreNextDocuments");
        if (iPreNextDocuments == null) {
            iPreNextDocuments = new PreNextDocumentsImpl();
            publishTaskContext.putInCache(string, iPreNextDocuments);
        }
        IPublishContent iPublishContent = (IPublishContent)publishTagContext.getUpperHost();
        IPublishFolder iPublishFolder = iPublishContent.getFolder();
        if (iPublishContent.getModal() != 1 && iPublishContent.getModal() != 3) {
            iPublishFolder = iPublishContent.getOriginalHome();
        }
        this.m_oCurrFolder = iPublishFolder;
        Channel channel = (Channel)iPublishFolder.getSubstance();
        int n = publishTagContext.getAttribute("NUM", 1);
        Documents[] documentsArray = iPreNextDocuments.getPreNextDocuments(channel, (Document)iPublishContent.getSubstance(), n);
        Documents documents = null;
        if (documentsArray != null) {
            documents = documentsArray[this.getCurrMode()];
            documents.setSelect(this.getSelectFields(publishTagContext));
        } else {
            documents = new Documents(null);
        }
        return documents;
    }

    protected boolean isValidate(PublishTagContext publishTagContext) throws WCMException {
        IPublishElement iPublishElement = publishTagContext.getUpperHost();
        CMSObj cMSObj = iPublishElement.getSubstance();
        return cMSObj instanceof Document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getSelectFields(PublishTagContext publishTagContext) {
        TagItem tagItem = publishTagContext.getTagItem();
        String string = tagItem.getExtraAttributeValue("SELECT");
        if (string == null) {
            TagItem tagItem2 = tagItem;
            synchronized (tagItem2) {
                string = tagItem.getExtraAttributeValue("SELECT");
                if (string == null) {
                    string = this.makeSelectFields(publishTagContext);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("SelectFields:" + string));
                    }
                    tagItem.setExtraAttribute("SELECT", string);
                }
            }
        }
        return string;
    }

    private String makeSelectFields(PublishTagContext publishTagContext) {
        String string = (String)FIELDS_DEFAULT_LIST.get(0);
        int n = FIELDS_DEFAULT_LIST.size();
        for (int i = 1; i < n; ++i) {
            string = string + "," + FIELDS_DEFAULT_LIST.get(i);
        }
        ArrayList arrayList = TagParseHelper.makeSelectFields(publishTagContext.getTagItem(), "TRS_DOCUMENT");
        DBManager dBManager = DBManager.getDBManager();
        int n2 = arrayList.size();
        for (int i = 0; i < n2; ++i) {
            String string2 = (String)arrayList.get(i);
            if (FIELDS_DEFAULT_LIST.indexOf(string2) >= 0) continue;
            String string3 = (String)FIELDS_MAP.get(string2);
            if (string3 != null) {
                string2 = string3;
            }
            try {
                if (dBManager.getFieldInfo("WCMDOCUMENT", string2) == null) {
                    publishTagContext.addWarning(I18NMessage.get(BaseWCMTagParserPreNextDocuments.class, "BaseWCMTagParserPreNextDocuments.label2", "TRS_DOCUMENT\u7f6e\u6807\u6307\u5b9a\u7684Field[") + string2 + I18NMessage.get(BaseWCMTagParserPreNextDocuments.class, "BaseWCMTagParserPreNextDocuments.label3", "]\u5728WCMDocument\u8868\u4e2d\u4e0d\u5b58\u5728\uff01"));
                    continue;
                }
            }
            catch (WCMException wCMException) {
                wCMException.printStackTrace();
                try {
                    publishTagContext.addWarning(I18NMessage.get(BaseWCMTagParserPreNextDocuments.class, "BaseWCMTagParserPreNextDocuments.label4", "\u83b7\u53d6\u6307\u5b9a\u7684Field[") + string2 + I18NMessage.get(BaseWCMTagParserPreNextDocuments.class, "BaseWCMTagParserPreNextDocuments.label5", "]\u4eceWCMDocument\u8868\u4e2d\u53d1\u751f\u5f02\u5e38\uff01") + CMyException.getStackTraceText(wCMException));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            string = string + "," + string2;
        }
        return string;
    }

    static {
        FIELDS_DEFAULT_LIST.add("DOCID");
        FIELDS_DEFAULT_LIST.add("DOCCHANNEL");
        FIELDS_DEFAULT_LIST.add("DOCTYPE");
        FIELDS_DEFAULT_LIST.add("DOCTITLE");
        FIELDS_DEFAULT_LIST.add("CRUSER");
        FIELDS_DEFAULT_LIST.add("CRTIME");
        FIELDS_DEFAULT_LIST.add("DocFlag");
        FIELDS_DEFAULT_LIST.add("DocKind");
        FIELDS_DEFAULT_LIST.add("TITLECOLOR");
        FIELDS_DEFAULT_LIST.add("DOCLINK");
        FIELDS_DEFAULT_LIST.add("DOCFILENAME");
        FIELDS_DEFAULT_LIST.add("DOCVERSION");
        FIELDS_MAP = new HashMap(3);
        FIELDS_MAP.put("DOCFROM", "DOCSOURCE");
        FIELDS_MAP.put("DOCHTMLCON", "DOCPUBHTMLCON");
        FIELDS_MAP.put("DOCHTMLCONTENT", "DOCPUBHTMLCON");
        s_TagBeanInfo = null;
    }
}

