/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish.region;

import com.trs.DreamFactory;
import com.trs.ajaxservice.WCMAJAXServiceHelper;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.publish.region.CellInfos;
import com.trs.components.wcm.publish.region.RegionEmployMgr;
import com.trs.components.wcm.publish.region.RegionEmploys;
import com.trs.components.wcm.publish.region.RegionInfo;
import com.trs.components.wcm.publish.region.RegionInfos;
import com.trs.infra.common.WCMException;
import com.trs.infra.common.WCMRightTypes;
import com.trs.infra.persistent.IdFilterSqlUtil;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyString;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.IGlueServiceProvider;
import java.util.List;

public class RegionServiceProvider
implements IGlueServiceProvider {
    public void delete(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        RegionInfos regionInfos = RegionInfos.findByIds(user, methodContext.getObjectIds());
        for (int i = 0; i < regionInfos.size(); ++i) {
            RegionInfo regionInfo = (RegionInfo)regionInfos.getAt(i);
            if (regionInfo == null) continue;
            try {
                this.validRight(user, regionInfo, WCMRightTypes.REGION_DELETE);
            }
            catch (Exception exception) {
                continue;
            }
            regionInfo.delete(user);
            this.deleteCellInfos(regionInfo);
            this.deleteRegionEmploy(regionInfo);
        }
    }

    public Object query(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        int n = methodContext.getValue("ChannelId", 0);
        int n2 = methodContext.getValue("WebSiteId", 0);
        boolean bl = methodContext.getValue("ContainsChildren", false);
        WCMFilter wCMFilter = new WCMFilter();
        String string = methodContext.getValue("orderby");
        if (CMyString.isEmpty(string)) {
            string = "REGIONINFOID desc";
        }
        wCMFilter.setOrder(string);
        StringBuffer stringBuffer = new StringBuffer(256);
        if (n > 0) {
            Channel channel = Channel.findById(n);
            if (channel == null) {
                throw new WCMException("\u6307\u5b9a\u680f\u76ee\u4e0d\u5b58\u5728[ID=" + n + "]");
            }
            this.validRight(user, channel, WCMRightTypes.REGION_LIST);
            stringBuffer.append("channelid=?");
            wCMFilter.addSearchValues(n);
            if (bl) {
                StringBuffer stringBuffer2 = new StringBuffer(512);
                this.makeQueryAllChildren(stringBuffer2, channel, this.getLoginUser());
                if (stringBuffer2.length() > 1) {
                    IdFilterSqlUtil.RangeSQL rangeSQL = IdFilterSqlUtil.make("CHANNELID", stringBuffer2.substring(1));
                    stringBuffer.append(" or ");
                    stringBuffer.append(rangeSQL.getSql());
                    int[] nArray = rangeSQL.getValues();
                    if (nArray != null) {
                        int n3 = nArray.length;
                        for (int i = 0; i < n3; ++i) {
                            wCMFilter.addSearchValues(nArray[i]);
                        }
                    }
                    stringBuffer2.setLength(0);
                }
            }
        } else if (n2 > 0) {
            WebSite webSite = WebSite.findById(n2);
            if (webSite == null) {
                throw new WCMException("\u6307\u5b9a\u7ad9\u70b9\u4e0d\u5b58\u5728[ID=" + n2 + "]");
            }
            this.validRight(user, webSite, WCMRightTypes.REGION_LIST);
            stringBuffer.append("WEBSITEID=?");
            wCMFilter.addSearchValues(n2);
            if (bl) {
                stringBuffer.append(" or CHANNELID in ");
                stringBuffer.append("(select CHANNELID from WCMCHANNEL where SITEID=? and STATUS=0)");
                wCMFilter.addSearchValues(n2);
            }
        }
        wCMFilter.setWhere(stringBuffer.toString());
        wCMFilter.mergeWith(methodContext.getExtraWCMFilter());
        return RegionInfos.openWCMObjs(null, wCMFilter);
    }

    private void makeQueryAllChildren(StringBuffer stringBuffer, Channel channel, User user) throws WCMException {
        List list = channel.getChildren(user);
        if (list == null || list.isEmpty()) {
            return;
        }
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Channel channel2 = (Channel)list.get(i);
            if (channel2 == null || channel2.isDeleted()) continue;
            stringBuffer.append(',').append(channel2.getId());
            this.makeQueryAllChildren(stringBuffer, channel2, user);
        }
    }

    public int save(MethodContext methodContext) throws Throwable {
        RegionInfo regionInfo = null;
        User user = ContextHelper.getLoginUser();
        int n = methodContext.getObjectId();
        if (n > 0) {
            regionInfo = RegionInfo.findById(n);
            if (regionInfo == null) {
                throw new WCMException("\u6307\u5b9a\u7684\u5bfc\u8bfb\u4e0d\u5b58\u5728[ID=" + n + "]");
            }
            this.validRight(user, regionInfo, WCMRightTypes.REGION_EDIT);
        } else {
            regionInfo = new RegionInfo();
            regionInfo.setChannelId(methodContext.getValue("ChannelId", 0));
            regionInfo.setWebSiteId(methodContext.getValue("WebSiteId", 0));
            this.validRight(user, regionInfo, WCMRightTypes.REGION_ADD);
        }
        regionInfo = (RegionInfo)WCMAJAXServiceHelper.setWCMObjectProperties(user, methodContext, regionInfo, null);
        String string = regionInfo.getName();
        if (this.checkRegionName(n, string)) {
            throw new WCMException("\u4e0d\u5141\u8bb8\u521b\u5efa\u540c\u540d\u7684\u5bfc\u8bfb\uff01");
        }
        regionInfo.save(user);
        return regionInfo.getId();
    }

    public boolean existsSimilarName(MethodContext methodContext) throws Throwable {
        String string = methodContext.getValue("Rname");
        if (string == null || "".equals(string.trim())) {
            throw new WCMException("\u5fc5\u987b\u4f20\u5165\u53c2\u6570\u5bfc\u8bfb\u540d\u79f0\u3010Rname\u3011\uff01");
        }
        int n = methodContext.getValue("ObjectId", 0);
        return this.checkRegionName(n, string);
    }

    private boolean checkRegionName(int n, String string) throws WCMException {
        WCMFilter wCMFilter = new WCMFilter("XWCMREGIONINFO", "", "", "RegionInfoId");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("RName=?");
        if (n > 0) {
            stringBuffer.append(" and RegionInfoId not in (" + n + ")");
        }
        wCMFilter.addSearchValues(string);
        wCMFilter.setWhere(stringBuffer.toString());
        return DBManager.getDBManager().sqlExecuteIntQuery(wCMFilter) > 0;
    }

    public Object findById(MethodContext methodContext) throws Throwable {
        int n = methodContext.getObjectId();
        if (n == 0) {
            return null;
        }
        RegionInfo regionInfo = this.findById(n);
        this.validRight(this.getLoginUser(), regionInfo, WCMRightTypes.REGION_DETAIL);
        return regionInfo;
    }

    public Object findByIds(MethodContext methodContext) throws Throwable {
        return null;
    }

    private RegionInfo findById(int n) throws WCMException {
        RegionInfo regionInfo = RegionInfo.findById(n);
        if (regionInfo == null) {
            throw new WCMException("\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u5bfc\u8bfb\u5bf9\u8c61\uff01[ID=" + n + "]");
        }
        return regionInfo;
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    private void deleteCellInfos(RegionInfo regionInfo) throws WCMException {
        if (regionInfo == null) {
            return;
        }
        CellInfos cellInfos = CellInfos.findCellInfos(regionInfo, null);
        if (cellInfos != null) {
            cellInfos.removeAll();
        }
    }

    private void deleteRegionEmploy(RegionInfo regionInfo) throws WCMException {
        if (regionInfo == null) {
            return;
        }
        RegionEmployMgr regionEmployMgr = (RegionEmployMgr)DreamFactory.createObjectById("RegionEmployMgr");
        RegionEmploys regionEmploys = regionEmployMgr.getRegionEmploysByRegion(regionInfo);
        if (regionEmploys == null) {
            return;
        }
        regionEmploys.removeAll();
    }

    private boolean validRight(User user, RegionInfo regionInfo, int n) throws WCMException {
        int n2 = regionInfo.getChannelId();
        int n3 = regionInfo.getWebSiteId();
        Channel channel = Channel.findById(n2);
        WebSite webSite = WebSite.findById(n3);
        BaseChannel baseChannel = channel;
        if (baseChannel == null) {
            baseChannel = webSite;
        }
        if (baseChannel != null) {
            if (!AuthServer.hasRight(user, (CMSObj)baseChannel, n)) {
                throw new WCMException("\u60a8[" + user.getName() + "]\u6ca1\u6709\u6743\u9650\u7ba1\u7406[" + baseChannel + "]\u7684\u5bfc\u8bfb\uff01");
            }
        } else {
            throw new WCMException("\u6307\u5b9a\u5bfc\u8bfb\u6240\u5728\u7684\u680f\u76ee[ID=" + n2 + "]\u548c\u7ad9\u70b9[ID=" + n3 + "\u4e0d\u5b58\u5728");
        }
        return true;
    }

    private boolean validRight(User user, CMSObj cMSObj, int n) throws WCMException {
        if (!AuthServer.hasRight(user, cMSObj, n)) {
            throw new WCMException("\u60a8[" + user.getName() + "]\u6ca1\u6709\u6743\u9650\u7ba1\u7406[" + cMSObj + "]\u7684\u5bfc\u8bfb\uff01");
        }
        return true;
    }
}

