/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish.region;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.components.common.publish.domain.PublishServer;
import com.trs.components.common.publish.domain.template.TemplateEmployMgr;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.publish.region.CellInfos;
import com.trs.components.wcm.publish.region.RegionEmploy;
import com.trs.components.wcm.publish.region.RegionEmployMgr;
import com.trs.components.wcm.publish.region.RegionEmploys;
import com.trs.components.wcm.publish.region.RegionInfo;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.listener.IObjectLCListenerOnDel;
import com.trs.infra.persistent.listener.IObjectLCListenerOnModify;
import java.util.List;
import org.apache.log4j.Logger;

public class DocumentListenerForPublish
implements IObjectLCListenerOnDel,
IObjectLCListenerOnModify {
    private static Logger s_logger = Logger.getLogger(DocumentListenerForPublish.class);

    public void notifyOnDelObj(BaseObj baseObj, int n) throws WCMException {
        if (!(baseObj instanceof Document)) {
            s_logger.error((Object)("Listener[" + this.getClass() + "]\u4e0d\u80fd\u76d1\u542c\u5bf9\u8c61[" + baseObj.getClass() + "]\u7684\u5220\u9664\uff01"));
            return;
        }
        s_logger.debug((Object)"\u8fdb\u5165\u5fb9\u5e95\u5220\u9664\u6587\u6863\u7684\u76d1\u542c--");
        this.updateRegionEmployAndPublish((Document)baseObj);
    }

    public void notifyOnModifyObj(BaseObj baseObj, int n) throws WCMException {
        if (!(baseObj instanceof Document)) {
            s_logger.error((Object)("Listener[" + this.getClass() + "]\u4e0d\u80fd\u76d1\u542c\u5bf9\u8c61[" + baseObj.getClass() + "]\u7684\u4fee\u6539\uff01"));
            return;
        }
        if (baseObj.isChangeProperty("DOCSTATUS") && baseObj.getNewPropertyAsInt("DOCSTATUS", 0) < 0) {
            this.updateRegionEmployAndPublish((Document)baseObj);
        }
    }

    private void updateRegionEmployAndPublish(Document document) throws WCMException {
        TemplateEmployMgr templateEmployMgr = (TemplateEmployMgr)DreamFactory.createObjectById("TemplateEmployMgr");
        RegionEmployMgr regionEmployMgr = (RegionEmployMgr)DreamFactory.createObjectById("RegionEmployMgr");
        RegionEmploys regionEmploys = this.getRegionEmploysByObj(document);
        if (regionEmploys == null || regionEmploys.size() == 0) {
            s_logger.debug((Object)("\u6587\u6863" + document + "\u6ca1\u6709\u88ab\u4efb\u4f55\u5bfc\u8bfb\u4f7f\u7528\uff01"));
        }
        if (regionEmploys != null) {
            for (int i = 0; i < regionEmploys.size(); ++i) {
                int n;
                RegionInfo regionInfo;
                RegionEmploy regionEmploy = (RegionEmploy)regionEmploys.getAt(i);
                if (regionEmploy == null || (regionInfo = RegionInfo.findById(n = regionEmploy.getRegionId())) == null) continue;
                this.deleteRegionCell(regionInfo, document.getId());
                int[] nArray = new int[]{102};
                RegionEmploys regionEmploys2 = regionEmployMgr.getRegionEmploysByRegionAndType(n, nArray);
                if (regionEmploys2 == null) continue;
                for (int j = 0; j < regionEmploys2.size(); ++j) {
                    List list;
                    int n2;
                    Template template;
                    RegionEmploy regionEmploy2 = (RegionEmploy)regionEmploys2.getAt(j);
                    if (regionEmploy2 == null || (template = Template.findById(n2 = regionEmploy2.getObjId())) == null || (list = templateEmployMgr.getEmployers(template, null)) == null) continue;
                    this.publishHost(list);
                }
                regionEmploys.removeAll();
            }
        }
    }

    private RegionEmploys getRegionEmploysByObj(Document document) throws WCMException {
        RegionEmployMgr regionEmployMgr = (RegionEmployMgr)DreamFactory.createObjectById("RegionEmployMgr");
        RegionEmploys regionEmploys = regionEmployMgr.getRegionEmploysByObj(document.getId(), 605);
        return regionEmploys;
    }

    private void deleteRegionCell(RegionInfo regionInfo, int n) throws WCMException {
        WCMFilter wCMFilter = new WCMFilter("", "DocId=?", "");
        wCMFilter.addSearchValues(n);
        CellInfos cellInfos = CellInfos.findCellInfos(regionInfo, wCMFilter);
        cellInfos.removeAll();
    }

    private void publishHost(List list) throws WCMException {
        for (int i = 0; i < list.size(); ++i) {
            int n;
            IPublishElement iPublishElement = (IPublishElement)list.get(i);
            if (iPublishElement == null) continue;
            int n2 = iPublishElement.getType();
            int n3 = n = n2 == 103 ? 5 : 17;
            if (!AuthServer.hasRight(ContextHelper.getLoginUser(), iPublishElement.getSubstance(), n)) {
                s_logger.debug((Object)("\u7528\u6237" + ContextHelper.getLoginUser() + "\u6ca1\u6709\u6743\u9650\u53d1\u5e03\uff1a" + iPublishElement.getSubstance()));
                continue;
            }
            IPublishFolder iPublishFolder = iPublishElement.getFolder();
            if (!iPublishFolder.canDoOutlinePageTask()) continue;
            PublishServer publishServer = PublishServer.getInstance();
            publishServer.publishFolder((IPublishFolder)iPublishElement, 8);
        }
    }
}

