/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish.region;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.components.common.publish.domain.PublishServer;
import com.trs.components.common.publish.domain.template.TemplateEmployMgr;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.wcm.content.persistent.ChnlDoc;
import com.trs.components.wcm.publish.region.CellInfos;
import com.trs.components.wcm.publish.region.RegionEmploy;
import com.trs.components.wcm.publish.region.RegionEmployMgr;
import com.trs.components.wcm.publish.region.RegionEmploys;
import com.trs.components.wcm.publish.region.RegionInfo;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.listener.IObjectLCListenerOnModify;
import java.util.List;
import org.apache.log4j.Logger;

public class ChannelDocListenerForPublish
implements IObjectLCListenerOnModify {
    private static Logger s_logger = Logger.getLogger(ChannelDocListenerForPublish.class);

    public void notifyOnModifyObj(BaseObj baseObj, int n) throws WCMException {
        if (!(baseObj instanceof ChnlDoc)) {
            s_logger.error((Object)("Listener[" + this.getClass() + "]\u4e0d\u80fd\u76d1\u542c\u5bf9\u8c61[" + baseObj.getClass() + "]\u7684\u4fee\u6539\uff01"));
            return;
        }
        ChnlDoc chnlDoc = (ChnlDoc)baseObj;
        if (chnlDoc.isChangeProperty("DOCSTATUS") && chnlDoc.isPublished() && chnlDoc.getNewPropertyAsInt("DOCSTATUS", 0) < 0) {
            this.updateRegionEmployAndPublish(chnlDoc.getDocId());
        }
    }

    private void updateRegionEmployAndPublish(int n) throws WCMException {
        TemplateEmployMgr templateEmployMgr = (TemplateEmployMgr)DreamFactory.createObjectById("TemplateEmployMgr");
        RegionEmployMgr regionEmployMgr = (RegionEmployMgr)DreamFactory.createObjectById("RegionEmployMgr");
        RegionEmploys regionEmploys = this.getRegionEmploysByObj(n);
        if (regionEmploys == null || regionEmploys.size() == 0) {
            s_logger.debug((Object)("\u6587\u6863[" + n + "]\u6ca1\u6709\u88ab\u4efb\u4f55\u5bfc\u8bfb\u4f7f\u7528\uff01"));
            return;
        }
        for (int i = 0; i < regionEmploys.size(); ++i) {
            int n2;
            RegionInfo regionInfo;
            RegionEmploy regionEmploy = (RegionEmploy)regionEmploys.getAt(i);
            if (regionEmploy == null || (regionInfo = RegionInfo.findById(n2 = regionEmploy.getRegionId())) == null) continue;
            this.deleteRegionCell(regionInfo, n);
            int[] nArray = new int[]{102};
            RegionEmploys regionEmploys2 = regionEmployMgr.getRegionEmploysByRegionAndType(n2, nArray);
            if (regionEmploys2 == null) continue;
            for (int j = 0; j < regionEmploys2.size(); ++j) {
                List list;
                int n3;
                Template template;
                RegionEmploy regionEmploy2 = (RegionEmploy)regionEmploys2.getAt(j);
                if (regionEmploy2 == null || (template = Template.findById(n3 = regionEmploy2.getObjId())) == null || (list = templateEmployMgr.getEmployers(template, null)) == null) continue;
                this.publishHost(list);
            }
            regionEmploys.removeAll();
        }
    }

    private RegionEmploys getRegionEmploysByObj(int n) throws WCMException {
        RegionEmployMgr regionEmployMgr = (RegionEmployMgr)DreamFactory.createObjectById("RegionEmployMgr");
        RegionEmploys regionEmploys = regionEmployMgr.getRegionEmploysByObj(n, 605);
        return regionEmploys;
    }

    private void deleteRegionCell(RegionInfo regionInfo, int n) throws WCMException {
        WCMFilter wCMFilter = new WCMFilter("", "DocId=?", "");
        wCMFilter.addSearchValues(n);
        CellInfos cellInfos = CellInfos.findCellInfos(regionInfo, wCMFilter);
        cellInfos.removeAll();
    }

    private void publishHost(List list) throws WCMException {
        for (int i = 0; i < list.size(); ++i) {
            int n;
            IPublishElement iPublishElement = (IPublishElement)list.get(i);
            if (iPublishElement == null) continue;
            int n2 = iPublishElement.getType();
            int n3 = n = n2 == 103 ? 5 : 17;
            if (!AuthServer.hasRight(ContextHelper.getLoginUser(), iPublishElement.getSubstance(), n)) {
                s_logger.debug((Object)("\u7528\u6237" + ContextHelper.getLoginUser() + "\u6ca1\u6709\u6743\u9650\u53d1\u5e03\uff1a" + iPublishElement.getSubstance()));
                continue;
            }
            IPublishFolder iPublishFolder = iPublishElement.getFolder();
            if (!iPublishFolder.canDoOutlinePageTask()) continue;
            PublishServer publishServer = PublishServer.getInstance();
            publishServer.publishFolder((IPublishFolder)iPublishElement, 8);
        }
    }
}

