/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish.element;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.config.PublishServerConfigMapper;
import com.trs.components.common.publish.domain.taskdispatch.IPublishElementsIterator;
import com.trs.components.common.publish.persistent.element.IFolderQuoter;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishElements;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.persistent.element.PublishElementsCMSListImpl;
import com.trs.components.common.publish.persistent.element.PublishElementsCMSObjsImpl;
import com.trs.components.common.publish.persistent.element.PublishFolderImplBase;
import com.trs.components.common.publish.persistent.publisher.FolderPublishConfig;
import com.trs.components.common.publish.persistent.template.Templates;
import com.trs.components.wcm.content.domain.DocumentMgr;
import com.trs.components.wcm.content.domain.DocumentsGetHelper;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.publish.IFolderPubStatusCacheMgr;
import com.trs.components.wcm.publish.element.PublishElementsIteratorDocumentsImpl;
import com.trs.components.wcm.publish.element.PublishFolderWebSiteImpl;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMDatainvalidException;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.DebugTimer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;

public class PublishFolderChannelImpl
extends PublishFolderImplBase
implements IFolderQuoter {
    private static final Logger logger = Logger.getLogger((String)PublishFolderChannelImpl.class.getName());
    private Channel m_channel;

    public PublishFolderChannelImpl() {
    }

    public PublishFolderChannelImpl(Channel channel) {
        this.setSubstance(channel);
    }

    public int getType() {
        return 101;
    }

    public CMSObj getSubstance() {
        return this.m_channel;
    }

    public void setSubstance(CMSObj cMSObj) {
        this.m_channel = (Channel)cMSObj;
    }

    public boolean loadById(int n) throws WCMException {
        this.m_channel = Channel.findById(n);
        return this.m_channel != null;
    }

    public IPublishElements getIncreasedContents(WCMFilter wCMFilter) throws Exception {
        IPublishFolder iPublishFolder = this.getRoot();
        IFolderPubStatusCacheMgr iFolderPubStatusCacheMgr = (IFolderPubStatusCacheMgr)DreamFactory.createObjectById("IFolderPubStatusCacheMgr");
        return this.getContents(iFolderPubStatusCacheMgr.findStatusesCanDoIncreasePub(iPublishFolder.getType(), iPublishFolder.getId()), wCMFilter);
    }

    public IPublishElements getPublishedContents(WCMFilter wCMFilter) throws Exception {
        return this.getContents(new int[]{10}, wCMFilter);
    }

    public IPublishElements getAllContents(WCMFilter wCMFilter) throws Exception {
        IPublishFolder iPublishFolder = this.getRoot();
        IFolderPubStatusCacheMgr iFolderPubStatusCacheMgr = (IFolderPubStatusCacheMgr)DreamFactory.createObjectById("IFolderPubStatusCacheMgr");
        return this.getContents(iFolderPubStatusCacheMgr.findStatusesCanDoPub(iPublishFolder.getType(), iPublishFolder.getId()), wCMFilter);
    }

    private IPublishElements getContents(int[] nArray, WCMFilter wCMFilter) throws Exception {
        if (nArray == null || nArray.length <= 0) {
            return null;
        }
        DebugTimer debugTimer = new DebugTimer();
        debugTimer.start();
        WCMFilter wCMFilter2 = new WCMFilter("", "", "");
        wCMFilter2.setMaxRowNumber(PublishServerConfigMapper.getTemplateParseConfig().getWcmOutlineContentsMaxNum());
        String string = "WCMCHNLDOC.DOCSTATUS in(?";
        wCMFilter2.addSearchValues(0, nArray[0]);
        int n = nArray.length;
        for (int i = 1; i < n; ++i) {
            string = string + ",?";
            wCMFilter2.addSearchValues(i, nArray[i]);
        }
        string = string + ")";
        wCMFilter2.setWhere(string);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getContents: Where=" + string));
        }
        if (wCMFilter != null) {
            wCMFilter2.mergeWith(wCMFilter);
        }
        Documents documents = null;
        if (Document.DOCUMENTS_GET_OPTIMIZE) {
            documents = DocumentsGetHelper.getDocuments(this.m_channel, wCMFilter2);
        } else {
            DocumentMgr documentMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
            documents = documentMgr.getDocuments(this.m_channel, wCMFilter2);
        }
        debugTimer.stop();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getContents use [" + debugTimer.getTime() + "]ms\nSQL:" + documents.getFilter().toSQL()));
        }
        if (documents == null || documents.isEmpty()) {
            return null;
        }
        return new PublishElementsCMSObjsImpl(documents);
    }

    public boolean isLink() {
        return this.m_channel.isLink();
    }

    public String getLinkUrl() {
        return this.m_channel.getLinkUrl();
    }

    public int getId() {
        return this.m_channel == null ? 0 : this.m_channel.getId();
    }

    public boolean isRoot() {
        return false;
    }

    public IPublishFolder getRoot() throws WCMException {
        PublishFolderWebSiteImpl publishFolderWebSiteImpl = null;
        if (this.m_channel != null) {
            WebSite webSite = this.m_channel.getSite();
            if (webSite == null) {
                throw new WCMException(I18NMessage.get(PublishFolderChannelImpl.class, "PublishFolderChannelImpl.label1", "\u6307\u5b9a\u7684\u680f\u76ee[Id=") + this.m_channel.getId() + ",Name=" + this.m_channel.getName() + I18NMessage.get(PublishFolderChannelImpl.class, "PublishFolderChannelImpl.label2", "]\u6240\u5c5e\u7ad9\u70b9[SiteId=") + this.m_channel.getSiteId() + I18NMessage.get(PublishFolderChannelImpl.class, "PublishFolderChannelImpl.label3", "]\u4e0d\u5b58\u5728!"));
            }
            publishFolderWebSiteImpl = new PublishFolderWebSiteImpl(webSite);
        }
        return publishFolderWebSiteImpl;
    }

    public void makeFrom(CMSObj cMSObj) {
        this.m_channel = (Channel)cMSObj;
    }

    public IPublishFolder getParent() throws WCMException {
        if (this.m_channel == null) {
            return null;
        }
        Channel channel = this.m_channel.getParent();
        PublishFolderImplBase publishFolderImplBase = channel == null ? new PublishFolderWebSiteImpl(this.m_channel.getSite()) : new PublishFolderChannelImpl(channel);
        return publishFolderImplBase;
    }

    public IPublishElements getChildren() throws WCMException {
        List list = this.m_channel.getChildren(ContextHelper.getLoginUser());
        if (list == null) {
            return null;
        }
        return new PublishElementsCMSListImpl(list);
    }

    public int getSiblingIndex() throws WCMException {
        return this.m_channel.getSiblingIndex();
    }

    public boolean validateCanDoPub() throws WCMException {
        int n = this.m_channel.getType();
        if (n == 2 || n == 1) {
            return true;
        }
        if (!this.m_channel.isCanPub()) {
            throw new WCMDatainvalidException(200004, CMyString.format(I18NMessage.get(PublishFolderChannelImpl.class, "PublishFolderChannelImpl.label4", "[{0}]\u8bbe\u7f6e\u4e3a\u4e0d\u53ef\u53d1\u5e03\uff01"), new String[]{this.getInfo()}));
        }
        FolderPublishConfig folderPublishConfig = FolderPublishConfig.findOf(this);
        if (folderPublishConfig == null) {
            throw new WCMDatainvalidException(200001, CMyString.format(I18NMessage.get(PublishFolderChannelImpl.class, "PublishFolderChannelImpl.label5", "[{0}]\u6ca1\u6709\u8bbe\u7f6e\u53d1\u5e03\u5c5e\u6027!"), new String[]{this.getInfo()}));
        }
        Templates templates = this.getOutlineTemplates();
        if (templates == null || templates.isEmpty()) {
            throw new WCMDatainvalidException(200002, CMyString.format(I18NMessage.get(PublishFolderChannelImpl.class, "PublishFolderChannelImpl.label6", "[{0}]\u6ca1\u6709\u8bbe\u7f6e\u6982\u89c8\u6a21\u677f\uff01"), new String[]{this.getInfo()}));
        }
        return true;
    }

    public boolean canDoOutlinePageTask() {
        if (this.m_channel == null || this.m_channel.isDeleted()) {
            return false;
        }
        int n = this.m_channel.getType();
        if (n == 2 || n == 1) {
            return false;
        }
        Templates templates = this.getOutlineTemplates();
        return templates != null && !templates.isEmpty();
    }

    public boolean canDoDetailPageTask() {
        if (this.m_channel == null) {
            return false;
        }
        int n = this.m_channel.getType();
        if (n == 2 || n == 1) {
            return true;
        }
        if (!this.m_channel.isCanPub()) {
            return false;
        }
        return this.getDetailTemplate() != null;
    }

    public boolean isValidElement() {
        if (this.m_channel == null) {
            return false;
        }
        try {
            this.validateCanDoPub();
            return true;
        }
        catch (WCMDatainvalidException wCMDatainvalidException) {
        }
        catch (WCMException wCMException) {
            logger.error((Object)(I18NMessage.get(PublishFolderChannelImpl.class, "PublishFolderChannelImpl.label7", "\u5224\u65ad\u53d1\u5e03\u5143\u7d20:") + this.getInfo() + I18NMessage.get(PublishFolderChannelImpl.class, "PublishFolderChannelImpl.label8", "\u7684\u6709\u6548\u6027\u5931\u8d25!")), (Throwable)wCMException);
        }
        return false;
    }

    public void validateCanDoPreview() throws WCMException {
        FolderPublishConfig folderPublishConfig = FolderPublishConfig.findOf(this);
        if (folderPublishConfig == null) {
            throw new WCMDatainvalidException(200001, CMyString.format(I18NMessage.get(PublishFolderChannelImpl.class, "PublishFolderChannelImpl.label5", "[{0}]\u6ca1\u6709\u8bbe\u7f6e\u53d1\u5e03\u5c5e\u6027!"), new String[]{this.getInfo()}));
        }
        Templates templates = this.getOutlineTemplates();
        if (templates == null || templates.isEmpty()) {
            throw new WCMDatainvalidException(200002, CMyString.format(I18NMessage.get(PublishFolderChannelImpl.class, "PublishFolderChannelImpl.label6", "[{0}]\u6ca1\u6709\u8bbe\u7f6e\u6982\u89c8\u6a21\u677f\uff01"), new String[]{this.getInfo()}));
        }
    }

    public boolean canDoPreview() {
        try {
            FolderPublishConfig folderPublishConfig = FolderPublishConfig.findOf(this);
            if (folderPublishConfig == null) {
                return false;
            }
            return !this.getOutlineTemplates().isEmpty();
        }
        catch (Exception exception) {
            logger.error((Object)(I18NMessage.get(PublishFolderChannelImpl.class, "PublishFolderChannelImpl.label9", "\u5224\u65ad ") + this.getInfo() + I18NMessage.get(PublishFolderChannelImpl.class, "PublishFolderChannelImpl.label10", " \u662f\u5426\u53ef\u4ee5\u9884\u89c8\u53d1\u751f\u5f02\u5e38\uff01")), (Throwable)exception);
            return false;
        }
    }

    public IPublishElementsIterator getIncreasedContentsIterator(WCMFilter wCMFilter) throws Exception {
        IPublishFolder iPublishFolder = this.getRoot();
        IFolderPubStatusCacheMgr iFolderPubStatusCacheMgr = (IFolderPubStatusCacheMgr)DreamFactory.createObjectById("IFolderPubStatusCacheMgr");
        return this.getContentsIterator(iFolderPubStatusCacheMgr.findStatusesCanDoIncreasePub(iPublishFolder.getType(), iPublishFolder.getId()), wCMFilter);
    }

    public IPublishElementsIterator getAllContentsIterator(WCMFilter wCMFilter) throws Exception {
        IPublishFolder iPublishFolder = this.getRoot();
        IFolderPubStatusCacheMgr iFolderPubStatusCacheMgr = (IFolderPubStatusCacheMgr)DreamFactory.createObjectById("IFolderPubStatusCacheMgr");
        return this.getContentsIterator(iFolderPubStatusCacheMgr.findStatusesCanDoPub(iPublishFolder.getType(), iPublishFolder.getId()), wCMFilter);
    }

    public IPublishElementsIterator getPublishedContentsIterator(WCMFilter wCMFilter) throws Exception {
        return this.getContentsIterator(new int[]{10}, wCMFilter);
    }

    private IPublishElementsIterator getContentsIterator(int[] nArray, WCMFilter wCMFilter) throws Exception {
        WCMFilter wCMFilter2 = new WCMFilter("", "", "");
        wCMFilter2.setMaxRowNumber(PublishServerConfigMapper.getTemplateParseConfig().getWcmOutlineContentsMaxNum());
        String string = "WCMCHNLDOC.DOCSTATUS";
        string = "DOCSTATUS in(?";
        wCMFilter2.addSearchValues(0, nArray[0]);
        int n = nArray.length;
        for (int i = 1; i < n; ++i) {
            string = string + ",?";
            wCMFilter2.addSearchValues(i, nArray[i]);
        }
        string = string + ")";
        wCMFilter2.setWhere(string);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getContents: Where=" + string));
        }
        if (wCMFilter != null) {
            wCMFilter2.mergeWith(wCMFilter);
        }
        WCMFilter wCMFilter3 = null;
        if (Document.DOCUMENTS_GET_OPTIMIZE) {
            wCMFilter3 = DocumentsGetHelper.makeChannelFilter(this.m_channel, wCMFilter2);
        } else {
            DocumentMgr documentMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
            wCMFilter3 = documentMgr.getFilterForDocuments(this.m_channel, wCMFilter2);
        }
        return new PublishElementsIteratorDocumentsImpl(wCMFilter3);
    }

    public boolean canDoBatchDetailPageTask() {
        return this.canDoDetailPageTask();
    }

    public boolean isCanDoSave(User user) throws WCMException {
        return AuthServer.hasRight(user, (CMSObj)this.m_channel, 13);
    }

    public boolean isDeleted() {
        return this.m_channel.isDeleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPublishStatus(int n) throws WCMException {
        if (n == 10 && this.m_channel.isCanPub()) {
            String string;
            User user = ContextHelper.getLoginUser();
            if (this.m_channel.canEdit(user)) {
                try {
                    this.m_channel.setCanPub(false);
                    this.m_channel.update(user);
                    string = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    if (this.m_channel.isLocked()) {
                        this.m_channel.cancelUpdate(user);
                    }
                    throw throwable;
                }
                if (this.m_channel.isLocked()) {
                    this.m_channel.cancelUpdate(user);
                }
            }
            String string2 = "update WCMDocument set DocStatus=? where DocChannel=? and DocStatus=?";
            string = "update WCMChnlDoc set DocStatus=? where ChnlId=? and DocStatus=?";
            String string3 = "update WCMChnlDoc set DocStatus=? where DocChannel=? and DocStatus=?";
            int[] nArray = new int[]{15, this.m_channel.getId(), 10};
            DBManager.getDBManager().sqlExecuteUpdate(new String[]{string2, string, string3}, nArray);
        }
    }

    public String toString() {
        return this.getInfo();
    }

    public Collection getFoldersQuotingMe(boolean bl) throws WCMException {
        Collection collection = this.getFoldersQuotingMe();
        if (!bl) {
            return collection;
        }
        Collection collection2 = this.getFoldersQuotingCotnent();
        collection = this.mergeWith(collection, collection2);
        return collection;
    }

    /*
     * Loose catch block
     */
    private Collection getFoldersQuotingCotnent() throws WCMException {
        ArrayList<IPublishElement> arrayList;
        DebugTimer debugTimer;
        block19: {
            Exception exception2222;
            DBManager dBManager;
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            Connection connection;
            block17: {
                String string = "select ChannelId from WCMChannel where exists(select 1 from WCMChnlDoc where docchannel=? and modal=2 and WCMChannel.ChannelId=WCMChnlDoc.ChnlId)";
                debugTimer = new DebugTimer();
                debugTimer.start();
                connection = null;
                preparedStatement = null;
                resultSet = null;
                arrayList = null;
                dBManager = DBManager.getDBManager();
                connection = dBManager.getConnection();
                preparedStatement = connection.prepareStatement(string);
                preparedStatement.setInt(1, this.m_channel.getId());
                resultSet = preparedStatement.executeQuery();
                arrayList = new ArrayList<IPublishElement>();
                while (resultSet.next()) {
                    int n = resultSet.getInt(1);
                    IPublishElement iPublishElement = PublishElementFactory.lookupElement(this.m_channel.getWCMType(), n);
                    arrayList.add(iPublishElement);
                }
                resultSet.close();
                preparedStatement.close();
                preparedStatement = null;
                Object var12_10 = null;
                if (resultSet == null) break block17;
                try {
                    resultSet.close();
                }
                catch (Exception exception2222) {
                    logger.error((Object)"Failed to close result", (Throwable)exception2222);
                }
            }
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (Exception exception2222) {
                    logger.error((Object)"Failed to close prepared statement", (Throwable)exception2222);
                }
            }
            if (connection != null) {
                dBManager.freeConnection(connection);
            }
            break block19;
            {
                catch (Exception exception3) {
                    throw new WCMException(1100, "Failed to Desc!", exception3);
                }
            }
            catch (Throwable throwable) {
                Exception exception42222;
                Object var12_11 = null;
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception42222) {
                        logger.error((Object)"Failed to close result", (Throwable)exception42222);
                    }
                }
                if (preparedStatement != null) {
                    try {
                        preparedStatement.close();
                    }
                    catch (Exception exception42222) {
                        logger.error((Object)"Failed to close prepared statement", (Throwable)exception42222);
                    }
                }
                if (connection != null) {
                    dBManager.freeConnection(connection);
                }
                throw throwable;
            }
        }
        debugTimer.stop();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("get[" + this.m_channel.getInfo() + "] contentQuote use [" + debugTimer.getTime() + "]ms"));
        }
        return arrayList;
    }

    private Collection mergeWith(Collection collection, Collection collection2) {
        if (collection == null || collection.isEmpty()) {
            return collection2;
        }
        if (collection2 == null || collection2.isEmpty()) {
            return collection;
        }
        for (Object e : collection2) {
            if (collection.contains(e)) continue;
            collection.add(e);
        }
        return collection;
    }
}

