/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish.element;

import com.trs.DreamFactory;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.domain.PublishServer;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishContentImplBase;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.persistent.publisher.FolderPublishConfig;
import com.trs.components.wcm.content.domain.AppendixMgr;
import com.trs.components.wcm.content.domain.auth.DocumentAuthServer;
import com.trs.components.wcm.content.persistent.Appendix;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.publish.PreNextPageRefresher;
import com.trs.components.wcm.publish.WCMPubStatusConfig;
import com.trs.components.wcm.publish.element.IRelateResource;
import com.trs.components.wcm.publish.element.PublishFolderChannelImpl;
import com.trs.components.wcm.resource.Status;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMDatainvalidException;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.WCMDiscoveryFactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class PublishContentDocumentImpl
extends PublishContentImplBase {
    private static Logger logger = Logger.getLogger(PublishContentDocumentImpl.class);
    private Document m_doc = null;
    private int m_nModal = 0;
    private int m_nStatusInHome = 0;
    private int m_nStatusInCurrentFolder = 0;
    private AppendixMgr m_appendixmgr;

    public PublishContentDocumentImpl() {
    }

    public PublishContentDocumentImpl(Document document) {
        this.setSubstance(document);
    }

    public void setFolder(IPublishFolder iPublishFolder) {
        super.setFolder(iPublishFolder);
        this.m_nModal = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getModal() throws WCMException {
        if (this.m_doc.getId() == 0) {
            this.m_nModal = 1;
        }
        if (this.m_nModal == 0) {
            Number number = (Number)this.m_doc.getProperty("MODAL");
            if (number != null) {
                this.m_nModal = Math.abs(number.intValue());
            } else {
                PublishContentDocumentImpl publishContentDocumentImpl = this;
                synchronized (publishContentDocumentImpl) {
                    if (this.m_nModal <= 0) {
                        this.loadPropertiesInChnlDoc();
                    }
                }
            }
        }
        return this.m_nModal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPublishedInHome() throws WCMException {
        if (this.m_nStatusInHome == 0) {
            PublishContentDocumentImpl publishContentDocumentImpl = this;
            synchronized (publishContentDocumentImpl) {
                if (this.m_nStatusInHome != 10) {
                    this.findStatusInHome();
                }
            }
        }
        return this.m_nStatusInHome == 10;
    }

    /*
     * Loose catch block
     */
    private void loadPropertiesInChnlDoc() throws WCMException {
        block22: {
            Exception exception2222;
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            Connection connection;
            DBManager dBManager;
            block20: {
                block19: {
                    if (this.getFolder() != null) {
                        int n = this.getFolder().getId();
                        if (n == this.m_doc.getChannelId()) {
                            this.m_nModal = 1;
                            return;
                        }
                    } else {
                        this.m_nModal = 1;
                        return;
                    }
                    dBManager = DBManager.getDBManager();
                    connection = null;
                    preparedStatement = null;
                    resultSet = null;
                    connection = dBManager.getConnection();
                    preparedStatement = connection.prepareStatement("SELECT MODAL FROM WCMCHNLDOC WHERE DOCID=? AND CHNLID=?");
                    preparedStatement.setInt(1, this.m_doc.getId());
                    preparedStatement.setInt(2, this.getFolder().getId());
                    preparedStatement.setMaxRows(1);
                    resultSet = preparedStatement.executeQuery();
                    if (resultSet != null && resultSet.next()) {
                        this.m_nModal = Math.abs(resultSet.getInt(1));
                        break block19;
                    }
                    this.m_nModal = 2;
                }
                Object var8_6 = null;
                if (resultSet == null) break block20;
                try {
                    resultSet.close();
                }
                catch (Exception exception2222) {
                    // empty catch block
                }
            }
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (Exception exception2222) {
                    // empty catch block
                }
            }
            if (connection != null) {
                dBManager.freeConnection(connection);
            }
            break block22;
            {
                catch (Exception exception3) {
                    throw new WCMException(1100, "Failed to load the doucment properties from database table WCMChnlDoc!", exception3);
                }
            }
            catch (Throwable throwable) {
                Exception exception42222;
                Object var8_7 = null;
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception42222) {
                        // empty catch block
                    }
                }
                if (preparedStatement != null) {
                    try {
                        preparedStatement.close();
                    }
                    catch (Exception exception42222) {
                        // empty catch block
                    }
                }
                if (connection != null) {
                    dBManager.freeConnection(connection);
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    private synchronized void findStatusInHome() throws WCMException {
        block18: {
            Exception exception2222;
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            Connection connection;
            DBManager dBManager;
            block16: {
                block15: {
                    dBManager = DBManager.getDBManager();
                    connection = null;
                    preparedStatement = null;
                    resultSet = null;
                    connection = dBManager.getConnection();
                    preparedStatement = connection.prepareStatement("SELECT DOCSTATUS FROM WCMDOCUMENT WHERE DOCID=?");
                    preparedStatement.setInt(1, this.m_doc.getId());
                    preparedStatement.setMaxRows(1);
                    resultSet = preparedStatement.executeQuery();
                    if (resultSet == null || !resultSet.next()) break block15;
                    this.m_nStatusInHome = resultSet.getInt(1);
                }
                Object var8_5 = null;
                if (resultSet == null) break block16;
                try {
                    resultSet.close();
                }
                catch (Exception exception2222) {
                    // empty catch block
                }
            }
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (Exception exception2222) {
                    // empty catch block
                }
            }
            if (connection != null) {
                dBManager.freeConnection(connection);
            }
            break block18;
            {
                catch (Exception exception3) {
                    throw new WCMException(1100, "Failed to find the doucment status in its home!", exception3);
                }
            }
            catch (Throwable throwable) {
                Exception exception42222;
                Object var8_6 = null;
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception42222) {
                        // empty catch block
                    }
                }
                if (preparedStatement != null) {
                    try {
                        preparedStatement.close();
                    }
                    catch (Exception exception42222) {
                        // empty catch block
                    }
                }
                if (connection != null) {
                    dBManager.freeConnection(connection);
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    private synchronized void findStatusInCurrentFolder() throws WCMException {
        block20: {
            Exception exception2222;
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            Connection connection;
            DBManager dBManager;
            block18: {
                block17: {
                    Channel channel = (Channel)this.getFolder().getSubstance();
                    if (channel.isOnlySearch()) {
                        channel = this.m_doc.getChannel();
                    }
                    if (channel == null) {
                        return;
                    }
                    dBManager = DBManager.getDBManager();
                    connection = null;
                    preparedStatement = null;
                    resultSet = null;
                    connection = dBManager.getConnection();
                    preparedStatement = connection.prepareStatement("SELECT DOCSTATUS FROM WCMCHNLDOC WHERE DOCID=? and CHNLID=?");
                    preparedStatement.setInt(1, this.m_doc.getId());
                    preparedStatement.setInt(2, channel.getId());
                    preparedStatement.setMaxRows(1);
                    resultSet = preparedStatement.executeQuery();
                    if (resultSet == null || !resultSet.next()) break block17;
                    this.m_nStatusInCurrentFolder = resultSet.getInt(1);
                }
                Object var9_6 = null;
                if (resultSet == null) break block18;
                try {
                    resultSet.close();
                }
                catch (Exception exception2222) {
                    // empty catch block
                }
            }
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (Exception exception2222) {
                    // empty catch block
                }
            }
            if (connection != null) {
                dBManager.freeConnection(connection);
            }
            break block20;
            {
                catch (Exception exception3) {
                    throw new WCMException(1100, "Failed to find the doucment status in its home!", exception3);
                }
            }
            catch (Throwable throwable) {
                Exception exception42222;
                Object var9_7 = null;
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception42222) {
                        // empty catch block
                    }
                }
                if (preparedStatement != null) {
                    try {
                        preparedStatement.close();
                    }
                    catch (Exception exception42222) {
                        // empty catch block
                    }
                }
                if (connection != null) {
                    dBManager.freeConnection(connection);
                }
                throw throwable;
            }
        }
    }

    public int getBodyType() {
        if (this.m_doc.getType() == 40 && this.isSWFModeContent()) {
            return 20;
        }
        return this.m_doc.getType();
    }

    /*
     * Loose catch block
     */
    public void setPublishStatus(int n) throws WCMException {
        String[] stringArray;
        Connection connection;
        DBManager dBManager;
        boolean bl;
        block19: {
            PreparedStatement preparedStatement;
            block18: {
                int n2;
                switch (n) {
                    case 10: {
                        n2 = 15;
                        break;
                    }
                    case 50: {
                        n2 = 10;
                        break;
                    }
                    default: {
                        return;
                    }
                }
                Channel channel = (Channel)this.getFolder().getSubstance();
                if (channel.isOnlySearch()) {
                    channel = this.m_doc.getChannel();
                }
                if (channel == null) {
                    return;
                }
                boolean bl2 = channel.getId() == this.m_doc.getChannelId();
                bl = n == 10;
                dBManager = DBManager.getDBManager();
                connection = dBManager.getConnection();
                preparedStatement = null;
                String string = null;
                string = "update WCMChnlDoc set DOCStatus=? where DocId=? and ChnlId=? and not DocStatus=? and DocStatus>0";
                preparedStatement = connection.prepareStatement(string);
                preparedStatement.setInt(1, n2);
                preparedStatement.setInt(2, this.getId());
                preparedStatement.setInt(3, channel.getId());
                preparedStatement.setInt(4, n2);
                preparedStatement.executeUpdate();
                preparedStatement.close();
                if (bl2) {
                    string = "update WCMDocument set DOCStatus=? where DocId=? and DocChannel=? and not DocStatus=? and DocStatus>0";
                    preparedStatement = connection.prepareStatement(string);
                    preparedStatement.setInt(1, n2);
                    preparedStatement.setInt(2, this.getId());
                    preparedStatement.setInt(3, channel.getId());
                    preparedStatement.setInt(4, n2);
                    preparedStatement.executeUpdate();
                    preparedStatement.close();
                }
                if (!bl2 || !bl) break block18;
                string = "update WCMChnlDoc set DOCStatus=? where DocId=? and not DocStatus=? and Modal=2 and DocStatus>0";
                preparedStatement = connection.prepareStatement(string);
                preparedStatement.setInt(1, n2);
                preparedStatement.setInt(2, this.getId());
                preparedStatement.setInt(3, n2);
                preparedStatement.executeUpdate();
                preparedStatement.close();
            }
            stringArray = null;
            if (preparedStatement == null) break block19;
            try {
                preparedStatement.close();
                break block19;
            }
            catch (Exception exception) {
                // empty catch block
            }
            {
                break block19;
                catch (Exception exception) {
                    throw new WCMException(I18NMessage.get(PublishContentDocumentImpl.class, "PublishContentDocumentImpl.label1", "\u66f4\u65b0DocStatus\u5931\u8d25\uff01"), exception);
                }
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                if (preparedStatement != null) {
                    try {
                        preparedStatement.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                dBManager.freeConnection(connection);
                throw throwable;
            }
        }
        dBManager.freeConnection(connection);
        if (bl) {
            Object object;
            boolean bl3 = "true".equalsIgnoreCase(ConfigServer.getServer().getSysConfigValue("PUBLISH_RELDOC_ON_DESTROY", "false"));
            if (bl3) {
                this.publishRelDocumentsByRelation(1);
                this.publishRelDocumentsByRelation(3);
                object = this.m_doc.getKeywords();
                if (object != null && ((String)(object = ((String)object).trim())).length() > 0) {
                    stringArray = ((String)object).split(";");
                    this.publishRelDocumentsByKeywords(stringArray, 1);
                    this.publishRelDocumentsByKeywords(stringArray, 3);
                }
            }
            object = new PreNextPageRefresher(this.m_doc);
            ((PreNextPageRefresher)object).refresh();
        }
    }

    /*
     * Loose catch block
     */
    private void publishRelDocumentsByKeywords(String[] stringArray, int n) throws WCMException {
        block21: {
            Exception exception2222;
            String string;
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            Connection connection;
            DBManager dBManager;
            block20: {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("select 1 from WCMDocKeyword where WCMDocKeyword.DocKeyWord in(");
                boolean bl = false;
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i].trim().length() == 0) continue;
                    bl = true;
                    stringBuffer.append("?,");
                }
                if (!bl) {
                    return;
                }
                stringBuffer.setLength(stringBuffer.length() - 1);
                stringBuffer.append(")");
                dBManager = DBManager.getDBManager();
                String string2 = "exists(" + stringBuffer + " and WCMDocKeyword.DocId=WCMChnlDoc.DocId)" + " and Modal=? and DocStatus=" + 10 + " and DocChannel>0";
                String string3 = n == 1 ? "DocId" : "DocId,ChnlId";
                WCMFilter wCMFilter = new WCMFilter("WCMChnlDoc", string2, "", string3);
                for (int i = 0; i < stringArray.length; ++i) {
                    wCMFilter.addSearchValues(stringArray[i]);
                }
                wCMFilter.addSearchValues(n);
                connection = null;
                preparedStatement = null;
                resultSet = null;
                string = wCMFilter.toSQL();
                connection = dBManager.getConnection();
                preparedStatement = connection.prepareStatement(string);
                DBManager.setParameters(preparedStatement, wCMFilter);
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    int n2 = resultSet.getInt(1);
                    int n3 = n == 1 ? 0 : resultSet.getInt(2);
                    this.publishDocumentSelf(n2, n3);
                }
                Object var16_19 = null;
                if (connection != null) {
                    dBManager.freeConnection(connection);
                }
                if (preparedStatement == null) break block20;
                try {
                    preparedStatement.close();
                }
                catch (Exception exception2222) {
                    // empty catch block
                }
            }
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception2222) {}
            }
            break block21;
            {
                catch (SQLException sQLException) {
                    throw new WCMException("\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff1aSQL=" + string, sQLException);
                }
                catch (Exception exception3) {
                    throw new WCMException("\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff1aSQL=" + string, exception3);
                }
            }
            catch (Throwable throwable) {
                Exception exception42222;
                Object var16_20 = null;
                if (connection != null) {
                    dBManager.freeConnection(connection);
                }
                if (preparedStatement != null) {
                    try {
                        preparedStatement.close();
                    }
                    catch (Exception exception42222) {
                        // empty catch block
                    }
                }
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception42222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    private void publishRelDocumentsByRelation(int n) throws WCMException {
        block18: {
            Exception exception2222;
            String string;
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            Connection connection;
            DBManager dBManager;
            block17: {
                dBManager = DBManager.getDBManager();
                String string2 = "DocId in(select DocId from WCMRelation where WCMRelation.RelDocId=?) and Modal=? and DocStatus=10 and DocChannel>0";
                String string3 = n == 1 ? "DocId" : "DocId,ChnlId";
                WCMFilter wCMFilter = new WCMFilter("WCMChnlDoc", string2, "", string3);
                wCMFilter.addSearchValues(this.m_doc.getId());
                wCMFilter.addSearchValues(n);
                connection = null;
                preparedStatement = null;
                resultSet = null;
                string = wCMFilter.toSQL();
                connection = dBManager.getConnection();
                preparedStatement = connection.prepareStatement(string);
                DBManager.setParameters(preparedStatement, wCMFilter);
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    int n2 = resultSet.getInt(1);
                    int n3 = n == 1 ? 0 : resultSet.getInt(2);
                    this.publishDocumentSelf(n2, n3);
                }
                Object var13_14 = null;
                if (connection != null) {
                    dBManager.freeConnection(connection);
                }
                if (preparedStatement == null) break block17;
                try {
                    preparedStatement.close();
                }
                catch (Exception exception2222) {
                    // empty catch block
                }
            }
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception2222) {}
            }
            break block18;
            {
                catch (SQLException sQLException) {
                    throw new WCMException("\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff1aSQL=" + string, sQLException);
                }
                catch (Exception exception3) {
                    throw new WCMException("\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff1aSQL=" + string, exception3);
                }
            }
            catch (Throwable throwable) {
                Exception exception42222;
                Object var13_15 = null;
                if (connection != null) {
                    dBManager.freeConnection(connection);
                }
                if (preparedStatement != null) {
                    try {
                        preparedStatement.close();
                    }
                    catch (Exception exception42222) {
                        // empty catch block
                    }
                }
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception42222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    private void publishDocumentSelf(int n, int n2) throws WCMException {
        Document document = Document.findById(n, "DocId,DocTitle,DocChannel");
        int n3 = 1;
        Channel channel = null;
        if (n2 > 0) {
            channel = Channel.findById(n2);
            n3 = 3;
        } else {
            channel = document.getChannel();
        }
        if (channel == null || channel.isDeleted()) {
            return;
        }
        IPublishFolder iPublishFolder = (IPublishFolder)PublishElementFactory.makeElementFrom(channel);
        PublishContentDocumentImpl publishContentDocumentImpl = new PublishContentDocumentImpl(document);
        publishContentDocumentImpl.setFolder(iPublishFolder);
        publishContentDocumentImpl.m_nModal = n3;
        publishContentDocumentImpl.m_nStatusInCurrentFolder = 10;
        publishContentDocumentImpl.m_nStatusInHome = 10;
        PublishServer.getInstance().publishContent((IPublishContent)publishContentDocumentImpl, 8);
    }

    public int getType() {
        return 605;
    }

    public CMSObj getSubstance() {
        return this.m_doc;
    }

    public void setSubstance(CMSObj cMSObj) {
        this.m_doc = (Document)cMSObj;
    }

    public boolean loadById(int n) throws WCMException {
        this.m_doc = Document.findById(n);
        return this.m_doc != null;
    }

    public int getId() {
        return this.m_doc == null ? 0 : this.m_doc.getId();
    }

    public void makeFrom(CMSObj cMSObj) {
        this.m_doc = (Document)cMSObj;
    }

    public IPublishFolder getOriginalHome() throws WCMException {
        if (this.getModal() == 1 && this.m_folder != null) {
            return this.m_folder;
        }
        if (this.getFolder() != null && this.m_doc.getChannelId() == this.getFolder().getId() && this.getFolder().getType() == 101) {
            return this.getFolder();
        }
        Channel channel = this.m_doc.getChannel();
        if (channel == null) {
            return null;
        }
        return new PublishFolderChannelImpl(channel);
    }

    public CMyDateTime getCreatedTime() {
        return this.m_doc.getCrTime();
    }

    /*
     * Loose catch block
     */
    public void setPublishTime(CMyDateTime cMyDateTime) throws WCMException {
        Connection connection;
        DBManager dBManager;
        block10: {
            dBManager = DBManager.getDBManager();
            connection = dBManager.getConnection();
            Statement statement = null;
            Timestamp timestamp = cMyDateTime.toTimestamp();
            String[] stringArray = new String[4];
            stringArray[0] = "update WCMChnlDoc set DOCPUBTIME=? where DocId=? and ChnlId=?";
            stringArray[1] = "update WCMChnlDoc set DOCFirstPUBTIME=? where DocId=? and ChnlId=? and DOCFirstPUBTIME is null";
            if (this.getFolder().getId() == this.m_doc.getChannelId()) {
                stringArray[2] = "update WCMDocument  set DOCPUBTIME=? where DocId=? and DocChannel=?";
                stringArray[3] = "update WCMDocument set DOCFirstPUBTIME=? where DocId=? and DocChannel=? and DOCFirstPUBTIME is null";
            }
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null) continue;
                statement = connection.prepareStatement(stringArray[i]);
                statement.setTimestamp(1, timestamp);
                statement.setInt(2, this.getId());
                statement.setInt(3, this.getFolder().getId());
                statement.executeUpdate();
                statement.close();
                statement = null;
            }
            Object var9_9 = null;
            if (statement == null) break block10;
            try {
                statement.close();
                break block10;
            }
            catch (Exception exception) {
                // empty catch block
            }
            {
                break block10;
                catch (Exception exception) {
                    throw new WCMException(I18NMessage.get(PublishContentDocumentImpl.class, "PublishContentDocumentImpl.label2", "\u66f4\u65b0DocPubTime\u548cDocPubURL\u5931\u8d25\uff01"), exception);
                }
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                dBManager.freeConnection(connection);
                throw throwable;
            }
        }
        dBManager.freeConnection(connection);
    }

    /*
     * Loose catch block
     */
    public void setPublishTimeAndURL(CMyDateTime cMyDateTime, String string) throws WCMException {
        Connection connection;
        DBManager dBManager;
        block11: {
            Statement statement;
            block10: {
                boolean bl = this.getFolder().getId() == this.m_doc.getChannelId();
                boolean bl2 = cMyDateTime == null && string == null;
                String string2 = string;
                Timestamp timestamp = null;
                dBManager = DBManager.getDBManager();
                connection = dBManager.getConnection();
                statement = null;
                if (cMyDateTime != null) {
                    timestamp = cMyDateTime.toTimestamp();
                }
                String string3 = null;
                string3 = "update WCMChnlDoc set DOCPUBTIME=?, DocPubURL=? where DocId=? and ChnlId=?";
                statement = connection.prepareStatement(string3);
                statement.setTimestamp(1, timestamp);
                statement.setString(2, string2);
                statement.setInt(3, this.getId());
                statement.setInt(4, this.getFolder().getId());
                statement.executeUpdate();
                statement.close();
                string3 = "update WCMChnlDoc set DOCFirstPUBTIME=? where DocId=? and ChnlId=? and DOCFirstPUBTIME is null";
                statement = connection.prepareStatement(string3);
                statement.setTimestamp(1, timestamp);
                statement.setInt(2, this.getId());
                statement.setInt(3, this.getFolder().getId());
                statement.executeUpdate();
                statement.close();
                if (bl) {
                    string3 = "update WCMDOCUMENT set DOCPUBTIME=?, DOCPUBURL=? where DOCID=?";
                    statement = connection.prepareStatement(string3);
                    statement.setTimestamp(1, timestamp);
                    statement.setString(2, string2);
                    statement.setInt(3, this.getId());
                    statement.executeUpdate();
                    statement.close();
                    string3 = "update WCMDOCUMENT set DOCFIRSTPUBTIME=? where DOCID=? and DOCFIRSTPUBTIME is null";
                    statement = connection.prepareStatement(string3);
                    statement.setTimestamp(1, timestamp);
                    statement.setInt(2, this.getId());
                    statement.executeUpdate();
                    statement.close();
                }
                if (!bl || !bl2) break block10;
                string3 = "update WCMChnlDoc set DOCPUBTIME=?, DocPubURL=? where DocId=? and Modal=2";
                statement = connection.prepareStatement(string3);
                statement.setTimestamp(1, timestamp);
                statement.setString(2, string2);
                statement.setInt(3, this.getId());
                statement.executeUpdate();
                statement.close();
            }
            Object var12_12 = null;
            if (statement == null) break block11;
            try {
                statement.close();
                break block11;
            }
            catch (Exception exception) {
                // empty catch block
            }
            {
                break block11;
                catch (Exception exception) {
                    throw new WCMException(I18NMessage.get(PublishContentDocumentImpl.class, "PublishContentDocumentImpl.label2", "\u66f4\u65b0DocPubTime\u548cDocPubURL\u5931\u8d25\uff01"), exception);
                }
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                dBManager.freeConnection(connection);
                throw throwable;
            }
        }
        dBManager.freeConnection(connection);
    }

    public boolean validateCanDoPub() throws WCMException {
        Object object;
        int n;
        Object object2;
        if (this.getFolder() == null) {
            throw new WCMDatainvalidException(I18NMessage.get(PublishContentDocumentImpl.class, "PublishContentDocumentImpl.label3", "\u6ca1\u6709\u627e\u5230[") + this.getInfo() + I18NMessage.get(PublishContentDocumentImpl.class, "PublishContentDocumentImpl.label4", "]\u7684\u6240\u5c5e\u680f\u76ee\uff01"));
        }
        Channel channel = (Channel)this.getFolder().getSubstance();
        if (!channel.isCanPub()) {
            throw new WCMDatainvalidException(200004, "[" + channel.getDispDesc() + I18NMessage.get(PublishContentDocumentImpl.class, "PublishContentDocumentImpl.label5", "]\u8bbe\u7f6e\u4e0d\u53ef\u53d1\u5e03\uff01\u6240\u4ee5") + this.m_doc + I18NMessage.get(PublishContentDocumentImpl.class, "PublishContentDocumentImpl.label6", "\u4e0d\u80fd\u53d1\u5e03\uff01"));
        }
        if (this.getDetailTemplate() == null) {
            throw new WCMDatainvalidException(200003, "[" + this.getInfo() + I18NMessage.get(PublishContentDocumentImpl.class, "PublishContentDocumentImpl.label7", "]\u6ca1\u6709\u8bbe\u7f6e\u7ec6\u89c8\u6a21\u677f\uff01"));
        }
        boolean bl = false;
        int n2 = this.getModal();
        if (n2 == 2) {
            IPublishFolder iPublishFolder = this.getOriginalHome();
            channel = (Channel)iPublishFolder.getSubstance();
            if (!channel.isCanPub()) {
                throw new WCMDatainvalidException(200004, "[" + channel.getDispDesc() + I18NMessage.get(PublishContentDocumentImpl.class, "PublishContentDocumentImpl.label5", "]\u8bbe\u7f6e\u4e0d\u53ef\u53d1\u5e03\uff01\u6240\u4ee5") + this.m_doc + I18NMessage.get(PublishContentDocumentImpl.class, "PublishContentDocumentImpl.label6", "\u4e0d\u80fd\u53d1\u5e03\uff01"));
            }
            object2 = WCMPubStatusConfig.findOf((iPublishFolder = iPublishFolder.getRoot()).getType(), iPublishFolder.getId());
            if (object2 == null) {
                bl = false;
            } else {
                boolean bl2 = bl = ("," + ((WCMPubStatusConfig)object2).getStatusesCanDoPub() + ",").indexOf("," + this.m_doc.getStatusId() + ",") >= 0;
            }
            if (!bl) {
                Status status = Status.findById(this.m_doc.getStatusId());
                String string = status == null ? I18NMessage.get(PublishContentDocumentImpl.class, "PublishContentDocumentImpl.label8", "\u672a\u77e5") : status.getDisp();
                throw new WCMDatainvalidException(200005, I18NMessage.get(PublishContentDocumentImpl.class, "PublishContentDocumentImpl.label17", "\u6587\u6863[") + this.getInfo() + I18NMessage.get(PublishContentDocumentImpl.class, "PublishContentDocumentImpl.label9", "]\u7684\u72b6\u6001[") + string + I18NMessage.get(PublishContentDocumentImpl.class, "PublishContentDocumentImpl.label10", "]\u4e3a\u4e0d\u53ef\u53d1\u5e03\u72b6\u6001!"));
            }
        }
        if (Status.findById(n = this.getCurrentStatusId()) == null) {
            object2 = I18NMessage.get(PublishContentDocumentImpl.class, "PublishContentDocumentImpl.label8", "\u672a\u77e5");
            throw new WCMDatainvalidException(200005, I18NMessage.get(PublishContentDocumentImpl.class, "PublishContentDocumentImpl.label17", "\u6587\u6863[") + this.getInfo() + I18NMessage.get(PublishContentDocumentImpl.class, "PublishContentDocumentImpl.label9", "]\u7684\u72b6\u6001[") + (String)object2 + I18NMessage.get(PublishContentDocumentImpl.class, "PublishContentDocumentImpl.label10", "]\u4e3a\u4e0d\u53ef\u53d1\u5e03\u72b6\u6001!"));
        }
        if (n == 10) {
            return true;
        }
        try {
            object2 = this.getFolder().getRoot();
            object = WCMPubStatusConfig.findOf(object2.getType(), object2.getId());
            bl = object == null ? false : ("," + ((WCMPubStatusConfig)object).getStatusesCanDoPub() + ",").indexOf("," + n + ",") >= 0;
        }
        catch (Exception exception) {
            bl = false;
        }
        if (!bl) {
            object2 = Status.findById(n);
            object = object2 == null ? I18NMessage.get(PublishContentDocumentImpl.class, "PublishContentDocumentImpl.label8", "\u672a\u77e5") : ((Status)object2).getDisp();
            throw new WCMDatainvalidException(200005, I18NMessage.get(PublishContentDocumentImpl.class, "PublishContentDocumentImpl.label17", "\u6587\u6863[") + this.getInfo() + I18NMessage.get(PublishContentDocumentImpl.class, "PublishContentDocumentImpl.label9", "]\u7684\u72b6\u6001[") + (String)object + I18NMessage.get(PublishContentDocumentImpl.class, "PublishContentDocumentImpl.label10", "]\u4e3a\u4e0d\u53ef\u53d1\u5e03\u72b6\u6001!"));
        }
        return true;
    }

    private int getCurrentStatusId() throws WCMException {
        if (this.m_nStatusInCurrentFolder == 0) {
            this.findStatusInCurrentFolder();
        }
        return this.m_nStatusInCurrentFolder;
    }

    public boolean isValidElement() {
        try {
            this.validateCanDoPub();
        }
        catch (WCMDatainvalidException wCMDatainvalidException) {
            return false;
        }
        catch (WCMException wCMException) {
            logger.error((Object)(I18NMessage.get(PublishContentDocumentImpl.class, "PublishContentDocumentImpl.label11", "\u5224\u65ad\u53d1\u5e03\u5143\u7d20:") + this.getInfo() + I18NMessage.get(PublishContentDocumentImpl.class, "PublishContentDocumentImpl.label12", "\u7684\u6709\u6548\u6027\u5931\u8d25!")), (Throwable)wCMException);
            return false;
        }
        return true;
    }

    public boolean isLink() {
        return this.m_doc.getType() == 30;
    }

    public String getLinkUrl() {
        return CMyString.showNull(this.m_doc.getPropertyAsString("DOCLINK"));
    }

    public boolean isFile() {
        if (this.m_doc.getType() != 40) {
            return false;
        }
        return !this.isSWFModeContent();
    }

    private boolean isSWFModeContent() {
        String string = this.getFileName();
        int n = string.lastIndexOf(46);
        String string2 = CMyFile.excludeFileExt(string);
        if (!string2.equals("swf") && n > 0) {
            String string3 = string.substring(0, n + 1) + "swf";
            try {
                string3 = FilesMan.getFilesMan().mapFilePath(string3, 0) + string3;
                if (CMyFile.fileExists(string3)) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public String getFileName() {
        return this.m_doc.getPropertyAsString("DOCFILENAME");
    }

    public void validateCanDoPreview() throws WCMException {
        IPublishFolder iPublishFolder = null;
        switch (this.getModal()) {
            case 1: 
            case 2: {
                iPublishFolder = this.getOriginalHome();
                break;
            }
            case 3: {
                iPublishFolder = this.getFolder();
                break;
            }
            default: {
                throw new WCMDatainvalidException("[" + this.getInfo() + I18NMessage.get(PublishContentDocumentImpl.class, "PublishContentDocumentImpl.label13", "]\u4e0d\u53ef\u8bc6\u522b\u7684\u6587\u6863\u6a21\u5f0f!"));
            }
        }
        if (iPublishFolder == null) {
            throw new WCMDatainvalidException(I18NMessage.get(PublishContentDocumentImpl.class, "PublishContentDocumentImpl.label3", "\u6ca1\u6709\u627e\u5230[") + this.getInfo() + I18NMessage.get(PublishContentDocumentImpl.class, "PublishContentDocumentImpl.label4", "]\u7684\u6240\u5c5e\u680f\u76ee\uff01"));
        }
        FolderPublishConfig folderPublishConfig = FolderPublishConfig.findOf(iPublishFolder);
        if (folderPublishConfig == null) {
            throw new WCMDatainvalidException(200001, "[" + this.getInfo() + I18NMessage.get(PublishContentDocumentImpl.class, "PublishContentDocumentImpl.label14", "]\u6ca1\u6709\u8bbe\u7f6e\u53d1\u5e03\u5c5e\u6027!"));
        }
        if (this.isFile() || this.isLink()) {
            return;
        }
        if (this.getDetailTemplate() == null) {
            throw new WCMDatainvalidException(200003, "[" + this.getInfo() + I18NMessage.get(PublishContentDocumentImpl.class, "PublishContentDocumentImpl.label7", "]\u6ca1\u6709\u8bbe\u7f6e\u7ec6\u89c8\u6a21\u677f\uff01"));
        }
    }

    public boolean canDoPreview() {
        try {
            IPublishFolder iPublishFolder = null;
            switch (this.getModal()) {
                case 1: 
                case 2: {
                    iPublishFolder = this.getOriginalHome();
                    break;
                }
                case 3: {
                    iPublishFolder = this.getFolder();
                    break;
                }
                default: {
                    return false;
                }
            }
            FolderPublishConfig folderPublishConfig = FolderPublishConfig.findOf(iPublishFolder);
            if (folderPublishConfig == null) {
                return false;
            }
            if (this.isFile() || this.isLink()) {
                return true;
            }
            return this.getDetailTemplate() != null;
        }
        catch (Exception exception) {
            logger.error((Object)(I18NMessage.get(PublishContentDocumentImpl.class, "PublishContentDocumentImpl.label15", "\u5224\u65ad ") + this.getInfo() + I18NMessage.get(PublishContentDocumentImpl.class, "PublishContentDocumentImpl.label16", " \u662f\u5426\u53ef\u4ee5\u9884\u89c8\u53d1\u751f\u5f02\u5e38\uff01")), (Throwable)exception);
            return false;
        }
    }

    public Iterator getRelatedResources() throws WCMException {
        Object object;
        if (this.m_doc == null) {
            return null;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = this.getModal();
        if (this.m_doc.getType() == 20 && n != 2 && (object = this.m_doc.getHTMLWCMFiles(true)) != null && object.size() > 0) {
            arrayList.addAll((Collection<Object>)object);
        }
        if (this.m_doc.getType() == 40 && n != 2 && this.isSWFModeContent()) {
            object = this.getFileName();
            arrayList.add(object);
            int n2 = ((String)object).lastIndexOf(46);
            arrayList.add(((String)object).substring(0, n2 + 1) + "swf");
        }
        if (this.m_appendixmgr == null) {
            this.m_appendixmgr = (AppendixMgr)DreamFactory.createObjectById("AppendixMgr");
        }
        object = this.m_appendixmgr.getAppendixes(this.m_doc, -1);
        for (int i = 0; i < ((BaseObjs)object).size(); ++i) {
            Appendix appendix = (Appendix)((BaseObjs)object).getAt(i);
            if (appendix == null || appendix.getFlag() == 40) continue;
            arrayList.add(appendix.getFile());
        }
        if (this.getModal() != 2) {
            Object object2;
            Channel channel = this.m_doc.getChannel();
            if (channel.getSite().getPropertyAsInt("SiteType", 0) == 1 && !CMyString.isEmpty((String)(object2 = this.m_doc.getRelateWords()))) {
                arrayList.addAll(Arrays.asList(CMyString.split((String)object2, ",")));
            }
            if ((object2 = WCMDiscoveryFactory.getDiscovery()) != null) {
                Iterator iterator = object2.getImplementors(IRelateResource.class.getName());
                Class<?> clazz = null;
                IRelateResource iRelateResource = null;
                while (iterator.hasNext()) {
                    try {
                        clazz = Class.forName((String)iterator.next());
                        iRelateResource = (IRelateResource)clazz.newInstance();
                        arrayList.addAll(iRelateResource.getResourceNames(this));
                    }
                    catch (Exception exception) {
                        logger.warn((Object)"get relate files fail.", (Throwable)exception);
                    }
                }
            }
        }
        return arrayList.iterator();
    }

    public boolean isCanDoSave(User user) throws WCMException {
        return DocumentAuthServer.hasRight(user, null, this.m_doc, 32);
    }

    public String toString() {
        return String.valueOf(this.m_doc);
    }
}

