/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish.domain.job;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.job.BaseStatefulScheduleWorker;
import com.trs.components.common.publish.domain.PublishServer;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishElements;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.wcm.content.domain.DocumentMgr;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.infra.common.ContextParameters;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.log.LogServer;
import org.apache.log4j.Logger;

public class PublishJobWorker
extends BaseStatefulScheduleWorker {
    private static final Logger logger = Logger.getLogger((String)PublishJobWorker.class.getName());
    private int m_nSenderType;
    private int m_nSenderId;
    private User m_oScheduleUser;

    protected boolean analyzeParams() {
        try {
            this.m_nSenderType = Integer.parseInt(this.getArgAsString("SenderType"));
            this.m_nSenderId = Integer.parseInt(this.getArgAsString("SenderId"));
            String string = this.getArgAsString("CrUser");
            ContextHelper.initContext(User.getSystem());
            this.m_oScheduleUser = User.findByName(string);
            if (this.m_oScheduleUser == null || this.m_oScheduleUser.getStatus() != 30 || this.m_oScheduleUser.isDeleted()) {
                this.m_oScheduleUser = User.getSystem();
            }
            ContextHelper.setLoginUser(this.m_oScheduleUser);
            return true;
        }
        catch (Exception exception) {
            logger.error((Object)"excute schedule publish failed", (Throwable)exception);
            return false;
        }
    }

    protected void execute() throws WCMException {
        if (!this.analyzeParams()) {
            throw new WCMException(1100, "\u5206\u6790\u8ba1\u5212\u53d1\u5e03\u7684\u53c2\u6570\u5931\u8d25!");
        }
        ContextParameters.set(7, Boolean.TRUE);
        ContextHelper.setArg(LogServer.CONTEXT_INDEX_IP, "127.0.0.1");
        IPublishElement iPublishElement = PublishElementFactory.lookupElement(this.m_nSenderType, this.m_nSenderId);
        if (iPublishElement == null) {
            logger.error((Object)"publish failed,no element to publish!");
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("schedule publish[" + iPublishElement.getInfo() + "] begin...."));
        }
        if (iPublishElement instanceof IPublishContent) {
            this.publishContent((IPublishContent)iPublishElement);
        } else if (iPublishElement instanceof IPublishFolder) {
            this.publishFolder((IPublishFolder)iPublishElement);
        } else {
            logger.error((Object)("schedule publish[" + iPublishElement.getInfo() + "] failed,not a valid element!"));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("schedule publish[" + iPublishElement.getInfo() + "] end."));
        }
    }

    private void publishFolder(IPublishFolder iPublishFolder) throws WCMException {
        Object object;
        if (iPublishFolder.isDeleted()) {
            return;
        }
        int n = 1;
        try {
            object = iPublishFolder.getIncreasedContents(null);
            if (!iPublishFolder.isRoot() && (object == null || object.isEmpty())) {
                if (!"1".equals(iPublishFolder.getSubstance().getAttributeValue("FORCESCHEDULEPUB"))) {
                    return;
                }
                n = 8;
            }
        }
        catch (Exception exception) {
            logger.error((Object)("\u6784\u9020\u6307\u5b9a\u7684[" + iPublishFolder.getInfo() + "]\u589e\u91cf\u53d1\u5e03\u5185\u5bb9\u5931\u8d25\uff01"), (Throwable)exception);
            return;
        }
        try {
            object = PublishServer.getInstance();
            ((PublishServer)object).publishFolder(iPublishFolder, n);
        }
        catch (Exception exception) {
            logger.error((Object)("schedule publish[" + iPublishFolder.getInfo() + "] failed!"), (Throwable)exception);
            throw new WCMException(1100, "\u8ba1\u5212\u53d1\u5e03\u5931\u8d25!", exception);
        }
    }

    private void publishContent(IPublishContent iPublishContent) throws WCMException {
        try {
            PublishServer publishServer = PublishServer.getInstance();
            iPublishContent.setFolder(iPublishContent.getOriginalHome());
            if (iPublishContent.getType() == 605) {
                boolean bl;
                Document document = (Document)iPublishContent.getSubstance();
                if (document == null || document.isDeleted()) {
                    return;
                }
                DocumentMgr documentMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
                Channels channels = documentMgr.getQutoedChannels(document, 0, null);
                channels.addElement(document.getChannelId());
                boolean bl2 = bl = !this.m_oScheduleUser.isAdministrator() && this.m_oScheduleUser.getId() != 0;
                if (bl) {
                    int n = 39;
                    for (int i = channels.size() - 1; i >= 0; --i) {
                        Channel channel = (Channel)channels.getAt(i);
                        if (channel == null || AuthServer.hasRight(this.m_oScheduleUser, (CMSObj)channel, n)) continue;
                        channels.removeAt(i, false);
                    }
                }
                if (channels.isEmpty()) {
                    return;
                }
                IPublishElements iPublishElements = PublishElementFactory.makeElementsFrom(channels);
                publishServer.publishContent(iPublishContent, iPublishElements);
            } else {
                publishServer.publishContent(iPublishContent);
            }
        }
        catch (Exception exception) {
            logger.error((Object)("schedule publish[" + iPublishContent.getInfo() + "] failed!"), (Throwable)exception);
            throw new WCMException(1100, "\u8ba1\u5212\u53d1\u5e03\u5931\u8d25!", exception);
        }
    }
}

