/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish;

import com.trs.DreamFactory;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.job.Schedule;
import com.trs.components.common.publish.domain.publisher.PublishPathCompass;
import com.trs.components.common.publish.domain.template.TemplateEmployMgr;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.persistent.publisher.FolderPublishConfig;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.common.publish.persistent.template.Templates;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.publish.WCMPubStatusConfig;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;

public class WCMFolderPublishConfig
extends CMSObj {
    protected boolean m_bCheckPropertyValid = false;
    private boolean m_bSaveing = false;
    private Schedule m_oSchedule = null;
    private FolderPublishConfig m_oFolderPublishConfig = null;
    private BaseChannel m_oChannel = null;
    private WCMPubStatusConfig m_oStatusConfig = null;
    private IPublishFolder m_oFolder = null;
    public static final int OBJ_TYPE = 1326635776;
    public static final String DB_TABLE_NAME = "WCMFOLDERPUBLISHINFO";
    public static final String DB_ID_NAME = "FOLDERPUBLISHCONFIGID";
    private boolean m_bIsSavePublishConfig = true;
    private boolean m_bScheduleInited = false;
    private boolean m_bFolderPublishConfigInited = false;
    private boolean m_bWCMPubStatusConfigInited = false;

    public WCMFolderPublishConfig() {
    }

    public WCMFolderPublishConfig(IPublishFolder iPublishFolder) {
        this.m_bSaveing = false;
        try {
            this.setFolderType(iPublishFolder.getType(), iPublishFolder.getId());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.m_oChannel = (BaseChannel)iPublishFolder.getSubstance();
        this.id = iPublishFolder.getId();
        this.m_oFolder = iPublishFolder;
    }

    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    public int getWCMType() {
        return 1326635776 + this.getFolderType();
    }

    public int getFolderType() {
        return this.getPropertyAsInt("FOLDERTYPE", 0);
    }

    public boolean setFolderType(int n, int n2) throws WCMException {
        return this.setProperty("FOLDERTYPE", n) && this.setProperty("FOLDERID", n2);
    }

    public int getFolderId() {
        return this.getPropertyAsInt("FOLDERID", 0);
    }

    public String getOutlineFileName() throws WCMException {
        if (!this.m_bSaveing && this.isDefineFileRule()) {
            return this.getFolderPublishConfig().getOutlineFileName();
        }
        return this.getPropertyAsString("OUTLINEFILENAME");
    }

    public boolean setOutlineFileName(String string) throws WCMException {
        return this.setProperty("OUTLINEFILENAME", string);
    }

    public String getDetailFileExt() throws WCMException {
        if (!this.m_bSaveing && this.isDefineFileRule()) {
            return this.getFolderPublishConfig().getDetailFileExt();
        }
        return this.getPropertyAsString("DETAILFILEEXT");
    }

    public boolean setDetailFileExt(String string) throws WCMException {
        return this.setProperty("DETAILFILEEXT", string);
    }

    public String getDataPath() throws WCMException {
        if (!this.m_bSaveing && this.isDefineFileRule()) {
            return this.getFolderPublishConfig().getDataPath();
        }
        return this.getPropertyAsString("DATAPATH");
    }

    public boolean setDataPath(String string) throws WCMException {
        return this.setProperty("DATAPATH", string);
    }

    public String getRootDomain() throws WCMException {
        if (!this.m_bSaveing && this.isDefineFileRule()) {
            return this.getFolderPublishConfig().getRootDomain();
        }
        return this.getPropertyAsString("ROOTDOMAIN");
    }

    public boolean setRootDomain(String string) throws WCMException {
        return this.setProperty("ROOTDOMAIN", string);
    }

    public String getOutlineTemplateIds() throws WCMException {
        if (!this.m_bSaveing) {
            Templates templates = null;
            templates = this.getTemplateEmployMgr().getOutlineTemplates(this.getFolder());
            return templates.getIdListAsString();
        }
        return this.getPropertyAsString("OUTLINETEMPLATEID");
    }

    public int getDefaultOutlineTemplateId() throws WCMException {
        Template template = this.getTemplateEmployMgr().getDefaultOutlineTemplate(this.getFolder());
        if (template == null) {
            return 0;
        }
        return template.getId();
    }

    public String getOtherOutlineTemplateIds() throws WCMException {
        Templates templates = this.getTemplateEmployMgr().getOtherOutlineTemplates(this.getFolder());
        return templates.getIdListAsString();
    }

    public boolean setOutlineTemplateId(String string) throws WCMException {
        return this.setProperty("OUTLINETEMPLATEID", string, false);
    }

    public int getDetailTemplateId() throws WCMException {
        if (!this.m_bSaveing) {
            Template template = this.getTemplateEmployMgr().getDetailTemplate(this.getFolder());
            return template == null ? 0 : template.getId();
        }
        return this.getPropertyAsInt("DETAILTEMPLATEID", 0);
    }

    public boolean setDetailTemplateId(int n) throws WCMException {
        return this.setProperty("DETAILTEMPLATEID", n);
    }

    public boolean setInfoviewPrintTemplateId(int n) throws WCMException {
        return this.setProperty("INFOVIEWPRINTTEMPLATEID", n);
    }

    public int getInfoviewPrintTemplateId() throws WCMException {
        if (!this.m_bSaveing) {
            Template template = this.getTemplateEmployMgr().getDetailTemplate(this.getFolder(), 3);
            return template == null ? 0 : template.getId();
        }
        return this.getPropertyAsInt("InfoviewPrintTemplateId", 0);
    }

    public String getStatusesCanDoPub() throws WCMException {
        if (!this.m_bSaveing) {
            if (this.getStatusConfig() == null) {
                return "";
            }
            return this.getStatusConfig().getStatusesCanDoPub();
        }
        return this.getPropertyAsString("STATUSESCANDOPUB");
    }

    public boolean setStatusesCanDoPub(String string) throws WCMException {
        return this.setProperty("STATUSESCANDOPUB", string);
    }

    public int getStatusIdAfterModify() throws WCMException {
        if (!this.m_bSaveing) {
            if (this.getStatusConfig() == null) {
                return 0;
            }
            return this.getStatusConfig().getStatusIdAfterModify();
        }
        return this.getPropertyAsInt("STATUSIDAFTERMODIFY", 0);
    }

    public boolean setStatusIdAfterModify(int n) throws WCMException {
        return this.setProperty("STATUSIDAFTERMODIFY", n);
    }

    public int getScheduleMode() throws WCMException {
        if (!this.m_bSaveing && this.isDefineSchedule()) {
            return this.getSchedule().getMode();
        }
        return this.getPropertyAsInt("SCHEDULEMODE", 0);
    }

    public int getScheduleId() throws WCMException {
        Schedule schedule = this.getSchedule();
        return schedule == null ? 0 : schedule.getId();
    }

    public boolean setScheduleMode(int n) throws WCMException {
        return this.setProperty("SCHEDULEMODE", n);
    }

    public String getStartTime() throws WCMException {
        if (!this.m_bSaveing && this.isDefineSchedule()) {
            return this.getSchedule().getStartTime().toString("HH:mm");
        }
        return this.getPropertyAsString("STARTTIME");
    }

    public boolean setStartTime(String string) throws WCMException {
        return this.setProperty("STARTTIME", string);
    }

    public String getEndTime() throws WCMException {
        if (!this.m_bSaveing && this.isDefineSchedule()) {
            return this.getSchedule().getEndTime().toString("HH:mm");
        }
        return this.getPropertyAsString("ENDTIME");
    }

    public boolean setEndTime(String string) throws WCMException {
        return this.setProperty("ENDTIME", string);
    }

    public int getInterval() throws WCMException {
        if (!this.m_bSaveing && this.isDefineSchedule()) {
            return this.getSchedule().getParam();
        }
        return this.getPropertyAsInt("INTERVAL", 0);
    }

    public boolean setInterval(int n) throws WCMException {
        return this.setProperty("INTERVAL", n);
    }

    public String getExecTime() throws WCMException {
        if (!this.m_bSaveing && this.isDefineSchedule()) {
            return this.getSchedule().getExeTime().toString("HH:mm");
        }
        return this.getPropertyAsString("EXECTIME");
    }

    public boolean setExecTime(String string) throws WCMException {
        return this.setProperty("EXECTIME", string);
    }

    public boolean isDefineFileRule() throws WCMException {
        if (!this.m_bSaveing) {
            return this.getFolderPublishConfig() != null;
        }
        return this.getPropertyAsBoolean("DEFINEFILERULE", false);
    }

    public boolean setDefineFileRule(boolean bl) throws WCMException {
        return this.setProperty("DEFINEFILERULE", bl);
    }

    public boolean isDefineSchedule() throws WCMException {
        if (!this.m_bSaveing) {
            return this.getSchedule() != null;
        }
        return this.getPropertyAsBoolean("DEFINESCHEDULE", false);
    }

    public boolean setDefineSchedule(boolean bl) throws WCMException {
        return this.setProperty("DEFINESCHEDULE", bl);
    }

    public boolean isDefineStatus() throws WCMException {
        if (!this.m_bSaveing) {
            return this.getStatusConfig() != null;
        }
        return this.getPropertyAsBoolean("DEFINESTATUS", false);
    }

    public boolean setDefineStatus(boolean bl) throws WCMException {
        return this.setProperty("DEFINESTATUS", bl);
    }

    public boolean isResetChildrenTemplates() {
        return this.getPropertyAsBoolean("ISRESETCHILDRENTEMPLATES", false);
    }

    public boolean setIsResetChildrenTemplates(boolean bl) throws WCMException {
        return this.setProperty("ISRESETCHILDRENTEMPLATES", bl);
    }

    public int getSiteLanguage() throws WCMException {
        if (!this.m_bSaveing && this.isDefineFileRule()) {
            return this.getFolderPublishConfig().getSiteLanguage();
        }
        return this.getPropertyAsInt("SITELANGUAGE", 0);
    }

    public boolean setSiteLanguage(int n) throws WCMException {
        return this.setProperty("SITELANGUAGE", n);
    }

    public String getPageEncoding() throws WCMException {
        if (!this.m_bSaveing && this.isDefineFileRule()) {
            return this.getFolderPublishConfig().getPageEncoding();
        }
        return this.getPropertyAsString("PAGEENCODING");
    }

    public boolean setPageEncoding(String string) throws WCMException {
        return this.setProperty("PAGEENCODING", string);
    }

    public boolean isValid() throws WCMException {
        if (this.getProperty("DEFINEFILERULE") != null && !this.getPropertyAsBoolean("DEFINEFILERULE", false)) {
            this.setSavePublishConfig(false);
        }
        if (this.getProperty("FOLDERTYPE") == null) {
            throw new WCMException(1106, I18NMessage.get(WCMFolderPublishConfig.class, "WCMFolderPublishConfig.label1", "\u5c5e\u6027FolderType\u6ca1\u6709\u8bbe\u7f6e(WCMFolderPublishConfig.isValid)"));
        }
        if (this.getProperty("FOLDERID") == null) {
            throw new WCMException(1106, I18NMessage.get(WCMFolderPublishConfig.class, "WCMFolderPublishConfig.label2", "\u5c5e\u6027FolderId\u6ca1\u6709\u8bbe\u7f6e(WCMFolderPublishConfig.isValid)"));
        }
        String string = this.getFinalPropertyAsString("DATAPATH", "");
        if (string.matches("^.*[\\.\\\\//].*$")) {
            throw new WCMException("The datapath contains invalid chars [.\\/].");
        }
        return true;
    }

    public void insert(User user) throws WCMException {
        throw new WCMException(I18NMessage.get(WCMFolderPublishConfig.class, "WCMFolderPublishConfig.label3", "\u7981\u6b62\u7684\u64cd\u4f5c\uff01"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(User user) throws WCMException {
        if (this.id <= 0) {
            this.id = this.getFolderId();
        }
        if (!this.isLocked() || !this.getLocker(false).lockUserIs(user)) {
            throw new WCMException(1012, I18NMessage.get(WCMFolderPublishConfig.class, "WCMFolderPublishConfig.label4", "\u5bf9\u8c61\u6ca1\u6709\u9501\u5b9a\u6216\u5176\u4ed6\u7528\u6237\u6b63\u5728\u4fee\u6539!\u5f53\u524d\u64cd\u4f5c\u7684\u7528\u6237:[") + user + I18NMessage.get(WCMFolderPublishConfig.class, "WCMFolderPublishConfig.label5", "] \u9501\u5b9a\u7684\u7528\u6237:[") + this.getLockerUser() + "]");
        }
        try {
            this.m_bSaveing = true;
            this.isValid();
            if (this.isSavePublishConfig()) {
                this.saveTemplateEmploys();
                this.saveFolderPublishConfig(user);
                this.saveWCMPubStatusConfig(user);
            }
            this.saveScheduleInfo(user);
            this.m_bSaveing = false;
            Object var3_2 = null;
            this.bAddMode = false;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.bAddMode = false;
            if (this.isLocked() && this.getLocker(false).lockUserIs(user)) {
                this.unlock();
            }
            throw throwable;
        }
        if (this.isLocked() && this.getLocker(false).lockUserIs(user)) {
            this.unlock();
        }
    }

    public synchronized void update(User user) throws WCMException {
        throw new WCMException(I18NMessage.get(WCMFolderPublishConfig.class, "WCMFolderPublishConfig.label3", "\u7981\u6b62\u7684\u64cd\u4f5c\uff01"));
    }

    public void insert() throws WCMException {
        throw new WCMException(I18NMessage.get(WCMFolderPublishConfig.class, "WCMFolderPublishConfig.label3", "\u7981\u6b62\u7684\u64cd\u4f5c\uff01"));
    }

    public void save() throws WCMException {
        throw new WCMException(I18NMessage.get(WCMFolderPublishConfig.class, "WCMFolderPublishConfig.label3", "\u7981\u6b62\u7684\u64cd\u4f5c\uff01"));
    }

    public synchronized void update() throws WCMException {
        throw new WCMException(I18NMessage.get(WCMFolderPublishConfig.class, "WCMFolderPublishConfig.label3", "\u7981\u6b62\u7684\u64cd\u4f5c\uff01"));
    }

    private void saveScheduleInfo(User user) throws WCMException {
        if (!this.containsProperty("DEFINESCHEDULE")) {
            return;
        }
        Schedule schedule = this.getSchedule();
        if (!this.isDefineSchedule()) {
            if (schedule == null) {
                return;
            }
            schedule.delete(user);
            return;
        }
        try {
            int n = this.getScheduleMode();
            if (schedule == null) {
                if (n != 0) {
                    this.m_oSchedule = this.saveScheduleInfo(user, Schedule.createNewInstance(), n, this.getStartTime(), this.getEndTime(), this.getInterval(), this.getExecTime());
                }
            } else if (n != 0) {
                this.m_oSchedule = this.saveScheduleInfo(user, schedule, n, this.getStartTime(), this.getEndTime(), this.getInterval(), this.getExecTime());
            } else {
                schedule.delete(user);
                this.m_oSchedule = null;
            }
        }
        catch (CMyException cMyException) {
            throw new WCMException(I18NMessage.get(WCMFolderPublishConfig.class, "WCMFolderPublishConfig.label6", "\u8ba1\u5212\u53d1\u5e03\u7684\u65e5\u671f\u6570\u636e\u6709\u8bef\uff01"), cMyException);
        }
    }

    private Schedule saveScheduleInfo(User user, Schedule schedule, int n, String string, String string2, int n2, String string3) throws WCMException {
        try {
            CMyDateTime cMyDateTime = new CMyDateTime();
            if (schedule.isAddMode()) {
                String string4 = this.getFolder().getInfo() + I18NMessage.get(WCMFolderPublishConfig.class, "WCMFolderPublishConfig.label7", "-\u8ba1\u5212\u53d1\u5e03");
                schedule.setName(string4);
                schedule.setDesc(string4);
                schedule.setWorkerType(4);
                schedule.setSender(this.getFolderType(), this.getFolderId());
            } else if (!schedule.canEdit(user)) {
                throw new WCMException(I18NMessage.get(WCMFolderPublishConfig.class, "WCMFolderPublishConfig.label8", "Schedule\u88ab\uff3b") + schedule.getLockerUserName() + I18NMessage.get(WCMFolderPublishConfig.class, "WCMFolderPublishConfig.label9", "\uff3d\u9501\u5b9a"));
            }
            schedule.setMode(n);
            switch (n) {
                case 1: {
                    cMyDateTime.setDateTimeWithString("2005-04-01 " + string3);
                    schedule.setExeTime(cMyDateTime);
                    break;
                }
                case 2: {
                    cMyDateTime = CMyDateTime.now();
                    cMyDateTime.setTimeWithString(string + ":00", 0);
                    schedule.setStartTime(cMyDateTime);
                    cMyDateTime = CMyDateTime.now();
                    cMyDateTime.setTimeWithString(string2 + ":00", 0);
                    schedule.setEndTime(cMyDateTime);
                    schedule.setParam(n2);
                    break;
                }
                case 3: {
                    cMyDateTime.setDateTimeWithString(string3);
                    schedule.setExeTime(cMyDateTime);
                }
            }
            schedule.save(user);
            return schedule;
        }
        catch (CMyException cMyException) {
            throw new WCMException(I18NMessage.get(WCMFolderPublishConfig.class, "WCMFolderPublishConfig.label6", "\u8ba1\u5212\u53d1\u5e03\u7684\u65e5\u671f\u6570\u636e\u6709\u8bef\uff01"), cMyException);
        }
    }

    public static final WCMFolderPublishConfig findById(int n) throws WCMException {
        if (n <= 0) {
            return null;
        }
        return (WCMFolderPublishConfig)BaseObj.findById(WCMFolderPublishConfig.class, n);
    }

    public static final WCMFolderPublishConfig createNewInstance() throws WCMException {
        return (WCMFolderPublishConfig)BaseObj.createNewInstance(WCMFolderPublishConfig.class);
    }

    public static final WCMFolderPublishConfig findByKey(Object object) throws WCMException {
        return (WCMFolderPublishConfig)BaseObj.findByKey(WCMFolderPublishConfig.class, object);
    }

    private BaseChannel getChannel() throws WCMException {
        if (this.m_oChannel == null) {
            this.initChannel();
        }
        return this.m_oChannel;
    }

    private void initChannel() throws WCMException {
        BaseChannel baseChannel = (BaseChannel)BaseObj.findById(this.getFolderType(), this.getFolderId());
        if (baseChannel == null) {
            throw new WCMException(I18NMessage.get(WCMFolderPublishConfig.class, "WCMFolderPublishConfig.label10", "\u6307\u5b9a\u7684FolderType[") + this.getFolderType() + I18NMessage.get(WCMFolderPublishConfig.class, "WCMFolderPublishConfig.label11", "]\u548cFolderId[") + this.getFolderId() + I18NMessage.get(WCMFolderPublishConfig.class, "WCMFolderPublishConfig.label12", "]\u65e0\u6548\uff01"));
        }
        this.setChannel(baseChannel);
    }

    private void setChannel(BaseChannel baseChannel) {
        this.m_oChannel = baseChannel;
    }

    private FolderPublishConfig getFolderPublishConfig() throws WCMException {
        if (this.m_oFolderPublishConfig == null) {
            this.initFolderPublishConfig();
        }
        return this.m_oFolderPublishConfig;
    }

    private void initFolderPublishConfig() throws WCMException {
        if (this.m_bFolderPublishConfigInited) {
            return;
        }
        this.setFolderPublishConfig(FolderPublishConfig.findOf(this.getFolderType(), this.getFolderId()));
        this.m_bFolderPublishConfigInited = true;
    }

    private void setFolderPublishConfig(FolderPublishConfig folderPublishConfig) {
        this.m_oFolderPublishConfig = folderPublishConfig;
    }

    private Schedule getSchedule() throws WCMException {
        if (this.m_oSchedule == null) {
            this.initSchedule();
        }
        return this.m_oSchedule;
    }

    private void initSchedule() throws WCMException {
        if (this.m_bScheduleInited) {
            return;
        }
        this.setSchedule(Schedule.findBySender(4, this.getChannel()));
        this.m_bScheduleInited = true;
    }

    private void setSchedule(Schedule schedule) {
        this.m_oSchedule = schedule;
    }

    private WCMPubStatusConfig getStatusConfig() throws WCMException {
        if (this.m_oStatusConfig == null) {
            this.initWCMPubStatusConfig();
        }
        return this.m_oStatusConfig;
    }

    private void initWCMPubStatusConfig() throws WCMException {
        if (this.m_bWCMPubStatusConfigInited) {
            return;
        }
        this.setStatusConfig(WCMPubStatusConfig.findOf(this.getFolderType(), this.getFolderId()));
        this.m_bWCMPubStatusConfigInited = true;
    }

    private void setStatusConfig(WCMPubStatusConfig wCMPubStatusConfig) {
        this.m_oStatusConfig = wCMPubStatusConfig;
    }

    protected TemplateEmployMgr getTemplateEmployMgr() {
        return (TemplateEmployMgr)DreamFactory.createObjectById("TemplateEmployMgr");
    }

    private void saveFolderPublishConfig(User user) throws WCMException {
        FolderPublishConfig folderPublishConfig = this.getFolderPublishConfig();
        if (folderPublishConfig == null) {
            folderPublishConfig = FolderPublishConfig.createNewInstance();
        } else if (!folderPublishConfig.canEdit(user)) {
            throw new WCMException(I18NMessage.get(WCMFolderPublishConfig.class, "WCMFolderPublishConfig.label13", "\u5bf9\u8c61\u88ab\u7528\u6237[") + folderPublishConfig.getLockerUserName() + I18NMessage.get(WCMFolderPublishConfig.class, "WCMFolderPublishConfig.label14", "]\u9501\u5b9a\uff0c\u4e0d\u80fd\u4fee\u6539!"));
        }
        if (folderPublishConfig.isAddMode()) {
            folderPublishConfig.setFolder(this.getFolderType(), this.getFolderId());
        }
        if (this.getDataPath() != null) {
            folderPublishConfig.setDataPath(this.getDataPath());
        }
        if (this.getDetailFileExt() != null) {
            folderPublishConfig.setDetailFileExt(this.getDetailFileExt());
        }
        if (this.getOutlineFileName() != null) {
            folderPublishConfig.setOutlineFileName(this.getOutlineFileName());
        }
        if (this.getRootDomain() != null) {
            folderPublishConfig.setRootDomain(this.getRootDomain());
        }
        if (this.getSiteLanguage() != 0) {
            folderPublishConfig.setSiteLanguage(this.getSiteLanguage());
        }
        if (this.getPageEncoding() != null) {
            folderPublishConfig.setPageEncoding(this.getPageEncoding());
        }
        if (folderPublishConfig.isAddMode() && folderPublishConfig.getProperties().size() > 2 || folderPublishConfig.getNewProperties() != null) {
            folderPublishConfig.save(user);
        }
        this.m_oFolderPublishConfig = folderPublishConfig;
    }

    private void saveTemplateEmploys() throws WCMException {
        TemplateEmployMgr templateEmployMgr = this.getTemplateEmployMgr();
        if (this.isAddMode() && this.containsProperty("DETAILTEMPLATEID") || this.containsNewProperty("DETAILTEMPLATEID")) {
            templateEmployMgr.setDetailTemplate(this.getFolder(), this.getDetailTemplateId(), this.isResetChildrenTemplates());
        }
        if (this.getOutlineTemplateIds() != null) {
            templateEmployMgr.setOutlineTemplates(this.getFolder(), this.getOutlineTemplateIds(), this.isResetChildrenTemplates());
        }
        if (this.isAddMode() && this.containsProperty("INFOVIEWPRINTTEMPLATEID")) {
            templateEmployMgr.setDetailTemplate(this.getFolder(), this.getInfoviewPrintTemplateId(), this.isResetChildrenTemplates(), 3);
        }
    }

    public String getURL() throws WCMException {
        PublishPathCompass publishPathCompass = new PublishPathCompass();
        return publishPathCompass.getAbsoluteHttpPath(this.getFolder());
    }

    public IPublishFolder getFolder() throws WCMException {
        if (this.m_oFolder == null) {
            this.m_oFolder = (IPublishFolder)PublishElementFactory.makeElementFrom(this.getChannel());
        }
        return this.m_oFolder;
    }

    private void saveWCMPubStatusConfig(User user) throws WCMException {
        if (!this.containsProperty("DEFINESTATUS")) {
            return;
        }
        WCMPubStatusConfig wCMPubStatusConfig = this.getStatusConfig();
        if (!this.isDefineStatus()) {
            if (wCMPubStatusConfig == null) {
                return;
            }
            wCMPubStatusConfig.delete(user);
            return;
        }
        if (wCMPubStatusConfig == null) {
            wCMPubStatusConfig = WCMPubStatusConfig.createNewInstance();
        } else if (!wCMPubStatusConfig.canEdit(user)) {
            throw new WCMException(I18NMessage.get(WCMFolderPublishConfig.class, "WCMFolderPublishConfig.label15", "\u5bf9\u8c61\u88ab[") + wCMPubStatusConfig.getLockerUserName() + I18NMessage.get(WCMFolderPublishConfig.class, "WCMFolderPublishConfig.label14", "]\u9501\u5b9a\uff0c\u4e0d\u80fd\u4fee\u6539!"));
        }
        wCMPubStatusConfig.setFolderType(this.getChannel());
        wCMPubStatusConfig.setStatusesCanDoPub(this.getStatusesCanDoPub());
        wCMPubStatusConfig.setStatusIdAfterModify(this.getStatusIdAfterModify());
        wCMPubStatusConfig.save(user);
    }

    public static final WCMFolderPublishConfig findOf(int n, int n2) throws WCMException {
        WCMFolderPublishConfig wCMFolderPublishConfig = WCMFolderPublishConfig.createNewInstance();
        wCMFolderPublishConfig.m_bSaveing = false;
        wCMFolderPublishConfig.setFolderType(n, n2);
        wCMFolderPublishConfig.m_oChannel = (BaseChannel)BaseObj.findById(n, n2);
        wCMFolderPublishConfig.id = n2;
        return wCMFolderPublishConfig;
    }

    public boolean canEdit(User user) {
        if (this.id <= 0) {
            this.id = this.getFolderId();
        }
        return super.canEdit(user);
    }

    public boolean isValidInstance() {
        return true;
    }

    public boolean isSavePublishConfig() {
        return this.m_bIsSavePublishConfig;
    }

    public void setSavePublishConfig(boolean bl) {
        this.m_bIsSavePublishConfig = bl;
    }
}

