/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.job.Schedules;
import com.trs.components.common.publish.domain.PublishServer;
import com.trs.components.common.publish.domain.publisher.PageDestroyer;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.publish.WCMPubStatusConfig;
import com.trs.infra.I18NMessage;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.listener.IObjectLCListenerOnDel;
import com.trs.infra.persistent.listener.IObjectLCListenerOnModify;
import org.apache.log4j.Logger;

public class WCMFolderLCListener
implements IObjectLCListenerOnDel,
IObjectLCListenerOnModify {
    private static Logger logger = Logger.getLogger(WCMFolderLCListener.class);

    public void notifyOnDelObj(BaseObj baseObj, int n) {
        CMSObj cMSObj;
        if (!(baseObj instanceof BaseChannel)) {
            logger.error((Object)("Listener[" + this.getClass() + I18NMessage.get(WCMFolderLCListener.class, "WCMFolderLCListener.label1", "]\u4e0d\u80fd\u76d1\u542c\u5bf9\u8c61[") + baseObj.getClass() + I18NMessage.get(WCMFolderLCListener.class, "WCMFolderLCListener.label2", "]\u7684\u5220\u9664\uff01")));
            return;
        }
        BaseChannel baseChannel = (BaseChannel)baseObj;
        try {
            cMSObj = WCMPubStatusConfig.findOf(baseChannel.getWCMType(), baseChannel.getId());
            if (cMSObj != null) {
                cMSObj.delete(ContextHelper.getLoginUser());
            }
        }
        catch (Throwable throwable) {
            logger.error((Object)(I18NMessage.get(WCMFolderLCListener.class, "WCMFolderLCListener.label3", "\u5220\u9664[") + baseChannel.getInfo() + I18NMessage.get(WCMFolderLCListener.class, "WCMFolderLCListener.label4", "]\u53ef\u53d1\u5e03\u72b6\u6001\u914d\u7f6e\u4fe1\u606f\u5931\u8d25!")), throwable);
        }
        try {
            cMSObj = User.getSystem();
            try {
                cMSObj = ContextHelper.getLoginUser();
            }
            catch (Exception exception) {
                // empty catch block
            }
            Schedules schedules = new Schedules((User)cMSObj);
            WCMFilter wCMFilter = new WCMFilter("", "", "");
            wCMFilter.setWhere("SENDERTYPE=? and SENDERID=?");
            wCMFilter.addSearchValues(baseChannel.getWCMType());
            wCMFilter.addSearchValues(baseChannel.getId());
            schedules.open(wCMFilter);
            schedules.removeAll(true);
        }
        catch (Throwable throwable) {
            logger.error((Object)"clear schedule on object delete failed.", throwable);
        }
        if (baseChannel.isDeleted()) {
            return;
        }
        try {
            PageDestroyer.withdraw((IPublishFolder)PublishElementFactory.makeElementFrom(baseChannel), null);
        }
        catch (Throwable throwable) {
            logger.error((Object)(I18NMessage.get(WCMFolderLCListener.class, "WCMFolderLCListener.label5", "\u540c\u6b65\u64a4\u9664[") + baseChannel.getInfo() + I18NMessage.get(WCMFolderLCListener.class, "WCMFolderLCListener.label6", "]\u53d1\u5e03\u76ee\u5f55\u51fa\u73b0\u5f02\u5e38\uff01")), throwable);
        }
    }

    public void notifyOnModifyObj(BaseObj baseObj, int n) {
        if (!(baseObj instanceof BaseChannel)) {
            logger.error((Object)("Listener[" + this.getClass() + I18NMessage.get(WCMFolderLCListener.class, "WCMFolderLCListener.label1", "]\u4e0d\u80fd\u76d1\u542c\u5bf9\u8c61[") + baseObj.getClass() + I18NMessage.get(WCMFolderLCListener.class, "WCMFolderLCListener.label7", "]\u7684\u4fee\u6539\uff01")));
            return;
        }
        BaseChannel baseChannel = (BaseChannel)baseObj;
        int n2 = baseChannel.getNewPropertyAsInt("STATUS", 0);
        boolean bl = n2 == -1;
        boolean bl2 = baseChannel.isChangeProperty("SITEID");
        IPublishFolder iPublishFolder = null;
        try {
            iPublishFolder = (IPublishFolder)PublishElementFactory.makeElementFrom(baseChannel);
        }
        catch (Throwable throwable) {
            logger.error((Object)(I18NMessage.get(WCMFolderLCListener.class, "WCMFolderLCListener.label8", "\u6784\u9020[") + baseChannel.getInfo() + I18NMessage.get(WCMFolderLCListener.class, "WCMFolderLCListener.label9", "]Folder\u51fa\u73b0\u5f02\u5e38\uff01")), throwable);
        }
        try {
            if (bl || bl2) {
                PublishServer.getInstance().deleteFolder(iPublishFolder, false);
            }
        }
        catch (Throwable throwable) {
            logger.error((Object)(I18NMessage.get(WCMFolderLCListener.class, "WCMFolderLCListener.label5", "\u540c\u6b65\u64a4\u9664[") + baseChannel.getInfo() + I18NMessage.get(WCMFolderLCListener.class, "WCMFolderLCListener.label6", "]\u53d1\u5e03\u76ee\u5f55\u51fa\u73b0\u5f02\u5e38\uff01")), throwable);
        }
    }
}

