/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish;

import com.trs.DreamFactory;
import com.trs.components.common.publish.domain.PublishServer;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.wcm.content.domain.DocumentMgr;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.components.wcm.publish.domain.PreNextDocumentsImpl;
import com.trs.components.wcm.publish.element.PublishContentDocumentImpl;
import com.trs.infra.common.WCMException;
import org.apache.log4j.Logger;

public class PreNextPageRefresher {
    private static final Logger LOG = Logger.getLogger(PreNextPageRefresher.class);
    private Document m_oDocument;
    private PublishServer m_oPublishServer;

    public PreNextPageRefresher(Document document) {
        this.m_oDocument = document;
    }

    public void refresh() throws WCMException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"enter refreshPreNextPages.");
        }
        this.m_oPublishServer = PublishServer.getInstance();
        this.refreshPreNext(this.m_oDocument.getChannel());
        DocumentMgr documentMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
        Channels channels = documentMgr.getQutoedChannels(this.m_oDocument, 3, null);
        if (channels == null || channels.isEmpty()) {
            return;
        }
        int n = channels.size();
        for (int i = 0; i < n; ++i) {
            Channel channel = (Channel)channels.getAt(i);
            if (channel == null || channel.isDeleted()) continue;
            this.refreshPreNext(channel);
        }
    }

    private void refreshPreNext(Channel channel) throws WCMException {
        PreNextDocumentsImpl preNextDocumentsImpl;
        Documents[] documentsArray;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("refresh prenext of: " + channel));
        }
        if ((documentsArray = (preNextDocumentsImpl = new PreNextDocumentsImpl()).getPreNextDocuments(channel, this.m_oDocument, 1)) != null) {
            this.refreshDocs(channel, documentsArray[0]);
            this.refreshDocs(channel, documentsArray[1]);
            documentsArray[0] = null;
            documentsArray[1] = null;
        }
    }

    private void refreshDocs(Channel channel, Documents documents) throws WCMException {
        if (documents == null || documents.isEmpty()) {
            return;
        }
        Document document = (Document)documents.getAt(0);
        if (document != null && 10 == document.getStatusId()) {
            this.publishDoc(document.getId(), channel);
        }
        documents.clear();
    }

    private void publishDoc(int n, Channel channel) throws WCMException {
        Document document = Document.findById(n, "DocId,DocTitle,DocChannel");
        IPublishFolder iPublishFolder = (IPublishFolder)PublishElementFactory.makeElementFrom(channel);
        PublishContentDocumentImpl publishContentDocumentImpl = new PublishContentDocumentImpl(document);
        publishContentDocumentImpl.setFolder(iPublishFolder);
        this.m_oPublishServer.publishContent((IPublishContent)publishContentDocumentImpl, 8);
    }
}

