/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish;

import com.trs.components.wcm.publish.IFolderPubStatusCacheMgr;
import com.trs.components.wcm.publish.WCMPubStatusConfig;
import com.trs.components.wcm.publish.WCMPubStatusConfigs;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.util.CMyString;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class FolderPubStatusCacheMgrImpl
implements IFolderPubStatusCacheMgr {
    private static Logger logger = Logger.getLogger(FolderPubStatusCacheMgrImpl.class);
    private Map m_mapCache = null;

    public int[] findStatusesCanDoPub(int n, int n2) throws WCMException {
        int[][] nArray;
        if (this.m_mapCache == null) {
            this.init();
        }
        if ((nArray = (int[][])this.m_mapCache.get(n + "_" + n2)) == null) {
            return null;
        }
        return nArray[0];
    }

    public int[] findStatusesCanDoIncreasePub(int n, int n2) throws WCMException {
        int[][] nArray;
        if (this.m_mapCache == null) {
            this.init();
        }
        if ((nArray = (int[][])this.m_mapCache.get(n + "_" + n2)) == null) {
            return null;
        }
        return nArray[1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean init() throws WCMException {
        if (this.m_mapCache != null) {
            return true;
        }
        FolderPubStatusCacheMgrImpl folderPubStatusCacheMgrImpl = this;
        synchronized (folderPubStatusCacheMgrImpl) {
            WCMPubStatusConfigs wCMPubStatusConfigs = WCMPubStatusConfigs.openWCMObjs(null, null);
            HashMap<String, int[][]> hashMap = new HashMap<String, int[][]>(wCMPubStatusConfigs.size());
            int n = wCMPubStatusConfigs.size();
            for (int i = 0; i < n; ++i) {
                WCMPubStatusConfig wCMPubStatusConfig = (WCMPubStatusConfig)wCMPubStatusConfigs.getAt(i);
                if (wCMPubStatusConfig == null) continue;
                int[][] nArrayArray = new int[][]{this.makeStatusesCanDoPubFromConfig(wCMPubStatusConfig), this.makeStatusesCanDoIncreasePubFromConfig(wCMPubStatusConfig)};
                hashMap.put(wCMPubStatusConfig.getFolderType() + "_" + wCMPubStatusConfig.getFolderId(), nArrayArray);
            }
            this.m_mapCache = hashMap;
        }
        return true;
    }

    public boolean reinit() throws WCMException {
        this.clear();
        return this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        if (this.m_mapCache == null) {
            return;
        }
        FolderPubStatusCacheMgrImpl folderPubStatusCacheMgrImpl = this;
        synchronized (folderPubStatusCacheMgrImpl) {
            this.m_mapCache.clear();
            this.m_mapCache = null;
        }
    }

    public void notifyOnAddObj(BaseObj baseObj) throws WCMException {
        if (!(baseObj instanceof WCMPubStatusConfig)) {
            logger.error((Object)("Listener[" + this.getClass() + I18NMessage.get(FolderPubStatusCacheMgrImpl.class, "FolderPubStatusCacheMgrImpl.label1", "]\u4e0d\u80fd\u76d1\u542c\u5bf9\u8c61[") + baseObj.getClass() + I18NMessage.get(FolderPubStatusCacheMgrImpl.class, "FolderPubStatusCacheMgrImpl.label2", "]\u7684\u65b0\u589e\uff01")));
            return;
        }
        if (this.m_mapCache == null) {
            this.init();
        }
        WCMPubStatusConfig wCMPubStatusConfig = (WCMPubStatusConfig)baseObj;
        int[][] nArrayArray = new int[][]{this.makeStatusesCanDoPubFromConfig(wCMPubStatusConfig), this.makeStatusesCanDoIncreasePubFromConfig(wCMPubStatusConfig)};
        this.m_mapCache.put(wCMPubStatusConfig.getFolderType() + "_" + wCMPubStatusConfig.getFolderId(), nArrayArray);
    }

    public void notifyOnDelObj(BaseObj baseObj, int n) throws WCMException {
        if (!(baseObj instanceof WCMPubStatusConfig)) {
            logger.error((Object)("Listener[" + this.getClass() + I18NMessage.get(FolderPubStatusCacheMgrImpl.class, "FolderPubStatusCacheMgrImpl.label1", "]\u4e0d\u80fd\u76d1\u542c\u5bf9\u8c61[") + baseObj.getClass() + I18NMessage.get(FolderPubStatusCacheMgrImpl.class, "FolderPubStatusCacheMgrImpl.label3", "]\u7684\u5220\u9664\uff01")));
            return;
        }
        if (this.m_mapCache == null) {
            this.init();
        }
        WCMPubStatusConfig wCMPubStatusConfig = (WCMPubStatusConfig)baseObj;
        this.m_mapCache.remove(wCMPubStatusConfig.getFolderType() + "_" + wCMPubStatusConfig.getFolderId());
    }

    public void notifyOnModifyObj(BaseObj baseObj, int n) throws WCMException {
        if (!(baseObj instanceof WCMPubStatusConfig)) {
            logger.error((Object)("Listener[" + this.getClass() + I18NMessage.get(FolderPubStatusCacheMgrImpl.class, "FolderPubStatusCacheMgrImpl.label1", "]\u4e0d\u80fd\u76d1\u542c\u5bf9\u8c61[") + baseObj.getClass() + I18NMessage.get(FolderPubStatusCacheMgrImpl.class, "FolderPubStatusCacheMgrImpl.label4", "]\u7684\u4fee\u6539\uff01")));
            return;
        }
        if (!baseObj.isChangeProperty("STATUSESCANDOPUB")) {
            return;
        }
        String string = baseObj.getNewPropertyAsString("STATUSESCANDOPUB");
        if (this.m_mapCache == null) {
            this.init();
        }
        WCMPubStatusConfig wCMPubStatusConfig = (WCMPubStatusConfig)baseObj;
        int[][] nArrayArray = new int[][]{this.makeStatusesCanDoPubFromConfig(string), this.makeStatusesCanDoIncreasePubFromConfig(string)};
        this.m_mapCache.put(wCMPubStatusConfig.getFolderType() + "_" + wCMPubStatusConfig.getFolderId(), nArrayArray);
    }

    private int[] makeStatusesCanDoPubFromConfig(WCMPubStatusConfig wCMPubStatusConfig) {
        String string = null;
        if (wCMPubStatusConfig == null) {
            logger.warn((Object)"Publish config not found!");
        } else {
            string = wCMPubStatusConfig.getStatusesCanDoPub();
            if (string == null || (string = string.trim()).length() == 0) {
                logger.warn((Object)("Publish config of " + wCMPubStatusConfig.getFolderType() + ":" + " not set!"));
            }
        }
        return this.makeStatusesCanDoPubFromConfig(string);
    }

    private int[] makeStatusesCanDoPubFromConfig(String string) {
        if (string == null || string.length() == 0) {
            string = String.valueOf(10);
        } else if (string.indexOf(String.valueOf(10)) < 0) {
            string = string + ',' + String.valueOf(10);
        }
        return CMyString.splitToInt(string, ",");
    }

    private int[] makeStatusesCanDoIncreasePubFromConfig(WCMPubStatusConfig wCMPubStatusConfig) {
        String string = wCMPubStatusConfig.getStatusesCanDoPub();
        if (string == null || (string = string.trim()).length() == 0) {
            return null;
        }
        return this.makeStatusesCanDoIncreasePubFromConfig(string);
    }

    private int[] makeStatusesCanDoIncreasePubFromConfig(String string) {
        if (string == null || string.length() == 0) {
            return new int[0];
        }
        string = ',' + string + ',';
        string = (string = CMyString.replaceStr(string, ",10,", ",")).length() >= 3 ? string.substring(1, string.length() - 1) : null;
        return CMyString.splitToInt(string, ",");
    }
}

