/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish;

import com.trs.DreamFactory;
import com.trs.components.common.publish.domain.PublishServer;
import com.trs.components.common.publish.domain.publisher.PageDestroyer;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.wcm.content.domain.DocumentMgr;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.persistent.listener.IObjectLCListenerOnModify;
import com.trs.infra.support.config.ConfigServer;
import org.apache.log4j.Logger;

public class DocumentLCListenerForPublish
implements IObjectLCListenerOnModify {
    private static Logger logger = Logger.getLogger(DocumentLCListenerForPublish.class);
    private DocumentMgr m_oDocumentMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
    private PublishServer m_oPublishServer = PublishServer.getInstance();

    public void notifyOnModifyObj(BaseObj baseObj, int n) throws WCMException {
        if (baseObj == null || !(baseObj instanceof Document)) {
            return;
        }
        Document document = (Document)baseObj;
        this.changeStatusIfNesscerray(document);
    }

    private void changeStatusIfNesscerray(Document document) throws WCMException {
        if (document.isModified() && (document.isChangeProperty("FLOWOPERATIONMARK") || document.isChangeProperty("FLOWOPERATIONMARK") || document.isChangeProperty("FLOWOPERATIONMASKENUM"))) {
            return;
        }
        if (document.isModified() && !document.isChangeProperty("DocStatus")) {
            int n = document.getChannelId();
            if (document.isChangeProperty("DocChannel")) {
                n = document.getNewPropertyAsInt("DocChannel", 0);
            }
            if (n < 0) {
                return;
            }
            Channel channel = Channel.findById(n);
            if (channel == null) {
                return;
            }
            if (10 == document.getStatusId()) {
                int n2 = 1027;
                String string = "UPDATE WCMChnlDoc SET DocStatus=" + n2 + ",DocPubTime=null WHERE DocId=" + document.getDocId() + " AND DocStatus=" + 10 + " AND ChnlId>0";
                String string2 = "UPDATE WCMDocument SET DocStatus=" + n2 + ",DocPubTime=null WHERE DocId=" + document.getDocId();
                DBManager.getDBManager().sqlExecuteUpdate(new String[]{string, string2});
                String string3 = ConfigServer.getServer().getSysConfigValue("PageDestroyWhenModifyPublishStatusDoc", "false");
                if (string3.equalsIgnoreCase("true") || string3.equalsIgnoreCase("1")) {
                    this.onChangePublishedChnlDocStatus(document);
                }
            }
        }
    }

    private void onChangePublishedChnlDocStatus(Document document) throws WCMException {
        Channel channel = document.getChannel();
        Channels channels = this.m_oDocumentMgr.getQutoedChannels(document, 0, "DocStatus=1027");
        if (channels == null) {
            channels = new Channels(null, 1, 1);
        }
        channels.addElement(channel);
        IPublishContent iPublishContent = PublishElementFactory.makeContentFrom(document, null);
        int n = channels.size();
        for (int i = 0; i < n; ++i) {
            Channel channel2 = (Channel)channels.getAt(i);
            if (channel2 == null) continue;
            IPublishFolder iPublishFolder = (IPublishFolder)PublishElementFactory.makeElementFrom(channel2);
            iPublishContent.setFolder(iPublishFolder);
            try {
                if (iPublishContent.getModal() != 2) {
                    PageDestroyer.withdraw(iPublishContent, null);
                }
            }
            catch (Exception exception) {
                logger.error((Object)("withdraw detail fail:" + iPublishContent.getInfo()), (Throwable)exception);
            }
            this.m_oPublishServer.publishFolder(iPublishFolder, 12);
        }
    }
}

