/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish;

import com.trs.DreamFactory;
import com.trs.components.common.publish.domain.PublishServer;
import com.trs.components.common.publish.domain.publisher.PageDestroyer;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishElements;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.wcm.content.domain.DocumentMgr;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.ChnlDoc;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.publish.PreNextPageRefresher;
import com.trs.components.wcm.publish.WCMPubStatusConfig;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.ContextParameters;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.persistent.listener.IObjectLCListenerOnAdd;
import com.trs.infra.persistent.listener.IObjectLCListenerOnDel;
import com.trs.infra.persistent.listener.IObjectLCListenerOnModify;
import org.apache.log4j.Logger;

public class ChnlDocLCListnerForPublish
implements IObjectLCListenerOnAdd,
IObjectLCListenerOnDel,
IObjectLCListenerOnModify {
    private static Logger logger = Logger.getLogger(ChnlDocLCListnerForPublish.class);
    private DocumentMgr m_oDocumentMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
    private PublishServer m_oPublishServer = PublishServer.getInstance();

    public void notifyOnDelObj(BaseObj baseObj, int n) {
        if (!(baseObj instanceof ChnlDoc)) {
            logger.error((Object)("Listener[" + this.getClass() + I18NMessage.get(ChnlDocLCListnerForPublish.class, "ChnlDocLCListnerForPublish.label1", "]\u4e0d\u80fd\u76d1\u542c\u5bf9\u8c61[") + baseObj.getClass() + I18NMessage.get(ChnlDocLCListnerForPublish.class, "ChnlDocLCListnerForPublish.label2", "]\u7684\u5220\u9664\uff01")));
            return;
        }
        ChnlDoc chnlDoc = (ChnlDoc)baseObj;
        int n2 = chnlDoc.getStatusId();
        if (n2 < 0 || n2 != 10) {
            return;
        }
        try {
            this.destroyChnlDoc(chnlDoc);
        }
        catch (Throwable throwable) {
            logger.error((Object)I18NMessage.get(ChnlDocLCListnerForPublish.class, "ChnlDocLCListnerForPublish.label3", "\u6587\u6863\u5220\u9664\u64a4\u56de\u7a3f\u4ef6\u5931\u8d25\uff01"), throwable);
        }
    }

    public void notifyOnModifyObj(BaseObj baseObj, int n) {
        if (!(baseObj instanceof ChnlDoc)) {
            logger.error((Object)("Listener[" + this.getClass() + I18NMessage.get(ChnlDocLCListnerForPublish.class, "ChnlDocLCListnerForPublish.label1", "]\u4e0d\u80fd\u76d1\u542c\u5bf9\u8c61[") + baseObj.getClass() + I18NMessage.get(ChnlDocLCListnerForPublish.class, "ChnlDocLCListnerForPublish.label4", "]\u7684\u4fee\u6539\uff01")));
            return;
        }
        ChnlDoc chnlDoc = (ChnlDoc)baseObj;
        if (!chnlDoc.isChangeProperty("DOCSTATUS") && !chnlDoc.isChangeProperty("CHNLID")) {
            return;
        }
        this.onMovePublishedChnlDoc(chnlDoc);
        try {
            this.onChangePublishedChnlDocStatus(chnlDoc);
        }
        catch (Exception exception) {
            logger.error((Object)I18NMessage.get(ChnlDocLCListnerForPublish.class, "ChnlDocLCListnerForPublish.label5", "\u72b6\u6001\u89e6\u53d1\u7684\u64cd\u4f5c\u53d1\u751f\u5f02\u5e38\uff01"), (Throwable)exception);
        }
        this.refreshPreNextPagesIfNeed(chnlDoc);
    }

    protected void refreshPreNextPagesIfNeed(ChnlDoc chnlDoc) {
        try {
            if (chnlDoc.getModal() == 2 || chnlDoc.isChangeProperty("CHNLID") || !chnlDoc.isPublished() || ContextParameters.get(0, true) == Boolean.TRUE) {
                return;
            }
            PreNextPageRefresher preNextPageRefresher = new PreNextPageRefresher(chnlDoc.getDocument());
            preNextPageRefresher.refresh();
        }
        catch (Exception exception) {
            logger.error((Object)"refresh prenext detail pages failed.", (Throwable)exception);
        }
    }

    private void onMovePublishedChnlDoc(ChnlDoc chnlDoc) {
        int n = chnlDoc.getNewPropertyAsInt("ChnlId", 0);
        if (chnlDoc.isDeleted() || !chnlDoc.isChangeProperty("CHNLID") || n <= 0 || !chnlDoc.isPublished()) {
            return;
        }
        try {
            Channel channel = Channel.findById(n);
            if (channel == null) {
                return;
            }
            Channel channel2 = chnlDoc.getChannel();
            if (channel2 == null) {
                return;
            }
            Document document = null;
            boolean bl = false;
            if (chnlDoc.isEntity() || chnlDoc.getModal() == 3) {
                document = chnlDoc.getDocument();
                if (document == null) {
                    return;
                }
                bl = true;
                document.getProperties().put("MODAL", chnlDoc.getProperty("Modal"));
            }
            IPublishFolder iPublishFolder = (IPublishFolder)PublishElementFactory.makeElementFrom(channel);
            Channels channels = null;
            if (iPublishFolder.canDoDetailPageTask()) {
                if (bl) {
                    IPublishContent iPublishContent = PublishElementFactory.makeContentFrom(document, iPublishFolder);
                    this.m_oPublishServer.publishContent(iPublishContent);
                    channels = this.m_oDocumentMgr.getQutoedChannels(document, 0, "DocStatus=10");
                    if (channels.indexOf(channel.getId()) < 0) {
                        channels.addElement(channel);
                    }
                    this.withdraw(channel2, document);
                    if (channels.indexOf(channel2.getId()) < 0) {
                        channels.addElement(channel2);
                    }
                } else {
                    channels = new Channels(null, 2, 1);
                    channels.addElement(channel2);
                    channels.addElement(channel);
                }
            } else {
                if (chnlDoc.isEntity()) {
                    channels = this.m_oDocumentMgr.getQutoedChannels(document, 0, "DocStatus=10");
                }
                this.changePublishedStatus(chnlDoc, channel.getSiteId());
                if (bl) {
                    this.withdraw(channel2, document);
                }
                if (channels == null) {
                    channels = new Channels(null, 1, 1);
                }
                channels.addElement(channel2);
            }
            int n2 = channels.size();
            for (int i = 0; i < n2; ++i) {
                IPublishFolder iPublishFolder2;
                Channel channel3 = (Channel)channels.getAt(i);
                if (channel3 == null || !(iPublishFolder2 = (IPublishFolder)PublishElementFactory.makeElementFrom(channel3)).canDoOutlinePageTask()) continue;
                this.m_oPublishServer.publishFolder(iPublishFolder2, 12);
            }
        }
        catch (Throwable throwable) {
            logger.error((Object)(I18NMessage.get(ChnlDocLCListnerForPublish.class, "ChnlDocLCListnerForPublish.label6", "\u79fb\u52a8\u6587\u6863\u65f6\u5019\u540c\u6b65\u53d1\u5e03\u64cd\u4f5c\u51fa\u73b0\u5f02\u5e38\uff01[DocId=") + chnlDoc.getDocId() + ", FromChannel=" + chnlDoc.getChannelId() + ", ToChannel=" + n + "]"), throwable);
        }
    }

    private void onChangePublishedChnlDocStatus(ChnlDoc chnlDoc) throws WCMException {
        if (!chnlDoc.isChangeProperty("DocStatus")) {
            return;
        }
        Channel channel = chnlDoc.getChannel();
        if (channel == null) {
            return;
        }
        if (chnlDoc.isDeleted()) {
            if (chnlDoc.getStatusId() == -10) {
                this.changePublishedStatus(chnlDoc, channel.getSiteId());
            }
            return;
        }
        if (!chnlDoc.isPublished()) {
            return;
        }
        Document document = null;
        document = chnlDoc.getDocument();
        if (document == null) {
            return;
        }
        boolean bl = false;
        if (chnlDoc.isEntity() || chnlDoc.getModal() == 3) {
            bl = true;
            document.getProperties().put("MODAL", chnlDoc.getProperty("Modal"));
        }
        Channels channels = null;
        if (chnlDoc.isEntity()) {
            channels = this.m_oDocumentMgr.getQutoedChannels(document, 0, "DocStatus=10");
        }
        if (bl) {
            try {
                this.withdraw(channel, document);
            }
            catch (Exception exception) {
                logger.error((Object)"Failed to delete file.", (Throwable)exception);
            }
        }
        if (channels == null) {
            channels = new Channels(null, 1, 1);
        }
        channels.addElement(channel);
        boolean bl2 = chnlDoc.isEntity();
        IPublishContent iPublishContent = PublishElementFactory.makeContentFrom(document, null);
        int n = channels.size();
        for (int i = 0; i < n; ++i) {
            Channel channel2 = (Channel)channels.getAt(i);
            if (channel2 == null) continue;
            IPublishFolder iPublishFolder = (IPublishFolder)PublishElementFactory.makeElementFrom(channel2);
            this.m_oPublishServer.publishFolder(iPublishFolder, 12);
            if (!bl2) continue;
            iPublishContent.setFolder(iPublishFolder);
            try {
                if (iPublishContent.getModal() == 2) continue;
                PageDestroyer.withdraw(iPublishContent, null);
                continue;
            }
            catch (Exception exception) {
                logger.error((Object)("withdraw detail fail:" + iPublishContent.getInfo()), (Throwable)exception);
            }
        }
    }

    private void withdraw(Channel channel, Document document) throws WCMException, Exception {
        IPublishFolder iPublishFolder = (IPublishFolder)PublishElementFactory.makeElementFrom(channel);
        IPublishContent iPublishContent = PublishElementFactory.makeContentFrom(document, iPublishFolder);
        PageDestroyer.withdraw(iPublishContent, null);
    }

    private void changePublishedStatus(ChnlDoc chnlDoc, int n) throws WCMException {
        int n2;
        WCMPubStatusConfig wCMPubStatusConfig = WCMPubStatusConfig.findOf(103, n);
        int n3 = 2;
        if (wCMPubStatusConfig != null && (n2 = wCMPubStatusConfig.getStatusIdAfterModify()) != 0) {
            n3 = n2;
        }
        String string = null;
        String string2 = null;
        int[] nArray = null;
        if (chnlDoc.isEntity()) {
            string = "UPDATE WCMChnlDoc SET DocStatus=?,DocPubTime=null WHERE DocId=? and DocStatus=?";
            string2 = "UPDATE WCMDocument SET DocStatus=?,DocPubTime=null WHERE DocId=? and DocStatus=?";
            nArray = new int[]{n3, chnlDoc.getDocId(), 10};
        } else {
            string = "UPDATE WCMChnlDoc SET DocStatus=?,DocPubTime=null WHERE RecId=? and DocStatus=?";
            nArray = new int[]{n3, chnlDoc.getId(), 10};
        }
        DBManager.getDBManager().sqlExecuteUpdate(new String[]{string, string2}, nArray);
    }

    private void destroyChnlDoc(ChnlDoc chnlDoc) throws WCMException, Exception {
        Object object;
        Object object2;
        if (chnlDoc.getChannelId() < 0) {
            return;
        }
        Channel channel = chnlDoc.getChannel();
        if (channel == null || channel.isDeleted()) {
            return;
        }
        IPublishFolder iPublishFolder = (IPublishFolder)PublishElementFactory.lookupElement(101, chnlDoc.getChannelId());
        if (iPublishFolder == null) {
            throw new WCMException(I18NMessage.get(ChnlDocLCListnerForPublish.class, "ChnlDocLCListnerForPublish.label7", "\u6ca1\u6709\u627e\u5230\u6587\u6863[Id=") + chnlDoc.getDocId() + I18NMessage.get(ChnlDocLCListnerForPublish.class, "ChnlDocLCListnerForPublish.label8", "]\u6307\u5b9a\u7684folder[Id=") + chnlDoc.getChannelId() + "]!");
        }
        IPublishElements iPublishElements = PublishElementFactory.lookupElements(605, String.valueOf(chnlDoc.getDocId()));
        Channels channels = null;
        if (chnlDoc.isEntity()) {
            channels = new Channels(null);
            object2 = new StringBuffer(64);
            ((StringBuffer)object2).append("DocId=").append(chnlDoc.getDocId());
            ((StringBuffer)object2).append(" AND ChnlId>0 AND (");
            ((StringBuffer)object2).append("DocStatus=").append(10);
            ((StringBuffer)object2).append(" OR ");
            ((StringBuffer)object2).append("DocStatus=-").append(10);
            ((StringBuffer)object2).append(") AND NOT MODAL=").append(1);
            object = new WCMFilter("WCMChnlDoc", ((StringBuffer)object2).toString(), "", "ChnlId AS ChannelId");
            channels.open((WCMFilter)object);
            channels.addElement(channel);
        }
        object2 = null;
        if (channels != null && !channels.isEmpty()) {
            object2 = PublishElementFactory.makeElementsFrom(channels);
            IPublishContent iPublishContent = (IPublishContent)iPublishElements.get(0);
            for (int i = 0; i < object2.size(); ++i) {
                object = (IPublishFolder)object2.get(i);
                iPublishContent.setFolder((IPublishFolder)object);
                if (Math.abs(iPublishContent.getModal()) != 3) continue;
                PageDestroyer.withdraw(iPublishContent, null);
            }
        }
        this.m_oPublishServer.deleteContents(iPublishElements, iPublishFolder, (IPublishElements)object2, false);
    }

    public void notifyOnAddObj(BaseObj baseObj) throws WCMException {
        int n;
        if (!this.isListening(baseObj)) {
            return;
        }
        ChnlDoc chnlDoc = (ChnlDoc)baseObj;
        if (10 != chnlDoc.getStatusId()) {
            return;
        }
        Channel channel = chnlDoc.getChannel();
        if (channel == null) {
            return;
        }
        int n2 = channel.getSiteId();
        WCMPubStatusConfig wCMPubStatusConfig = WCMPubStatusConfig.findOf(103, n2);
        int n3 = 2;
        if (wCMPubStatusConfig != null && (n = wCMPubStatusConfig.getStatusIdAfterModify()) != 0) {
            n3 = n;
        }
        String[] stringArray = new String[]{"UPDATE WCMCHNLDOC SET DocStatus=" + n3 + " WHERE RecId=" + chnlDoc.getId(), "UPDATE WCMDOCUMENT SET DocStatus=" + n3 + " WHERE DocId=" + chnlDoc.getDocId() + " AND DocStatus=" + 10 + " AND DocChannel=" + chnlDoc.getChannelId()};
        DBManager.getDBManager().sqlExecuteUpdate(stringArray);
    }

    private boolean isListening(BaseObj baseObj) {
        return baseObj != null && baseObj instanceof ChnlDoc;
    }
}

