/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.process.element;

import com.trs.DreamFactory;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.cms.process.IFlowContent;
import com.trs.cms.process.definition.Flow;
import com.trs.cms.process.definition.FlowEmployMgr;
import com.trs.cms.process.engine.FlowDoc;
import com.trs.components.wcm.content.domain.DocumentMgr;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.ChnlDoc;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.resource.Status;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;

public class FlowContentDocumentImpl
implements IFlowContent {
    private boolean m_zLostDocument = false;
    private Document m_oDocument = null;
    private int m_nDocId = 0;
    private FlowDoc m_oFlowDoc = null;
    private Flow m_oFlow = null;
    private CMyDateTime m_dtStartTime = null;
    private long m_lSerialNum = -1L;
    private static final String QUERY_CHNLDOCID = "select RecId from WCMChnlDoc where DocId=? and ChnlId=?";
    private int m_nChnlDocId = -1;

    public FlowContentDocumentImpl(Document document) {
        this.makeFrom(document);
    }

    public FlowContentDocumentImpl(int n) {
        try {
            this.loadById(n);
        }
        catch (Exception exception) {
            throw new RuntimeException(I18NMessage.get(FlowContentDocumentImpl.class, "FlowContentDocumentImpl.label1", "\u5b9e\u4f8b\u5316\u5de5\u4f5c\u6d41\u5bf9\u8c61\u5931\u8d25\uff01\u7c7b\u578b\u4e3a\u6587\u6863\uff0cDocId=") + n, exception);
        }
    }

    public FlowContentDocumentImpl() {
    }

    public Document getDocument() throws WCMException {
        if (this.m_oDocument == null && !this.m_zLostDocument) {
            this.m_oDocument = Document.findById(this.m_nDocId);
            if (this.m_oDocument == null) {
                this.m_zLostDocument = true;
            }
        }
        return this.m_oDocument;
    }

    public boolean canEdit(User user) throws WCMException {
        if (this.getDocument() == null) {
            return false;
        }
        return this.getDocument().canEdit(user);
    }

    public Flow getOwnerFlow() throws WCMException {
        if (this.m_oFlow != null) {
            return this.m_oFlow;
        }
        Document document = this.getDocument();
        String string = document.getAttributeValue("FlowId");
        if (!CMyString.isEmpty(string)) {
            return Flow.findById(Integer.parseInt(string));
        }
        return this.getFlowEmployMgr().getFlow(this.getDocument().getChannel());
    }

    public String getDesc() throws WCMException {
        if (this.getDocument() == null) {
            return I18NMessage.get(FlowContentDocumentImpl.class, "FlowContentDocumentImpl.label2", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u6587\u6863[ID=") + this.m_nDocId + "]";
        }
        return this.getDocument().toString();
    }

    public int getContentType() {
        return 605;
    }

    public int getSubinstanceId() {
        return this.m_nDocId;
    }

    public void setSubinstance(int n) {
        this.m_nDocId = n;
    }

    public void updateStatus(User user, int n) throws WCMException {
        Channel channel;
        Document document = this.getDocument();
        ChnlDoc chnlDoc = ChnlDoc.findByDocAndChnl(document, channel = document.getChannel());
        if (chnlDoc == null) {
            return;
        }
        int n2 = chnlDoc.getStatusId();
        if (n2 == 1027) {
            return;
        }
        this.getDocumentMgr().changeStatus(document, channel, Status.findById(n));
    }

    public void cancelUpdate(User user) throws WCMException {
        this.getDocument().cancelUpdate(user);
    }

    public User getCrUser() throws WCMException {
        return this.getDocument().getCrUser();
    }

    public int getStatusId() throws WCMException {
        if (this.getDocument() == null) {
            return -1;
        }
        return this.getDocument().getStatusId();
    }

    public String getStatusDesc() throws WCMException {
        if (this.getDocument() == null) {
            return I18NMessage.get(FlowContentDocumentImpl.class, "FlowContentDocumentImpl.label3", "\u672a\u77e5");
        }
        Status status = this.getDocument().getStatus();
        return status == null ? I18NMessage.get(FlowContentDocumentImpl.class, "FlowContentDocumentImpl.label3", "\u672a\u77e5") : status.getDisp();
    }

    private FlowEmployMgr getFlowEmployMgr() {
        return (FlowEmployMgr)DreamFactory.createObjectById("FlowEmployMgr");
    }

    private DocumentMgr getDocumentMgr() {
        return (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
    }

    public CMSObj getSubinstance() throws WCMException {
        return this.getDocument();
    }

    public void setSubinstance(CMSObj cMSObj) {
        this.m_oDocument = (Document)cMSObj;
        this.setSubinstance(cMSObj.getId());
    }

    public String getContentShowPage() throws WCMException {
        if (this.getDocument() == null) {
            return I18NMessage.get(FlowContentDocumentImpl.class, "FlowContentDocumentImpl.label4", "\u6307\u5b9a\u7684\u5185\u5bb9\u4e0d\u5b58\u5728");
        }
        Channel channel = this.getDocument().getChannel();
        if (channel == null) {
            return "";
        }
        String string = channel.getContentShowPage();
        String string2 = "";
        string2 = string.indexOf(63) > 0 ? (string.endsWith("?") ? "" : "&") : "?";
        int n = this.getChnlDocId();
        return string + string2 + "DocumentId=" + this.getDocument().getId() + "&ChannelId=" + channel.getId() + "&ChnlDocId=" + n;
    }

    public String getContentAddEditPage() throws WCMException {
        if (this.getDocument() == null) {
            return I18NMessage.get(FlowContentDocumentImpl.class, "FlowContentDocumentImpl.label5", "javascript:alert('\u6307\u5b9a\u7684\u5185\u5bb9\u4e0d\u5b58\u5728\uff01');");
        }
        Channel channel = this.getDocument().getChannel();
        if (channel == null) {
            return "";
        }
        String string = channel.getContentAddEditPage();
        String string2 = "";
        string2 = string.indexOf(63) > 0 ? (string.endsWith("?") ? "" : "&") : "?";
        int n = this.getChnlDocId();
        return channel.getContentAddEditPage() + string2 + "DocumentId=" + this.getDocument().getId() + "&ChannelId=" + channel.getId() + "&ChnlDocId=" + n;
    }

    private int getChnlDocId() throws WCMException {
        if (this.m_nChnlDocId == -1) {
            this.m_nChnlDocId = DBManager.getDBManager().sqlExecuteIntQuery(QUERY_CHNLDOCID, new int[]{this.getDocument().getId(), this.getDocument().getChannelId()});
        }
        return this.m_nChnlDocId;
    }

    public String getDeletePage() throws WCMException {
        if (this.getDocument() == null) {
            return I18NMessage.get(FlowContentDocumentImpl.class, "FlowContentDocumentImpl.label5", "javascript:alert('\u6307\u5b9a\u7684\u5185\u5bb9\u4e0d\u5b58\u5728\uff01');");
        }
        Channel channel = this.getDocument().getChannel();
        if (channel == null) {
            return "";
        }
        return "serviceId=wcm6_viewdocument&methodName=delete&drop=false&objectids=" + this.getChnlDocId();
    }

    public String getPublishPage() throws WCMException {
        if (this.getDocument() == null) {
            return I18NMessage.get(FlowContentDocumentImpl.class, "FlowContentDocumentImpl.label5", "javascript:alert('\u6307\u5b9a\u7684\u5185\u5bb9\u4e0d\u5b58\u5728\uff01');");
        }
        return "../document/document_publish.jsp?DocumentIds=" + this.getDocument().getId() + "&PubType=3";
    }

    public int getId() {
        return this.m_nDocId;
    }

    public String getInfo() {
        try {
            return this.getDesc();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return I18NMessage.get(FlowContentDocumentImpl.class, "FlowContentDocumentImpl.label6", "\u83b7\u53d6\u63cf\u8ff0\u51fa\u73b0\u5f02\u5e38\uff01\uff01\uff01");
        }
    }

    public CMSObj getSubstance() {
        return this.m_oDocument;
    }

    public int getType() {
        return 605;
    }

    public boolean loadById(int n) throws WCMException {
        Document document = Document.findById(n);
        if (document == null) {
            throw new WCMException(I18NMessage.get(FlowContentDocumentImpl.class, "FlowContentDocumentImpl.label7", "\u6307\u5b9a\u7684\u6587\u6863\u6ca1\u6709\u627e\u5230\uff01[DocId=") + n + "]");
        }
        this.makeFrom(document);
        return true;
    }

    public void makeFrom(CMSObj cMSObj) throws WCMException {
        if (!(cMSObj instanceof Document)) {
            throw new WCMException(I18NMessage.get(FlowContentDocumentImpl.class, "FlowContentDocumentImpl.label8", "\u7c7b\u578b\u4e0d\u5339\u914d\uff01"));
        }
        this.makeFrom((Document)cMSObj);
    }

    private void makeFrom(Document document) {
        this.m_oDocument = document;
        this.m_nDocId = document.getId();
    }

    public void setSubstance(CMSObj cMSObj) {
        try {
            this.makeFrom(cMSObj);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public FlowDoc getFlowDoc() {
        return this.m_oFlowDoc;
    }

    public void setFlowDoc(FlowDoc flowDoc) {
        this.m_oFlowDoc = flowDoc;
    }

    public String getProperty(String string) {
        return this.m_oDocument.getPropertyAsString(string);
    }

    public CMyDateTime getStartTime() {
        return this.m_dtStartTime;
    }

    public void setStartTime(CMyDateTime cMyDateTime) {
        this.m_dtStartTime = cMyDateTime;
    }

    public boolean isDeleted() {
        try {
            Channel channel = this.m_oDocument.getChannel();
            if (channel == null) {
                return true;
            }
            if (channel.getStatus() < 0) {
                return true;
            }
        }
        catch (WCMException wCMException) {
            wCMException.printStackTrace();
        }
        return this.m_oDocument.isDeleted();
    }

    public long getSerialNum() {
        return this.m_lSerialNum;
    }

    public void setSerialNum(long l) {
        this.m_lSerialNum = l;
    }

    public void setFlow(Flow flow) {
        this.m_oFlow = flow;
    }
}

