/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.process;

import com.trs.DreamFactory;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.process.FlowServer;
import com.trs.cms.process.IFlowContent;
import com.trs.cms.process.definition.Flow;
import com.trs.cms.process.definition.FlowEmploy;
import com.trs.cms.process.definition.FlowEmployMgr;
import com.trs.cms.process.engine.FlowDoc;
import com.trs.cms.process.engine.FlowDocs;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.persistent.listener.IObjectLCListenerOnModify;
import org.apache.log4j.Logger;

public class ChannelLCListenerForFlow
implements IObjectLCListenerOnModify {
    private static Logger s_logger = Logger.getLogger(ChannelLCListenerForFlow.class);
    private FlowServer m_oFlowServer = null;

    public void notifyOnModifyObj(BaseObj baseObj, int n) throws WCMException {
        if (!(baseObj instanceof Channel)) {
            s_logger.error((Object)("Listener[" + this.getClass() + I18NMessage.get(ChannelLCListenerForFlow.class, "ChannelLCListenerForFlow.label1", "]\u4e0d\u80fd\u76d1\u542c\u5bf9\u8c61[") + baseObj.getClass() + I18NMessage.get(ChannelLCListenerForFlow.class, "ChannelLCListenerForFlow.label2", "]\u7684\u4fee\u6539\uff01")));
            return;
        }
        BaseObjs baseObjs = null;
        Channel channel = (Channel)baseObj;
        int n2 = channel.getNewPropertyAsInt("STATUS", 0);
        if (n2 == -1 || n2 == -2) {
            baseObjs = this.getFlowEmployMgr().getEmploysOfEmployer(101, channel.getId());
        }
        if (baseObjs == null || baseObjs.size() <= 0) {
            return;
        }
        for (int i = 0; i < baseObjs.size(); ++i) {
            Flow flow;
            FlowEmploy flowEmploy = (FlowEmploy)baseObjs.getAt(i);
            if (flowEmploy == null || (flow = flowEmploy.getFlow()) == null) continue;
            this.deleteFolwDocInFlow(flow, channel.getId());
        }
        this.deleteFolwDocBak(channel.getId());
    }

    private void deleteFolwDocInFlow(Flow flow, int n) throws WCMException {
        if (flow == null) {
            return;
        }
        String string = "exists(select NodeId from WCMFlowNode where WCMFlowDoc.NodeId=NodeId and FlowId=" + flow.getId() + ")";
        WCMFilter wCMFilter = new WCMFilter("", string, "");
        FlowDocs flowDocs = FlowDocs.openWCMObjs(User.getSystem(), wCMFilter);
        if (flowDocs == null || flowDocs.size() <= 0) {
            return;
        }
        for (int i = 0; i < flowDocs.size(); ++i) {
            FlowDoc flowDoc = (FlowDoc)flowDocs.getAt(i);
            if (flowDoc == null) continue;
            this.deleteFolwDoc(flowDoc, n);
        }
    }

    private void deleteFolwDoc(FlowDoc flowDoc, int n) throws WCMException {
        if (flowDoc == null) {
            return;
        }
        IFlowContent iFlowContent = flowDoc.getFlowContent();
        if (iFlowContent == null || iFlowContent.getContentType() != 605) {
            return;
        }
        Document document = (Document)iFlowContent.getSubinstance();
        if (document == null || document.getChannelId() != n) {
            return;
        }
        this.getFlowServer().removeFlowDoc(flowDoc.getContentType(), flowDoc.getContentId());
    }

    private void deleteFolwDocBak(int n) throws WCMException {
        String string = "DELETE FROM WCMFLOWDOCBAK where EXISTS(SELECT DOCID FROM WCMCHNLDOC WHERE WCMCHNLDOC.DOCID=WCMFLOWDOCBAK.OBJID and WCMCHNLDOC.CHNLID=" + -n + ")";
        String string2 = "DELETE FROM WCMFLOWDOC where EXISTS(SELECT DOCID FROM WCMCHNLDOC WHERE WCMCHNLDOC.DOCID=WCMFLOWDOC.OBJID and WCMCHNLDOC.CHNLID=" + -n + ")";
        DBManager dBManager = DBManager.getDBManager();
        dBManager.sqlExecuteUpdate(new String[]{string, string2});
    }

    private FlowEmployMgr getFlowEmployMgr() {
        return (FlowEmployMgr)DreamFactory.createObjectById("FlowEmployMgr");
    }

    private FlowServer getFlowServer() throws WCMException {
        if (this.m_oFlowServer == null) {
            this.m_oFlowServer = FlowServer.getFlowServer();
        }
        return this.m_oFlowServer;
    }
}

