/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.mobileportal;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.domain.template.TemplateEmployMgr;
import com.trs.components.common.publish.domain.template.TemplateMgr;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.persistent.publisher.FolderPublishConfig;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.common.publish.persistent.template.Templates;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.mobileportal.IMobilePortalServiceProvider;
import com.trs.components.wcm.publish.WCMFolderPublishConfig;
import com.trs.components.wcm.publish.logo.Logo;
import com.trs.components.wcm.util.INameGenerator;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.presentation.plugin.PluginConfig;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.controler.JSPRequestProcessor;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class MobilePortalServiceProvider
implements IMobilePortalServiceProvider {
    private static Logger logger = Logger.getLogger(MobilePortalServiceProvider.class);
    private static boolean BPROCESSING = false;
    private String m_sDocSDate = "";
    private int[] m_nStatusOfCanPub = new int[]{1, 2, 10, 16, 15, 18, 1027, 21, 22};
    private static Templates m_oTemplats = null;
    public static String[] m_sSiteOutlineTemplateNames = new String[]{"\u6d4f\u89c8\u5668-\u7ad9\u70b9\u9996\u9875", "\u7ad9\u70b9\u8f85\u52a9\u6a21\u677f"};
    public static String[] m_sChnlOutlineTemplateNames = new String[]{"\u6d4f\u89c8\u5668-\u680f\u76ee\u901a\u7528\u6982\u89c8", "\u680f\u76ee\u8f85\u52a9\u6a21\u677f"};
    public static String[] m_sPushMsgOutlineTemplateNames = new String[]{"\u6d4f\u89c8\u5668-\u680f\u76ee\u901a\u7528\u6982\u89c8", "\u680f\u76ee\u8f85\u52a9\u6a21\u677f", "\u6d88\u606f\u63a8\u9001\u6700\u65b0\u65f6\u95f4"};
    public static String m_sDetailTemplateNames = "\u6587\u6863\u8be6\u7ec6\u4fe1\u606f\u56fe\u7247\u6765\u81ea\u9644\u4ef6";
    public static String m_sPushMsgChnlName = "\u6d88\u606f\u63a8\u9001";
    public static String m_sPushMsgChnlPath = "notify";
    public static String m_sWBChnlName = "\u5b98\u65b9\u5fae\u535a";
    public static String m_sWBChnlPath = "WEIBO";
    public static String[] m_sDefaultLogo = new String[]{"home.png", "service.png", "hot.png"};
    private TemplateEmployMgr m_oEmployMgr = (TemplateEmployMgr)DreamFactory.createObjectById("TemplateEmployMgr");
    private JSPRequestProcessor processor = new JSPRequestProcessor(null, null);
    private HashMap serviceMap = new HashMap();
    private static String m_sMessage = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createMobilePortal(MethodContext methodContext) throws CMyException {
        if (!PluginConfig.isStartMobilePortal()) {
            throw new WCMException("\u60a8\u6ca1\u6709\u8d2d\u4e70\u79fb\u52a8\u95e8\u6237\uff01");
        }
        final User user = this.getLoginUser();
        if (!user.isAdministrator()) {
            throw new WCMException("\u60a8\u4e0d\u662f\u7cfb\u7edf\u7ba1\u7406\u5458\uff0c\u4e0d\u80fd\u521b\u5efa\u79fb\u52a8\u95e8\u6237\u7ad9\u70b9\uff01");
        }
        final int n = methodContext.getValue("SrcSiteId", 0);
        if (n <= 0) {
            throw new WCMException("\u4f20\u5165\u7684\u7ad9\u70b9ID\u5fc5\u987b\u5927\u4e8e0\uff01");
        }
        WebSite webSite = WebSite.findById(n);
        if (webSite == null) {
            throw new WCMException("\u4f20\u5165\u7684\u7ad9\u70b9Id\u3010" + n + "\u3011\u65e0\u6548.");
        }
        MobilePortalServiceProvider mobilePortalServiceProvider = this;
        synchronized (mobilePortalServiceProvider) {
            if (BPROCESSING) {
                return;
            }
            final MethodContext methodContext2 = methodContext;
            Thread thread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run() {
                    ContextHelper.initContext(user);
                    BPROCESSING = true;
                    try {
                        try {
                            MobilePortalServiceProvider.this.setDocSynTime(methodContext2.getValue("DocSDate"));
                            int n2 = MobilePortalServiceProvider.this.createSite(n);
                            MobilePortalServiceProvider.this.importTemplate(n2);
                            MobilePortalServiceProvider.this.configSiteTemplate(n2);
                            String string = methodContext2.getValue("DelChnlIds");
                            MobilePortalServiceProvider.this.makeMobileChnls(n, n2, string);
                            boolean bl = methodContext2.getValue("CreateOfficialWB", true);
                            boolean bl2 = methodContext2.getValue("CreatePushMsg", true);
                            MobilePortalServiceProvider.this.createLogoForLevelOneChnl(n2);
                            MobilePortalServiceProvider.this.createSpecialChannel(n2, bl2, bl);
                            MobilePortalServiceProvider.this.fullPublishSite(n2);
                        }
                        catch (Exception exception) {
                            logger.error((Object)"\u521b\u5efa\u79fb\u52a8\u95e8\u6237\u51fa\u73b0\u5f02\u5e38!", (Throwable)exception);
                            Object var6_7 = null;
                            BPROCESSING = false;
                            m_sMessage = "-1";
                            MobilePortalServiceProvider.this.m_sDocSDate = "";
                            ContextHelper.clear();
                            return;
                        }
                        Object var6_6 = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_8 = null;
                        BPROCESSING = false;
                        m_sMessage = "-1";
                        MobilePortalServiceProvider.this.m_sDocSDate = "";
                        ContextHelper.clear();
                        throw throwable;
                    }
                    BPROCESSING = false;
                    m_sMessage = "-1";
                    MobilePortalServiceProvider.this.m_sDocSDate = "";
                    ContextHelper.clear();
                }
            };
            thread.start();
        }
    }

    private void setDocSynTime(String string) throws CMyException {
        if (CMyString.isEmpty(string)) {
            String string2;
            CMyDateTime cMyDateTime = CMyDateTime.now();
            CMyDateTime cMyDateTime2 = cMyDateTime.dateAdd(1, -10);
            this.m_sDocSDate = string2 = cMyDateTime2.toString("yyyy-MM-dd");
        } else {
            CMyDateTime cMyDateTime = new CMyDateTime();
            cMyDateTime.setDateTimeWithString(string, "yyyy-MM-dd");
            this.m_sDocSDate = cMyDateTime.toString("yyyy-MM-dd");
        }
    }

    private int createSite(int n) throws WCMException {
        m_sMessage = "\u6b63\u5728\u521b\u5efa\u79fb\u52a8\u7ad9\u70b9";
        WebSite webSite = WebSite.findById(n);
        if (webSite == null) {
            throw new WCMException("\u4f20\u5165\u7684\u7ad9\u70b9Id\u3010" + n + "\u3011\u65e0\u6548.");
        }
        WebSite webSite2 = (WebSite)webSite.cloneToNewObj();
        webSite2.setName(webSite2.getName() + "-mobile");
        INameGenerator iNameGenerator = (INameGenerator)DreamFactory.createObjectById("INameGenerator");
        String string = iNameGenerator.generate(webSite2, "SITENAME", webSite2.getName());
        webSite2.setName(string);
        webSite2.setDesc(webSite2.getDesc() + "-\u79fb\u52a8\u95e8\u6237");
        webSite2.setOrder(webSite2.getOrder() + 1);
        webSite2.setMobile(true);
        webSite2.setCrUser(this.getLoginUser());
        webSite2.save(this.getLoginUser());
        int n2 = webSite2.getId();
        IPublishElement iPublishElement = PublishElementFactory.lookupElement(103, n);
        WCMFolderPublishConfig wCMFolderPublishConfig = new WCMFolderPublishConfig((IPublishFolder)iPublishElement);
        String string2 = wCMFolderPublishConfig.getRootDomain();
        String string3 = wCMFolderPublishConfig.getDataPath();
        string2 = string2.lastIndexOf("/") == string2.length() - 1 ? string2.substring(0, string2.length() - 1) : string2;
        string2 = string2.substring(0, string2.lastIndexOf("/") + 1);
        FolderPublishConfig folderPublishConfig = FolderPublishConfig.createNewInstance();
        WCMFilter wCMFilter = new WCMFilter("", "FolderType=?", "");
        wCMFilter.addSearchValues(103);
        string3 = iNameGenerator.generate(folderPublishConfig, "DataPath", string3 + "mobile", wCMFilter);
        String string4 = "wcm6_publish";
        String string5 = "saveSitePublishConfig";
        this.processor.reset();
        this.serviceMap.clear();
        this.serviceMap.put("OBJECTID", n2);
        this.serviceMap.put("SITETYPE", webSite2.getType());
        this.serviceMap.put("DATAPATH", string3);
        this.serviceMap.put("SITELANGUAGE", "8");
        this.serviceMap.put("PAGEENCODING", "UTF-8");
        this.serviceMap.put("ROOTDOMAIN", string2 + string3);
        this.serviceMap.put("STATUSESCANDOPUB", CMyString.join(this.m_nStatusOfCanPub, ","));
        this.serviceMap.put("STATUSIDAFTERMODIFY", "1");
        try {
            this.processor.excute(string4, string5, this.serviceMap);
        }
        catch (WCMException wCMException) {
            throw new WCMException("\u521b\u5efa\u7ad9\u70b9\u53d1\u5e03\u4fe1\u606f\u51fa\u73b0\u5f02\u5e38\uff01", wCMException);
        }
        return n2;
    }

    private void importTemplate(int n) throws CMyException {
        m_sMessage = "\u6b63\u5728\u5bfc\u5165\u7ad9\u70b9\u6a21\u677f";
        String string = this.getMobileDataPath();
        String string2 = string + "TEMPLATE--MOBILEPORTAL.zip";
        String string3 = string2 + "datatemp";
        if (!CMyFile.fileExists(string3)) {
            CMyFile.makeDir(string3, true);
        }
        String string4 = string3 + File.separator + "TEMPLATE--MOBILEPORTAL_bak.zip";
        try {
            try {
                if (!CMyFile.fileExists(string2)) {
                    throw new WCMException("\u79fb\u52a8\u95e8\u6237\u7684\u6a21\u677f\u6587\u4ef6\u5305\u4e0d\u5b58\u5728\uff01\u3010" + string2 + "\u3011");
                }
                CMyFile.copyFile(string2, string4);
                String string5 = "wcm6_template";
                String string6 = "importTemplates";
                this.processor.reset();
                this.serviceMap.clear();
                this.serviceMap.put("IMPORTFILE", string4);
                this.serviceMap.put("SRCFILENAME", "TEMPLATE--MOBILEPORTAL.zip");
                this.serviceMap.put("IMPORTMODE", 1);
                this.serviceMap.put("PICMODE", 1);
                this.serviceMap.put("HOSTID", n);
                this.serviceMap.put("HOSTTYPE", 103);
                this.serviceMap.put("FILEENCODE", "UTF-8");
                this.processor.excute(string5, string6, this.serviceMap);
            }
            catch (WCMException wCMException) {
                throw new WCMException("\u5bfc\u5165\u6a21\u677f\u51fa\u73b0\u5f02\u5e38\uff01", wCMException);
            }
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            CMyFile.deleteDir(string3);
            throw throwable;
        }
        CMyFile.deleteDir(string3);
        m_oTemplats = null;
    }

    private void configSiteTemplate(int n) throws WCMException {
        m_sMessage = "\u6b63\u5728\u914d\u7f6e\u7ad9\u70b9\u6a21\u677f";
        String string = this.getSiteOutLineTemplatesIds(n);
        IPublishElement iPublishElement = PublishElementFactory.lookupElement(103, n);
        this.m_oEmployMgr.setOutlineTemplates((IPublishFolder)iPublishElement, string, false);
    }

    private Templates getSiteAllTemplates(int n) throws WCMException {
        if (m_oTemplats != null) {
            return m_oTemplats;
        }
        IPublishFolder iPublishFolder = (IPublishFolder)PublishElementFactory.lookupElement(103, n);
        TemplateMgr templateMgr = (TemplateMgr)DreamFactory.createObjectById("TemplateMgr");
        m_oTemplats = templateMgr.getManagedTemplates(iPublishFolder, -1, null, true);
        return m_oTemplats;
    }

    private String getSiteOutLineTemplatesIds(int n) throws WCMException {
        String string;
        Template template;
        int n2;
        Templates templates = this.getSiteAllTemplates(n);
        StringBuffer stringBuffer = new StringBuffer();
        for (n2 = 0; n2 < templates.size(); ++n2) {
            template = (Template)templates.getAt(n2);
            string = template.getName();
            if (!m_sSiteOutlineTemplateNames[0].equals(string)) continue;
            stringBuffer.append(template.getId());
        }
        block1: for (n2 = 0; n2 < templates.size(); ++n2) {
            template = (Template)templates.getAt(n2);
            string = template.getName();
            for (int i = 1; i < m_sSiteOutlineTemplateNames.length; ++i) {
                if (!m_sSiteOutlineTemplateNames[i].equals(string)) continue;
                stringBuffer.append("," + template.getId());
                continue block1;
            }
        }
        return stringBuffer.toString();
    }

    private String getChannelOutLineTemplatesIds(int n, String[] stringArray) throws WCMException {
        String string;
        Template template;
        int n2;
        Templates templates = this.getSiteAllTemplates(n);
        StringBuffer stringBuffer = new StringBuffer();
        for (n2 = 0; n2 < templates.size(); ++n2) {
            template = (Template)templates.getAt(n2);
            string = template.getName();
            if (!stringArray[0].equals(string)) continue;
            stringBuffer.append(template.getId());
        }
        block1: for (n2 = 0; n2 < templates.size(); ++n2) {
            template = (Template)templates.getAt(n2);
            string = template.getName();
            for (int i = 1; i < stringArray.length; ++i) {
                if (!stringArray[i].equals(string)) continue;
                stringBuffer.append("," + template.getId());
                continue block1;
            }
        }
        return stringBuffer.toString();
    }

    private int getDetailTemplateId(int n) throws WCMException {
        Templates templates = this.getSiteAllTemplates(n);
        int n2 = 0;
        for (int i = 0; i < templates.size(); ++i) {
            Template template = (Template)templates.getAt(i);
            String string = template.getName();
            if (!m_sDetailTemplateNames.equals(string)) continue;
            n2 = template.getId();
            break;
        }
        return n2;
    }

    private void makeMobileChnls(int n, int n2, String string) throws CMyException {
        User user = this.getLoginUser();
        int[] nArray = null;
        if (!CMyString.isEmpty(string)) {
            nArray = CMyString.splitToInt(string, ",");
        }
        WebSite webSite = WebSite.findById(n);
        List list = webSite.getChildren(user);
        for (int i = 0; i < list.size(); ++i) {
            Channel channel = (Channel)list.get(i);
            this.makeChnlSelfAndchildren(null, channel, n2, nArray, true);
        }
    }

    private int makeChnlSelfAndchildren(BaseChannel baseChannel, Channel channel, int n, int[] nArray, boolean bl) throws CMyException {
        if (channel == null) {
            return 0;
        }
        int n2 = channel.getId();
        if (this.isIgnore(channel, nArray)) {
            return 0;
        }
        Channel channel2 = this.makeOneMobileChannel(baseChannel, channel, n, nArray);
        if (bl) {
            List list = channel.getChildren(this.getLoginUser());
            for (int i = 0; i < list.size(); ++i) {
                Channel channel3 = (Channel)list.get(i);
                this.makeChnlSelfAndchildren(channel2, channel3, n, nArray, bl);
            }
        }
        return channel2.getId();
    }

    private boolean isContainChildren(Channel channel, int[] nArray) throws WCMException {
        List list = channel.getChildren(ContextHelper.getLoginUser(), 0);
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Channel channel2 = (Channel)list.get(i);
            if (this.isIgnore(channel2, nArray)) continue;
            return true;
        }
        return false;
    }

    private boolean isIgnore(Channel channel, int[] nArray) {
        if (channel.getType() != 0) {
            return true;
        }
        if (channel.isOnlySearch()) {
            return true;
        }
        int n = channel.getId();
        if (nArray == null) {
            return false;
        }
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = nArray[i];
            if (n2 != n) continue;
            return true;
        }
        return false;
    }

    private Channel makeOneMobileChannel(BaseChannel baseChannel, Channel channel, int n, int[] nArray) throws CMyException {
        Channel channel2 = (Channel)channel.cloneToNewObj();
        m_sMessage = "\u6b63\u5728\u4e3a\u680f\u76ee\u3010" + channel2.getName() + "\u3011\u521b\u5efa\u79fb\u52a8\u680f\u76ee";
        channel2.setSite(n);
        INameGenerator iNameGenerator = (INameGenerator)DreamFactory.createObjectById("INameGenerator");
        WCMFilter wCMFilter = new WCMFilter("", "siteid=?", "");
        wCMFilter.addSearchValues(n);
        String string = iNameGenerator.generate(channel2, "CHNLNAME", channel2.getName(), wCMFilter);
        channel2.setName(string);
        int n2 = 0;
        if (baseChannel != null && baseChannel instanceof Channel) {
            n2 = baseChannel.getId();
        }
        channel2.setParent(n2);
        boolean bl = this.isContainChildren(channel, nArray);
        if (n2 == 0) {
            if (bl) {
                channel2.setAttribute("LISTTYPE", "0");
            } else {
                channel2.setAttribute("LISTTYPE", "1");
            }
        } else {
            channel2.setAttribute("LISTTYPE", "1");
        }
        channel2.setCrUser(this.getLoginUser());
        channel2.setPropertyWithString("ContentAddEditPage", "../document/document_addedit.jsp");
        channel2.setPropertyWithString("ContentShowPage", "../document/document_detail.jsp");
        channel2.setPropertyWithString("ContentListPage", "../document/document_list.html");
        channel2.setQuery("");
        channel2.save();
        int n3 = channel2.getId();
        IPublishElement iPublishElement = PublishElementFactory.lookupElement(101, channel.getId());
        WCMFolderPublishConfig wCMFolderPublishConfig = new WCMFolderPublishConfig((IPublishFolder)iPublishElement);
        String string2 = wCMFolderPublishConfig.getDataPath();
        FolderPublishConfig folderPublishConfig = FolderPublishConfig.createNewInstance();
        WCMFilter wCMFilter2 = new WCMFilter("", "FolderType=?", "");
        wCMFilter2.addSearchValues(101);
        string2 = iNameGenerator.generate(folderPublishConfig, "DataPath", string2, wCMFilter2);
        IPublishElement iPublishElement2 = PublishElementFactory.lookupElement(101, n3);
        WCMFolderPublishConfig wCMFolderPublishConfig2 = new WCMFolderPublishConfig((IPublishFolder)iPublishElement2);
        wCMFolderPublishConfig2.setFolderType(101, n3);
        wCMFolderPublishConfig2.setDataPath(string2);
        wCMFolderPublishConfig2.canEdit(this.getLoginUser());
        wCMFolderPublishConfig2.save(this.getLoginUser());
        m_sMessage = "\u6b63\u5728\u4e3a\u680f\u76ee\u3010" + channel2.getName() + "\u3011\u7684\u79fb\u52a8\u680f\u76ee\u914d\u7f6e\u6a21\u677f";
        this.configChannelTemplate(n3, n, m_sChnlOutlineTemplateNames);
        m_sMessage = "\u6b63\u5728\u4e3a\u680f\u76ee\u3010" + channel2.getName() + "\u3011\u540c\u6b65\u6570\u636e";
        this.setChannelSyn(channel.getId(), n3);
        return channel2;
    }

    private void setChannelSyn(int n, int n2) throws CMyException {
        String string = "wcm6_documentSyn";
        String string2 = "save";
        this.processor.reset();
        this.serviceMap.clear();
        this.serviceMap.put("ObjectId", 0);
        this.serviceMap.put("CHANNELID", n);
        this.serviceMap.put("DSTCHANNELIDS", n2);
        this.serviceMap.put("CHANNELASTARGET", false);
        CMyDateTime cMyDateTime = CMyDateTime.now();
        String string3 = cMyDateTime.toString("yyyy-MM-dd");
        CMyDateTime cMyDateTime2 = cMyDateTime.dateAdd(1, -10);
        String string4 = cMyDateTime2.toString("yyyy-MM-dd");
        CMyDateTime cMyDateTime3 = cMyDateTime.dateAdd(1, 20);
        String string5 = cMyDateTime2.toString("yyyy-MM-dd");
        this.serviceMap.put("SDATE", string3);
        this.serviceMap.put("EDATE", string5);
        this.serviceMap.put("DOCSDATE", this.m_sDocSDate);
        this.serviceMap.put("DOCEDATE", string4);
        this.serviceMap.put("SYNTYPES", "PUBLISH");
        this.serviceMap.put("ATTRIBUTE", "TransmitType=3");
        this.serviceMap.put("TRANSMITTYPEASS", "3");
        this.serviceMap.put("OPERAFTER", "1");
        this.serviceMap.put("STATUSES", CMyString.join(this.m_nStatusOfCanPub, ","));
        this.serviceMap.put("STATUSESASS", CMyString.join(this.m_nStatusOfCanPub, ","));
        int n3 = 0;
        try {
            Integer n4 = (Integer)this.processor.excute(string, string2, this.serviceMap);
            n3 = n4;
        }
        catch (WCMException wCMException) {
            throw new WCMException("\u521b\u5efa\u6587\u6863\u540c\u6b65\u51fa\u73b0\u5f02\u5e38\uff01", wCMException);
        }
        if (n3 <= 0) {
            return;
        }
        string = "wcm61_docsyn";
        string2 = "synUndoContent";
        this.processor.reset();
        this.serviceMap.clear();
        this.serviceMap.put("ObjectIds", n3);
        try {
            this.processor.excute(string, string2, this.serviceMap);
        }
        catch (WCMException wCMException) {
            throw new WCMException("\u540c\u6b65\u6587\u6863\u6570\u636e\u51fa\u73b0\u5f02\u5e38\uff01", wCMException);
        }
    }

    private void configChannelTemplate(int n, int n2, String[] stringArray) throws WCMException {
        String string = this.getChannelOutLineTemplatesIds(n2, stringArray);
        IPublishElement iPublishElement = PublishElementFactory.lookupElement(101, n);
        this.m_oEmployMgr.setOutlineTemplates((IPublishFolder)iPublishElement, string, false);
        int n3 = this.getDetailTemplateId(n2);
        this.m_oEmployMgr.setDetailTemplate((IPublishFolder)iPublishElement, n3, false);
    }

    private void fullPublishSite(int n) throws WCMException {
        m_sMessage = "\u6b63\u5728\u5b8c\u5168\u53d1\u5e03\u79fb\u52a8\u7ad9\u70b9\uff01";
        String string = "wcm6_publish";
        String string2 = "fullyPublish";
        this.processor.reset();
        this.serviceMap.clear();
        this.serviceMap.put("OBJECTIDS", n);
        this.serviceMap.put("OBJECTTYPE", 103);
        try {
            this.processor.excute(string, string2, this.serviceMap);
        }
        catch (WCMException wCMException) {
            throw new WCMException("\u5b8c\u5168\u53d1\u5e03\u7ad9\u70b9\u51fa\u73b0\u5f02\u5e38\uff01");
        }
    }

    private void createSpecialChannel(int n, boolean bl, boolean bl2) throws WCMException {
        if (bl) {
            this.createOneSpecialChannel(m_sPushMsgChnlName, n, 0, m_sPushMsgChnlPath, m_sPushMsgOutlineTemplateNames, 1);
        }
        if (bl2) {
            WebSite webSite = WebSite.findById(n);
            if (webSite == null) {
                return;
            }
            int n2 = 0;
            List list = webSite.getChildren(this.getLoginUser());
            if (list.size() > 0) {
                BaseChannel baseChannel = (BaseChannel)list.get(0);
                n2 = baseChannel.getId();
            }
            this.createOneSpecialChannel(m_sWBChnlName, n, n2, m_sWBChnlPath, m_sChnlOutlineTemplateNames, 11);
        }
    }

    private void createOneSpecialChannel(String string, int n, int n2, String string2, String[] stringArray, int n3) throws WCMException {
        Channel channel = Channel.createNewInstance();
        channel.setName(string);
        channel.setDesc(string);
        channel.setSite(n);
        channel.setParent(n2);
        channel.setCrUser(this.getLoginUser());
        channel.setCanPub(true);
        channel.setAttribute("LISTTYPE", n3 + "");
        INameGenerator iNameGenerator = (INameGenerator)DreamFactory.createObjectById("INameGenerator");
        WCMFilter wCMFilter = new WCMFilter("", "siteid=?", "");
        wCMFilter.addSearchValues(n);
        String string3 = iNameGenerator.generate(channel, "CHNLNAME", channel.getName(), wCMFilter);
        channel.setName(string3);
        channel.save();
        int n4 = channel.getId();
        IPublishElement iPublishElement = PublishElementFactory.lookupElement(101, n4);
        WCMFolderPublishConfig wCMFolderPublishConfig = new WCMFolderPublishConfig((IPublishFolder)iPublishElement);
        wCMFolderPublishConfig.setFolderType(101, n4);
        wCMFolderPublishConfig.setDataPath(string2);
        wCMFolderPublishConfig.canEdit(this.getLoginUser());
        wCMFolderPublishConfig.save(this.getLoginUser());
        this.configChannelTemplate(n4, n, stringArray);
    }

    private void createLogoForLevelOneChnl(int n) throws WCMException {
        User user = this.getLoginUser();
        String string = this.getMobileDataPath();
        WebSite webSite = WebSite.findById(n);
        List list = webSite.getChildren(user);
        int n2 = list.size();
        for (int i = 0; i < n2; ++i) {
            Channel channel = (Channel)list.get(i);
            if (i > 2) break;
            String string2 = string + m_sDefaultLogo[i];
            this.createLogoForChnl(channel, string2);
        }
    }

    private void createLogoForChnl(Channel channel, String string) throws WCMException {
        if (!CMyFile.fileExists(string)) {
            return;
        }
        FilesMan filesMan = FilesMan.getFilesMan();
        String string2 = filesMan.getNextFileName("U0", CMyFile.extractFileExt(string));
        String string3 = filesMan.mapFilePath(string2, 0) + string2;
        try {
            CMyFile.copyFile(string, string3);
        }
        catch (Exception exception) {
            throw new WCMException("\u4fdd\u5b58\u6587\u4ef6[" + string + "]-->[" + string3 + "]\u5931\u8d25\uff01", exception);
        }
        Logo logo = Logo.createNewInstance();
        logo.setHostId(channel.getId());
        logo.setHostType(101);
        logo.setFileName(string2);
        logo.save();
    }

    private String getMobileDataPath() throws WCMException {
        String string = ConfigServer.getServer().getSysConfigValue("WCM_PATH", "");
        if ("\\".equals(File.separator)) {
            string = CMyString.replaceStr(string, "/", File.separator);
        }
        if ((string = CMyString.setStrEndWith(string, File.separatorChar)) == null || string.trim().equals("")) {
            throw new WCMException("\u6ca1\u6709\u83b7\u53d6\u5230\u5e94\u7528\u6240\u5728\u8def\u5f84\uff01");
        }
        String string2 = string + "app" + File.separator + "mobile" + File.separator + "data" + File.separator;
        return string2;
    }

    public void createMobileChannel(MethodContext methodContext) throws WCMException {
        if (!PluginConfig.isStartMobilePortal()) {
            throw new WCMException("\u60a8\u6ca1\u6709\u8d2d\u4e70\u79fb\u52a8\u95e8\u6237\uff01");
        }
        if (BPROCESSING) {
            return;
        }
        BPROCESSING = true;
        User user = this.getLoginUser();
        int n = methodContext.getValue("SrcChnlId", 0);
        int n2 = methodContext.getValue("DestHostId", 0);
        int n3 = methodContext.getValue("DestHostType", 0);
        boolean bl = methodContext.getValue("ContainChildren", false);
        try {
            try {
                Channel channel = Channel.findById(n);
                if (channel == null) {
                    throw new WCMException("\u65e0\u6cd5\u627e\u5230id\u4e3a\u3010" + n + "\u3011\u7684\u680f\u76ee.");
                }
                if (!AuthServer.hasRight(user, (CMSObj)channel, 13)) {
                    throw new WCMException("\u5bf9\u4e0d\u8d77\uff0c\u60a8[" + user.getName() + "]\u6ca1\u6709\u6743\u9650\u4ece\u680f\u76ee[" + channel.getName() + "]\u521b\u5efa\u79fb\u52a8\u680f\u76ee.");
                }
                WebSite webSite = null;
                BaseChannel baseChannel = null;
                if (103 == n3) {
                    webSite = WebSite.findById(n2);
                    baseChannel = webSite;
                } else if (101 == n3) {
                    baseChannel = Channel.findById(n2);
                    if (baseChannel == null) {
                        throw new WCMException("\u65e0\u6cd5\u627e\u5230id\u4e3a\u3010" + n2 + "\u3011\u7684\u680f\u76ee.");
                    }
                    webSite = baseChannel.getSite();
                }
                if (webSite == null) {
                    throw new WCMException("\u65e0\u6cd5\u627e\u5230id\u4e3a\u3010" + n2 + "\u3011\u7684\u7ad9\u70b9.");
                }
                if (!AuthServer.hasRight(user, (CMSObj)baseChannel, 11)) {
                    throw new WCMException("\u5bf9\u4e0d\u8d77\uff0c\u60a8[" + user.getName() + "]\u6ca1\u6709\u6743\u9650" + "\u5728[" + baseChannel.getName() + "]\u4e0a\u521b\u5efa\u680f\u76ee.");
                }
                this.setDocSynTime(methodContext.getValue("DocSDate"));
                int n4 = this.makeChnlSelfAndchildren(baseChannel, channel, webSite.getId(), null, bl);
                Channel channel2 = Channel.findById(n4);
                if (channel2 == null) {
                    Object var16_13 = null;
                    BPROCESSING = false;
                    m_sMessage = "-1";
                    this.m_sDocSDate = "";
                    return;
                }
                m_sMessage = "\u6b63\u5728\u5b8c\u5168\u53d1\u5e03\u79fb\u52a8\u680f\u76ee\uff01";
                String string = "wcm6_publish";
                String string2 = "fullyPublish";
                this.processor.reset();
                this.serviceMap.clear();
                this.serviceMap.put("OBJECTIDS", n4);
                this.serviceMap.put("OBJECTTYPE", 101);
                try {
                    this.processor.excute(string, string2, this.serviceMap);
                }
                catch (WCMException wCMException) {
                    throw new WCMException("\u5b8c\u5168\u53d1\u5e03\u680f\u76ee\u51fa\u73b0\u5f02\u5e38\uff01");
                }
            }
            catch (Exception exception) {
                throw new WCMException("\u521b\u5efa\u79fb\u52a8\u95e8\u6237\u680f\u76ee\u51fa\u73b0\u5f02\u5e38!", exception);
            }
        }
        catch (Throwable throwable) {
            Object var16_15 = null;
            BPROCESSING = false;
            m_sMessage = "-1";
            this.m_sDocSDate = "";
            throw throwable;
        }
        Object var16_14 = null;
        BPROCESSING = false;
        m_sMessage = "-1";
        this.m_sDocSDate = "";
    }

    public String getCurrMessage(MethodContext methodContext) {
        return m_sMessage;
    }

    public boolean isCanCreateMobile(MethodContext methodContext) throws WCMException {
        WebSite webSite;
        if (!PluginConfig.isStartMobilePortal()) {
            return false;
        }
        int n = methodContext.getValue("ObjectId", 0);
        int n2 = methodContext.getValue("ObjectType", 0);
        if (n2 == 101) {
            Channel channel = Channel.findById(n);
            if (channel == null) {
                return false;
            }
            if (channel.getType() != 0 || channel.isOnlySearch()) {
                return false;
            }
            WebSite webSite2 = channel.getSite();
            if (webSite2 == null || webSite2.isMobile()) {
                return false;
            }
        } else if (n2 == 103 && ((webSite = WebSite.findById(n)) == null || webSite.isMobile())) {
            return false;
        }
        return true;
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }
}

