/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.individuation;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSBaseObjs;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.WebSites;
import com.trs.components.wcm.individuation.Individuation;
import com.trs.components.wcm.individuation.Individuations;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.persistent.WCMFilter;
import java.util.Enumeration;
import java.util.Hashtable;

public class IndividuationMgr {
    public Individuations getLoginUserIndividuationConfigs(String[] stringArray, boolean bl) throws WCMException {
        User user = this.getLoginUser();
        WCMFilter wCMFilter = new WCMFilter("", "", "", "individuationId,paramName,paramValue,objectIdsValue");
        wCMFilter.addSearchValues(user.getId());
        StringBuffer stringBuffer = new StringBuffer("userId=?");
        if (stringArray.length > 0) {
            if (bl) {
                stringBuffer.append(" and paramName in (");
            } else {
                stringBuffer.append(" and paramName not in (");
            }
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append("?,");
                wCMFilter.addSearchValues(stringArray[i]);
            }
            stringBuffer.setCharAt(stringBuffer.length() - 1, ')');
        }
        wCMFilter.setWhere(stringBuffer.toString());
        return Individuations.openWCMObjs(user, wCMFilter);
    }

    public String getObjectIdsAsString(int n) throws Exception {
        Hashtable hashtable = this.getObjectIdsHashtable(n);
        StringBuffer stringBuffer = new StringBuffer(hashtable.size());
        Enumeration enumeration = hashtable.keys();
        if (enumeration.hasMoreElements()) {
            while (true) {
                stringBuffer.append(enumeration.nextElement());
                if (!enumeration.hasMoreElements()) break;
                stringBuffer.append(",");
            }
        }
        return stringBuffer.toString();
    }

    public Hashtable getObjectIdsHashtable(int n) throws Exception {
        Individuations individuations = this.getObjects(n);
        return this.filterObject(this.clearRepeat(individuations), n);
    }

    public Individuations getIndividuations4System() throws Exception {
        String string = " USERID=?";
        WCMFilter wCMFilter = new WCMFilter("", string, "");
        wCMFilter.addSearchValues(-1);
        return Individuations.openWCMObjs(null, wCMFilter);
    }

    private Individuations getObjects(int n) throws Exception {
        User user = this.getLoginUser();
        String string = " INDIVIDUATIONID in(select A.INDIVIDUATIONID from XWCMCUSTOMSITECHECKEDINFO A where A.CHECKEDUSERID=?)";
        WCMFilter wCMFilter = new WCMFilter("", string, "");
        wCMFilter.addSearchValues(user.getId());
        return Individuations.openWCMObjs(user, wCMFilter);
    }

    private Hashtable clearRepeat(BaseObjs baseObjs) {
        String[] stringArray = null;
        Hashtable<String, Boolean> hashtable = new Hashtable<String, Boolean>();
        int n = baseObjs.size();
        for (int i = 0; i < n; ++i) {
            Individuation individuation = (Individuation)baseObjs.getAt(i);
            if (individuation == null) continue;
            stringArray = individuation.getObjectIdsValue().split(",");
            for (int j = 0; j < stringArray.length; ++j) {
                hashtable.put(stringArray[j], new Boolean(true));
            }
        }
        return hashtable;
    }

    private Hashtable filterObject(Hashtable hashtable, int n) throws Exception {
        int n2;
        CMSBaseObjs cMSBaseObjs;
        User user = this.getLoginUser();
        StringBuffer stringBuffer = new StringBuffer(hashtable.size());
        Enumeration enumeration = hashtable.keys();
        if (enumeration.hasMoreElements()) {
            while (true) {
                stringBuffer.append(enumeration.nextElement());
                if (!enumeration.hasMoreElements()) break;
                stringBuffer.append(",");
            }
        }
        String string = stringBuffer.toString();
        switch (n) {
            case 103: {
                cMSBaseObjs = WebSites.findByIds(user, string);
                n2 = 64;
                break;
            }
            case 101: {
                cMSBaseObjs = Channels.findByIds(user, string);
                n2 = 14;
                break;
            }
            default: {
                throw new WCMException(I18NMessage.get(IndividuationMgr.class, "IndividuationMgr.label1", "\u4e0d\u652f\u6301\u7684\u5bf9\u8c61\u7c7b\u578b"));
            }
        }
        int n3 = cMSBaseObjs.size();
        for (int i = 0; i < n3; ++i) {
            BaseChannel baseChannel = (BaseChannel)cMSBaseObjs.getAt(i);
            if (baseChannel == null || !baseChannel.isDeleted() && AuthServer.hasRight(user, (CMSObj)baseChannel, n2)) continue;
            hashtable.remove(String.valueOf(baseChannel.getId()));
        }
        return hashtable;
    }

    private User getLoginUser() {
        User user = ContextHelper.getLoginUser();
        return user;
    }
}

