/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.filter;

import com.trs.components.wcm.filter.Filter;
import com.trs.components.wcm.filter.FilterOption;
import com.trs.components.wcm.filter.FilterOptionGroup;
import com.trs.components.wcm.filter.FilterOptionGroups;
import com.trs.components.wcm.filter.FilterOptions;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class FilterXMLMaker {
    private List m_arFiles = new ArrayList();

    public List getRelateFiles() {
        return this.m_arFiles;
    }

    public String parseToXML(Filter filter) throws WCMException {
        Element element = DocumentHelper.createElement((String)"Filter");
        element.addAttribute("name", filter.getFilterName());
        element.addAttribute("viewName", filter.getViewName());
        element.addAttribute("disabledoptions", filter.getPropertyAsString("disabledoptions"));
        WCMFilter wCMFilter = new WCMFilter("", "FILTERID=?", "FOrder");
        wCMFilter.addSearchValues(filter.getId());
        FilterOptionGroups filterOptionGroups = FilterOptionGroups.openWCMObjs(null, wCMFilter);
        int n = filterOptionGroups.size();
        for (int i = 0; i < n; ++i) {
            FilterOptionGroup filterOptionGroup = (FilterOptionGroup)filterOptionGroups.getAt(i);
            Element element2 = this.makeXMLElement(filterOptionGroup);
            element.add(element2);
        }
        return element.asXML();
    }

    private Element makeXMLElement(FilterOptionGroup filterOptionGroup) throws WCMException {
        Element element = DocumentHelper.createElement((String)"optiongroup");
        element.addAttribute("id", String.valueOf(filterOptionGroup.getId()));
        element.addAttribute("name", filterOptionGroup.getOptionGroupName());
        element.addAttribute("minValue", filterOptionGroup.getPropertyAsString("minValue"));
        element.addAttribute("max_Value", filterOptionGroup.getPropertyAsString("max_Value"));
        element.addAttribute("columnCount", filterOptionGroup.getPropertyAsString("columnCount"));
        element.addAttribute("optGroupType", filterOptionGroup.getPropertyAsString("OPTGROUPTYPE"));
        element.addAttribute("inputName", filterOptionGroup.getOptionGroupDesc());
        WCMFilter wCMFilter = new WCMFilter("", "GROUPID=?", "FOrder");
        wCMFilter.addSearchValues(filterOptionGroup.getId());
        FilterOptions filterOptions = FilterOptions.openWCMObjs(null, wCMFilter);
        int n = filterOptions.size();
        for (int i = 0; i < n; ++i) {
            FilterOption filterOption = (FilterOption)filterOptions.getAt(i);
            Element element2 = this.makeXMLElement(filterOption);
            element.add(element2);
        }
        return element;
    }

    private Element makeXMLElement(FilterOption filterOption) throws WCMException {
        String string;
        String string2;
        Element element = DocumentHelper.createElement((String)"option");
        String string3 = filterOption.getFirstPic();
        if (!CMyString.isEmpty(string3)) {
            this.m_arFiles.add(string3);
        }
        if (!CMyString.isEmpty(string2 = filterOption.getSecondPic())) {
            this.m_arFiles.add(string2);
        }
        if (!CMyString.isEmpty(string = filterOption.getThirdPic())) {
            this.m_arFiles.add(string);
        }
        element.addAttribute("id", String.valueOf(filterOption.getId()));
        element.addAttribute("seq", String.valueOf(filterOption.getOrder()));
        element.addAttribute("name", filterOption.getOptionName());
        element.addAttribute("uirelation", filterOption.getNotAllowedSelectOptions());
        element.addAttribute("pic1", string3);
        element.addAttribute("pic2", string2);
        element.addAttribute("pic3", string);
        element.addAttribute("query", filterOption.getSearchCondition());
        return element;
    }
}

