/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.filter;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.db.DBManager;

public class FilterOptionGroup
extends CMSObj {
    public static final int OBJ_TYPE = 1310565549;
    public static final String DB_TABLE_NAME = "XWCMFILTEROPTIONGROUP";
    public static final String DB_ID_NAME = "FILTEROPTIONGROUPID";
    private static final int DIRECTION_MOVE_FORWARD = 1;
    private static final int DIRECTION_MOVE_BACK = -1;
    private static final int DIRECTION_MOVE_NO = 0;

    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    public int getWCMType() {
        return 1310565549;
    }

    public String getOptionGroupName() {
        return this.getPropertyAsString("OPTIONGROUPNAME");
    }

    public boolean setOptionGroupName(String string) throws WCMException {
        return this.setProperty("OPTIONGROUPNAME", string);
    }

    public String getOptionGroupDesc() {
        return this.getPropertyAsString("OPTIONGROUPDESC");
    }

    public boolean setOptionGroupDesc(String string) throws WCMException {
        return this.setProperty("OPTIONGROUPDESC", string);
    }

    public int getFilterId() {
        return this.getPropertyAsInt("FILTERID", 0);
    }

    public boolean setFilterId(int n) throws WCMException {
        return this.setProperty("FILTERID", n);
    }

    public int getOrder() {
        return this.getPropertyAsInt("FORDER", 0);
    }

    public boolean setOrder(int n) throws WCMException {
        return this.setProperty("FORDER", n);
    }

    public boolean isValid() throws WCMException {
        if (this.isAddMode()) {
            if (this.getProperty("OPTIONGROUPNAME") == null) {
                throw new WCMException(1106, I18NMessage.get(FilterOptionGroup.class, "FilterOptionGroup.label1", "\u5c5e\u6027OptionGroupName\u6ca1\u6709\u8bbe\u7f6e(FilterOptionGroup.isValid)"));
            }
            if (this.getProperty("FORDER") == null) {
                throw new WCMException(1106, I18NMessage.get(FilterOptionGroup.class, "FilterOptionGroup.label2", "\u5c5e\u6027Forder\u6ca1\u6709\u8bbe\u7f6e(FilterOptionGroup.isValid)"));
            }
        } else if (!this.isModified()) {
            throw new WCMException(1107, I18NMessage.get(FilterOptionGroup.class, "FilterOptionGroup.label3", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(FilterOptionGroup.isValid)"));
        }
        this.changeOrder();
        return true;
    }

    public void insert(User user) throws WCMException {
        if (this.isAddMode() && this.isModified()) {
            super.insert(user);
        }
    }

    private void changeOrder() throws WCMException {
        int n;
        int n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if (this.isAddMode()) {
            n2 = this.getOrder();
            n = this.getMaxOrder();
            if (n2 == -1) {
                n2 = n + 1;
                this.setOrder(n2);
                return;
            }
            n5 = 1;
            n4 = n;
            n3 = n2;
        } else {
            if (!this.isChangeProperty("FORDER")) {
                return;
            }
            n2 = this.getNewPropertyAsInt("FORDER", -1);
            if (n2 == -1) {
                n = this.getMaxOrder();
                if (n == this.getOrder()) {
                    n2 = this.getOrder();
                } else {
                    n5 = -1;
                    n4 = n;
                    n3 = this.getOrder() + 1;
                    n2 = n;
                }
            } else if (n2 > this.getOrder()) {
                n5 = -1;
                n4 = n2;
                n3 = this.getOrder() + 1;
            } else {
                n5 = 1;
                n4 = this.getOrder() - 1;
                n3 = n2;
            }
        }
        String string = "FORDER>=" + n3 + " AND FORDER <= " + n4 + " and FILTERID=" + this.getFilterId();
        String string2 = "UPDATE XWCMFILTEROPTIONGROUP SET FORDER = FORDER+(" + n5 + ") WHERE " + string;
        DBManager.getDBManager().sqlExecuteUpdate(string2);
        this.setOrder(n2);
    }

    private int getMaxOrder() throws WCMException {
        return DBManager.getDBManager().sqlExecuteIntQuery("select max(FORDER) from XWCMFILTEROPTIONGROUP where FILTERID=?", new int[]{this.getFilterId()});
    }

    public static final FilterOptionGroup findById(int n) throws WCMException {
        if (n <= 0) {
            return null;
        }
        return (FilterOptionGroup)BaseObj.findById(FilterOptionGroup.class, n);
    }

    public static final FilterOptionGroup createNewInstance() throws WCMException {
        return (FilterOptionGroup)BaseObj.createNewInstance(FilterOptionGroup.class);
    }

    public static final FilterOptionGroup findByKey(Object object) throws WCMException {
        return (FilterOptionGroup)BaseObj.findByKey(FilterOptionGroup.class, object);
    }
}

