/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.filter;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;

public class FilterOption
extends CMSObj {
    public static final int OBJ_TYPE = 158294668;
    public static final String DB_TABLE_NAME = "XWCMFILTEROPTION";
    public static final String DB_ID_NAME = "FILTEROPTIONID";
    private static final int DIRECTION_MOVE_FORWARD = 1;
    private static final int DIRECTION_MOVE_BACK = -1;
    private static final int DIRECTION_MOVE_NO = 0;

    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    public int getWCMType() {
        return 158294668;
    }

    public String getOptionName() {
        return this.getPropertyAsString("OPTIONNAME");
    }

    public boolean setOptionName(String string) throws WCMException {
        return this.setProperty("OPTIONNAME", string);
    }

    public String getOptionDesc() {
        return this.getPropertyAsString("OPTIONDESC");
    }

    public boolean setOptionDesc(String string) throws WCMException {
        return this.setProperty("OPTIONDESC", string);
    }

    public String getSearchCondition() {
        return this.getPropertyAsString("SEARCHCONDITION");
    }

    public boolean setSearchCondition(String string) throws WCMException {
        return this.setProperty("SEARCHCONDITION", string);
    }

    public String getNotAllowedSelectOptions() {
        return this.getPropertyAsString("NOTALLOWEDSELECTOPTIONS");
    }

    public boolean setNotAllowedSelectOptions(String string) throws WCMException {
        return this.setProperty("NOTALLOWEDSELECTOPTIONS", string);
    }

    public String getFirstPic() {
        return this.getPropertyAsString("FIRSTPIC");
    }

    public boolean setFirstPic(String string) throws WCMException {
        return this.setProperty("FIRSTPIC", string);
    }

    public String getSecondPic() {
        return this.getPropertyAsString("SECONDPIC");
    }

    public boolean setSecondPic(String string) throws WCMException {
        return this.setProperty("SECONDPIC", string);
    }

    public String getThirdPic() {
        return this.getPropertyAsString("THIRDPIC");
    }

    public boolean setThirdPic(String string) throws WCMException {
        return this.setProperty("THIRDPIC", string);
    }

    public int getGroupId() {
        return this.getPropertyAsInt("GROUPID", 0);
    }

    public boolean setGroupId(int n) throws WCMException {
        return this.setProperty("GROUPID", n);
    }

    public int getOrder() {
        return this.getPropertyAsInt("FORDER", 0);
    }

    public boolean setOrder(int n) throws WCMException {
        return this.setProperty("FORDER", n);
    }

    public boolean isValid() throws WCMException {
        if (this.isAddMode()) {
            if (this.getProperty("OPTIONNAME") == null) {
                throw new WCMException(1106, I18NMessage.get(FilterOption.class, "FilterOption.label1", "\u5c5e\u6027OptionName\u6ca1\u6709\u8bbe\u7f6e(FilterOption.isValid)"));
            }
            if (this.getProperty("GROUPID") == null) {
                throw new WCMException(1106, I18NMessage.get(FilterOption.class, "FilterOption.label2", "\u5c5e\u6027GroupId\u6ca1\u6709\u8bbe\u7f6e(FilterOption.isValid)"));
            }
            if (this.getProperty("FORDER") == null) {
                throw new WCMException(1106, I18NMessage.get(FilterOption.class, "FilterOption.label3", "\u5c5e\u6027FOrder\u6ca1\u6709\u8bbe\u7f6e(FilterOption.isValid)"));
            }
        } else {
            String string;
            if (!this.isModified()) {
                throw new WCMException(1107, I18NMessage.get(FilterOption.class, "FilterOption.label4", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(FilterOption.isValid)"));
            }
            if (this.isChangeProperty("FIRSTPIC") && !CMyString.isEmpty(string = this.getFirstPic())) {
                this.deleteOldPic(string);
            }
            if (this.isChangeProperty("SECONDPIC") && !CMyString.isEmpty(string = this.getSecondPic())) {
                this.deleteOldPic(string);
            }
            if (this.isChangeProperty("THIRDPIC") && !CMyString.isEmpty(string = this.getThirdPic())) {
                this.deleteOldPic(string);
            }
        }
        this.changeOrder();
        return true;
    }

    private void deleteOldPic(String string) throws WCMException {
        FilesMan filesMan = FilesMan.getFilesMan();
        String string2 = filesMan.mapFilePath(string, 0) + string;
        CMyFile.deleteFile(string2);
    }

    public void insert(User user) throws WCMException {
        if (this.isAddMode() && this.isModified()) {
            super.insert(user);
        }
    }

    public int delete() throws WCMException {
        this.deleteRelationFiles();
        return super.delete();
    }

    public int delete(User user) throws WCMException {
        this.deleteRelationFiles();
        return super.delete(user);
    }

    private void deleteRelationFiles() throws WCMException {
        String string = this.getFirstPic();
        this.deleteFile(string);
        string = this.getSecondPic();
        this.deleteFile(string);
        string = this.getThirdPic();
        this.deleteFile(string);
    }

    private void deleteFile(String string) throws WCMException {
        if (!CMyString.isEmpty(string)) {
            FilesMan filesMan = FilesMan.getFilesMan();
            String string2 = filesMan.mapFilePath(string, 0) + string;
            CMyFile.deleteFile(string2);
        }
    }

    private void changeOrder() throws WCMException {
        int n;
        int n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if (this.isAddMode()) {
            n2 = this.getOrder();
            n = this.getMaxOrder();
            if (n2 == -1) {
                n2 = n + 1;
                this.setOrder(n2);
                return;
            }
            n5 = 1;
            n4 = n;
            n3 = n2;
        } else {
            if (!this.isChangeProperty("FORDER")) {
                return;
            }
            n2 = this.getNewPropertyAsInt("FORDER", -1);
            if (n2 == -1) {
                n = this.getMaxOrder();
                if (n == this.getOrder()) {
                    n2 = this.getOrder();
                } else {
                    n5 = -1;
                    n4 = n;
                    n3 = this.getOrder() + 1;
                    n2 = n;
                }
            } else if (n2 > this.getOrder()) {
                n5 = -1;
                n4 = n2;
                n3 = this.getOrder() + 1;
            } else {
                n5 = 1;
                n4 = this.getOrder() - 1;
                n3 = n2;
            }
        }
        String string = "FORDER>=" + n3 + " AND FORDER <= " + n4 + " and GROUPID=" + this.getGroupId();
        String string2 = "UPDATE XWCMFILTEROPTION SET FORDER = FORDER+(" + n5 + ") WHERE " + string;
        DBManager.getDBManager().sqlExecuteUpdate(string2);
        this.setOrder(n2);
    }

    private int getMaxOrder() throws WCMException {
        return DBManager.getDBManager().sqlExecuteIntQuery("select max(FORDER) from XWCMFILTEROPTION where GROUPID=?", new int[]{this.getGroupId()});
    }

    public static final FilterOption findById(int n) throws WCMException {
        if (n <= 0) {
            return null;
        }
        return (FilterOption)BaseObj.findById(FilterOption.class, n);
    }

    public static final FilterOption createNewInstance() throws WCMException {
        return (FilterOption)BaseObj.createNewInstance(FilterOption.class);
    }

    public static final FilterOption findByKey(Object object) throws WCMException {
        return (FilterOption)BaseObj.findByKey(FilterOption.class, object);
    }
}

