/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.filter;

import com.trs.DreamFactory;
import com.trs.ajaxservice.WCMAJAXServiceHelper;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.domain.publisher.PublishPageContext;
import com.trs.components.common.publish.domain.publisher.PublishPathCompass;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.publisher.PublishTaskContext;
import com.trs.components.common.publish.domain.tagparser.TagDocument;
import com.trs.components.common.publish.domain.tagparser.TagDocumentReader;
import com.trs.components.common.publish.domain.tagparser.TagParseHelper;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.wcm.advisor.AdvisorCenterServiceProvider;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.filter.Filter;
import com.trs.components.wcm.filter.FilterExporter;
import com.trs.components.wcm.filter.FilterImporter;
import com.trs.components.wcm.filter.FilterMgr;
import com.trs.components.wcm.filter.FilterOption;
import com.trs.components.wcm.filter.FilterOptionGroup;
import com.trs.components.wcm.filter.FilterOptionGroups;
import com.trs.components.wcm.filter.FilterOptions;
import com.trs.components.wcm.filter.Filters;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.common.WCMTypes;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.IGlueServiceProvider;

public class FilterCenterServiceProvider
implements IGlueServiceProvider {
    private FilterMgr m_oFilterMgr = (FilterMgr)DreamFactory.createObjectById("FilterMgr");

    public FilterOptionGroups queryFilterOptionGroupsByFilter(MethodContext methodContext) throws Throwable {
        int n = methodContext.getObjectId();
        Filter filter = Filter.findById(n);
        if (filter == null) {
            throw new WCMException(10, I18NMessage.get(FilterCenterServiceProvider.class, "FilterCenterServiceProvider.label1", "\u8fc7\u6ee4\u5668\u5bf9\u8c61\u65e0\u6548\uff0c\u65e0\u6cd5\u83b7\u53d6\u5176\u9009\u9879\u7ec4\uff01"));
        }
        this.validRight(filter, this.getLoginUser(), 14);
        return this.m_oFilterMgr.queryGroupsByFilter(filter, null);
    }

    public FilterOptions queryFilterOptionsByGroup(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        int n = methodContext.getObjectId();
        FilterOptionGroup filterOptionGroup = FilterOptionGroup.findById(n);
        if (filterOptionGroup == null) {
            throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(n), WCMTypes.getLowerObjName(1310565549)}));
        }
        this.validGroup(filterOptionGroup, 0, user, 14);
        return this.m_oFilterMgr.queryFilterOptionsByGroup(filterOptionGroup, null);
    }

    public FilterOptions queryOtherOptions(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        int n = methodContext.getValue("OptionId", 0);
        FilterOption filterOption = FilterOption.findById(n);
        int n2 = filterOption.getGroupId();
        FilterOptionGroup filterOptionGroup = FilterOptionGroup.findById(n2);
        if (filterOptionGroup == null) {
            throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(n2), WCMTypes.getLowerObjName(1310565549)}));
        }
        int n3 = filterOptionGroup.getFilterId();
        Filter filter = Filter.findById(n3);
        if (filter == null) {
            throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(n3), WCMTypes.getLowerObjName(1852535607)}));
        }
        this.validRight(filter, user, 14);
        String string = "FILTEROPTIONID <> ? AND GROUPID IN (SELECT FILTEROPTIONGROUPID FROM XWCMFILTEROPTIONGROUP WHERE FILTERID = ?)";
        WCMFilter wCMFilter = new WCMFilter("", string, "GROUPID,FORDER");
        wCMFilter.addSearchValues(n);
        wCMFilter.addSearchValues(n3);
        return FilterOptions.openWCMObjs(null, wCMFilter);
    }

    public FilterOptions queryOptionsByFilter(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        int n = methodContext.getValue("FilterId", 0);
        Filter filter = Filter.findById(n);
        if (filter == null) {
            throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(n), WCMTypes.getLowerObjName(1852535607)}));
        }
        this.validRight(filter, user, 14);
        String string = "GROUPID IN (SELECT FILTEROPTIONGROUPID FROM XWCMFILTEROPTIONGROUP WHERE FILTERID = ?)";
        WCMFilter wCMFilter = new WCMFilter("", string, "GROUPID,FORDER");
        wCMFilter.addSearchValues(n);
        return FilterOptions.openWCMObjs(null, wCMFilter);
    }

    public int saveFilterOptionGroup(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        int n = methodContext.getObjectId();
        int n2 = methodContext.getValue("FilterId", 0);
        FilterOptionGroup filterOptionGroup = null;
        filterOptionGroup = n == 0 ? new FilterOptionGroup() : FilterOptionGroup.findById(n);
        if (n == 0 && n2 == 0) {
            throw new WCMException(I18NMessage.get(FilterCenterServiceProvider.class, "FilterCenterServiceProvider.label2", "\u5fc5\u987b\u4f20\u5165\u53c2\u6570FilterId\uff01"));
        }
        this.validGroup(filterOptionGroup, n2, user, 13);
        String[] stringArray = new String[]{"ObjectId"};
        filterOptionGroup = (FilterOptionGroup)WCMAJAXServiceHelper.setWCMObjectProperties(user, methodContext, filterOptionGroup, stringArray);
        filterOptionGroup.save(user);
        return filterOptionGroup.getId();
    }

    public int saveFilter(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        int n = methodContext.getObjectId();
        Filter filter = n == 0 ? new Filter() : Filter.findById(n);
        this.validRight(filter, user, 13);
        String[] stringArray = new String[]{"ObjectId"};
        filter = (Filter)WCMAJAXServiceHelper.setWCMObjectProperties(user, methodContext, filter, stringArray);
        filter.save(user);
        return filter.getId();
    }

    public int saveFilterOption(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        int n = methodContext.getObjectId();
        int n2 = methodContext.getValue("GroupId", 0);
        FilterOption filterOption = null;
        filterOption = n == 0 ? new FilterOption() : FilterOption.findById(n);
        if (n == 0 && n2 == 0) {
            throw new WCMException(I18NMessage.get(FilterCenterServiceProvider.class, "FilterCenterServiceProvider.label3", "\u5fc5\u987b\u4f20\u5165\u53c2\u6570GroupId\uff01"));
        }
        this.validOption(filterOption, n2, user, 13);
        String[] stringArray = new String[]{"ObjectId"};
        filterOption = (FilterOption)WCMAJAXServiceHelper.setWCMObjectProperties(user, methodContext, filterOption, stringArray);
        filterOption.save(user);
        return filterOption.getId();
    }

    public void deleteFilter(MethodContext methodContext) throws WCMException {
        User user = this.getLoginUser();
        String string = methodContext.getValue("FilterIds");
        Filters filters = Filters.findByIds(user, string);
        for (int i = filters.size() - 1; i >= 0; --i) {
            Filter filter = (Filter)filters.getAt(i);
            if (filter == null) continue;
            this.validRight(filter, user, 13);
            this.m_oFilterMgr.deleteFilter(filter);
        }
    }

    public void deleteFilterOptionGroup(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        int n = methodContext.getObjectId();
        FilterOptionGroup filterOptionGroup = FilterOptionGroup.findById(n);
        if (filterOptionGroup == null) {
            throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(n), WCMTypes.getLowerObjName(1310565549)}));
        }
        this.validGroup(filterOptionGroup, 0, user, 13);
        this.m_oFilterMgr.deleteFilterOptionGroup(filterOptionGroup);
    }

    public void deleteFilterOption(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        int n = methodContext.getObjectId();
        FilterOption filterOption = FilterOption.findById(n);
        if (filterOption == null) {
            throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(n), WCMTypes.getLowerObjName(266112697)}));
        }
        this.validOption(filterOption, 0, user, 13);
        this.m_oFilterMgr.deleteFilterOption(filterOption);
    }

    public void copy(MethodContext methodContext) throws Throwable {
        CMSObj cMSObj;
        User user = this.getLoginUser();
        String string = methodContext.getValue("FilterIds");
        String string2 = methodContext.getValue("ChannelIds");
        Channels channels = Channels.findByIds(user, string2);
        int n = channels.size();
        for (int i = 0; i < n; ++i) {
            cMSObj = (Channel)channels.getAt(i);
            if (cMSObj == null) continue;
            this.validateRight((Channel)cMSObj, user, 13);
        }
        Filters filters = Filters.findByIds(user, string);
        for (n = filters.size() - 1; n >= 0; --n) {
            cMSObj = (Filter)filters.getAt(n);
            if (cMSObj == null) continue;
            this.validRight((Filter)cMSObj, user, 13);
            this.m_oFilterMgr.copy((Filter)cMSObj, channels, user);
        }
    }

    public String export(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        String string = methodContext.getValue("FilterIds");
        Filters filters = Filters.findByIds(user, string);
        int n = filters.size();
        for (int i = 0; i < n; ++i) {
            Filter filter = (Filter)filters.getAt(i);
            if (filter == null) continue;
            this.validRight(filter, user, 14);
        }
        FilterExporter filterExporter = new FilterExporter();
        return filterExporter.export(filters);
    }

    public void importFilters(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        int n = methodContext.getValue("ImportType", 1);
        int n2 = methodContext.getValue("ChannelId", 0);
        Channel channel = Channel.findById(n2);
        if (channel == null) {
            throw new WCMException("\u4f20\u5165\u7684\u680f\u76eeId[" + n2 + "]\u4e0d\u5b58\u5728");
        }
        this.validateRight(channel, user, 13);
        String string = methodContext.getValue("ImportFile");
        FilterImporter filterImporter = new FilterImporter(n, channel);
        filterImporter.setImportToCurrChnl(methodContext.getValue("ImportToCurrChnl", true));
        filterImporter.importFromZip(string);
    }

    public void createXMLForFilter(MethodContext methodContext) throws Throwable {
        int n = methodContext.getValue("ChannelId", 0);
        Channel channel = Channel.findById(n);
        if (channel == null) {
            throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(n), WCMTypes.getLowerObjName(101)}));
        }
        boolean bl = AuthServer.hasRight(this.getLoginUser(), (CMSObj)channel, 13);
        if (!bl) {
            throw new WCMException(I18NMessage.get(FilterCenterServiceProvider.class, "FilterCenterServiceProvider.label4", "\u60a8\u6ca1\u6709\u6743\u9650\u5728\u680f\u76ee\u3010id=") + n + I18NMessage.get(FilterCenterServiceProvider.class, "FilterCenterServiceProvider.label5", "\u3011\u4e0b\u7684\u64cd\u4f5c\u7b5b\u9009\u5668\u4fe1\u606f\uff01 "));
        }
        String string = methodContext.getValue("FilterIds");
        if (CMyString.isEmpty(string)) {
            this.createFilterXML(null, n, methodContext);
            return;
        }
        int[] nArray = CMyString.splitToInt(string, ",");
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = nArray[i];
            Filter filter = Filter.findById(n2);
            this.createFilterXML(filter, n, methodContext);
        }
    }

    protected IPublishElement makeElement(int n) throws WCMException {
        IPublishElement iPublishElement = null;
        iPublishElement = PublishElementFactory.lookupElement(101, n);
        if (iPublishElement == null) {
            throw new WCMException(I18NMessage.get(FilterCenterServiceProvider.class, "FilterCenterServiceProvider.label6", "\u6307\u5b9a\u7684\u680f\u76ee[Id=") + n + I18NMessage.get(FilterCenterServiceProvider.class, "FilterCenterServiceProvider.label7", "]\u4e0d\u5b58\u5728\uff01"));
        }
        return iPublishElement;
    }

    private void createFilterXML(Filter filter, int n, MethodContext methodContext) throws CMyException {
        Object object;
        Object object2;
        String string = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>";
        String string2 = "";
        if (filter == null) {
            string = string + "<TRS_FILTER FIELD=\"XML\" DisFile=\"true\"/>";
        } else {
            string2 = filter.getFilterName();
            string = string + "<TRS_FILTER FIELD=\"XML\" name=\"" + string2 + "\" DisFile=\"true\"/>";
        }
        String string3 = null;
        PublishTaskContext publishTaskContext = new PublishTaskContext(null, null);
        IPublishElement iPublishElement = this.makeElement(n);
        PublishPageContext publishPageContext = new PublishPageContext(iPublishElement, publishTaskContext);
        PublishTagContext publishTagContext = new PublishTagContext(publishPageContext);
        PublishPathCompass publishPathCompass = new PublishPathCompass();
        String string4 = publishPathCompass.getLocalPath(iPublishElement, methodContext.getValue("isPreview", true));
        try {
            object2 = TagDocumentReader.read(string);
            if (object2 == null) {
                throw new WCMException(I18NMessage.get(FilterCenterServiceProvider.class, "FilterCenterServiceProvider.label8", "\u5c06\u6a21\u677f\u5185\u5bb9\u8f6c\u6362\u4e3aTagDocument\u5931\u8d25\uff01"));
            }
            object = TagParseHelper.parseItems(((TagDocument)object2).getItems(), publishTagContext);
            string3 = object[0];
        }
        catch (Exception exception) {
            throw new WCMException(I18NMessage.get(FilterCenterServiceProvider.class, "FilterCenterServiceProvider.label9", "\u89e3\u6790\u7f6e\u6807\u3010TRS_FILTER\u3011\u5931\u8d25\uff01"), exception);
        }
        object2 = "filter";
        object = string4 + (String)object2 + ".xml";
        CMyFile.writeFile((String)object, string3, CMyString.GET_ENCODING_DEFAULT);
        publishTagContext.getFileDistributeShip().distributeFile((String)object, iPublishElement, null, false);
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    private void validOption(FilterOption filterOption, int n, User user, int n2) throws WCMException {
        int n3 = n;
        FilterOptionGroup filterOptionGroup = null;
        if (n3 == 0) {
            n3 = filterOption.getGroupId();
        }
        if ((filterOptionGroup = FilterOptionGroup.findById(n3)) == null) {
            throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(n3), WCMTypes.getLowerObjName(1310565549)}));
        }
        this.validGroup(filterOptionGroup, 0, user, n2);
    }

    private void validGroup(FilterOptionGroup filterOptionGroup, int n, User user, int n2) throws WCMException {
        int n3 = n;
        Filter filter = null;
        if (n3 == 0) {
            n3 = filterOptionGroup.getFilterId();
        }
        if ((filter = Filter.findById(n3)) == null) {
            throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(n3), WCMTypes.getLowerObjName(1852535607)}));
        }
        this.validRight(filter, user, n2);
    }

    private void validRight(Filter filter, User user, int n) throws WCMException {
        int n2 = filter.getChannelId();
        Channel channel = Channel.findById(n2);
        if (channel == null) {
            throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(n2), WCMTypes.getLowerObjName(101)}));
        }
        boolean bl = AuthServer.hasRight(this.getLoginUser(), (CMSObj)channel, n);
        if (!bl) {
            throw new WCMException(I18NMessage.get(FilterCenterServiceProvider.class, "FilterCenterServiceProvider.label4", "\u60a8\u6ca1\u6709\u6743\u9650\u5728\u680f\u76ee\u3010id=") + n2 + I18NMessage.get(FilterCenterServiceProvider.class, "FilterCenterServiceProvider.label5", "\u3011\u4e0b\u7684\u64cd\u4f5c\u7b5b\u9009\u5668\u4fe1\u606f\uff01 "));
        }
    }

    private void validateRight(Channel channel, User user, int n) throws WCMException {
        boolean bl = AuthServer.hasRight(this.getLoginUser(), (CMSObj)channel, n);
        if (!bl) {
            throw new WCMException(I18NMessage.get(AdvisorCenterServiceProvider.class, "AdvisorCenterServiceProvider.label2", "\u60a8\u6ca1\u6709\u6743\u9650\u5728\u680f\u76ee\u3010id=") + channel.getId() + I18NMessage.get(AdvisorCenterServiceProvider.class, "AdvisorCenterServiceProvider.label3", "\u3011\u4e0b\u7684\u64cd\u4f5c\u987e\u95ee\u4fe1\u606f\uff01 "));
        }
    }

    public void delete(MethodContext methodContext) throws Throwable {
    }

    public Object query(MethodContext methodContext) throws Throwable {
        return null;
    }

    public int save(MethodContext methodContext) throws Throwable {
        return 0;
    }

    public Object findById(MethodContext methodContext) throws Throwable {
        return null;
    }

    public Object findByIds(MethodContext methodContext) throws Throwable {
        return null;
    }
}

