/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.epress;

import com.trs.components.wcm.content.persistent.Channel;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.util.CMyDateTime;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class EPressConf {
    public static final String ATTR_HAS_COVERPAGE = "hascoverpage";
    private static final String TRSWCMEPRESS_CONF = "/TRSWCMEPress.properties";
    private final Map m_channels = new HashMap(5, 0.2f);
    private final Map m_conf = new HashMap(5, 0.2f);

    private EPressConf() {
        this.load();
    }

    public static final EPressConf instance() {
        return InstanceHolder.INSTANCE;
    }

    public Iterator keys() {
        return this.m_channels.keySet().iterator();
    }

    public void add(String string, int n) throws WCMException {
        if (this.m_channels.containsKey(string)) {
            throw new WCMException(10, "\u7cfb\u7edf\u5df2\u5b58\u5728\u6807\u8bc6\u4e3a[" + string + "]\u7684\u7535\u5b50\u62a5\u9891\u9053");
        }
        this.loadChannels(string, String.valueOf(n));
        this.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getChannels(String string) {
        if (!this.existsEPress(string)) {
            return null;
        }
        Map map = (Map)this.m_channels.get(string);
        if (map != null && map.isEmpty()) {
            Map map2 = map;
            synchronized (map2) {
                try {
                    this.loadChannels(string, (String)this.m_conf.get(string));
                }
                catch (WCMException wCMException) {
                    // empty catch block
                }
            }
            map = (Map)this.m_channels.get(string);
        }
        return map;
    }

    public Map getChannels(int n) {
        if (!this.existsEPress(n)) {
            return null;
        }
        String string = this.getEPressKeyById(n);
        if (string != null) {
            return this.getChannels(string);
        }
        return null;
    }

    public boolean existsEPress(String string) {
        if (string == null) {
            return false;
        }
        String string2 = (String)this.m_conf.get(string);
        Channel channel = null;
        if (string2 != null) {
            try {
                channel = Channel.findById(Integer.parseInt(string2));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return channel != null;
    }

    public boolean existsEPress(int n) {
        Channel channel = null;
        if (this.m_conf.containsValue(String.valueOf(n))) {
            try {
                channel = Channel.findById(n);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return channel != null;
    }

    private String getEPressKeyById(int n) {
        String string = String.valueOf(n);
        Iterator iterator = this.m_conf.keySet().iterator();
        String string2 = null;
        while (iterator.hasNext()) {
            string2 = (String)iterator.next();
            if (!string.equals(this.m_conf.get(string2))) continue;
            return string2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void load() {
        InputStream inputStream = null;
        Class<?> clazz = this.getClass();
        inputStream = clazz.getResourceAsStream(TRSWCMEPRESS_CONF);
        if (inputStream == null) {
            inputStream = clazz.getResourceAsStream(TRSWCMEPRESS_CONF.substring(1));
        }
        Properties properties = new Properties();
        properties.load(inputStream);
        Iterator<Object> iterator = properties.keySet().iterator();
        String string = null;
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            this.loadChannels(string, properties.getProperty(string));
        }
        properties.clear();
        Object var7_7 = null;
        if (inputStream == null) return;
        try {
            inputStream.close();
            return;
        }
        catch (Exception exception) {}
        return;
        {
            catch (Exception exception) {
                Object var7_8 = null;
                if (inputStream == null) return;
                try {
                    inputStream.close();
                    return;
                }
                catch (Exception exception2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (inputStream == null) throw throwable;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private void loadChannels(String string, String string2) throws WCMException {
        int n = Integer.parseInt(string2);
        Channel channel = Channel.findById(n);
        if (channel == null) {
            this.m_conf.remove(string);
            return;
        }
        this.m_conf.put(string, string2);
        List list = channel.getChildren(null);
        int n2 = list.size();
        HashMap<String, Object> hashMap = new HashMap<String, Object>(n2 + 1);
        boolean bl = "true".equals(channel.getAttributeValue(ATTR_HAS_COVERPAGE));
        for (int i = 0; i < n2; ++i) {
            channel = (Channel)list.get(i);
            if (channel == null) continue;
            if (bl) {
                hashMap.put(String.valueOf(i), channel.getKey());
                continue;
            }
            hashMap.put(String.valueOf(i + 1), channel.getKey());
        }
        list.clear();
        this.m_channels.put(string, hashMap);
    }

    public void reload() {
        this.m_channels.clear();
        this.m_conf.clear();
        this.load();
    }

    /*
     * Loose catch block
     */
    private synchronized void save() throws WCMException {
        Properties properties;
        block9: {
            properties = new Properties();
            Iterator iterator = this.m_conf.keySet().iterator();
            String string = null;
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                properties.setProperty(string, (String)this.m_conf.get(string));
            }
            FileOutputStream fileOutputStream = null;
            Class<?> clazz = this.getClass();
            URL uRL = clazz.getResource(TRSWCMEPRESS_CONF);
            fileOutputStream = new FileOutputStream(uRL.getFile());
            properties.store(fileOutputStream, CMyDateTime.now().toString("yyyy-MM-dd HH:mm"));
            Object var8_8 = null;
            if (fileOutputStream == null) break block9;
            try {
                fileOutputStream.close();
                break block9;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            {
                break block9;
                catch (Exception exception) {
                    throw new WCMException(50, "\u4fdd\u5b58\u914d\u7f6e\u6587\u4ef6\u5931\u8d25\uff01", exception);
                }
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                properties.clear();
                throw throwable;
            }
        }
        properties.clear();
    }

    public String toXml(String string) {
        if (string == null || string.trim().length() == 0) {
            string = "target";
        }
        StringBuffer stringBuffer = new StringBuffer(128);
        Iterator iterator = this.m_conf.keySet().iterator();
        String string2 = null;
        String string3 = null;
        int n = 0;
        Channel channel = null;
        stringBuffer.append("<?xml version=\"1.0\" encoding=\"GBK\"?>");
        stringBuffer.append("<");
        stringBuffer.append(string).append("s");
        stringBuffer.append(">");
        while (iterator.hasNext()) {
            string2 = (String)iterator.next();
            string3 = (String)this.m_conf.get(string2);
            try {
                n = Integer.parseInt(string3);
                channel = Channel.findById(n);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (channel == null) continue;
            stringBuffer.append("<");
            stringBuffer.append(string);
            stringBuffer.append(">");
            stringBuffer.append("<desc><![CDATA[");
            stringBuffer.append(channel.getDesc());
            stringBuffer.append("]]></desc>");
            stringBuffer.append("<uuid>");
            stringBuffer.append(string2);
            stringBuffer.append("</uuid>");
            stringBuffer.append("</");
            stringBuffer.append(string);
            stringBuffer.append(">");
        }
        stringBuffer.append("</");
        stringBuffer.append(string).append("s");
        stringBuffer.append(">");
        return stringBuffer.toString();
    }

    Iterator itrEPressChnlIds() {
        return this.m_conf.values().iterator();
    }

    public void notifyOnDelObj(BaseObj baseObj) {
        if (baseObj == null || baseObj.getWCMType() != 101) {
            return;
        }
        String string = String.valueOf(baseObj.getId());
        if (this.m_conf.containsValue(string)) {
            Iterator iterator = this.m_conf.keySet().iterator();
            String string2 = null;
            while (iterator.hasNext()) {
                string2 = (String)iterator.next();
                if (!string.equals(this.m_conf.get(string2))) continue;
                this.m_conf.remove(string2);
                Map map = (Map)this.m_channels.remove(string2);
                if (map == null) break;
                map.clear();
                map = null;
                break;
            }
        }
    }

    private static class InstanceHolder {
        static final EPressConf INSTANCE = new EPressConf();

        private InstanceHolder() {
        }
    }
}

