/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.epress;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.persistent.publisher.FolderPublishConfig;
import com.trs.components.wcm.content.domain.ChannelMgr;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.epress.EPressConf;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.log.LogServer;
import com.trs.infra.util.CMyString;
import org.apache.log4j.Logger;

public class EPressChannelWrapper {
    private static final String ROLLBACK_PUBCONFS = "DELETE FROM wcmfolderpublishconfig WHERE EXISTS(SELECT channelid FROM wcmchannel WHERE (parentid=? OR channelid=?) AND channelid=folderid and foldertype=101)";
    private static final String ROLLBACK_CHANNELS = "DELETE FROM wcmchannel WHERE parentid=? OR channelid=?";
    private static final String[] ROLLBACK_SQL = new String[]{"DELETE FROM wcmfolderpublishconfig WHERE EXISTS(SELECT channelid FROM wcmchannel WHERE (parentid=? OR channelid=?) AND channelid=folderid and foldertype=101)", "DELETE FROM wcmchannel WHERE parentid=? OR channelid=?"};
    private static Logger s_logger = Logger.getLogger(EPressChannelWrapper.class);
    private Channel m_oCchannel;
    private int m_nPageNums;
    private String m_sUid;
    private String m_sParentName;
    private User m_oUser;
    private int m_nSiteId;
    private String m_sCoverPageName;
    private boolean m_zHasCoverPage;

    public EPressChannelWrapper(int n, String string) {
        this.m_nPageNums = n;
        this.m_sUid = string;
    }

    public Channel save(User user, Channel channel) throws Exception {
        if (channel == null) {
            throw new WCMException(10, "\u65e0\u6548\u7684\u9891\u9053\u5bf9\u8c61[null]\uff01");
        }
        if (!channel.isAddMode()) {
            return channel;
        }
        ContextHelper.initContext(user);
        this.m_oUser = user;
        ChannelMgr channelMgr = (ChannelMgr)DreamFactory.createObjectById("ChannelMgr");
        String string = "\u4fdd\u5b58\u7535\u5b50\u62a5\u9891\u9053[" + channel.getDesc() + "]";
        long l = LogServer.startRecord(user.getName(), "CHANNEL_ADD", string, user);
        try {
            channel.setCanPub(true);
            channel.setAttribute("EPressUID", this.m_sUid);
            channel.setAttribute("hascoverpage", String.valueOf(this.m_zHasCoverPage));
            this.m_oCchannel = (Channel)channelMgr.save(channel);
            this.m_sParentName = this.m_oCchannel.getName();
        }
        catch (Throwable throwable) {
            LogServer.endRecordFailedOperation(l, throwable);
            throw new WCMException(1100, "\u4fdd\u5b58\u7535\u5b50\u62a5\u9891\u9053\u5931\u8d25\uff01", throwable);
        }
        boolean bl = false;
        try {
            try {
                this.m_nSiteId = this.m_oCchannel.getSiteId();
                this.makeChildren();
                EPressConf.instance().add(this.m_sUid, this.m_oCchannel.getId());
            }
            catch (Exception exception) {
                bl = true;
                throw exception;
            }
            Object var10_8 = null;
            if (bl) {
                this.rollback();
            }
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            if (bl) {
                this.rollback();
            }
            throw throwable;
        }
        LogServer.endRecordSucceedOperation(l);
        return this.m_oCchannel;
    }

    private void makeChildren() throws WCMException {
        Channel channel = null;
        String string = this.m_sCoverPageName;
        boolean bl = this.m_zHasCoverPage;
        for (int i = 0; i < this.m_nPageNums; ++i) {
            channel = new Channel();
            int n = bl ? i : i + 1;
            channel.setName(this.makeName(n));
            String string2 = n == 0 ? string : this.makeDesc(n);
            channel.setDesc(string2);
            channel.setCanPub(true);
            channel.setParent(this.m_oCchannel);
            channel.setProperty("CHNLORDER", this.m_nPageNums - i);
            channel.setSite(this.m_nSiteId);
            channel.insert(this.m_oUser);
            this.setPublishConf(channel, this.makeDataPath(n));
        }
    }

    private String makeDataPath(int n) {
        return "page_" + n;
    }

    private void setPublishConf(Channel channel, String string) throws WCMException {
        FolderPublishConfig folderPublishConfig = new FolderPublishConfig();
        folderPublishConfig.setDataPath(string);
        folderPublishConfig.setFolder(101, channel.getId());
        folderPublishConfig.insert(this.m_oUser);
    }

    private String makeName(int n) {
        return this.m_sParentName + "_" + n;
    }

    private String makeDesc(int n) {
        return "\u7b2c" + ChineseNumber.format(n) + "\u7248";
    }

    private void rollback() {
        block2: {
            try {
                int n = this.m_oCchannel.getId();
                DBManager dBManager = DBManager.getDBManager();
                dBManager.sqlExecuteUpdate(ROLLBACK_SQL, new int[]{n, n});
            }
            catch (Exception exception) {
                if (!s_logger.isDebugEnabled()) break block2;
                s_logger.error((Object)"fail to rollback when create epress failed", (Throwable)exception);
            }
        }
    }

    public void setCoverPageName(String string) {
        this.m_sCoverPageName = string;
        this.m_zHasCoverPage = !CMyString.isEmpty(this.m_sCoverPageName);
    }

    public static void main(String[] stringArray) {
        EPressChannelWrapper ePressChannelWrapper = new EPressChannelWrapper(10, "trs");
        Channel channel = new Channel();
        try {
            User user = User.findById(1);
            channel.setParent(0);
            channel.setName("trs");
            channel.setSite(5);
            channel.setDesc("trs");
            ePressChannelWrapper.save(user, channel);
            System.out.println("OK");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }

    private static class ChineseNumber {
        private static final String CN_ZERO = "\u96f6";
        private static final char[] CN_NUMBER = new char[]{'\u96f6', '\u4e00', '\u4e8c', '\u4e09', '\u56db', '\u4e94', '\u516d', '\u4e03', '\u516b', '\u4e5d', '\u5341'};
        private static final char[] BASE_UNIT = new char[]{'\u96f6', '\u5341', '\u767e', '\u5343'};
        private static final char[] TEN_UNIT = new char[]{'\u842c', '\u4ebf', '\u842c', '\u5146'};

        private ChineseNumber() {
        }

        static String format(int n) {
            if (n == 0) {
                return CN_ZERO;
            }
            int[] nArray = new int[32];
            StringBuffer stringBuffer = new StringBuffer(32);
            int n2 = 0;
            while (n > 0) {
                nArray[n2++] = n % 10;
                n /= 10;
            }
            boolean bl = false;
            boolean bl2 = false;
            while (n2 > 0) {
                int n3 = nArray[--n2];
                int n4 = n2;
                boolean bl3 = n4 >= 4;
                boolean bl4 = n4 % 4 == 0;
                int n5 = n4 % 4;
                int n6 = (n4 / 4 - 1) % 4;
                if (n3 == 0) {
                    if (bl3 && bl4 && bl2) {
                        stringBuffer.append(TEN_UNIT[n6]);
                        continue;
                    }
                    bl = true;
                    continue;
                }
                bl2 = true;
                if (bl) {
                    bl = false;
                    stringBuffer.append(CN_NUMBER[0]);
                }
                stringBuffer.append(CN_NUMBER[n3]);
                if (!bl4) {
                    stringBuffer.append(BASE_UNIT[n5]);
                    continue;
                }
                if (!bl3) continue;
                stringBuffer.append(TEN_UNIT[n6]);
            }
            return stringBuffer.toString();
        }
    }
}

